C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c ******************************************************************** C
C *
c *
c *  Program QIFL computes and applies time-variant or time-invariant
c *  inverse or forward Q filter using input values of Q as either   
c *  a constant, time-Q pairs of interval or average Q values, or    
c *  a file containing the Q field computed by program qest.         
c *  This program is a direct port of the old SIS program QIFL       
C *  The filter computes is a mininum phase filter whose Fourier
C *  transform is defined as (Hale, SEP #26)
C *         b(w) = exp(wT/2Q +i ph(T,w))
C *     where      w = frequency,                               
C *                T = sample interval, in seconds,              
C *                Q = attenuation (or Quality) Factor            
C *                i = sqrt(-1)                                    
C *     and       ph = minimum phase determined as the Hilbert       
C *                    transform of the natural log of the amplitude
C *                    spectrum.          
C ******************************************************************** C
C
#include <save_defs.h>
#include <f77/sisdef.h>
#include <f77/lhdrsz.h>
#include <f77/iounit.h>
#include <f77/pid.h>

      COMPLEX PHI(2*SZLNHD)
C
      REAL    SCALV(2*SZLNHD),CLIPG(2*SZLNHD),FILT(2*SZLNHD)
      REAL    OUTPUT(2*SZLNHD),FILT2(2*SZLNHD),SUM
      REAL    QI(2*SZLNHD),fcut,FACT(2*SZLNHD),AMP(2*SZLNHD)
      REAL    input(2*SZLNHD)
      REAL    Q(64,70),T(64,70),DT,SR
      real    qix(2*SZLNHD),scalvx(2*SZLNHD),ampscl

      integer    itr (2*SZLNHD)

      INTEGER LHED(2*SZLNHD),QLHED(2*SZLNHD)
      INTEGER LHDR(2*SZLNHD),npairs(70),jr(70)
      INTEGER PHASE,MODE,IFRCD,LRCD,obytes,nbytes
      INTEGER INV,FWD,LFILT1,LFILT2,ABSOL,IERR
      INTEGER ERRKNT
      integer argis,ipass,nsets,pipe,smh,itype,lw,nsi

      real        tabl1, tabl2, work
      pointer     (ptabl1,tabl1(1))
      pointer     (ptabl2,tabl2(1))
      pointer     (pwork,work(1))

C
      character*1 LABEL(19),RELABL(66),MODHLH(33)
      character TITL*4,ntap*256,otap*256,cardin*256
      character qtap*256
      character name*4
C
      logical verbos,query,crd,qtape,H,stk,rmute
      logical rsamp, dorec, constq, noscl
C
      EQUIVALENCE (itr(1),LHDR(1))
c     EQUIVALENCE (itr(129),input(1))
C
      DATA RELABL/66*' '/
      DATA LABEL/'I','N','V','E','R','S','E',' ','Q',' ','F','I','L',
     1'T','E','R','I','N','G'/
      DATA TITL/'QIFL'/,ICC/0/
      DATA name/'QIFL'/
      DATA ERRKNT/0/
      DATA MODHLH/33*' '/
cc      DATA LFILT2/35/
      DATA LFILT2/55/
      DATA INV/35/,FWD/35/
cc      DATA INV/13/,FWD/13/
      DATA ipass/0/
      DATA qtape/.false./
      DATA constq/.false./
      DATA pipe/3/

      luc = 18
      name = 'QIFL'
      H = (argis('-H').gt.0).or.(argis('-h').gt.0)
      query = (argis('-?').gt.0).or.H
      if(query)then
       call help()
       call ccexit(0)
      endif

#include <f77/open.h>

      ikp = in_ikp()
      ntap = ' '
      otap = ' '
      cardin = ' '
      verbos = .false.
      call gcmdln(ntap,otap,cardin,verbos,luc,crd,qtap,qtape,
     1            dorec,stk,rmute,qnull,qmin,scale,smh,noscl,itype,
     2            lw,ampscl)

      call getln(luin,ntap,'r',0)
      if (luin .lt. 0) then
         write(LERR,*)'Unable to open input stream:'
         write(LERR,*)'Check existence of input file or pipe'
         write(LER ,*)'Unable to open input stream:'
         write(LER ,*)'Check existence of input file or pipe'
         stop
      endif

      call getln(luout,otap,'w',1)
      if (luout .lt. 0) then
         write(LERR,*)'Unable to open output stream:'
         write(LERR,*)'Check -O cmd line args or output pipe'
         write(LER ,*)'Unable to open output stream:'
         write(LER ,*)'Check -O cmd line args or output pipe'
         stop
      endif
C
C         -----------------------------
C         | PRINT THE TORCH AND OVAL. |
C         -----------------------------
C
      call move(1,RELABL(23),LABEL,19)
      call gamoco(RELABL,1,LERR)
C
C         -------------------------------------------------
C         | READ THE LINE HEADER FROM THE INPUT DATA SET. |
C         -------------------------------------------------
C
      KNT    = 0
      IRI    = 0
      NIT    = 0
      IACT   = 0
      IFOUR  = 4
      ERRKNT = 0
      IERR   = 0
C
      call rtape(luin,itr ,NIT)
C
      IF(NIT.eq.0)then
      WRITE(LERR,*)'End of file found trying to read input line',
     :' header.  QIFL aborted.'
      ICC=100
      GO TO 2000
      endif
C
C
C         ----------------------------------------
C         | GET PARAMETERS FROM THE LINE HEADER. |
C         ----------------------------------------
C
      call savelu('NumSmp',ifmt_NumSmp,l_NumSmp,ln_NumSmp,LINEHEADER)
      call savelu('SmpInt',ifmt_SmpInt,l_SmpInt,ln_SmpInt,LINEHEADER)
      call savelu('NumTrc',ifmt_NumTrc,l_NumTrc,ln_NumTrc,LINEHEADER)
      call savelu('NumRec',ifmt_NumRec,l_NumRec,ln_NumRec,LINEHEADER)
      call savelu('Format',ifmt_Format,l_Format,ln_Format,LINEHEADER)

      call saver2(itr,ifmt_NumSmp,l_NumSmp,ln_NumSmp,nsamp,LINEHEADER)
      call saver2(itr,ifmt_SmpInt,l_SmpInt,ln_SmpInt,nsr  ,LINEHEADER)
      call saver2(itr,ifmt_NumTrc,l_NumTrc,ln_NumTrc,ntrc ,LINEHEADER)
      call saver2(itr,ifmt_NumRec,l_NumRec,ln_NumRec,nrec ,LINEHEADER)
      call saver2(itr,ifmt_Format,l_Format,ln_Format,iform,LINEHEADER)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('VPick1',ifmt_VPick1,l_VPick1,ln_VPick1,TRACEHEADER)

      nsi = nsr
      sr = float(nsr)
      dt  = sr * unitsc
      lw  = lw / nsi

      if (smh .gt. 0) then
        if (smh .gt. nsamp/2) then
        write(LERR,*)'WARNING:  envelope smoothing order too large'
        write(LERR,*)'Will default to 50% of the trace length'
        smh = .50 * nsamp
        write(LERR,*)'smh = ',smh
        endif
      endif
        
C
C         ------------------------------------------
C         | CALL THE SUBROUTINES TO READ THE CARD. |
C         ------------------------------------------
C
      call rqifl(MODE,ABSOL,PHASE,fcut,IFRCD,LRCD,DT,
     :                 ICC,ERRKNT,luc,crd,scl,q0,fpass,ist)
      irs = IFRCD
      ire = LRCD
      ist = 1

      if (irs .lt. 1) irs = 1
      if (ire .lt. 1) ire = nrec

      tmax = dt * nsamp

      IF (.not. qtape) THEN
c---
c  Q's input in card file
c---

      scl = 1.
      if(q0.eq.0.0)then
       call rqtim(T,Q,NPAIRS,JR,SR,NSAMP,IERR,luc,nsets,scl)
      else
       constq = .true.
       nsets = 1
       t(1,1) = 0.
       t(2,1) = sr*nsamp
       q(1,1) = q0
       q(2,1) = q0
       jr(1) = 1
       npairs(1)=2
      end if
     
      ic = 0
      qav = 0.
      tav = 0.
      do  700 j = 1, nsets
       write(LERR,*)' SET= ',j,' JR= ',jr(j)
       do  701 ii = 1, npairs(j)
        write(LERR,*)'ii= ',ii,' T= ',t(ii,j),' Q= ',q(ii,j)
        qj = q(ii,j)
        tj = dt * t(ii,j)
        qav = qav + tj * qj
        tav = tav + tj
        if (tj .ne. 0) ic  = ic + 1
701    continue
700   continue

      fnyq = .5 / dt
      if (fcut .le. 1.0 .AND. fcut .gt. 0.0) then
         write(LERR,*)' '
         write(LERR,*)'fcut given as a fraction of nyquist.'
         fcut = fcut * fnyq
         if (fcut .gt. .9*fnyq) fcut = .9 * fnyq
         write(LERR,*)'fcut = ',fcut
      endif
          
      if (fcut .eq. 0..and.fpass.eq.0.0) then
         qav = qav/tav
         tav = tav/float(ic)
         fcut = 4. * qav/tmax
         if (fcut .gt. .9*fnyq) fcut = .9 * fnyq
         write(LERR,*)' '
         write(LERR,*)'No -fc[fcut] given on cmd line:'
         write(LERR,*)'Will attempt run using fcut = ',fcut
         write(LERR,*)'based on avrge Q = ',qav,' and avrge time = ',
     1                 tav
         write(LERR,*)' '
      endif

      IF( IERR.EQ.1 )WRITE( LERR,25 )
      IF( IERR.EQ.2 )WRITE( LERR,30 )
      IF( IERR.EQ.3 )WRITE( LERR,35 )
      IF( IERR.EQ.4 )WRITE( LERR,40 )
      IF( IERR.EQ.5 )WRITE( LERR,45 )
      IF( IERR.EQ.6 )WRITE( LERR,50 )
25    FORMAT('0** M025 ** ERROR DETECTED BY MAIN QIFL:'/
     : 13X,'ILLEGAL INPUT CARD READ; NOT A QTIM CARD'/)
30    FORMAT('0** M0030 ** ERROR DETECTED BY MAIN QIFL:'/
     : 13X,'0QTIM CARD READ; NOT A VALID ENTRY')
35    FORMAT('0** M0035 ** ERROR DETECTED BY MAIN QIFL:'/
     : 13X,'QTIM CARD NUMBERS NOT INCREASING, OR 9QTIM CARD NOT FOUND')
40    FORMAT('0** M0040 ** ERROR DETECTED BY MAIN QIFL:'/
     : 13X,'9QTIM CARD IS BLANK; 9QTIM CARD MUST HAVE VALID ENTRIES.')
45    FORMAT('0** M0045 ** ERROR DETECTED BY MAIN QIFL:'/
     : 13X,'FIRST INPUT TIME MUST BE 0.')
50    FORMAT('0** M0050 ** ERROR DETECTED BY MAIN QIFL:'/
     : 13X,'INPUT TIMES ARE NOT INCREASING.')
      IF( IERR.EQ.0)GO TO 300
      ICC = 100
      ERRKNT = ERRKNT + 1
C
      ELSE

      if (qtap(1:1) .ne. ' ') then
          call getln (luq, qtap, 'r', -1)
      elseif (qtap(1:1) .eq. ' ' .AND. ikp .eq. 1) then
          call sisfdfit (luq, pipe)
          write(LERR,*)'qifl assumed to be running inside IKP'
      elseif (qtap(1:1) .ne. ' ' .AND. ikp .eq. 0) then
          write(lerr,*)'qifl error: Q-tape file -qt not accessible'
      endif
      if(luq .le. 0)   then
         write(lerr,*)'qifl error: Q-tape file -qt not accessible'
      endif

      call rtape(luq, QLHED , nit)

      if (NIT.eq.0)then
      WRITE(LERR,*)'End of file found trying to read Q-tape line',
     :' header.  QIFL aborted.'
      ICC=100
      stop 666
      endif

      call saver2(qlhed,ifmt_NumSmp,l_NumSmp,ln_NumSmp,nsmpq,LINEHEADER)
      call saver2(qlhed,ifmt_NumTrc,l_NumTrc,ln_NumTrc,ntrcq,LINEHEADER)
      call saver2(qlhed,ifmt_NumRec,l_NumRec,ln_NumRec,nrecq,LINEHEADER)
      call saver (qlhed,'SmpInt', nsrq  , LINHED)

      if(stk)then
       write(LERR,*)'Trace-by-trace option'
       if(ntrc*nrec.ne.ntrcq*nrecq)then
        write(LER,*)'For stack data, qtap and ntap MUST have same'
        write(LER,*)'number of traces.  FATAL! Abending!!'
        write(LERR,*)'For stack data, qtap and ntap MUST have same'
        write(LERR,*)'number of traces.  FATAL! Abending!!'
        call lbclos(luin)
        call lbclos(luout)
        call lbclos(luq)
        call ccexit (666)
       endif
      else
       write(LERR,*)'Record-by-trace option'
      endif

      itemd = (nsamp+1) * ISZBYT

      ier = 0
      jer  = 0
      abort1 = 0

      call galloc (ptabl1, itemd, jer, abort1)
      memsum=itemd
      call galloc (ptabl2, itemd, jer, abort1)
      memsum=memsum+itemd
      call galloc (pwork, itemd, jer, abort1)
      memsum=memsum+itemd
      if (ier.ne.0) then
         write(LERR,*)' '
         write(LERR,*)'FATAL ERROR in qifl:'
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) memsum,'  bytes'
         write(LERR,*)' '
         write(LER ,*)' '
         write(LER ,*)'FATAL ERROR in qifl:'
         write(LER ,*)'Unable to allocate workspace:'
         write(LER ,*) memsum,'  bytes'
         go to 2000
      endif

      if (nsrq .gt. nsr) then

         rsamp = .true.
         do  i = 1, nsamp
             tabl1 (i) = nsrq * (i-1)
         enddo
         do  i = 1, nsamp
             tabl2 (i) = nsr * (i-1)
         enddo
         icinit = 1

         write(LERR,*)' '
         write(LERR,*)'Input Q trace sample interval = ',nsrq
         write(LERR,*)'is larger than input data s.i.= ',nsr
         write(LERR,*)'Will do auto-interpolation of Q-traces onto'
         write(LERR,*)'data trace sampling.'
         write(LERR,*)' '
      else
         rsamp = .false.
      endif

      if (fcut .eq. 0..and.fpass.eq.0.0) then
          fnyq = .5 / dt
          fcut = .9 * fnyq
          write(LERR,*)' '
          write(LERR,*)'No -fc[fcut] given on cmd line:'
          write(LERR,*)'Will attempt run using fcut = ',fcut
          write(LERR,*)' '
      endif

      ENDIF

300   continue

      WRITE(LERR,55)
55    FORMAT(' SUMMARY OF PARAMETERS AFTER DEFAULTING:'/' --------------
     $-------------------------')
      IF( MODE.EQ.0 )WRITE(LERR,60)
      IF( MODE.EQ.1 )WRITE(LERR,65)
60    FORMAT(T2,'MODE  = 0 (INVERSE Q-FILTERING)')
65    FORMAT(T2,'MODE  = 1 (FORWARD Q-FILTERING)')
      IF( ABSOL.EQ.0 )WRITE(LERR,70)
      IF( ABSOL.EQ.1 )WRITE(LERR,75)
70    FORMAT(T2,'QTYPE = 0 (AVERAGE Q-INPUT)')
75    FORMAT(T2,'QTYPE = 1 (INTERVAL Q INPUT)')
      IF( PHASE.EQ.0 )WRITE(LERR,80)fcut
      IF( PHASE.EQ.1 )WRITE(LERR,85)fcut
80    FORMAT(T2,'PHASE = 0 (ZERO PHASE LOWPASS FILTER APPLIED WITH CUTOF
     :F FREQUENCY ',F6.0,' HZ)'//)
85    FORMAT(T2,'PHASE = 1 (MINIMUM PHASE LOWPASS FILTER APPLIED WITH CU
     :TOFF FREQUENCY ',F6.0,' HZ)'//)
C
C
      IF (ERRKNT .NE. 0) GOTO 1900
C
C         -----------------------------
C         | COMPUTE THE OUTPUT LENGTH |
C         -----------------------------
C
      LENOUT=NSAMP*SZSMPD+SZTRHD
      obytes=LENOUT
C
C         ------------------------------------------------
C         | UPDATE THE LINE HEADER.                      |
C         ------------------------------------------------
C
      IGOTIT=0
      call hlhprt(itr,nit,name,4,LERR)
C
C         ---------------------------------
C         | WRITE THE OUTPUT LINE HEADER. |
C         ---------------------------------
C
      call savhlh(itr ,nit,njto)
      call wrtape(luout,itr ,njto)
C
C         -------------------------------------------------
C         | BUILD THE STABLIZING FILTER ACCORDING TO USER |
C         | SPECIFIED ZERO OR MINIMUN PHASE.              |
C         ------------------------------------------------
C
      IF (phase.eq.0) THEN

       call bessel(filt,fcut,lfilt1,dt,LERR)
       mid = lfilt1/2 + 1
       xnorm = filt(mid)
       do jj=1,lfilt1
        filt(jj)=filt(jj)/xnorm
       end do
       kf=mid-1
       write(LERR,*)'BESSEL:'
       write(LERR,*)(FILT(i),i=1,lfilt1)

      ELSE
C
C         -----------------------------------------
C         | ERROR CHECK FOR MINUMUM PHASE ROUTINE |
C         -----------------------------------------
C
       call bpass(0.0,0.0,fcut-5,fcut+5,sr,512,amp,ierr)
       if (ierr.eq.1)then
        write(LERR,315)
        call lbclos(luin)
        call lbclos(luout)
        if (qtape) call lbclos(luq)
        stop
       endif
       if (ierr.eq.2)then
        write(LERR,325)
        call lbclos(luin)
        call lbclos(luout)
        if (qtape) call lbclos(luq)
        stop
       endif
       call minp(amp,512,9,filt2,phi)
       lfilt1 = ifix(1.0/(4.0*sr))
       kf=1
       do while(filt2(kf).lt.filt2(kf+1).and.kf.lt.lfilt1)
        kf=kf+1
       end do
       kf=kf-1
       if(kf.le.0)kf=1
       do i=1,lfilt1
        filt(i)=filt2(i)
       end do
       write(LERR,*)'FILT:'
       write(LERR,*)(FILT(i),i=1,lfilt1)
C
 315  FORMAT(' ',T10,'*** M0315 *** ERROR DETECTED IN MAIN PROGRAM.',
     */,1X,T10,'THE FREQUENCIES MUST BE IN ASCENDING ORDER.')
C
 325  FORMAT(' ',T10,'*** M0325 *** ERROR DETECTED IN MAIN PROGRAM.',
     :/,1X,T10,'THE NYQUIST FREQUENCY EXCEEDED....CHECK CUT OFF',
     :/,1X,T10,'FREQUENCY.')
C
C         ---------------------
C         | BUILD THE FILTER. |
C         ---------------------
C
      ENDIF

      if(Fpass.eq.0.)then
       call clip2g(fcut ,dt,nsamp,lfilt2,clipg,mode)
      else
       call clip2g(fpass,dt,nsamp,lfilt2,clipg,mode)
      endif
      write(LERR,*)'CLIPG:'
      write(LERR,*)(CLIPG(i),i=1,lfilt2)
      NTERMS = INV
      IF (MODE .EQ. 1) NTERMS = FWD
      SUM = 1.0
      DO 1100 I = 1,NTERMS
          SUM = SUM*FLOAT(I)
          FACT(I) = 1.0/SUM
 1100 CONTINUE
      write(LERR,*)'FACT:'
      write(LERR,*)(fact(i),i=1,nterms)

C         --------------------------------------
C         | pass unprocessed data              |
C         --------------------------------------

      if (stk) then

         irs = (irs-1) * ntrc + 1
         ire = ire * ntrc
         ntrc = 1

      endif

      nbytes = obytes
      call recrw (1,irs-1,luin,ntrc,itr,luout, nbytes)
      if (nbytes  .eq. 0) then
         write(LERR,*)'End of file encountered on input while reading'
         write(LERR,*)'and writing initial data to be passed'
         go to 2000
      endif

C         --------------------------------------
C         | READ, PROCESS AND OUTPUT THE DATA. |
C         --------------------------------------

      DO  1000  JJ = irs, ire
c +======================+
c | get current Q vector |
c +======================+
          call getq(JJ,jr,t,q,npairs,nsamp,dt,absol,qix,scalvx,
     1              ipass, nsets, luq, qtape, nsmpq , ITHWP1, lhed,
     2              ifmt_TrcNum,l_TrcNum, ln_TrcNum, nsr, nsrq,
     3              ifmt_VPick1,l_VPick1, ln_VPick1, rsamp, ist,
     4              ifmt_RecNum,l_RecNum, ln_RecNum,verbos,rmute,
     5              ifmt_DphInd,l_DphInd, ln_DphInd,ifmt_LinInd,
     6              l_LinInd, ln_LinInd,
     7              tabl1, tabl2, work, qnull, scale,qmin, constq)

          do  1001  KK = 1, ntrc
           do mm = 1,nsamp
            qi(mm)=qix(mm)
            scalv(mm)=scalvx(mm)
           end do
           call rtape (luin, itr , nbytes)
           if (nbytes  .eq. 0) then
            write(LERR,*)'End of file on input:'
            write(LERR,*)'Rec= ',JJ,'  trc= ',KK
            go to 2000
           endif
           call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     :                 irecn , TRACEHEADER)
           call saver2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     :                 itrcn , TRACEHEADER)
           call saver2(itr,ifmt_DphInd,l_DphInd, ln_DphInd,
     :                 idi   , TRACEHEADER)
           call saver2(itr,ifmt_LinInd,l_LinInd, ln_LinInd,
     :                 ili   , TRACEHEADER)
           call vmov (itr(ITHWP1), 1, input, 1, nsamp)
           if (verbos) then
            write(LERR,*)'Operating on seqtl Rec/Trc ',jj,kk,
     :      ' actual Rec/Trc ',irecn,itrcn,' LI/DI ',ili,idi
            write(LERR,*)' '
           endif
C         +-------------------------------------+
C         | MOVE THE TRACE INTO THE WORK BUFFER |
C         +-------------------------------------+
          call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     :                istat , TRACEHEADER)

          IF(istat.GE.30000)then

           do i=1,nsamp
            output(i)=0.
           end do

          ELSE

          call detmut (input, imute, nsamp)

          if (constq) call qcon (dt, nsamp, imute, qnull, 
     1                           qi, scalv)
C         -----------------------------------------
C         | APPLY THE Q FILTER TO THE TRACE DATA. |
C         -----------------------------------------

          call cvsum(filt,lfilt1,clipg,lfilt2,input,scalv,output,nsamp,
     1               nterms,fact,phase,mode,kf,fpass,imute,ierr)
	  if (ierr) then
              write(LERR,*)'STOP: Instability detected on Rec=', JJ,
     :            ', Trc=', KK
              write(LERR,*)'      Check input Q profile or increase',
     :            ' qmin from command line.'
              write(LERR,*)' '

              write(LER,*)'STOP: Instability detected on Rec=', JJ,
     :            ', Trc=', KK
              write(LER,*)'      Check input Q profile or increase',
     :            ' qmin from command line.'
              write(LER,*)' '

              stop
          endif

          if (.not. noscl)
     1    call  scaleh (input, nsamp, output, smh, ierr, LERR, SZSMPD,
     2                  itype, nsi, lw, ampscl)

          ENDIF

          call resmut (output, imute, nsamp)
          call vmov (output, 1, itr(ITHWP1), 1, nsamp)
          call wrtape(luout,itr ,obytes)

1001      continue

1000  CONTINUE

C         -----------------------------------------
C         | pass rest of the data                 |
C         -----------------------------------------

      nbytes = obytes
      call recrw (ire+1, nrec, luin, ntrc, itr, luout, nbytes)
      if (nbytes  .eq. 0) then
         write(LERR,*)'End of file encountered on input while reading'
         write(LERR,*)'and writing final data to be passed'
         go to 2000
      endif


      GO TO 2000
 1900 CONTINUE
        IF (ERRKNT .GT.0) WRITE(LERR,350) ERRKNT
 350    FORMAT(' ',T10,'*** M0250 *** PROGRAM QIFL ABENDED DUE TO ',I4,
     *          T10,'ERRORS. ****')
 2000 CONTINUE

      call lbclos(luin)
      call lbclos(luout)
      if (qtape)  then
         call lbclos(luq)
      endif
      stop

      END

      SUBROUTINE CLIP2G (fcut,TIME,NUMS,NUMG,CLIPG,MODE)
C **********************************************************************
C  A ROUTINE CALCULATING THE CLIPPED G FILTER FOR THE QPANALING
C  PROCEEDURE
C
C        fcut - HIGH CUT FREQUENCY
C        TIME - TIME IN SECONDS
C        NUMS - NUMBER OF SAMPLES IN TRACE
C        NUMG - NUMBER OF POINTS IN THE CLIPPED G FILTER
C       CLIPG - CLIPPED G FILTER ARRAY
C        MODE - INDICATES FORWARD OR INVERSE FILTERING
C **********************************************************************

      DIMENSION CLIPG(1)
      REAL SINQ,PI,TIME,ALPHA,PALPHA,FI,SN2,DENOM,fcut
      real * 4 fac,sn
      INTEGER NUMS,NUMG,MODE
C
C -- SET SINQ ACCORDING TO THE MODE, DEFUALT IS INVERSE Q
      SINQ = 1.
      IF (MODE .EQ. 1) SINQ = -1.
C -- SET CONSTANTS
      ALPHA   = fcut*TIME
      PI      = 3.1415926
      PALPHA  = PI*ALPHA
C -- COMPUTE THE CLIPPED G
      CLIPG(1) = SINQ*ALPHA*(1.-ALPHA)
      DO 20 I = 2,NUMG
          FI    = FLOAT(I-1)
          FAC   = PALPHA*FI
          cs    = cos(FAC)
          sn    = sqrt (1. - cs*cs)
          if (abs(sn) .gt. 1.e-03) then
             SN2   =  SN*SN
             DENOM = PI*PI*FI*FI
             CLIPG(I) =SINQ*(-2.*SN2/DENOM)
          else
             tmp1 = clipg(i-1)
             fi   = float(i)
             sn = sin(fi*PALPHA)
             sn2 = sn*sn
             denom = PI*PI*FI*FI
             tmp2 = SINQ*(-2.*SN2/DENOM)
             clipg(i) = .5 * (tmp1 + tmp2)
          endif
 20   CONTINUE

cc	clipg(1) = SINQ*0.25
cc	do i = 2, numg
cc	    if ( mod(i,2) .eq. 0) then
cc	        fi = float(i-1)
cc	        denom = PI*PI*FI*FI
cc		clipg(i) = SINQ*(-2./denom)
cc	    else
cc	    	clipg(i) = 0
cc	    endif
cc  	enddo

      RETURN
      END
C **********************************************************************
C
C ----SUBPROGRAM TO COMPUTE A LOW PASS BESSEL FILTER WITH UPPER
C     CUT-OFF FREQUENCY fcut (-6 DB POINT) --> 0 DB POINT = fcut-5 HZ,
C     REJECT FREQUENCY = fcut+5 <--  REJECT LEVEL IS SPECIFIED BY DBR,
C     SAMPLE RATE OF DT (SECONDS).
C
C **********************************************************************
      SUBROUTINE BESSEL(FILT,fcut,LFILT,TIME,LUPRT)
      REAL * 4    FILT(1), TIME,fcut
      INTEGER * 4 LFILT
      DATA        DBR/40.0/
C
C     CHECK CUTOFF FREQUENCY fcut AGAINST MINIMUM ALLOWABLE FREQUENCY
C
      IF( fcut.GE.5.0 )GO TO 25
      WRITE(LUPRT,20)fcut
20    FORMAT(' ',T10,'*** SO101 *** ERROR DETECTED IN BESSEL',
     +/,1X,T10,'THE SPECIFIED CUTOFF FREQUENCY OF ',F4.0,' HAS BEEN',
     +/,1X,T10,'RESET TO MINIMUM ALLOWABLE FREQUENCY OF 5 HERTZ')
      fcut = 5.0
25    CONTINUE
C
C     CHECK CUTOFF FREQUENCY fcut AGAINST NYQUIST TO PREVENT
C     ALIASING.
C
      FMAX = ( 1.0 / ( 2.0*TIME ) ) - 5.0
      IF( FCUT.gt.FMAX )then
      WRITE(LUPRT,30)FCUT,FMAX
30    FORMAT(' ',T10,'*** SO101 *** ERROR DETECTED IN BESSEL',
     +/,1X,T10,'THE SPECIFIED CUTOFF FREQUENCY OF ',F4.0,' HAS BEEN',
     +/,1X,T10,'RESET TO ',F4.0,' TO PREVENT ALIASING')
      FCUT = FMAX
      endif
C
C ----CALCULATE THE FILTER LENGTH
C
      LFILT = ( .06956*DBR - 0.5 ) / ( 10.0*TIME )
      LFILT = LFILT / 2*2 + 1
C
C ----CALCULATE THE EXPONENT
C
      EXPONT = -8.041 + 1.789*SQRT( DBR )
      IF( EXPONT.LT.0. )EXPONT=0.0
C
C ----COMPUTE THE FILTER
C
      call idef3(FCUT,TIME,EXPONT,LFILT,FILT)
      RETURN
      END
C **********************************************************************
C
C ----SUBROUTINE IDEF3 WRITTEN BY KEN PEACOCK COMPUTES THE LOWPASS
C     BESSEL FILTER
C
C
C      FCUT  - FILTER CUTOFF FREQUENCY
C      TIME  - SAMPLE TIME IN SECONDS
C      EXP   - VALUE CALLED FOR IN SUBROUTINE
C      LFILT - LENGHT OF FILTER
C      FILT  - FILTER ARRAY
C **********************************************************************
      SUBROUTINE IDEF3(FCUT,TIME,EXP,LFILT,FILT)
      REAL * 4  FILT(1),FCUT
      INTEGER * 4 LFILT
      FACT1 = 2.*3.1415927*FCUT*TIME
      FACT2 = 3.1415927*TIME
      EX = EXP
      N = LFILT / 2
      ISTA = N + 2
      KFACT = 1 - ISTA
      JFACT = LFILT + 1
      DO 1 I = ISTA,LFILT
         AK=I+KFACT
         FILT( I ) = SIN( FACT1*AK ) / ( FACT2*AK )
         J = JFACT - I
    1    FILT( J ) = FILT( I )
         FILT( ISTA-1 ) = 2.0*FCUT
       DO 2 I = ISTA,LFILT
         J = JFACT - I
    2    FILT(J) = FILT(I)
      IF(EX.LE.0.) RETURN
      DEN = 1.0
      DS  = 1.0
      D = 0.0
    3 D  = D + 2.0
      DS = DS*EX*EX / ( D*D )
      DEN = DEN + DS
      IF(DS.GT.0.2E-8*DEN) GO TO 3
      DO 5 I = ISTA,LFILT
         AK = I + KFACT
         EXX = EX*SQRT( 1.-( AK / N )**2 )
         ANUM=1.0
         DS = 1.0
         D  = 0.0
    4    D  = D + 2.0
      DS = DS*EXX*EXX / ( D*D )
      ANUM=ANUM+DS
      IF( DS.GT.0.2E-8*ANUM) GO TO 4
      FILT( I ) = FILT(I )*ANUM / DEN
      J = JFACT - I
    5 FILT( J ) = FILT( I )
         RETURN
      END
C***********************************************************************
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C                                                                      *
C                                                                      *
C***********************************************************************
C  ROUTINE:       BPASS
C  ROUTINE TYPE:  SUBROUTINE
C  PURPOSE:       COMPUTE AN ORMSBY TYPE TRAPEZOIDAL MAGNITUDE SPECTRUM
C                 DIRECTLY IN FREQUENCY DOMAIN, WITH A CONSTANT -40 DB
C                 REJECT LEVEL.
C
C  ARGUMENTS:
C   +-----------------------------------------------------------+
C   |                                                           |
C   | F1      - FIRST FREQUENCY POINT (-40DB)  = REJECT         |
C   | F2      - SECOND FREQUENCY POINT (0DB)   = PASS           |
C   | F3      - THIRD FREQUENCY POINT  (0DB)   = PASS           |
C   | F4      - FOURTH FREQUENCY POINT (-40DB) = REJECT         |
C   |                                                           |
C   | FOR LOWPASS FILTER,  F1 = F2 = 0.0                        |
C   |                                                           |
C   | FOR HIGHPASS FILTER, F3 = F4 = 0.0                        |
C   |                                                           |
C   | FOR BANDPASS FILTER, F1 < F2 < F3 < F4                    |
C   | ( NOTE: A 0/0/0/0 FILTER IS NOT ALLOWED )                 |
C   |                                                           |
C   | SI      - SAMPLE INTERVAL IN MILLISECONDS                 |
C   |                                                           |
C   | N       - NUMBER OF POINTS IN THE AMPLITUDE SPECTRUM      |
C   |           ARRAY - MUST BE A POWER OF 2                    |
C   |                                                           |
C   | A       - AMPLITUDE SPECTRUM ARRAY                        |
C   |                                                           |
C   | IERR    - ERROR RETURN CODE                               |
C   |                                                           |
C   |         = 0, NO ERRORS                                    |
C   |                                                           |
C   |         = 1, FREQUENCIES ARE NOT ASCENDING FOR BANDPASS   |
C   |           MODE OF DESIGN.                                 |
C   |                                                           |
C   |         = 2, FREQUENCY HAS EXCEEDED THE NYQUIST FREQUENCY |
C   |                                                           |
C   +-----------------------------------------------------------+
C
C  CATEGORY:      FILTERING
C  KEYWORDS:      BANDPASS, ORMSBY
C
C       +------------------------------------------------------+
C       |               DEVELOPMENT INFORMATION                |
C       +------------------------------------------------------+
C  AUTHOR:    JOHN D. MCGLYNN                 ORIGIN DATE:  85/11/15
C  LANGUAGE:  FORTRAN IV
C       +------------------------------------------------------+
C       |                 EXTERNAL ENVIRONMENT                 |
C       +------------------------------------------------------+
C  ROUTINES CALLED:
C      NONE
C
C  FILES:
C      NONE
C       +------------------------------------------------------+
C       |             SPECIAL DOCUMENTATION ITEMS              |
C       +------------------------------------------------------+
C  STOP CODES:
C               -
C       +------------------------------------------------------+
C       |             OTHER DOCUMENTATION DETAILS              |
C       +------------------------------------------------------+
C               -
C  ERROR HANDLING:  ERROR RETURN CODES - SEE ARGUMENT LIST
CC
C***********************************************************************
       SUBROUTINE BPASS(F1,F2,F3,F4,SI,N,A,IERR)
       REAL * 4 A( N ),FV( 4 )
C   +-----------------------------------------------------------+
C   | CONVERT SAMPLE INTERVAL FROM MILLISECONDS TO SECONDS AND  |
C   | CHECK UPPER FREQUENCY AGAINST NYQUIST                     |
C   +-----------------------------------------------------------+
       SI      = SI / 1000.0
       FNYQ    = 1.0 / ( 2.0 * SI )
       IERR    = 2
       IF( F4.GT.FNYQ )RETURN
         FV( 1 ) = F1
         FV( 2 ) = F2
         FV( 3 ) = F3
         FV( 4 ) = F4
C   +-----------------------------------------------------------+
C   | CHECK FOR NON-ASCENDING FREQUENCIES - EXCLUDING THE       |
C   | CASE OF LOW-PASS OR HIGH-PASS BANDS, I.E., 0/0/F3/F4,     |
C   | OR F1/F2/0/0                                              |
C   +-----------------------------------------------------------+
       IERR = 1
       IF( ( F3.EQ.0.0 ).AND.( F4.EQ.0.0 ) ) GO TO 105
       DO 100 I  = 1,3
          FCHEK  = FV( I+1 ) - FV( I )
          FZERO  = FV( I+1 ) + FV( I )
          IF( ( FCHEK.LT.0.0 ).AND.( FZERO.NE.0.0 ) ) RETURN
 100   CONTINUE
 105   IERR = 0
C   +-----------------------------------------------------------+
C   | INITIALIZE RESPONSE TO ALL PASS ( 1.0 )                   |
C   +-----------------------------------------------------------+
       DO 5 I = 1,N
 5      A( I ) = 1.0
C   +-----------------------------------------------------------+
C   | SET FREQUENCY INCREMENT SCALING ===> SCAL                 |
C   +-----------------------------------------------------------+
       SCAL   =  SI * FLOAT( N )
C   +-----------------------------------------------------------+
C   | SET F3 AND F4 TO NYQUIST FREQUENCY IF HIGH PASS FILTERING |
C   | IS INDICATED.                                             |
C   +-----------------------------------------------------------+
       IF( ( F3.NE.0.0 ).AND.( F4.NE.0.0 ) ) GO TO 110
       f3 = fnyq
       f4 = fnyq
 110      CONTINUE
C   +-----------------------------------------------------------+
C   | SCALE THE FREQUENCIES TO THE TRANSFORM SPACE FREQUENCY    |
C   | SAMPLING.                                                 |
C   +-----------------------------------------------------------+
          LF1    = F1 * SCAL
          LF2    = F2 * SCAL
          LF3    = F3 * SCAL
          LF4    = F4 * SCAL
          LF1P1  = LF1 + 1
          LF2P1  = LF2 + 1
          LF3P1  = LF3 + 1
          LF4P1  = LF4 + 1
C   +-----------------------------------------------------------+
C   | SET FIRST REJECT ZONE TO -40 DB ( 0.01 )                  |
C   +-----------------------------------------------------------+
       IF (LF1.EQ.1) GOTO 11
       DO 10 I = 1,LF1
         A( I ) = 0.01
 10       CONTINUE
 11       DELTL  = LF2 - LF1
          K      = 1
          SLPL   = 1.0
C   +-----------------------------------------------------------+
C   | CREATE THE FIRST RAMP                                     |
C   +-----------------------------------------------------------+
            IF( DELTL.GT.0.0 ) SLPL = 0.99 / DELTL
               DO 15 I  = LF1P1,LF2
                 A( I ) = K*SLPL
 15              K      = K + 1
C   +-----------------------------------------------------------+
C   | CREATE THE SECOND RAMP                                    |
C   +-----------------------------------------------------------+
            IF( F3.EQ.F4 )GO TO 30
            DELTH  = LF4 - LF3
            K      = 1
            SLPH   = 1.0
            IF( DELTH.GT.0.0 ) SLPH = 0.99 / DELTH
               DO 20 I  = LF3P1,LF4
                 A( I ) = 1.0 - K * SLPH
 20              K      = K + 1
C   +-----------------------------------------------------------+
C   | SET SECOND REJECT ZONE TO -40 DB ( 0.01 ), AND FLIP       |
C   | SPECTRUM AT NYQUIST                                       |
C   +-----------------------------------------------------------+
            NYQ      = N / 2 + 1
            DO 25 I  = LF4P1,NYQ
 25           A( I ) = 0.01
 30         CONTINUE
          DO 35 I  = 2,NYQ
            K      = N - I + 2
            A( K ) =  A( I )
 35         CONTINUE
       RETURN
       END
C***********************************************************************
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C                                                                      *
C                                                                      *
C***********************************************************************
C  ROUTINE:       MINP
C  ROUTINE TYPE:  SUBROUTINE
C  PURPOSE:
C   +-----------------------------------------------------------+
C   |    ROUTINE TO CALCULATE THE MINIMUM-PHASE SPECTRUM OF     |
C   |    A WAVLET, GIVEN ITS MAGNITUDE SPECTRUM, BY A           |
C   |    KOLMOGOROFF SPECTRAL FACTORIZATION; THE RESULTING      |
C   |    COMPLEX SPECTRUM IS SUBSEQUENTLY TRANSFORMED TO A      |
C   |    TIME DOMAIN MINIMUM DELAY IMPULSE RESPONSE VIA A       |
C   |    FAST FOURIER TRANSFORM.                                |
C   +-----------------------------------------------------------+
C
C
C  ARGUMENTS:
C   +-----------------------------------------------------------+
C   |                                                           |
C   | A       - AMPLITUDE SPECTRUM ARRAY                        |
C   |                                                           |
C   | L       - NUMBER OF POINTS IN THE AMPLITUDE SPECTRUM      |
C   |           ARRAY - MUST BE A POWER OF 2                    |
C   |                                                           |
C   | L2      - BASE 2 LOGARITHM OF N, E.G., N = 512, N2 = 9    |
C   |                                                           |
C   | F       - TIME DOMAIN MINIMUM-DELAY FILTER (ON RETURN)    |
C   |                                                           |
C   | PHI     - PHASE-SPECTRUM (MINIMUM-PHASE) ARRAY            |
C   |                                                           |
C   +-----------------------------------------------------------+
C  CATEGORY:      FILTERING
C  KEYWORDS:      MINIMUM PHASE, HILBERT TRANSFORM
C
C       +------------------------------------------------------+
C       |               DEVELOPMENT INFORMATION                |
C       +------------------------------------------------------+
C  AUTHOR:    JOHN D. MCGLYNN                 ORIGIN DATE:  85/11/15
C  LANGUAGE:  FORTRAN IV
C       +------------------------------------------------------+
C       |                 EXTERNAL ENVIRONMENT                 |
C       +------------------------------------------------------+
C  ROUTINES CALLED:
C      NLOGN : RADIX 2 COMPLEX FFT
C
C  FILES:
C      NONE
C       +------------------------------------------------------+
C       |             SPECIAL DOCUMENTATION ITEMS              |
C       +------------------------------------------------------+
C  STOP CODES:
C               -
C       +------------------------------------------------------+
C       |             OTHER DOCUMENTATION DETAILS              |
C       +------------------------------------------------------+
C               -
C  ERROR HANDLING:
CC
C***********************************************************************
       SUBROUTINE  MINP(AMP,L,L2,FMINP,PHI)
       REAL*4 AMP( L ),FMINP( L )
       COMPLEX PHI( L )
C
C ----FOR A GIVEN AMPLITUDE SPECTRUM, THIS ROUTINE
C     CALCULATES A MINIMUM PHASE SPECTRUM BY USING THE
C     HILBERT TRANSFORM METHOD.
C
C   +-----------------------------------------------------------+
C   | SET MAXIMUM REJECT LEVEL TO -40 DB ( 0.01 )               |
C   +-----------------------------------------------------------+
       DO 15 I=1,L
 15      IF( AMP( I ).LT.0.01) AMP( I ) = 0.01
          DO 10 I    = 1,L
            SAMP     = ALOG( AMP( I ) )
 10         PHI( I ) = SAMP
          CALL NLOGN(L2,PHI,1.0)
          L1 = L / 2
               DO 20 I    = 2,L1
 20              PHI( I ) = 2.0 * PHI( I )
        L3       =  L1 + 2
        DO 30 I  =  L3,L
 30       PHI(I) =  0.0
        CALL NLOGN(L2,PHI,-1.0)
       DO 40 I = 1,L
 40      PHI( I ) = CEXP( PHI( I ) )
         CALL NLOGN(L2,PHI,1.0)
       DO 50 I = 1,L
 50      FMINP( I ) = REAL( PHI( I ) )
       RETURN
       END
C   +-----------------------------------------------------------+
C   | SUBROUTINE NLOGN:                                         |
C   |                                                           |
C   | FAST FOURIER TRANSFORM ROUTINE                            |
C   |                                                           |
C   | SUBROUTINE NLOGN(N,X,SIGN) N IS A POWER OF 2              |
C   |            N IS A POWER OF 2                              |
C   |            X IS COMPLEX INPUT                             |
C   |            SIGN -1 FOR FORWARD +1 FOR INVERSE TRANSFORM   |
C   |                                                           |
C   +-----------------------------------------------------------+
       SUBROUTINE NLOGN(N,X,SIGN)
       REAL * 4 M( 32 )
       COMPLEX X( 2 ), WK, HOLD, Q
       LX = 2 * * N
       DO 10  I  = 1,N
 10       M( I ) = 2 * * ( N - I )
          DO 40  L = 1,N
            NBLOCK = 2 * * ( L - 1 )
            LBLOCK = LX / NBLOCK
            LBHALF = LBLOCK / 2
               K      = 0
               DO 40 IBLOCK = 1,NBLOCK
                 FK         = K
                 FLX        = LX
                 V          = SIGN * 6.2831853 * FK / FLX
                 WK         = CMPLX( COS( V ),SIN( V ) )
                 ISTART     = LBLOCK * ( IBLOCK - 1 )
                    DO 20 I   = 1,LBHALF
                      J       = ISTART + I
                      JH      = J + LBHALF
                      Q       = X( JH ) * WK
                      X( JH ) = X( J ) - Q
                      X( J )  = X( J ) + Q
 20                 CONTINUE
               DO 30 I = 2,N
                 II    = I
                IF( K.LT.M( I ) ) GO TO 40
 30       K = K - M( I )
 40    K = K + M( II )
       K = 0
          DO 70 J = 1,LX
            IF( K.LT.J ) GO TO 50
            HOLD       = X( J )
            X( J )     = X( K + 1 )
            X( K + 1 ) = HOLD
 50         DO 60 I  = 1,N
               II   =  I
               IF( K.LT.M( I ) ) GO TO 70
 60            K    = K - M( I  )
 70            K    = K + M( II )
            IF(SIGN.LT.0.) RETURN
          DO 80 I  =1,LX
 80         X( I ) = X( I ) / FLX
       RETURN
       END
C***********************************************************************
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C                                                                      *
C                                                                      *
C***********************************************************************
C  ROUTINE:       RQIFL
C  ROUTINE TYPE:  SUBROUTINE
C  PURPOSE:       READ "1QIFL" CARD, SET DEFAULTS AND DO ERROR CHECKING
C
C  ARGUMENTS:
C
C        MODE   - Q-FILTERING MODE
C               - 0 INDICATES INVERSE Q-FILTER
C               - 1 INDICATES FORWARD Q-FILTER
C
C        ABSOL  - FLAG TO INDICATE TYPE OF Q VALUES INPUT
C               - 0 INDICATES AVERAGE/RMS Q-VALUES (INTERPOLATE)
C               - 1 INDICATES ABSOLUTE/INTERVAL VALUES (CONVERT TO AVG)
C
C        PHASE  - BANDLIMITING FILTER PHASE
C               - 0 INDICATES MINIMUM-PHASE LOWPASS FILTER
C               - 1 INDICATES ZERO-PHASE LOWPASS FILTER
C
C        FCUT   - CUTOFF FREQUENCY OF LOWPASS FILTER
C
C        IFRCD  - FIRST RECORD TO PROCESS
C
C        LRCD   - LAST RECORD TO PROCESS
C
C        DT     - SAMPLE INTERVAL OF DATA IN SECONDS (USED FOR ERROR
C                 CHECKING)
C
C        ICC    - ERROR RETURN CODE
C
C         SAMPLE CALL IS:
C
C                 CALL RQIFL(CARD,MODE,ABSOL,PHASE,FCUT,IFRCD,LRCD,
C                +           ICC,ERRKNT)
C  CATEGORY:      UTILITY
C  KEYWORDS:      1QIFL
C
C       +------------------------------------------------------+
C       |               DEVELOPMENT INFORMATION                |
C       +------------------------------------------------------+
C  AUTHOR:    JOHN D. MCGLYNN                 ORIGIN DATE:  86/01/22
C  LANGUAGE:  FORTRAN IV
C       +------------------------------------------------------+
C       |                 EXTERNAL ENVIRONMENT                 |
C       +------------------------------------------------------+
C  ROUTINES CALLED:
C      WRCARD
C
C  FILES:
C      NONE
C       +------------------------------------------------------+
C       |             SPECIAL DOCUMENTATION ITEMS              |
C       +------------------------------------------------------+
C  STOP CODES:
C      0        -
C       +------------------------------------------------------+
C       |             OTHER DOCUMENTATION DETAILS              |
C       +------------------------------------------------------+
C  ERROR HANDLING:  RETURN CODES
CC
C***********************************************************************
C
      SUBROUTINE rqifl(MODE,ABSOL,PHASE,FCUT,IFRCD,LRCD,DT,
     +                 ICC,ERRKNT,luc,crd,scl,q0,fpass,ist)
#include <f77/localsys.h>
#include <f77/sisdef.h>
#include <f77/iounit.h>
#include <f77/pid.h>
      INTEGER MODE, ABSOL, PHASE, IFRCD, LRCD, ICC,ERRKNT, PRNTR
      REAL * 4 FCUT,DT, FNYQ
      character qiflid*5,cardid*5,card*80
      logical   crd

      prntr = LERR

      IF (crd) THEN

      qiflid = '1QIFL'
C
C         ---------------------------
C         | READ "1QIFL" INPUT CARD |
C         ---------------------------
C
      READ (luc,5,END=999)CARD,CARDID,MODE,ABSOL,PHASE,FCUT,IFRCD,LRCD
5     FORMAT (a80,T1,A5,T6,I1,I1,2X,I1,F3.0,2X,I5,I5)
C
C         -------------------------------
C         | WRITE CARD IMAGE TO PRINTER |
C         -------------------------------
C
      write(LERR,'(a80)')card
      IF(CARDID .EQ. QIFLID)GO TO 20
      WRITE(LERR,10)
10    FORMAT('0** M0010 ** ERROR DETECTED BY RQIFL:'/
     $ 13X,'FIRST INPUT DATA CARD IS NOT A 1QIFL CARD'/)
      ICC = 100
      ERRKNT = ERRKNT + 1
20    CONTINUE

      ELSE

          call argi4 ('-md', MODE, 0, 0)
          call argi4 ('-ab', ABSOL, 0, 0)
          call argi4 ('-ph', PHASE, 0, 0)
          call argr4 ('-fc', FCUT, 0., 0.)
          call argi4 ('-rs', IFRCD, 0, 0)
          call argi4 ('-re', LRCD, 0, 0)
          call argr4 ('-q', q0, 0.0, 0.0)
          call argr4 ('-fp', fpass,0.,0.)
          call argi4 ('-s', ist, 0, 0)

      ENDIF
C
C         ---------------------------
C         | SET DEFAULTS            |
C         ---------------------------
C
      FCUT = ABS( FCUT )
C
C         ---------------------------
C         | CHECK FOR VALID CARD ID |
C         ---------------------------
C
C
C         ------------------------------------------------
C         | CHECK MODE VALIDITY                          |
C         ------------------------------------------------
C
      IF( MODE .EQ. 0 .OR. MODE.EQ.1 )GO TO 40
      WRITE(LERR,30)MODE
30    FORMAT('0** M0030 ** WARNING FROM RQIFL '/
     $ 13X,'MODE WAS SPECIFIED AS ',I2,'.  VALID MODES ARE 0 AND 1; VALU
     $E WAS RESET TO 0'/)
      MODE  = 0
40    CONTINUE
C
C         ------------------------------------------------
C         | CHECK Q-TYPE VALIDITY                        |
C         ------------------------------------------------
C
      IF( ABSOL.EQ. 0 .OR. ABSOL.EQ.1 )GO TO 60
      WRITE(LERR,50)ABSOL
50    FORMAT('0** M0050 ** WARNING FROM RQIFL '/
     $ 13X,'Q-TYPE WAS SPECIFIED AS ',I2,'.  VALID MODES ARE 0 AND 1; VA
     $LUE WAS RESET TO 0'/)
      ABSOL = 0
60    CONTINUE
C
C         ------------------------------------------------
C         | CHECK PHASE FLAG VALIDITY                    |
C         ------------------------------------------------
C
      IF( PHASE.EQ. 0 .OR. PHASE.EQ.1 )GO TO 80
      WRITE(LERR,70)PHASE
70    FORMAT('0** M0070 ** WARNING FROM RQIFL '/
     $ 13X,'PHASE WAS SPECIFIED AS ',I2,'.  VALID MODES ARE 0 AND 1; VAL
     $UE WAS RESET TO 0'/)
      PHASE = 0
80    CONTINUE
C
C         ------------------------------------------------
C         | CHECK FCUT AGAINST MINIMUM ALLOWABLE         |
C         | FREQUENCY (5 HZ) AND MAXIMUM ALLOWABLE       |
C         | FREQUENCY ( NYQUIST - 5 HZ).                 |
C         ------------------------------------------------
C
      FNYQ = 1.0 / ( 2.0 * DT )
      FMIN = 5.0
      FMAX = FNYQ - 5.0
      IF( FCUT.LT.FMAX )GO TO 120
      WRITE(PRNTR,110)FCUT,FMAX,FMAX
110   FORMAT('0** M0110 ** WARNING FROM RQIFL '/
     $ 13X,'FCUT WAS SPECIFIED AS',F5.0,' WHICH IS GREATER THAN MAXIMUM
     $ ALLOWABLE OF ',F4.0,/13X,'VALUE RESET TO MAXIMUM ALLOWABLE FREQUE
     $NCY OF ',F4.0/)
      FCUT  = FMAX
120   CONTINUE
      GO TO 1000
999   WRITE(PRNTR,130)
130   FORMAT('0** M0999 ** ERROR DETECTED BY RQIFL '/
     $ 13X,'INPUT CARD MISSING - EXECUTION TERMINATED'/)
      ICC = 100
      ERRKNT = ERRKNT + 1
1000  CONTINUE
      RETURN
      END
C***********************************************************************
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C                                                                      *
C                                                                      *
C***********************************************************************
C  ROUTINE:       RQTIM
C  ROUTINE TYPE:  SUBROUTINE
C  PURPOSE:       READ "1-9QTIM" CARDS
C
C  ARGUMENTS:
C
C        TIME   - R*4 - INPUT TIMES FROM CARDS
C        QVAL   - R*4 - INPUT Q-VALUES FROM CARDS
C        T      - R*4 - RETURNED TIME VALUE ARRAY
C        Q      - R*4 - RETURNED Q-VALUE ARRAY
C        NPAIRS - I*4 - NUMBER OF VALUES IN T,Q ARRAYS
C        JR     - I*4 - Record Numbers for T,Q ARRAYS
C        NSAMP  - R*4 - NUMBER OF DATA SAMPLES PER TRACE
C        SI     - R*4 - SAMPLE INTERVAL OF DATA IN MILLISECONDS
C
C        IERR   - R*4 - ERROR RETURN CODE
C
C         SAMPLE CALL IS:
C
C            CALL RQTIM( TIME , QVAL, T, Q, NPAIRS,JR, SI, NSAMP, IERR )
C
C  CATEGORY:      UTILITY
C  KEYWORDS:      QTIM
C
C       +------------------------------------------------------+
C       |               DEVELOPMENT INFORMATION                |
C       +------------------------------------------------------+
C  AUTHOR:    JOHN D. MCGLYNN                 ORIGIN DATE:  86/01/22
C  LANGUAGE:  FORTRAN IV
C       +------------------------------------------------------+
C       |                 EXTERNAL ENVIRONMENT                 |
C       +------------------------------------------------------+
C  ROUTINES CALLED:
C
C  FILES:
C      NONE
C       +------------------------------------------------------+
C       |             SPECIAL DOCUMENTATION ITEMS              |
C       +------------------------------------------------------+
C  STOP CODES:
C      0        -
C       +------------------------------------------------------+
C       |             OTHER DOCUMENTATION DETAILS              |
C       +------------------------------------------------------+
C  ERROR HANDLING:  RETURN CODES
CC
C***********************************************************************
C
      SUBROUTINE RQTIM( T, Q, NPAIRS,JR, SI, NSAMP, IERR,luc,
     :nsets,scl)

#include <f77/sisdef.h>
#include <f77/iounit.h>
#include <f77/pid.h>
      INTEGER  npairs(*),jr(*)
      REAL * 4 TIME( 64 ), QVAL( 64 ), T( 64,70 ), Q( 64,70 )
      INTEGER CRDNUM, OLDCRD, luc, IERR, irec
      character card*80,cardid*4,qtim*4
      DATA CARDID/'    '/, CRDNUM/0/, QTIM/'QTIM'/, OLDCRD/0/
C   +-----------------------------------------------------------+
C   | READ Q-TIME PAIRS IN, ONE CARD AT A TIME, AND CHECK FOR   |
C   | VALIDITY.                                                 |
C   +-----------------------------------------------------------+
      write(LERR,*)'si,nsamp,scl= ',si,nsamp,scl
      kk = 1
      OLDCRD = 0
29    I = 0
30    READ( LUC,20,END=999)CARD,CRDNUM,CARDID,(TIME(J),QVAL(J),J=1,7),
     :irec
      if(irec.ne.0)jr(kk)=irec
20    FORMAT(a80,T1,I1,A4,7(F5.0,F5.0),t76,i5 )
c999   CONTINUE
C
C         -------------------------------
C         | WRITE CARD IMAGE TO PRINTER |
C         -------------------------------
C
      write(LERR,'(a80)')card
C
      IF( CARDID.EQ.QTIM )GO TO 10
         IERR = 1
         RETURN
 10    CONTINUE
C   +-----------------------------------------------------------+
C   | PERFORM VALIDITY CHECKS                                   |
C   +-----------------------------------------------------------+
      IF( CRDNUM.le.0 )then
         IERR = 2
         RETURN
      ENDIF
      IF( CRDNUM.le.OLDCRD )THEN
         IERR = 3
         RETURN
      ENDIF
      OLDCRD = CRDNUM
C   +-----------------------------------------------------------+
C   | HANDLE 9QTIM CARD DIFFERENTLY                             |
C   +-----------------------------------------------------------+
      IF( CRDNUM.EQ.9 )GO TO 1010
C
C   +-----------------------------------------------------------+
C   | STORE (TIME - Q) PAIRS                                    |
C   +-----------------------------------------------------------+
C
      DO 45 J = 1,7
         I    = I + 1
         T(I,kk) = TIME(J)
         Q(I,kk) = QVAL(J) * scl
45    CONTINUE
C
C   +-----------------------------------------------------------+
C   | READ ANOTHER CARD                                         |
C   +-----------------------------------------------------------+
C
      GO TO 30
C
C   +-----------------------------------------------------------+
C   | THIS IS WHERE A 9QTIM CARD IS READ - INITIALIZE LOOP      |
C   +-----------------------------------------------------------+
C
 1010 continue
      J = 8
 1020  J = J - 1
C
C   +-----------------------------------------------------------+
C   | LEAVE THE LOOP WHEN A NON-ZERO T-Q PAIR IS FOUND...       |
C   +-----------------------------------------------------------+
C
      IF( ( TIME(J).NE.0.0 ).OR.( Q(J,kk).NE.0.0 ) )GO TO 1030
C
C   +-----------------------------------------------------------+
C   | ...OTHERWISE, JUMP BACK AND COUNT SOME MORE ...           |
C   +-----------------------------------------------------------+
C
       GO TO 1020
 1030  JMAX = J
c     j=7
c     do while((time(j).eq.0.0).and.(q(j,kk).eq.0.0))
c      j=j-1
c     end do
C
C   +-----------------------------------------------------------+
C   | FINISH LOADING THE TIME-Q PAIRS INTO STORAGE              |
C   +-----------------------------------------------------------+
C
      DO 55 J = 1,JMAX
         I    = I + 1
         T(I,kk) = TIME(J)
         Q(I,kk) = QVAL(J) * scl
         IF( ( TIME( 1 ).EQ.0.0 ).AND.( QVAL( 1 ).EQ.0.0 ) )IERR = 4
55    CONTINUE
C
C   +-----------------------------------------------------------+
C   | CHECK FOR NON-ZERO START TIME, NON-INCREASING TIMES,      |
C   | AND CONVERT TIMES IN MILLISECONDS TO SAMPLES.             |
C   +-----------------------------------------------------------+
C
      IF( T( 1,kk ).EQ.0.0 )GO TO 60
         IERR = 5
         RETURN
60    CONTINUE
      ENDTIM = FLOAT( NSAMP )*SI
      T(64,KK)  = ENDTIM
      Q(64,KK)  = Q(63,KK)
         DO 65 K    = 1,63
            Q( K,KK )  = ABS( Q( K,KK ) )
c           TNEXT   = T( K+1,KK ) / SI
c           T( K,KK )  = T( K,KK ) / SI
            TNEXT   = T( K+1,KK )
            T( K,KK )  = T( K,KK )
            IF( ( TNEXT.LT.T( K,KK ) ).AND.( TNEXT.NE.0.0) )IERR = 6
            IF( T( K,KK ).GE.ENDTIM )GO TO 75
           IF( ( T(K,KK).EQ.0.0).AND.( Q(K,KK).EQ.0.0 ) )GO TO 75
65       CONTINUE
75    CONTINUE
      IF( T(K,KK).EQ.ENDTIM )GO TO 80
      T( K,KK ) = ENDTIM
      Q( K,KK ) = Q( K-1,KK )
80    CONTINUE
      NPAIRS(kk) = K
      nsets = kk
      kk = kk + 1
      oldcrd = 0
      go to 29

  999 continue
      RETURN
      END
C***********************************************************************
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C                                                                      *
C                                                                      *
C***********************************************************************
C  ROUTINE:       INTRPL
C  ROUTINE TYPE:  SUBROUTINE
C  PURPOSE:       LINEAR INTERPOLATION
C
C  ARGUMENTS:
C
C     INDEP   - ARRAY OF INDEPENDENT VARIABLES 'X'
C     DEPNDT  - ARRAY OF DEPENDENT VARIABLES 'Y( X )'
C
C          ***********************************************
C          *                                             *
C          *  INDEP AND DEPNDT MUST HAVE SAME DIMENSIONS *
C          *                                             *
C          ***********************************************
C
C     INTPL   - INTERPOLATED ARRAY OF DEPENDENDENT VARIABLES
C     DELTAI  - INTERPOLATION INCREMENT - USUALLY '1'
C     IND0    - ZERO INDEX OF INTERPOLATION - USUALLY '0'
C     NPAIRS  - NUMBER OF DEPENDENT/INDEPENDENT VARIABLES
C     JMAX    - NUMBER OF INTERPOLATED POINTS PLUS 1
C
C     SAMPLE CALL TO SUBROUTINE IS:
C
C
C           CALL INTRPL( INDEP, DEPNDT, INTPL, DELTAI, IND0,
C    +                   NPAIRS, JMAX )
C
C
C
C  CATEGORY:
C  KEYWORDS:
C
C       +------------------------------------------------------+
C       |               DEVELOPMENT INFORMATION                |
C       +------------------------------------------------------+
C  AUTHOR:    JOHN D. MCGLYNN                 ORIGIN DATE:  86/01/22
C  LANGUAGE:  FORTRAN IV
C       +------------------------------------------------------+
C       |                 EXTERNAL ENVIRONMENT                 |
C       +------------------------------------------------------+
C  ROUTINES CALLED: SLPICP
C
C  FILES:
C      NONE
C       +------------------------------------------------------+
C       |             SPECIAL DOCUMENTATION ITEMS              |
C       +------------------------------------------------------+
C  STOP CODES:
C      0        -
C       +------------------------------------------------------+
C       |             OTHER DOCUMENTATION DETAILS              |
C       +------------------------------------------------------+
C  ERROR HANDLING:  RETURN CODES
CC
C***********************************************************************
C
      SUBROUTINE INTRPL( INDEP, DEPNDT, INTPL, DELTAI, IND0,
     +                   NPAIRS )
C
      REAL     INDEP(64),DEPNDT(64), INTPL(6000), SLOPE, INTCPT
      REAL     DELTAI, INDINT, NEXTIN, IND0
      INTEGER  NPAIRS, JMAX
C
C     COMPUTE MAXIMUM INDEX VALUE
C
      JMAX = IFIX( ( INDEP( NPAIRS ) - IND0 ) /  DELTAI ) + 1
C
C     COMPUTE SLOPE AND INTERCEPT
C
      CALL SLPICP(INDEP,DEPNDT,1,SLOPE,INTCPT)
C
C     INITIALIZE LOOP PARAMETERS
C
      J = 0
      I = 1
      NEXTIN = INDEP( 2 )
      INDINT = IND0 - DELTAI
C
C     LOOP BEGINS HERE
C
C     BEGIN INCREMENTING INDICES AND INTERPOLATED INDEPENDENT VARIABLE
C     VALUES
C
10    INDINT = INDINT + DELTAI
      J = J + 1
C
C     CHECK TO SEE IF WE NEED TO RE-COMPUTE SLOPE AND INTERCEPT
C
      IF( INDINT .LE. NEXTIN ) GO TO 30
C
C     IF SO, UPDATE INDICES TIRST
C
20    I = I + 1
      NEXTIN = INDEP( I + 1 )
C
C     FIND THE APPROPRIATE INTERVAL IN THE DEPENDENT VARIABLE
C     RANGE TO USE FOR RE-COMPUTATION OF THE SLOPE AND INTERCEPT
C
      IF( .NOT. ( INDEP( I ) .LT. INDINT
     +    .AND.   INDINT .LE. INDEP( I + 1 ) ) ) GO TO 20
C
C     THEN RECOMPUTE SLOPE AND INTERCEPT
C
      CALL SLPICP( INDEP, DEPNDT, I, SLOPE, INTCPT )
C
C     COMPUTE INTERPOLATED VALUE
C
30    INTPL( J ) = INDINT * SLOPE + INTCPT
C
C     FINISHED ? IF NOT, LOOP BACK
C
      IF( J .LT. JMAX ) GO TO 10
C
C     IF SO, RETURN
C
      RETURN
      END
C***********************************************************************
C
C     THIS SUBROUTINE COMPUTES A SLOPE AND INTERCEPT
C
      SUBROUTINE SLPICP(T,D,I,SLOPE,INTCPT)
      REAL T(64),D(64),SLOPE,INTCPT
      SLOPE = (D(I+1)-D(I))/(T(I+1)-T(I))
      INTCPT = (D(I)*T(I+1)-D(I+1)*T(I))/(T(I+1)-T(I))
      RETURN
      END
C***********************************************************************
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C                                                                      *
C                                                                      *
C***********************************************************************
C  ROUTINE:       RUNAVG
C  ROUTINE TYPE:  SUBROUTINE
C  PURPOSE:       COMPUTE RUNNING AVERAGE (INTEGRATED) Q-PROFILE
C
C  ARGUMENTS:
C
C     T       - INPUT TIMES
C     Q       - INPUT Q VALUES
C     QI      - ARRAY CONTAINING THE AVERAGE PROFILE ON RETURN
C     INDEX   - NUMBER OF POINTS TO AVERAGE OVER (SHOULD BE NSAMP)
C
C     SAMPLE CALL TO SUBROUTINE IS:
C
C           CALL RUNAVG(T,Q,QI,INDEX)
C
C
C***********************************************************************
C
cc      SUBROUTINE RUNAVG(T,Q,QI,INDEX,DT)
cc      REAL*4 Q(64),T(64),QI(6000)
cc        xt = dt * 1000.
cc      J   = 1
cc      SUM = 0.0
cc         DO 10 I = 1,INDEX
cc            TM      = FLOAT( I - 1 ) * xt
cc*           IF( T( J ).GE.TM ) GO TO 15
cc*           J    = J + 1
cc            if(t(j).lt.tm)j=j+1
cc15          SUM  = SUM + Q( J )
cc         QI( I ) = SUM / ( FLOAT( I ) )
cc10    CONTINUE
cc      RETURN
cc      END
C***********************************************************************
C***********************************************************************
C
      SUBROUTINE RUNAVG(T,Q,QI,INDEX,DT)
C handles card Q input (sparse input) - also Harmonic average
C Ganyuan Xia 10/11/00

      REAL*4 Q(64),T(64),QI(6000)
        xt = dt * 1000.
      J   = 1
      SUM = 0.0
         DO 10 I = 1,INDEX
            TM      = FLOAT( I - 1 ) * xt
            if(T(j).lt.TM) j=j+1
            SUM  = SUM + 1./Q( J )
         QI( I ) = ( FLOAT( I ) )/SUM
10    CONTINUE
      RETURN
      END
C***********************************************************************
C
      SUBROUTINE RUNAVG_HM(Q,QI,INDEX)
C Now we do harmonic average instead of arithmatic
C Assuming the input Q is resularly sampled in time
C This applies to the case where Q in seismic trace format
C Ganyuan Xia 10/11/00
      REAL*4 Q(*),QI(*)
      QI(1) = Q(1)
      SUM = 0.0
      DO I = 2,INDEX
	    SUM = SUM + 1./Q(I)
	    QI(I) = FLOAT(I-1)/SUM
      ENDDO   
      RETURN
      END
C***********************************************************************
C
C     ROUTINE TO COMPUTE TIME-VARIANT SCALING FUNCTION FOR Q-FILTER
C
C***********************************************************************
      SUBROUTINE SCALQV(QI,SCALV,NSAMP,dt)
C     Correct for the pi factor by Ganyuan Xia  Oct. 11, 2000
      REAL     QI(*), SCALV(*), PI
      INTEGER  NSAMP
      pi=3.1415926
      DO 10 I = 1,NSAMP
cc         SCALV( I ) = ( 1.0 / ABS( QI( I ) ) ) * FLOAT( I )
         SCALV( I ) = ( pi/ ABS( QI( I ) ) ) * FLOAT( I )
10       CONTINUE
      RETURN
      END


      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
        write(LER,*) ' '
        write(LER,*)
     :'qifl will do forward or inverse Q filtering on seismic data'
        write(LER,*)
     :'see manual pages for details ( online by typing uman qifl )'
        write(LER,*)' '
        write(LER,*)
     :'execute qifl by typing qifl and the of program parameters'
        write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
        write(LER,*)' '
        write(LER,*)
     :' -N [ntap]    (stdin)         : input data file name'
        write(LER,*)
     :' -O [otap]    (stdout)        : output data file name'
        write(LER,*)' '
        write(LER,*)
     :' -Q  include on command line if input Q-function is q-tape fmt'
        write(LER,*)
     :'     otherwise input Q-function will be nQTIM card file, or'
        write(LER,*)
     :'     input Q-function will be constant Q'
        write(LER,*)
     :' -D [cardin]  (optional)      : file containing nQTIM functions'
        write(LER,*)
     :' -null (default = 500)        : Replace zeros with null Q value'
        write(LER,*)
     :' -qmin[qmin] (default=20.0)   : minimum Q required to stabilize'
        write(LER,*)
     :' -qt[qtap]   (optional)       : file containing Q-tape functions'
        write(LER,*)
     :' -q[q0]       (optional)      : constant Q'
        write(LER,*)
     :' -rec  include on command line apply 1 Q trace for each input'
        write(LER,*)
     :'       gather; else each Q trc will be applied to each input trc'
        write(LER,*)
     :' -R  restore mute on post-smoothed Q traces (uses VPick1 hdr valu
     :e'
        write(LER,*)
     :' -noscl  do not restore scaling'
        write(LER,*)
     :'       every data trace)'
        write(LER,*)' '
        write(LER,*)
     :' -rs[irs]     (default = first): start processing record number'
        write(LER,*)
     :' -re[ire]     (default = last) : end processing record number'
        write(LER,*) ' '
        write(LER,*)
     :' -md[mode]    (def = 0) : 0=inverse Q filt; 1=forward Q modeling'
        write(LER,*)
     :' -ab[absol]   (def = 0) : 0=average Q func; 1=interval Q func'
        write(LER,*)
     :' -ph[phase]   (def = 0) : 0=zero phase filt; 1=min phase filt'
        write(LER,*)
     :' -fc[fcut]    (def = 0) : lo-pass cutoff freq ( ~ 2*Q/tmax)'
        write(LER,*)
     :'              (def = .9 Nyquist if Q-functions in Q-tape fmt)'
        write(LER,*)
     :' -fp[fpass]   (def = use -fc defaults)  : Frequency at which '
        write(LER,*)
     :'                                           gain becomes constant'
        write(LER,*)
     :' -s[ist]   (def = samp 1) : start time (ms) for Q-filtering'
        write(LER,*)
     :' -scl[scl] (def = 1)      : scale factor for Qs'
        write(LER,*)
     :' -sc[sc] (def = 0)        : 0=envelope gain; 1=agc gain'
        write(LER,*)
     :' -sm[sm] (def = ignore)   : smooth envelope gain function'
        write(LER,*)
     :' -lw[lw] (def = 1000)     : agc gain window (ms)'
        write(LER,*)
     :' -s[s] (def = 15)         : agc gain amplitude (% of 2047)'
        write(LER,*) ' '
        write(LER,*)
     :' -V  include on command line if verbose printout is desired'
        write(LER,*)
     :'usage:   qifl -N[] -O[] -rec -Q -R -qt[] -q[] -D[] -null[]'
        write(LER,*)
     :'              -qmin[] -rs[] -re[] -md[] -ab[] -ph[] -fc[] -fp[]'
        write(LER,*)
     :'              -scl[] -noscl -sc[] -sm[] -lw[] -s[]]'
        write(LER,*) ' '
        write(LER,*)
     :'***************************************************************'
      return
      end
