C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine nmocor (t,dt,n,nv,x,v)

#include <f77/lhdrsz.h>

c
c  routine to compute corrected NMO times along a hyperbola
c  for a given t0

c        - based on t**2 + (x/v)**2 nmo equation

c     t = vector of times (along a hyperbola)
c     v = velocity trace (velocity vs sample)
c    dt = sample interval (secs)
c     n = number of times to compute (# samples along a hyperbola)
c    nv = length of velocity trace
c     x = distance vector (along a hyperbola)
c
c  tnmo = sqrt [ t0 **2 + (x/v) **2 ]

      real      tnmo
      real      t(*), v(*), x(*)
      integer   n,nv

      call minmgv (x, 1, xmin, ix, n)
      do  i = 1, n
          t(i) = t(i) / 1000.
      enddo
      t0  = t (ix)

      DO    i = 1, n

          ti   = t (i)
          it   = ti / dt + 1
          vi   = v (it)
          xi   = x (i)
          tnmo =  sqrt ( ti**2 + (xi/vi)**2 )

          t (i) = t (i) + (tnmo - t0)

      ENDDO

      do  i = 1, n
          t(i) = 1000. * t(i)
      enddo

      return
      end
