C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine filtdrt(uin,live,uout,udata,
     1                   uorig,ra,tracebuf,trheader,
     2                   ifl,ifh,cputim,waltim,mx,my,
     3                   iypointer,jy,ny,locate,nt,nx,nxw,nyw,
     4                   luin,luout,lerr,jrec,
     5                   l_StaCor,eof,lenhed,lntrhd,nfft,
     6                   rtabf,itabf,rtabi,fwgt,
     7                   itabi,work,twgt,omtwgt,
     8                   lenrtab,lenitab,lenwork,ler,nxpad,
     9                   istart,iend,nt_orig,nbytes_out,interpolate, 
     a                   l_LinInd,l_DphInd,
     b                   ifmt_LinInd,ln_LinInd,ifmt_DphInd,ln_DphInd,
     c                   ifmt_StaCor,ln_StaCor,reject,kypointer,
     d                   starttrace,endtrace,startline,endline,
     e                   kximin,kximax,kyimin,kyimax,
     b               ifmt_RecNum,l_RecNum,ln_RecNum,
     c               ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
c__________________________________________________________________________
c     input seismic records.                  
c___________________________________________________________________
      complex   uin(ifl:ifh,-mx:nx+mx,-my:my)
      real      uorig(0:nt_orig,0:nx,0:my)
      integer   iypointer(-my:ny+my)
      integer   kypointer(0:ny)
      logical   live(-mx:nx+mx,-my:+my)
c___________________________________________________________________
c     output vectors.
c___________________________________________________________________
      complex   uout(ifl:ifh,0:nx,kximin:kximax,kyimin:kyimax)
      real      udata(0:nfft-1,-mx:nx+mx,kximin:kximax)
      real      tracebuf(-lenhed:nt-1)
      integer*2 trheader(lntrhd,0:nx,-my:my)
c_______________________________________________________________
c     fourier transform table and work arrays.
c_______________________________________________________________
      real       rtabf(lenrtab)
      integer    itabf(lenitab)
      real       rtabi(lenrtab)
      integer    itabi(lenitab)
      real       work(lenwork)
c___________________________________________________________________
c     (tau,ptheta,phi) transform matrices and variables.
c___________________________________________________________________
      complex   ra(ifl:ifh,nxw*nyw,kximin:kximax,kyimin:kyimax)
c___________________________________________________________________
c     grid stencil for the transform and spatial weights.
c___________________________________________________________________
      integer   locate(2,nxw*nyw)
c___________________________________________________________________
c     timing arrays.
c___________________________________________________________________
      real     cputim(*),waltim(*)
c___________________________________________________________________
c     control variables.
c___________________________________________________________________
      integer  starttrace,endtrace,startline,endline
      logical  eof,reject,interpolate
c
      initfftf=1
      initffti=1
c
      jrec=0
c_____________________________________________________________
c     fill in the data swath uin needed for processing.
c_____________________________________________________________
      call timstr(va,wa)
      do 10000 iy=-my,+my
       iypointer(iy)=iy
       if(iy .lt. 0 .or. iy .gt. ny) then
c_____________________________________________________________
c         no records exist. set all traces to be dead.
c_____________________________________________________________
          call deadrec(live,iypointer(iy),my,mx,nx)
       else
c_____________________________________________________________
c         read in the next record.
c_____________________________________________________________
          call timstr(va,wa)
          kypointer(iy)=iy
          call rdgather(tracebuf,tracebuf,trheader,uin,
     1                  uorig,udata,live,luin,ler,nx,nxpad,
     2                  l_StaCor,eof,iypointer(iy),my,mx,
     3                  lenhed,lntrhd,nt,nfft,ifl,ifh,lerr,
     4                  rtabf,itabf,rtabi,fwgt,
     5                  itabi,work,twgt,kypointer(iy),
     6                  lenrtab,lenitab,lenwork,initfftf,
     7                  istart,iend,nt_orig,
     8                  l_LinInd,l_DphInd,ifmt_LinInd,ln_LinInd,
     9                  ifmt_DphInd,ln_DphInd,ifmt_StaCor,ln_StaCor)
          call timend(cputim(1),va,vb,waltim(1),wa,wb)
          if(eof) return
       endif
10000 continue
c_____________________________________________________________
c     data swath is now full. roll through in the y direction,
c     each time adding the next seismic line and dropping the
c     oldest.
c_____________________________________________________________
      do 90000 jy=0,endline
       if(jy .lt. startline) go to 40001
       if(jy .lt. startline+my) then
          write(ler,*) 'process line ',jy,' of ',ny
       elseif(jy .eq. startline+my) then
          call timstr(v0,w0)
          write(ler,*) 'process line ',jy,' of ',ny
       else
          write(ler,'(a,i5,a,i5,a,i5,a,i5,a,i5,a)')
     1    'process line ',jy,' of ',ny,
     2    ' time to completion: ',nhour,' hr',
     3      nmin,' min',nsec,' sec'
       endif
c___________________________________________________________________
c      loop over the inline (x) direction, taking the radon transform.
c      points lieing outside the computational window are 'dead' 
c      (i.e. live(jx,jy)=.false.)
c___________________________________________________________________
       do 40000 jx=starttrace,endtrace
        call timstr(v1,w1)
        jrec=jrec+1
c___________________________________________________________________
c       initialize.
c___________________________________________________________________
        do 15200 jyi=kyimin,kyimax
         do 15100 jxi=kximin,kximax
          do 15000 jomega=ifl,ifh
           uout(jomega,jx,jxi,jyi)=(0.,0.)
15000     continue
15100    continue
15200   continue
        iy=iypointer(jy)
        if(live(jx,iy) .or. interpolate) then
c___________________________________________________________________
c          center trace is live, or we wish to interpolate it.
c          collect traces comprising the computational star.
c          multiply them by the precomputed filter.
c___________________________________________________________________
           do 30000 jpoint=1,nxw*nyw
            ix=jx+locate(1,jpoint)
            iy=iypointer(jy+locate(2,jpoint))
            if(live(ix,iy)) then
               do 17200 jyi=kyimin,kyimax
                do 17100 jxi=kximin,kximax
                 do 20000 jomega=ifl,ifh
                  uout(jomega,jx,jxi,jyi)=uout(jomega,jx,jxi,jyi)+
     1               ra(jomega,jpoint,jxi,jyi)*uin(jomega,ix,iy)
20000            continue
17100           continue
17200          continue
            endif
30000      continue
        endif
        call timend(cputim(3),v1,v2,waltim(3),w1,w2)
40000  continue
c_____________________________________________________________
c      write out the results.
c_____________________________________________________________
       call timstr(va,wa)
       call wrgather(tracebuf,tracebuf,trheader,uout,
     1            uorig,udata,udata,luout,mx,nx,my,iypointer(jy),
     2               lenhed,lntrhd,nt,nfft,ifl,ifh,lerr,
     3               rtabi,itabi,work,
     5               lenrtab,lenitab,lenwork,initffti,
     6               istart,iend,nt_orig,nbytes_out,reject,
     7               l_dphind,l_linind,kypointer(jy),omtwgt,
     8               ifmt_LinInd,ln_LinInd,ifmt_DphInd,ln_DphInd,
     9               kximin,kximax,kyimin,kyimax,
     a               jy,startline,endline,
     b               ifmt_RecNum,l_RecNum,ln_RecNum,
     c               ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)

       call timend(cputim(10),va,vb,waltim(10),wa,wb)
40001  continue
c_____________________________________________________________
c      roll the swath buffer in y.
c_____________________________________________________________
       iypointer(jy+my+1)=iypointer(jy-my)
       kypointer(jy+my+1)=kypointer(jy)
       if(jy+my+1 .gt. ny .and. jy .lt. ny) then
c_____________________________________________________________
c         no more records exist. set all traces to be dead.
c_____________________________________________________________
          call deadrec(live,iypointer(jy+my+1),my,mx,nx)
       elseif(jy+my+1 .le. ny) then
c_____________________________________________________________
c         read in the next record.
c_____________________________________________________________
          call timstr(va,wa)
          call rdgather(tracebuf,tracebuf,trheader,uin,
     1                  uorig,udata,live,luin,ler,nx,nxpad,
     2                  l_StaCor,eof,iypointer(jy+my+1),my,mx,
     3                  lenhed,lntrhd,nt,nfft,ifl,ifh,lerr,
     4                  rtabf,itabf,rtabi,fwgt,
     5                  itabi,work,twgt,kypointer(jy+my+1),
     6                  lenrtab,lenitab,lenwork,initfftf,
     7                  istart,iend,nt_orig,
     8                  l_LinInd,l_DphInd,ifmt_LinInd,ln_LinInd,
     9                  ifmt_DphInd,ln_DphInd,ifmt_StaCor,ln_StaCor)
          call timend(cputim(1),va,vb,waltim(1),wa,wb)
          if(eof) return        
       endif
       if(jy .ge. startline+my) then
c_____________________________________________________________
c         calculate average wall time for completely
c         filled lines.
c_____________________________________________________________
          call timstr(vcurr,wcurr)
          time_per_line=(wcurr-w0)/(jy-startline-my+1)
c_____________________________________________________________
c         predict wall time to completion.
c_____________________________________________________________
          time_left=(endline-jy)*time_per_line
          nhour=time_left/3600.
          nmin=(time_left-3600.*nhour)/60.
          nsec=time_left-3600.*nhour-60.*nmin
       endif
90000 continue
c
      return
      end
