C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine wrgather(tracebuf,ibuffer2,trheader,uout,
     1                    uorig,udata,uf,luout,mx,nx,my,iy,
     2                    ITRWRD,lntrhd,nt,nfft,ifl,ifh,lerr,
     3                    rtabi,itabi,work,
     5                    lenrtab,lenitab,lenwork,initffti,
     6                    istart,iend,nt_orig,nbytes_out,reject,
     7                    l_dphind,l_linind,ky,omtwgt,
     8                    ifmt_LinInd,ln_LinInd,ifmt_DphInd,ln_DphInd,
     9                    kximin,kximax,kyimin,kyimax,
     a                    jy,startline,endline,
     b                    ifmt_RecNum,l_RecNum,ln_RecNum,
     c                    ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
c_______________________________________________________________
c     udata and uf are equivalenced by the calling sequence.
c_______________________________________________________________
      real      udata(0:nfft-1,0:nx,kximin:kximax)  
      complex   uf(0:nfft/2-1,0:nx,kximin:kximax)  
      integer*2 trheader(lntrhd,0:nx,-my:my)
      integer*2 ibuffer2(ITRWRD)
      real      tracebuf(-ITRWRD:nt_orig)
      real      omtwgt(0:nt)
      complex   uout(ifl:ifh,0:nx,kximin:kximax,kyimin:kyimax)
      real      uorig(0:nt_orig,0:nx,0:my)
      integer   startline,endline,startline_out,endline_out
      logical   forward,reject 
c_______________________________________________________________
c     fourier transform table and work arrays.
c_______________________________________________________________
      real       rtabi(lenrtab)
      integer    itabi(lenitab)
      real       work(lenwork)
c___________________________________________________________________
c     copy complex data uout into udata. 
c     udata(0,jp) maps to the real part of uout(0,jp)
c     udata(1,jp) maps to the imaginary part of uout(0,jp)
c___________________________________________________________________
      nyinterp=kyimax-kyimin+1
      startline_out=startline*nyinterp
      endline_out=endline*nyinterp
      nrec_out=(endline-startline)*nyinterp+1
      do 90000 jyi=kyimin,kyimax
       kyout=(jy-startline)*nyinterp+jyi+1
       if(kyout .ge. 1 .and. kyout .le. nrec_out) then
       do 60000 jx=0,nx
        do 59000 jxi=kximin,kximax
         do 11000 jf=0,ifl-1
          uf(jf,jx,jxi)=(0.,0.)
11000    continue
         do 12000 jf=ifl,ifh
          uf(jf,jx,jxi)=uout(jf,jx,jxi,jyi)
12000    continue
         do 13000 jf=ifh+1,nfft/2-1
          uf(jf,jx,jxi)=(0.,0.)
13000    continue
59000   continue
60000  continue
c___________________________________________________________________
c      take fourier transform from (omega,x,y) domain
c      into (t,x,y) domain. 
c___________________________________________________________________
       forward=.false.
       nxinterp=kximax-kximin+1
       ntrout=nx*nxinterp+1
       call rmmfft(udata(0,0,kximin),work,itabi,rtabi,forward,
     1             nfft,lenwork,lenitab,lenrtab,
     2             nfft,ntrout,initffti,lerr)
       initffti=0
       do 89000 jx=0,nx
        do 80000 jxi=kximin,kximax
         kx=jx*nxinterp+jxi+1
         if(kx .ge. 1 .and. kx .le. ntrout) then
            do 75000 k=1,lntrhd
             ibuffer2(k)=trheader(k,jx,iy)
75000       continue
            call savew2(tracebuf,ifmt_RecNum,l_RecNum,ln_RecNum,
     1                  kyout,TRACEHEADER)       
            call savew2(tracebuf,ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     1                  kx,TRACEHEADER)
            if(reject) then
               do 76100 jt=0,istart-1
                tracebuf(jt)=uorig(jt,jx,ky)
76100          continue
               kt=0
               do 76200 jt=istart,iend
                tracebuf(jt)=uorig(jt,jx,ky)-udata(kt,jx,jxi)
                kt=kt+1
76200          continue
               do 76300 jt=iend+1,nt_orig
                tracebuf(jt)=uorig(jt,jx,ky)
76300          continue
            else
               do 77100 jt=0,istart-1
                tracebuf(jt)=uorig(jt,jx,ky)
77100          continue
               kt=0
               do 77200 jt=istart,iend
                tracebuf(jt)=omtwgt(kt)*uorig(jt,jx,ky)
     1                           +udata(kt,jx,jxi)
                kt=kt+1
77200          continue
               do 77300 jt=iend+1,nt_orig
                tracebuf(jt)=uorig(jt,jx,ky)
77300          continue
            endif

            call wrtape(luout,tracebuf(-ITRWRD),nbytes_out)
         endif
80000   continue
89000  continue
       endif
90000 continue
c
      return
      end 
