C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine wrtaup(tracebuf,ibuffer2,trheader,utaup,
     1                  udata,lutaup,npqlive,
     2                  lenhed,nt,nfft,ifl,ifh,lerr,
     3                  rtabf,itabf,rtabi,
     4                  itabi,work,nt_orig,istart,iend, 
     5                  lenrtab,lenitab,lenwork,initfftf,
     6                  plive,qlive,slive,nbytes_out,lntrhd,
     7                  ifmt_phdr,l_phdr,ln_phdr,
     8                  ifmt_qhdr,l_qhdr,ln_qhdr,
     9                  ifmt_DstUsg,l_DstUsg,ln_DstUsg,
     a                  TRACEHEADER,dmsamp)
c
      real      tracebuf(-lenhed:nt_orig)
      real      udata(0:nfft-1,npqlive)  
      integer*2 ibuffer2(lntrhd),trheader(lntrhd)
      complex   utaup(ifl:ifh,npqlive)
      logical   eof,forward 
      real      plive(npqlive),qlive(npqlive),slive(npqlive)
c_______________________________________________________________
c     fourier transform table and work arrays.
c_______________________________________________________________
      real       rtabf(lenrtab)
      integer    itabf(lenitab)
      real       rtabi(lenrtab)
      integer    itabi(lenitab)
      real       work(lenwork)
c
      do 10000 k=1,lntrhd
       ibuffer2(k)=trheader(k)
10000 continue
      do 11000 k=0,nt
       tracebuf(k)=0
11000 continue
c___________________________________________________________________
c     copy complex data utaup into udata. 
c     udata(0,jpq) maps to the real part of utaup(0,jpq)
c     udata(1,jpq) maps to the imaginary part of utaup(0,jpq)
c___________________________________________________________________
      jbegin=2*ifl
      lenf=2*(ifh-ifl+1)
      do 60000 jpq=1,npqlive
       call vclr(udata(0,jpq),1,nfft)   
       call vmov(utaup(ifl,jpq),1,udata(jbegin,jpq),1,lenf)  
60000 continue
c___________________________________________________________________
c     take fourier transform from (omega,x,y) domain
c     into (t,x,y) domain. 
c___________________________________________________________________
      forward=.false.
      call rmmfft(udata(0,1),work,itabf,rtabf,forward,
     1            nfft,lenwork,lenitab,lenrtab,
     2            nfft,npqlive,initfftf,lerr)
      initfftf=0
      call vclr(tracebuf(0),1,nt_orig+1)
      do 80000 jpq=1,npqlive
c_____________________________________________________________________
c      store p,q and s=sqrt(p**2+q**2)
c      in 'DstUsg' for use in predictive deconvolution (eg taupred).
c      in 'phdr'  and 'qhdr' for subsequent (tau,p,q) filtering.
c_____________________________________________________________________
       ival=nint(1.e+07*slive(jpq)*dmsamp)
       call savew2(ibuffer2,ifmt_DstUsg,l_DstUsg, ln_DstUsg,
     1             ival,TRACEHEADER)
       call putfp2(ibuffer2,ifmt_phdr,l_phdr,ln_phdr,
     1             plive(jpq),TRACEHEADER)
       call putfp2(ibuffer2,ifmt_qhdr,l_qhdr,ln_qhdr,
     1             qlive(jpq),TRACEHEADER)
c_____________________________________________________________________
c      copy in the data.
c_____________________________________________________________________
       call vmov(udata(0,jpq),1,tracebuf(istart),1,nt+1)
       call wrtape(lutaup,tracebuf(-lenhed),nbytes_out)
80000 continue
c
      return
      end 
