C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
       subroutine fwdt(tbufin,tbufout,hbegin,nsamp,nsamp_out,
     1           utaup,ui,ui2,w,ndiv,adiv,sembwgt,
     2           unumsum,udenomsum,unum,unum2,udenom, 
     2           nfft,nfft2,theta,uout,
     3           dist,noffset,maxoffset,ioffset,  
     4           mindist,maxdist,nbyptr,wromega,swgt,lswgt,
     5           live,np,ifl,ifh,irec,ITRWRD,SZSMPD, 
     6           a,utrans,u,rnorm,luout,
     7           v,r,e,ec,temp,rc,
     8           s,freq,fstart,p,uxt,rho,
     9           radon,cincr,white,df,  
     a           ist,lenwnd,ntr,symmetric,
     b           rtabf,itabf,initfftf,work,
     c           rtabi,itabi,initffti,tabled,lastpat,
     d           lenrtab,lenitab,lenwork,distpat,maxpat,
     e           fwgt,twgt,nlive,ipw,firstrec,time,
     f           trcwgt,trcwgtsum,taupwgt,ncount,
     g           muteend,lerr,cputim,waltim,verbose,
     h           l_trcnum,l_dstsgn,l_recnum,pw,wrwgt,luwgt,tsembwgt,
     i           semblance,wrtaup,ltsemb,lxsemb,alphatrim,alpha,fourier)
c
      integer   hbegin, ITRWRD, SZSMPD
c_________________________________________________________________________
c     unfiltered gather in, filtered gather out.
c_________________________________________________________________________
      real   tbufin(hbegin:nsamp,ntr)    
c_________________________________________________________________________
c     outed 'noise' traces. (output multiple gather)
c_________________________________________________________________________
      real   tbufout(-ITRWRD:nsamp_out-1,np)    
c_________________________________________________________________________
c     moveout function theta(x)    
c     trace distances  dist(x)     
c_________________________________________________________________________
      real       theta(ntr)     
      real       dist(ntr)     
      real       distpat(ntr,0:maxpat)     
      integer    ioffset(mindist:maxdist)
c_________________________________________________________________________
c     live trace indicator
c_________________________________________________________________________
      logical    live(ntr)
c_________________________________________________________________________
c     radon transformed data.
c_________________________________________________________________________
      real       taupwgt(nfft,np)
      complex    utaup(nfft/2,np)
      complex    utrans(ifl:ifh,np)
c_______________________________________________________________
c     areas large enough for fourier transform of windowed input,
c     output and work arrays.
c_______________________________________________________________
      real       uxt(nfft,ntr)
      real       ui(nfft,ntr)
      real       ui2(nfft,ntr)
      real       uout(nfft,np)           
      real       trcwgt(nfft)
      real       trcwgtsum(nfft)
      integer    ncount(lenwnd)
      real       swgt(0:lswgt)    
c_______________________________________________________________
c     fourier transform table and work arrays.                       
c_______________________________________________________________
      real       rtabf(lenrtab)        
      integer    itabf(lenitab)
      real       rtabi(lenrtab)        
      integer    itabi(lenitab)
      real       work(lenwork)
      real       fwgt(nfft/2),rho(nfft/2)
      real       twgt(lenwnd)
      real       unum(lenwnd,ntr),udenom(lenwnd,ntr)
      real       unumsum(lenwnd,ntr),udenomsum(lenwnd,ntr)
      real       sembwgt(lenwnd,ntr)
      real       tsembwgt(nfft)
c_______________________________________________________________
c     matrices for normal equations and solutions.                   
c_______________________________________________________________
      complex    a(ifl:ifh,np,0:maxpat)
      complex    u(ifl:ifh,np)
c_______________________________________________________________
c     work arrays for weiner levinson recursion formula.
c_______________________________________________________________
      real       rnorm(ifl:ifh)
      complex    s(np,ifl:ifh)
      complex    v(ifl:ifh),r(ifl:ifh)
      complex    e(ifl:ifh),ec(ifl:ifh)
      complex    temp(ifl:ifh),rc(ifl:ifh)
c_______________________________________________________________
c     radon transform matrix
c_______________________________________________________________
      complex    radon(ifl:ifh,np,0:maxoffset)             
c_______________________________________________________________
c     tabled arrays.
c_______________________________________________________________
      real       freq(ifl:ifh)
      real       p(np)
      complex    cincr(np)                           
      real       w(-3:+4,0:ndiv)
c_______________________________________________________________
c     mute preservation array
c_______________________________________________________________
      integer    muteend(ntr)
c_______________________________________________________________
c     timing arrays.
c_______________________________________________________________
      real       cputim(*),waltim(*)
c_______________________________________________________________
c     logical control directives.
c_______________________________________________________________
      logical    fourier,symmetric
      logical    forward       
      logical    tabled(0:maxpat)
      logical    verbose             
      logical    ipw,firstrec,time,semblance
      logical    wrtaup,wrwgt,wromega
      logical    alphatrim
      real       alpha

      parameter  (pi=3.1415926)


      do 40000 itr=1,ntr
c___________________________________________________________________
c      copy window of trace data into work array uxt.
c___________________________________________________________________
       do 35000 isamp=1,lenwnd
        uxt(isamp,itr)=twgt(isamp)*tbufin(ist+isamp-1,itr)
35000 continue
40000 continue

c___________________________________________________________________
c     clear transform space
c     any dead traces have been zeroed out in calling program.
c___________________________________________________________________
      call vclr(utrans,1,np*(ifh-ifl+1)*2)


      if(time) then
         call timstr(v1,w1)
c___________________________________________________________________
c        calculate the forward (tau,p) transform in the time domain.
c___________________________________________________________________
         if(lxsemb .gt. 0.) then
c___________________________________________________________________
c           use a running semblance weighting technique.  
c___________________________________________________________________
            call taupsemb(uxt,utaup,ui,ui2,unum,udenom,
     1                    unumsum,udenomsum,sembwgt,
     2                    swgt,lswgt,ltsemb,lxsemb,lenwnd,nfft,
     3                    ntr,np,
     3                    p,theta,w,ndiv,adiv,ncount,
     4                    tsembwgt,live,lerr,cputim,waltim)
            if(wrwgt) then
c___________________________________________________________________
c              write out the weights.
c___________________________________________________________________
               do 41501 jp=1,np
                call vmov(utaup(1,jp),1,tbufout(0,jp),1,lenwnd)
                call vclr(tbufout(lenwnd,jp),1,nsamp_out-lenwnd)
41501          continue
               call wrgather(tbufout,hbegin,nsamp_out,np,luwgt,nbyptr)
            endif

         else
c___________________________________________________________________
c           use other techniques, including:
c             semblance weighting using the entire gather (non running).
c             inverse power weighting.
c             alpha-trim mean weighting.
c___________________________________________________________________
            call taup(uxt,utaup,ui,lenwnd,nfft,nfft2,
     1                ntr,np,firstrec,
     2                p,theta,w,ndiv,adiv,work,ncount,
     3                live,trcwgt,trcwgtsum,ipw,lerr,pw,
     4                unum,udenom,semblance,taupwgt,
     5                unum2,swgt,lswgt,ltsemb,
     6                alphatrim,alpha,cputim,waltim)
            if(wrwgt) then
c___________________________________________________________________
c              write out the weights.
c___________________________________________________________________
               do 41500 jp=1,np
                call vmov(taupwgt(1,jp),1,tbufout(0,jp),1,lenwnd)
                call vclr(tbufout(lenwnd,jp),1,nsamp_out-lenwnd)
41500          continue
               call wrgather(tbufout,hbegin,nsamp_out,np,luwgt,nbyptr)
            endif
         endif
         call timend(cputim(11),v1,v2,waltim(11),w1,w2)
c___________________________________________________________________
c        take fourier transform from (tau,p) into (omega,p) space.       
c___________________________________________________________________
         forward=.true.
         call timstr(v1,w1)
         call rmmfft(utaup,work,itabf,rtabf,forward,
     1               nfft,lenwork,lenitab,lenrtab,
     2               nfft,np,initfftf,lerr)
         initfftf=0
         if(wrtaup) then 
c___________________________________________________________________
c           apply the 'rho' filter sqrt(omega)/(2.*pi) 
c           do NOT apply the least squares DRT normalization. 
c           scale by number of live traces (approximate)
c___________________________________________________________________
            do 41700 ifreq=ifl,ifh 
             wc=fwgt(ifreq)*rho(ifreq)
             if(nlive .ne. 0) wc=wc/nlive
             do 41600 jp=1,np       
              u(ifreq,jp)=utaup(ifreq,jp)*wc
41600        continue
41700       continue
            go to 79000
         endif
c______________________________________________________________________
c        apply filter tapers.                                         
c______________________________________________________________________
         do 45000 ifreq=ifl,ifh   
          do 42000 ip=1,np                       
           utrans(ifreq,ip)=fwgt(ifreq)*utaup(ifreq,ip)
42000     continue
45000    continue
         call timend(cputim(2),v1,v2,waltim(2),w1,w2)
      else
c___________________________________________________________________
c        take fourier transform from t-x into omega-x space.       
c___________________________________________________________________
         forward=.true.
         call vclr(utrans,1,2*(ifh-ifl+1)*np)
          call timstr(v1,w1)
          call rmmfft(uxt,work,itabf,rtabf,forward,
     1                nfft,lenwork,lenitab,lenrtab,
     2                nfft,ntr,initfftf,lerr)
          initfftf=0
c______________________________________________________________________
c         apply filter tapers.
c______________________________________________________________________
          do 45100 ifreq=1,nfft/2
              kr=2*ifreq-1
              ki=kr+1
              do 42100 itr=1,ntr               
               uxt(kr,itr)=fwgt(ifreq)*uxt(kr,itr)
               uxt(ki,itr)=fwgt(ifreq)*uxt(ki,itr)
42100         continue
45100     continue
          call timend(cputim(2),v1,v2,waltim(2),w1,w2)
       endif
c______________________________________________________________________
c     determine which gather distance pattern we are working with.
c______________________________________________________________________
      call getpat(dist,distpat,ntr,1,ntr,lastpat,
     1            maxpat,ipat,live)
      if(verbose) write(lerr,*) 'ipat = ',ipat
      lena=2*np*(ifh-ifl+1)
      if(.not. tabled(ipat)) then
c______________________________________________________________________
c                                         T
c        initialize normal matrix: [A]=[R] [R]
c_____________________________________________________________________
         call vclr(a(ifl,1,ipat),1,lena)
      endif

      do 60000 itr=1,ntr                 
       if(.not. live(itr)) go to 60000
       idist=dist(itr)
       if(ioffset(idist) .eq. 0) then
          if(noffset .lt. maxoffset) then
             noffset=noffset+1
             ioffset(idist)=noffset
          else
          endif      
          call timstr(v1,w1)
          call getradon(radon(ifl,1,ioffset(idist)),p,ifl,ifh,
     1                  df,np,freq,theta(itr),cincr,fourier,
     2                  symmetric)
          call timend(cputim(3),v1,v2,waltim(3),w1,w2)
       endif
       if(.not. time) then
c___________________________________________________________________
c         take forward Radon transform in frequency domain.
c___________________________________________________________________
          call timstr(v1,w1)

          call radfwd(uxt(2*(ifl-1)+1,itr),utrans,itr,
     1                radon(ifl,1,ioffset(idist)),ifl,ifh,np)
       call timend(cputim(4),v1,v2,waltim(4),w1,w2)
       endif

       call timend(cputim(4),v1,v2,waltim(4),w1,w2)
       if(.not. tabled(ipat)) then
c___________________________________________________________________
c         accumulate normal equations by integrating over x.
c___________________________________________________________________
          call timstr(v1,w1)
          call accnorm(a(ifl,1,ipat),radon(ifl,1,ioffset(idist)),
     1                 ifl,ifh,np)
          call timend(cputim(10),v1,v2,waltim(10),w1,w2)
       endif
60000 continue

      if(.not. tabled(ipat)) then
c______________________________________________________________________
c        add white noise for stability
c______________________________________________________________________
         do 66000 ifreq=ifl,ifh
          a(ifreq,1,ipat)=a(ifreq,1,ipat)*(1.0+white)
66000    continue
         if(ipat .ne. 0) then
c______________________________________________________________________
c           normal equation assembly complete. it is now 'tabled'
c______________________________________________________________________
            tabled(ipat)=.true.
            write(lerr,*)
            write(lerr,*) 'trace distance pattern # ',ipat,' tabled'
            write(lerr,'(i12,f12.3)') 
     1                 (i,distpat(i,ipat),i=1,ntr)                 
         endif
      endif
      if(tabled(ipat)) then
c______________________________________________________________________
c        move tabled normal equations into work area (ipat = 0)
c        Toeplitz matrix solution destroys the input array a.
c______________________________________________________________________
         call vmov(a(ifl,1,ipat),1,a(ifl,1,0),1,lena)
      endif
c______________________________________________________________________
c     build intermediate inverse
c     solve equations using a complex levinson recurrsion algorithm
c     use non recursive version on vector computer,
c     use recursive version on scalar computer.
c______________________________________________________________________
      call timstr(v1,w1)
      call mclev(np,a(ifl,1,0),utrans,u,s,ifl,ifh,
     1           rnorm,v,r,e,ec,temp,rc)
      call timend(cputim(5),v1,v2,waltim(5),w1,w2)
79000 continue

      if(wromega) then
C_____________________________________________________________________
c        output (omega,p) data as amplitude and phase.
c_____________________________________________________________________
         do 80000 ip=1,np     
          call vclr(tbufout(0,ip),1,nsamp_out)
          iamp=nfft/2-(ifl-1)
          iphase=nfft-(ifl-1)  
          do 70000 iomega=ifl,ifh 
           iamp=iamp-1
           iphase=iphase-1
           tbufout(iamp,ip)=abs(u(iomega,ip))
           if(tbufout(iamp,ip) .eq. 0.) then
              tbufout(iphase,ip)=0.
           else
              tbufout(iphase,ip)=
     1         atan2(aimag(u(iomega,ip)),real(u(iomega,ip)))
           endif
70000     continue
80000    continue
      else
C_____________________________________________________________________
c        transform data back to time.                 
c        copy data into a output buffer.           
c_____________________________________________________________________
         forward=.false.
          do 67000 jp=1,np
           call vclr(uout(1,jp),1,nfft)
cc         call vmov(u(ifl,jp),1,uout(2*(ifl-1)+1,jp),1,
cc    1              2*(ifh-ifl+1))
           do i = ifl, ifh
              ii = 2*i
              uout (ii-1,jp) = real (u(i,jp))
              uout (ii  ,jp) = aimag(u(i,jp))
           enddo
67000    continue

         call timstr(v1,w1)
         call rmmfft(uout,work,itabi,rtabi,forward,
     1               nfft,lenwork,lenitab,lenrtab,
     2               nfft,np,initffti,lerr)

         initffti=0
         call timend(cputim(7),v1,v2,waltim(7),w1,w2)
         call timstr(v1,w1)
c
         if(semblance .and. lxsemb .eq. 0) then
c_____________________________________________________________________
c           weight the orthogonalized radon transform by its semblance
c           associated weight.
c_____________________________________________________________________
            do 84000 jp=1,np
             do 83000 isamp=1,lenwnd
              uout(isamp,jp)=uout(isamp,jp)*taupwgt(isamp,jp)
83000        continue
84000       continue
         endif

         do 90000 jp=1,np           
          call vclr(tbufout(0,jp),1,nsamp)
          do 85000 isamp=1,lenwnd   
           tbufout(ist+isamp-2,jp)=twgt(isamp)*uout(isamp,jp)                 
85000    continue
90000    continue
c
         call timend(cputim(8),v1,v2,waltim(8),w1,w2)
c
      endif
c
      return
      end

