C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine gettab(p,delt,df,dp,nf,np,rho,domega,pi,
     1                  fwgt,f1,f2,f3,f4,dt,twgt,nttaper,lenwnd,
     2                  tsembwgt,tsemb1,tsemb2,tsemb3,tsemb4,
     3                  dtmsec,pmin,pmax,nfft,freq,ifl,ifh,
     4                  swgt,sembv1,sembv2,lswgt,verbose,
     5                  xwgt,nxtaper,ntr,factor,lerr,parabolic)
c_______________________________________________________________
c     routine to precompute/table relevant matrices and arrays for
c     efficient calculations.
c_______________________________________________________________
      real    freq(ifl:ifh)
      real    p(np)
      real    delt(np)
      real    xwgt(ntr)
      real    fwgt(0:nfft/2-1),rho(0:nfft/2-1)
      real    twgt(lenwnd)
      real    tsembwgt(0:nfft-1)   
      real    swgt(0:lswgt)
      logical parabolic,verbose 
c_____________________________________________________________
c     precompute p array
c     delt...........moveout in ms at xmax
c     p..............moveout in sample/m (or sample/m**2)
c     ptrue..........moveout in ms/m (or ms/m**2)
c     v..............apparent velocity in ms/m (ms/m**2) 
c_____________________________________________________________
c_____________________________________________________________
c     precompute frequency array
c_____________________________________________________________
c     nfmax=nfft/2
c     df=pi/nfmax
      do 10000 ifreq=ifl,ifh
       freq(ifreq)=float(ifreq)*df
10000 continue

      write(lerr,'(/,a15,4a15)') 'curve number','moveout',
     1                     'slowness','slowness','app. vel.'
      if(parabolic) then
         write(lerr,'(a15,4a15,/)') '   ','(in ms at xmax)',
     1              '(in sample/m**2)','(in ms/m**2)','(in m/ms**2)'
      else
         write(lerr,'(a15,4a15,/)') '   ','(in ms at xmax)',
     1              '(in sample/m)','(in ms/m)','(in m/ms)'
      endif
      dp=(pmax-pmin)/(np-1)
      do 40000 jp=1,np      
       p(jp)=pmin+(jp-1)*dp
       ptrue=p(jp)*dtmsec
       if(ptrue .ne. 0.) then
          vapp=1./ptrue
       else
          vapp=1.e+10
       endif
       delt(jp)=factor*p(jp)
       write(lerr,'(i15,f15.5,2f15.10,f15.5)') jp,delt(jp),p(jp),
     1                                         ptrue,vapp     
40000 continue
c_____________________________________________________________________
c     calculate frequency tapers.
c_____________________________________________________________________
      dfraw=1./(nfft*dt)
      call gttapr(fwgt,f1,f2,f3,f4,dfraw,0,nfft/2-1)
      do 41000 jf=0,nfft/2-1
       omega=jf*domega
       rho(jf)=sqrt(omega)/(2.*pi)
41000 continue
      if(verbose) then
         write(lerr,'(a12,f12.6)') 'df',dfraw,'f1',f1,'f2',f2,
     1                              'f3',f3,'f4',f4
         write(lerr,'(a12,2a12)') 'k','f','fwgt'
         write(lerr,'(i12,2f12.6)') (k,k*dfraw,fwgt(k),k=0,nfft/2-1)
      endif
c_____________________________________________________________________
c     calculate spatial tapers to minimize edge effects.               
c_____________________________________________________________________
      x1=1
      x2=1+nxtaper
      x3=ntr-nxtaper
      x4=ntr
      dtrace=1.
      call gttapr(xwgt,x1,x2,x3,x4,dtrace,1,ntr)
      if(verbose) then
         write(lerr,'(a12,f12.6)') 'dtrace',dtrace,'x1',x1,'x2',x2,
     1                              'x3',x3,'x4',x4
         write(lerr,'(a12,2a12)') 'k','xwgt'
         write(lerr,'(i12,f12.6)') (k,xwgt(k),k=1,ntr)   
      endif
c_____________________________________________________________________
c     calculate semblance weights                                      
c_____________________________________________________________________
      s1=sembv1
      s2=sembv2
      s3=1.01             
      s4=1.01               
      dsemb=1./lswgt    
      call gttapr(swgt,s1,s2,s3,s4,dsemb,1,lswgt+1)
      if(verbose) then
         write(lerr,'(a12,f12.6)') 'dsemb',dsemb,'s1',s1,'s2',s2,
     1                              's3',s3,'s4',s4
         write(lerr,'(a12,2a12)') 'k','semb','swgt'
         write(lerr,'(i12,2f12.6)') (k,k*dsemb,swgt(k),k=0,lswgt)
      endif
c_____________________________________________________________________
c     calculate temporal tapers to minimize wrap around effects.
c_____________________________________________________________________
      t1=1
      t2=1+nttaper
      t3=lenwnd-nttaper
      t4=lenwnd
      dtime=1.
      call gttapr(twgt,t1,t2,t3,t4,dtime,1,lenwnd)
c_____________________________________________________________________
c     calculate temporal tapers to limit semblance weighting.    
c_____________________________________________________________________
      call gttapr(tsembwgt,tsemb1,tsemb2,tsemb3,tsemb4,dtmsec,0,nfft-1)
      do 50000 k=0,nfft-1
       tsembwgt(k)=1.-tsembwgt(k)
50000 continue
      if(verbose) then
         write(lerr,'(a12,f12.6)') 'dtmsec',dtmsec,'tsemb1',tsemb1,
     1              'tsemb2',tsemb2,'tsemb3',tsemb3,'tsemb4',tsemb4
         write(lerr,'(a12,2a12)') 'k','time','tsembwgt'
         write(lerr,'(i12,2f12.6)') (k,k*dtmsec,tsembwgt(k),k=0,nfft-1)
      endif
c
      return
      end

