C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
       subroutine msize(nsamp,nfft,nfft2,ist,iend,lenwnd,
     1                  mmin,mmax,fl,fh,ifl,ifh,flow,df,nf,nfmax,
     2                  pmin,pmax,np,dt,dtmsec,domega,
     3                  linear,parabolic,hyperbolic,fourier,zref,
     4                  offmax,factor,pi,lerr,fs,fstart,tpad)
C
       real      dt,pmin,pmax,offmax
       integer   mmin,mmax,tpad
       logical   linear,parabolic,hyperbolic,fourier
       integer   ipwr(4)
c______________________________________________________________________
c      calculate window length. 
c      make sure there is at least 20% padding to suppress wraparound.
c______________________________________________________________________
       dt=.001*dtmsec
       lenwnd=iend-ist+1
       nfftmin=1.2*lenwnd
c______________________________________________________________________
c      calculate length of mixed radix fft that fits lenwnd best.  
c      limit to radices 2,3 and 5 to allow use both cray scilib
c      and qtc routines.
c______________________________________________________________________
       call nrfft(nfftmin,5,nfft,ipwr)
       call nrfft(nfftmin,2,nfft2,ipwr)
       nfmax=nfft/2
       df=pi/(nfmax)
       omeganyq=2.*pi/(2.*dt)
       domega=omeganyq/(nfft/2)
c      domega=omeganyq/(nfft/2-1)
c_____________________________________________________________________
c      calculate frequency ranges and dimensionless frequencies.
c_____________________________________________________________________
c
      flow=2.*pi*dt*fl
      fstart=2*pi*dt*(fl+fs)
      ifl=nint(flow/df)
      ifl=max(ifl,1)
      flow=ifl*df
c
      fhi=2.*pi*dt*fh
      fhigh=fhi
      ifh=nint(fhi/df)
      ifh=min(ifh,nfmax-1)
      fhi=ifh*df
      nf=ifh-ifl+1
      xfh=fhigh/df

      if(fourier) then 
c______________________________________________________________________
c        fit multiple/noise trains with Fourier sin/cos functions.
c        sample maximum moveout at Nyquist at fh
c______________________________________________________________________
         smin=.001*mmin/offmax
         smax=.001*mmax/offmax
         pmin=2.*pi*fh*smin   
         pmax=2.*pi*fh*smax   
         write(lerr,*) 'pi,fh,smin,smax,pmin,pmax ',   
     1                pi,fh,smin,smax,pmin,pmax    
      else
         if(linear) then   
c______________________________________________________________________
c           fit multiple/noise trains with linear curves.
c______________________________________________________________________
            factor=dtmsec*offmax
         elseif(parabolic) then
c______________________________________________________________________
c           fit multiple/noise trains with parabolic curves.
c______________________________________________________________________
            factor=dtmsec*offmax**2
         elseif(hyperbolic) then
c______________________________________________________________________
c           fit multiple/noise trains with hyperbolic curves.
c______________________________________________________________________
            factor=dtmsec*(sqrt(offmax**2+zref**2)-zref)
         endif
         pmin=float(mmin)/factor         
         pmax=float(mmax)/factor         
      endif
c
      write(lerr,*) 'mmin ',mmin,' pmin',pmin
      write(lerr,*) 'mmax ',mmax,' pmax',pmax
c
      return
      end
