C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
       subroutine rdparm(nsamp,nrec,ntr,dtmsec,
     1                   ist,iend,f1,f2,f3,f4,mmin,mmax,np,minlive,
     2                   xmax,white,wromega,wrtaup,
     3                   linear,parabolic,hyperbolic,fourier,zref,
     4                   nxtaper,nttaper,lerr,ierror,ipw,pw,time,
     5                   szsmpd,amaxmem,semblance,alphatrim,alpha,
     6                   sembwt,ltsemb,lxsemb,sigma1,sigma2,
     7                   tsemb1,tsemb2,tsemb3,tsemb4,fs,tpad)
 
       integer    argis
       integer    mmin,mmax
       integer    np,minlive,tpad
       real       white,xmax,dtmsec
       logical    linear,parabolic,hyperbolic,fourier 
       logical    ipw,time,semblance
       integer    szsmpd
       logical    alphatrim
       logical    nyquist,wromega,wrtaup
       real       alpha
c
       data       undefined/-999999./
 
       irs  = 1
       ire  = nrec
       ierror=0

       tpad = 0

       nyquist=(argis('-nyquist') .gt. 0)
       wromega=(argis('-omega') .gt. 0)
       wrtaup=(argis('-taup') .gt. 0)

       call argr4 ('-f1',f1,5.,5.)
       call argr4 ('-f2',f2,0.,0.)
       call argr4 ('-f3',f3,0.,0.)
       call argr4 ('-f4',f4,0.,0.)
       call argr4 ('-fs',fs,0.,0.)
       call argr4 ('-sigma1',sigma1,0.,0.)
       call argr4 ('-sigma2',sigma2,0.,0.)
       call argr4 ('-sembwx',sembwx,0,0)
       call argr4 ('-sembwt',sembwt,0.,0.)
       call argr4 ('-tsemb1',tsemb1,0.,0.)
       call argr4 ('-tsemb2',tsemb2,0.,0.)
       call argr4 ('-tsemb3',tsemb3,0.,0.)
       call argr4 ('-tsemb4',tsemb4,0.,0.)
       call argi4 ('-tpad',tpad,0,0)
       call argi4 ('-s',ist,0,0)
       call argi4 ('-e',iend,0,0)
       if (tpad .gt. 0) then
           tpad = tpad / dtmsec
           nsamp = nsamp + tpad
       endif
       if(sigma1 .ne. 0. .or. sigma2 .ne. 0.) then
          semblance=.true.
       else
          semblance=.false.
       endif
      call argr4('-M',amaxmem,0.,0.)
      if (iend .eq. 0) iend = nsamp*dtmsec
      if(amaxmem .le. 0.) then
         if(szsmpd .eq. 4) then
c________________________________________________________________________
c           workstation architecture.
c           default to 16 Megabytes=4 Megawords
c________________________________________________________________________
            amaxmem=4.
         else
c________________________________________________________________________
c           supercomputer architecture.
c           default to 24 Megawords
c________________________________________________________________________
            amaxmem=24.
         endif
      endif
c________________________________________________________________________
c      enter moveout parameters that are to be modeled:
c      
c      mmin.....minimum moveout to be modeled. (was -id0 option)
c      mmax.....maximum moveout to be modeled. (was -id1 option)
c________________________________________________________________________
       call argi4('-mmin',mmin,0,0)               
       call argi4('-mmax',mmax,0,0)               
c
       call argi4 ('-np',np,0,0)
       call argr4 ('-xmin',xmin,-999999.,-999999.) 
       call argr4 ('-xmax',xmax,-999999.,-999999.)
       call argr4 ('-zref',zref,-999999.,-999999.)
       if (xmax .eq. -999999.) xmax = undefined
       if (zref .eq. -999999.) zref = undefined

       call argr4 ('-prew',white,5.0,5.0)
       call argi4 ('-live',minlive,3,3)
       call argi4 ('-nxtaper',nxtaper,0,0)  
       call argi4 ('-nttaper',nttaper,0,0)
       time=(argis('-time') .gt. 0)
       call argr4 ('-ipw',pw,0.1,0.0)
       if (tpad .ne. 0 .AND. ist .gt. 0) then
           write(LERR,*)'command line error!'
           write(LERR,*)'for time padding cannot use -s[]'
           ierror=ierror+1
       endif
       if (tpad .ne. 0 .AND. iend .ne. nsamp*dtmsec) then
           write(LERR,*)'command line error!'
           write(LERR,*)'for time padding cannot use -e[]'
           ierror=ierror+1
       endif
       if(nttaper .eq. 0) then
          nttaper=25
       else
          nttaper=nttaper/dtmsec
       endif
       if(pw .gt. 0.) then
          ipw=.true. 
          time=.true.
       endif
       if(semblance) then
          time=.true.
       endif
       if(wrtaup) time=.true.
       if(ipw .and. semblance) then
          write(lerr,*) 'command line error!'
          write(lerr,*) 'cannot enter both -ipw and -semb options!'
          ierror=ierror+1
       endif
       linear=(argis('-L') .gt. 0)
       parabolic=(argis('-P') .gt. 0)
       hyperbolic=(argis('-H') .gt. 0)
       fourier=(argis('-K') .gt. 0)
       call argr4('-alpha',alpha,1.0,1.0)             
c
       if(fourier) then
          wromega=.true.
       endif
c
       if (alpha .eq. 1.0) then
          alphatrim = .false.
       elseif(alpha .gt. 1.0 .or. alpha .lt. 0.0) then
          write(lerr,*) 'command line error!'
          write(lerr,*) 'alpha must lie between 0.0 and 1.0 !'
          ierror=ierror+1
       else
          alphatrim=.true.
          time=.true.
       endif

       noptions=0 
       if(linear) noptions=noptions+1
       if(parabolic) noptions=noptions+1
       if(hyperbolic) noptions=noptions+1
       if(fourier) noptions=noptions+1
       if(noptions .ne. 1) then         
          write(lerr,*) 'error in routine rdparm'
          write(lerr,*) 'must enter one and only one of the'
     1                  //' following options'
          write(lerr,*) '-L,   -P,   -H,  -K'                              
          write(lerr,*) 'check command line'
          ierror=ierror+1
       endif

       if(ist.ge.iend) then      
          write(lerr,*) 'error in rdparm !' 
          write(lerr,*) 'start time = ',ist
          write(lerr,*) 'exceeds end time = ',iend
          ierror=ierror+1
       endif
 
       ist = ist/dtmsec
       iend = iend/dtmsec
       if (ist .le. 0) ist = 1
       if (iend .le. 0) iend = nsamp
       if(xmax .eq. undefined) then
          write(lerr,*) 'error in routine rdparm'
          write(lerr,*) 'must supply -xmax option'
          ierror=ierror+1
       endif
       if(tsemb1 .eq. 0.) then
          tsemb1=ist*dtmsec
       else
          tsemb1=max(ist*dtmsec,tsemb1)
       endif               
       if(tsemb4 .eq. 0.) then
          tsemb4=iend*dtmsec
       else
          tsemb4=min(iend*dtmsec,tsemb4)
       endif               
       if(tsemb2 .eq. 0.) then
          tsemb2=tsemb1       
       endif               
       if(tsemb3 .eq. 0.) then
          tsemb3=tsemb4       
       endif               
c________________________________________________________________
c      check that semblance time window corners are in ascending order
c________________________________________________________________
       if(tsemb1 .lt.0.) then
          write(lerr,*) 'error! tsemb1 = ',tsemb1,' less than 0.'
          ierror=ierror+1
       endif
       if(tsemb2 .lt. tsemb1) then
          write(lerr,*) 'error! tsemb2 = ',tsemb2,' less than tsemb1 = ',tsemb1
          ierror=ierror+1
       endif
       if(tsemb3 .lt. tsemb2) then
          write(lerr,*) 'error! tsemb3 = ',tsemb3,' less than tsemb2 = ',tsemb2
          ierror=ierror+1
       endif
       if(tsemb4 .lt. tsemb3) then
          write(lerr,*) 'error! tsemb4 = ',tsemb4,' less than tsemb3 = ',tsemb3
          ierror=ierror+1
       endif
c
       xmax=abs(xmax)
c
       if(zref .eq. undefined) then
          zref=xmax  
       endif
c
c________________________________________________________________
c      set uninitialized frequencies to defaults.                   
c________________________________________________________________
       fnyquist=1000./(2.*dtmsec)
       if(f4 .eq. 0.) then
          f4=fnyquist
          write(lerr,*)'Upper freq limit defaulted to ',f4    
       endif
       if(f2 .eq. 0.) then
          f2=f1
       endif
       if(f3 .eq. 0.) then
          f3=f4
       endif
c________________________________________________________________
c      check that frequencies are in ascending order
c________________________________________________________________
       if(f1 .lt.0.) then
          write(lerr,*) 'error! f1 = ',f1,' less than 0.' 
          ierror=ierror+1
       endif
       if(f2 .lt. f1) then
          write(lerr,*) 'error! f2 = ',f2,' less than f1 = ',f1
          ierror=ierror+1
       endif
       if(f3 .lt. f2) then
          write(lerr,*) 'error! f3 = ',f3,' less than f2 = ',f2
          ierror=ierror+1
       endif
       if(f4 .lt. f3) then
          write(lerr,*) 'error! f4 = ',f4,' less than f3 = ',f3
          ierror=ierror+1
       endif
c
       if(f4 .gt.fnyquist) then
          write(lerr,*) 'error! f4 exceeds fnyquist'
          write(lerr,*) 'f4 = ',f4
          write(lerr,*) 'fnyquist = ',fnyquist
          ierror=ierror+1
       endif
       if(sembwt .eq. 0.) sembwt=5.*dtmsec
       lxsemb=nint(sembwx)                      
       ltsemb=nint(sembwt/dtmsec)
c_________________________________________________________________
c      if using running window transform, do NOT allow orthogonalization!
c_________________________________________________________________
       if(lxsemb .ne. 0) wrtaup=.true.
       if(sigma1 .eq. 0.) sigma1=.10  
       if(sigma2 .eq. 0.) sigma2=.20
       if(np .le. 0) then
          if(nyquist) then 
             np=2*f4*(mmax-mmin)/1000+1
             np=max(np,ntr)                             
             write(lerr,*)'Number of curves defaulted to ',np
          else
             np=ntr
          endif
       endif

       white = white/100.

c
       if (zref .lt. 0.) then  
         write(lerr,*) ' invalid reference depth (zref < 0.)',zref
         ierror=ierror+1
       endif

      if(minlive .le.0) then
         write(lerr,*) ' invalid number of live traces:',minlive
         ierror=ierror+1
      endif

      if(mmin.ge.mmax) then
         write(lerr,*) 'invalid model parameter range!'       
         write(lerr,*) 'mmin = ',mmin                    
         write(lerr,*) 'mmax = ',mmax                    
         ierror=ierror+1
      endif
      if(np .lt. ntr) then
         write(lerr,*) 'requested number of parameters np too small!'
         write(lerr,*) 'line header preservation forbids np < ntr'
         write(lerr,*) 'number of traces per record ntr  = ',ntr
         write(lerr,*) 'number of paramters requested np = ',np 
         write(lerr,*) 'resubmit with valid parameter after -np'
         ierror=ierror+1
      endif

C
      return
      end
