C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine taupsemb(uxt,utaup,ui,ui2,unum,udenom,
     1                    unumsum,udenomsum,sembwgt,
     2                    swgt,lswgt,ltsemb,lxsemb,len,nfft,ntr,np,
     3                    p,theta,w,ndiv,adiv,ncount,
     4                    tsembwgt,live,lerr,cputim,waltim)
c___________________________________________________________________
c     calculate semblance weighted (tau,p) transform 
c     in the (x,t) domain.
c
c     utaup(m,p)=sum(semblance(m*dt+i*dx*p,i)*uxt(m*dt+i*dx*p,i))),
c                 i
c
c     semblance(m,n)={sum[sum(u(m+j,n+k)]**2}/{ntr*sum[sum(u(m+j,n+k)**2)]}
c                      j   k                        j   k   
c
c     where (-lxsemb < k < +lxsemb) is the index over a trace window, 
c                               and 
c     where (-ltsemb < j < +ltsemb) is the index over a time window.
c
c     author: K. J. Marfurt (May 3, 1994).
c___________________________________________________________________
c     uxt     = input (x,t) data.
c     utaup   = output (tau,p) data.                         
c___________________________________________________________________
      real      uxt(nfft,ntr)
      real      ui(len,ntr),ui2(len,ntr)
      real      unum(len,ntr),udenom(len,ntr)
      real      unumsum(len,ntr),udenomsum(len,ntr)
      real      sembwgt(len,ntr)
      real      tsembwgt(0:nfft-1)
      real      utaup(nfft,np)  
      integer   ncount(len)
      real      swgt(0:lswgt)
c
      real      p(np)
      real      theta(ntr)
      real      w(-3:+4,0:ndiv)                         
      integer   firstsamp,lastsamp
      logical   live(ntr)
      logical   add,drop

      real      cputim(*),waltim(*)
c
c___________________________________________________________________
c     record will be scaled such that rms energy = 1.0
c     set baseline for running sum roundoff to be .001 .
c___________________________________________________________________
      parameter (eps2=1.e-3)
      write(0,*) 'in taupsemb'
      fact=float(lswgt)/(2*lxsemb+1)
c___________________________________________________________________
c     scale the data to avoid truncation errors when forming the
c     running sums using the efficient add/drop technique.
c___________________________________________________________________
      sum2=0.
      do 11000 jtr=1,ntr
       if(live(jtr)) then
          do 10000 jsamp=1,len
           sum2=sum2+uxt(jsamp,jtr)**2
10000     continue
       endif
11000 continue
      if(sum2 .eq. 0.) then
c___________________________________________________________________
c        all traces are either dead or zero.
c        zero out (taup,p) transform and return.
c___________________________________________________________________
         do 13000 jp=1,np
          do 12000 jsamp=1,len  
           utaup(jsamp,jp)=0.
12000     continue
13000    continue
         return
      endif
c___________________________________________________________________
c     scale the data.
c___________________________________________________________________
      scale=1./sqrt(sum2)
      unscale=1./scale    
      do 15000 jtr=1,ntr
       do 14000 jsamp=1,len
        uxt(jsamp,jtr)=scale*uxt(jsamp,jtr)
14000  continue
15000 continue
c___________________________________________________________________
c     loop over all p values.                        
c___________________________________________________________________
      do 80000 jp=1,np
       do 16000 jsamp=1,len
        ncount(jsamp)=0
16000  continue
       call timstr(v1,w1)
       do 20000 jtr=1,ntr
        if(live(jtr)) then
           ptheta=p(jp)*theta(jtr)
           if(ptheta .ge. 0.) then
              jptheta=ptheta   
           else
              jptheta=ptheta-1.   
           endif
           firstsamp=max(4-jptheta,1)
           lastsamp=min(len,len-(jptheta+4))
           idiv=nint(adiv*(ptheta-jptheta))
c
           do 17000 jsamp=1,firstsamp-1
            ui(jsamp,jtr)=0.
17000      continue
c
           do 18000 jsamp=lastsamp+1,len
            ui(jsamp,jtr)=0.
18000      continue
c
           do 19000 jsamp=firstsamp,lastsamp
            ileft=jsamp+jptheta
            ui(jsamp,jtr)= w(-3,idiv)*uxt(ileft-3,jtr)
     1                       +w(-2,idiv)*uxt(ileft-2,jtr)
     2                       +w(-1,idiv)*uxt(ileft-1,jtr)
     3                       +w( 0,idiv)*uxt(ileft  ,jtr)
     4                       +w(+1,idiv)*uxt(ileft+1,jtr)
     5                       +w(+2,idiv)*uxt(ileft+2,jtr)
     6                       +w(+3,idiv)*uxt(ileft+3,jtr)
     7                       +w(+4,idiv)*uxt(ileft+4,jtr)
            if(ui(jsamp,jtr) .ne. 0.) then
                ncount(jsamp)=ncount(jsamp)+1
            endif
19000      continue
        endif
20000  continue
       call timend(cputim(17),v1,v2,waltim(17),w1,w2)
c
       call timstr(v1,w1)
c__________________________________________________________________
c      initialize arrays.                       
c__________________________________________________________________
       call vclr(utaup(1,jp),1,nfft) 
       do 38000 jtr=1,ntr
        do 37000 jsamp=1,len
         ui2(jsamp,jtr)=ui(jsamp,jtr)**2
37000   continue
38000  continue
c__________________________________________________________________
c      initialize semblance calculation for the first trace.
c__________________________________________________________________
       jtr=1
c      do 43500 jtr=1,ntr
       do 39000 jsamp=1,len
        unum(jsamp,jtr)=0.
        udenom(jsamp,jtr)=0.
39000  continue
       do 43000 jx=max(1,jtr-lxsemb),min(ntr,jtr+lxsemb)
        do 41000 jsamp=1,len
          unum(jsamp,jtr)=unum(jsamp,jtr)+ui(jsamp,jx)
          udenom(jsamp,jtr)=udenom(jsamp,jtr)+ui2(jsamp,jx)
41000   continue
43000  continue
c43500  continue
c__________________________________________________________________
c      calculate running sums in x by adding/dropping terms to/from
c      the previous sum.
c__________________________________________________________________
        do 54000 jtr=2,ntr
         if(jtr-lxsemb-1 .ge. 1) then       
            drop=.true.
         else
            drop=.false.
         endif
         if(jtr+lxsemb .le. ntr) then
            add=.true.
         else
            add=.false.
         endif
         if(add .and. drop) then
c__________________________________________________________________
c          combine terms of like amplitude before adding to the sum
c          to minimize truncation error.
c__________________________________________________________________
            do 51000 jsamp=1,len
             unum(jsamp,jtr)=unum(jsamp,jtr-1)
     1             +(ui(jsamp,jtr+lxsemb)-ui(jsamp,jtr-lxsemb-1))
             udenom(jsamp,jtr)=udenom(jsamp,jtr-1)
     1             +(ui2(jsamp,jtr+lxsemb)-ui2(jsamp,jtr-lxsemb-1))
51000      continue
         elseif(add) then
            do 52000 jsamp=1,len
             unum(jsamp,jtr)=unum(jsamp,jtr-1)+ui(jsamp,jtr+lxsemb)
             udenom(jsamp,jtr)=udenom(jsamp,jtr-1)+ui2(jsamp,jtr+lxsemb)
52000      continue
         elseif(drop) then
            do 53000 jsamp=1,len
             unum(jsamp,jtr)=unum(jsamp,jtr-1)-ui(jsamp,jtr-lxsemb-1)
             udenom(jsamp,jtr)=udenom(jsamp,jtr-1)
     1                                   -ui2(jsamp,jtr-lxsemb-1)
53000      continue
         endif
54000  continue
c__________________________________________________________________
c      square the numerator.
c__________________________________________________________________
       do 56000 jtr=1,ntr
        do 55000 jsamp=1,len  
         unum(jsamp,jtr)=unum(jsamp,jtr)**2
55000   continue
56000  continue
c__________________________________________________________________
c      initialize the time integration gate.
c__________________________________________________________________
       jsamp=ltsemb+1
c      do 62500 jsamp=ltsemb+1,len-ltsemb
       do 62000 jtr=1,ntr
        unumsum(jsamp,jtr)=0.       
        udenomsum(jsamp,jtr)=eps2     
        do 61000 jgate=-ltsemb,+ltsemb
         unumsum(jsamp,jtr)=unumsum(jsamp,jtr)+unum(jsamp+jgate,jtr)
         udenomsum(jsamp,jtr)=udenomsum(jsamp,jtr)
     1                        +udenom(jsamp+jgate,jtr)
61000   continue
62000  continue
c62500  continue
c__________________________________________________________________
c      calculate running sums in t by adding/dropping terms to/from
c      the previous sum.
c__________________________________________________________________
        do 64000 jtr=1,ntr
         do 63000 jsamp=ltsemb+2,len-ltsemb
          unumsum(jsamp,jtr)=unumsum(jsamp-1,jtr)+
     1             (unum(jsamp+ltsemb,jtr)-unum(jsamp-ltsemb-1,jtr))
          udenomsum(jsamp,jtr)=udenomsum(jsamp-1,jtr)+
     1             (udenom(jsamp+ltsemb,jtr)-udenom(jsamp-ltsemb-1,jtr))
          unumsum(jsamp,jtr)=max(unumsum(jsamp,jtr),0.)  
          udenomsum(jsamp,jtr)=max(udenomsum(jsamp,jtr),eps2)
63000   continue
64000  continue
c__________________________________________________________________
c      complete the semblance calculation.
c      index the weight corresponding to the semblance.
c      form the weighted (tau,p) transform. 
c__________________________________________________________________
       do 77000 jtr=1,ntr
        do 73000 jsamp=ltsemb+1,len-ltsemb
         jsemb=(unumsum(jsamp,jtr)/udenomsum(jsamp,jtr))*fact
         if(jsemb .lt. 0 .or. jsemb .gt. lswgt) then
              write(lerr,*) 'jsamp,unumsum.udenomsum ',
     1               jsamp,unumsum(jsamp,jtr),udenomsum(jsamp,jtr)
             write(lerr,*) 'jsemb,fact,lswgt ',jsemb,fact,lswgt
             call exit(888)
         endif
         sembwgt(jsamp,jtr)=max(swgt(jsemb),tsembwgt(jsamp))
cccc
c        asemb=unumsum(jsamp,jtr)/udenomsum(jsamp,jtr)
c      c if(asemb .lt. .001) then
c           sembwgt(jsamp,jtr)=0.
c        else
c           sembwgt(jsamp,jtr)=1.
c        endif
cccc
         utaup(jsamp,jp)=utaup(jsamp,jp)+
     1                   ui(jsamp,jtr)*sembwgt(jsamp,jtr)
73000   continue
c__________________________________________________________________
c       use first (last) complete semblance calculation at the 
c       top (bottom) of the window.
c__________________________________________________________________
        do 74000 jsamp=1,ltsemb
         sembwgt(jsamp,jtr)=sembwgt(ltsemb+1,jtr)
         utaup(jsamp,jp)=utaup(jsamp,jp)+
     1                    ui(jsamp,jtr)*sembwgt(jsamp,jtr)
74000   continue
        do 76000 jsamp=len-ltsemb+1,len
         sembwgt(jsamp,jtr)=sembwgt(len-ltsemb,jtr)
         utaup(jsamp,jp)=utaup(jsamp,jp)+
     1                    ui(jsamp,jtr)*sembwgt(jsamp,jtr)
76000   continue
77000  continue
       call timend(cputim(18),v1,v2,waltim(18),w1,w2)
80000 continue
c___________________________________________________________________
c     unscale the results.
c___________________________________________________________________
      do 95000 jp=1,np   
       do 94000 jsamp=1,len
        utaup(jsamp,jp)=utaup(jsamp,jp)*unscale
94000  continue
95000 continue
c
      return
      end
