C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine rdgather(rbufin,ibufin,ibufout,
     1                    hbegin,nsamp_in,nsamp_out,lentr2_in,
     2                    lentr2_out,
     2                    lenhed,ntrout,np,luin,lerr,eod,irec,
     3                    ifmt_disthdr,l_disthdr,ln_disthdr,
     4                    ifmt_mute,l_mute,ln_mute,
     5                    p,dmin,dx,theta,dist,zref,
     6                    hyperbolic,parabolic,linear,fourier,live,
     7                    regularize,interpolate,verbose,dt)
      integer   hbegin
      integer   ibufin(lentr2_in,np)
      integer   ibufout(lentr2_out,ntrout)
      real      rbufin(hbegin:nsamp_in,np)
      real      dist(ntrout),theta(ntrout)
      real      p(np)
      logical   live(ntrout)
      logical   hyperbolic,parabolic,linear,fourier,eod
      logical   regularize,interpolate,verbose
      logical   deadgather

      common /thdr/ ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     1              ifmt_RecNum,l_RecNum,ln_RecNum,
     2              ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,
     3              ifmt_RecInd,l_RecInd,ln_RecInd,
     4              ifmt_DphInd,l_DphInd,ln_DphInd,
     5              ifmt_DstSgn,l_DstSgn,ln_DstSgn,
     6              ifmt_DstUsg,l_DstUsg,ln_DstUsg,
     7              ifmt_StaCor,l_StaCor,ln_StaCor,
     8              ifmt_SoPtNm,l_SoPtNm,ln_SoPtNm

c___________________________________________________________________________
c     read in tau-p data.               
c___________________________________________________________________________
      do 10000 ip=1,np     
       nbytes = 0
       call rtape(luin,rbufin(hbegin,ip),nbytes)
       if(nbytes .eq. 0) then
          write(LERR,*)'End of file on input:'
          write(LERR,*)'  rec= ',irec,'  trace= ',ip 
          eod=.true.
       endif
10000 continue
c
c___________________________________________________________________________
c     copy old trace headers into new.                 
c___________________________________________________________________________
      do 27000 itr=1,min(np,ntrout)
       do 26000 k=1,lenhed
        ibufout(k,itr)=ibufin(k,itr)
26000  continue
27000 continue
c
      do 29000 itr=np+1,ntrout
       do 28000 k=1,lenhed
        ibufout(k,itr)=0               
28000  continue
29000 continue
c
      deadgather=.true.
      do 30000 itr=1,ntrout
       if(regularize) then
c___________________________________________________________________________
c         calculate filtered traces on a regular grid.
c___________________________________________________________________________
          dist(itr)=dmin+(itr-1)*dx         
       else 
c___________________________________________________________________________
c         calculate filtered traces at original pretransform locations.
c___________________________________________________________________________
c         dist(itr)=ibufin(l_disthdr,itr)      
          call saver2(ibufin(1,itr),ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                 ival , 1)
          dist(itr) = ival
       endif
       if(linear .or. fourier) then
          theta(itr)=dist(itr)
       elseif(hyperbolic) then
          theta(itr)=sqrt(zref**2+dist(itr)**2)-zref
       else
          theta(itr)=dist(itr)**2
       endif
c      ibufout(l_DstSgn,itr)=nint(dist(itr))
c      ibufout(l_DstUsg,itr)=abs(nint(dist(itr)))  
c      ibufout(l_TrcNum,itr)=itr           
       call savew2(ibufout(1,itr),ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1              ival , 1)
       ival = iabs (ival)
       call savew2(ibufout(1,itr),ifmt_DstUsg,l_DstUsg, ln_DstUsg,
     1              ival , 1)
       call savew2(ibufout(1,itr),ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1              itr  , 1)
c___________________________________________________________________________
c      set dead traces to be live (interpolate!).
c      reassign original trace header information.                 
c___________________________________________________________________________
c      istacor=ibufout(l_StaCor,itr)
       call saver2(ibufout(1,itr),ifmt_StaCor,l_StaCor, ln_StaCor,
     1              istacor, 1)
       if(istacor .eq. 30002) then
c___________________________________________________________________________
c         dead trace transformed from (t,x,y) to (tau,p,q)!
c         inverse transform one level should keep all ray parameters live.
c___________________________________________________________________________
          live(itr)=.true.
c         ibufout(l_StaCor,itr)=30001
          call savew2(ibufout(1,itr),ifmt_StaCor,l_StaCor, ln_StaCor,
     1                 30001, 1)
       elseif(istacor .eq. 30001) then
c___________________________________________________________________________
c         original input trace to radonf was dead!
c         (changed from 30000 to 30001 to allow pred and taupred to work)
c___________________________________________________________________________
          if(interpolate .or. regularize) then 
c___________________________________________________________________________
c            set dead traces to be live.
c___________________________________________________________________________
             live(itr)=.true.
c            ibufout(l_StaCor,itr)=0
             call savew2(ibufout(1,itr),ifmt_StaCor,l_StaCor, ln_StaCor,
     1                    0, 1)
          else
c___________________________________________________________________________
c            set dead trace header flag to be conventional (x,t) gather
c            value of 30000
c___________________________________________________________________________
             live(itr)=.false.
c            ibufout(l_StaCor,itr)=30000
             call savew2(ibufout(1,itr),ifmt_StaCor,l_StaCor, ln_StaCor,
     1                    30000, 1)
          endif
       else
          live(itr)=.true.
          deadgather=.false.
       endif
30000 continue
      if(deadgather) then
c___________________________________________________________________________
c        all traces in this gather are original dead.
c        no way to interpolate. 
c
c                   -1
c        (R*R-eps*I)  R will be undefined in subroutine radinv.
c
c        reset all traces to be dead.
c___________________________________________________________________________
         do 40000 itr=1,ntrout
          live(itr)=.false.
40000    continue
      endif
       if(verbose) then
          write(lerr,*) 'in rdgather:'
          write(lerr,'(3a10)') 'itr','dist(itr)','live(itr)'          
          write(lerr,'(i10,f10.0,l10)') 
     1           (itr,dist(itr),live(itr),itr=1,ntrout) 
       endif
c
      return
      end
