C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM MODULE  rand
C
C**********************************************************************C
C
C RAND READS SEISMIC TRACE DATA FROM AN INPUT FILE,
C then  according to options adds random noise to the traces and/or
C time shifts traces by random times
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, SAVE, randno
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      INTEGER     ITR ( SZLNHD )
      INTEGER     LHED( SZLNHD )
      INTEGER     NSAMP, NSI, NTRC, NREC, IFORM
      INTEGER     LUIN , LBYTES, NBYTES,obytes,gi,si,si0,gi0
      integer     iseed, argis
#include <f77/pid.h>
      REAL        amp, alevel(SZLNHD)
      REAL        wtrce(SZSMPM),array(SZSMPM),xtr(SZSMPM)
      real        rarray(SZLNHD), sarray(SZLNHD)
      CHARACTER   NAME * 4, ntap * 256, otap * 256, iswd*6
      logical     verbos,query,src,rcvr,job
 
c     EQUIVALENCE ( ITR(129), xtr (1) )
      EQUIVALENCE ( ITR(  1), LHED(1) )
      DATA NAME     /'RAND'/
      DATA LUIN / 1 /, LBYTES / 0 /, NBYTES / 0 /

C**********************************************************************C
C     get online help if necessary
C**********************************************************************C
      query = (argis('-?').gt.0 .or. argis('-h').gt.0)
      if( query ) then
          call help()
          stop
      endif

C**********************************************************************C
C     open printout file
C**********************************************************************C
#include <f77/open.h>

C**********************************************************************C
C     READ PROGRAM PARAMETERS FROM COMMAND LINE ARGUMENT STRING
C**********************************************************************C
      call cmdln(ntap,otap,frac,trac,ist,iend,nst,ned,nrst,nred,iseed,
     &           amp,iswd,src,rcvr,verbos,job)

C**********************************************************************C
C     open data sets; read header; save key values
C**********************************************************************C
      call getln( luin, ntap, 'r', 0)
      call getln(luout, otap, 'w', 1)
      lbytes=0
      CALL RTAPE ( LUIN, ITR, LBYTES           )
      if(lbytes .eq. 0) then
         write(LERR,*)'RAND: no header read on unit ',ntap
         write(LERR,*)'Check existence of file & rerun'
         write(LERR,*)'FATAL'
         stop
      endif
      CALL HLHprt ( ITR , LBYTES, NAME, 4, LERR        )
#include <f77/saveh.h>

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu(iswd,ifmt_iswd,l_iswd,ln_iswd,TRACEHEADER)

      if(nsamp .gt. SZLNHD) nsamp=SZLNHD

C**********************************************************************C
C     check default command line parameters & update header
C**********************************************************************C
      call cmdchk(nst,ned,nrst,nred,ntrc,nrec)
      jtrc=ned-nst+1
       call savew( itr, 'NumTrc', jtrc , LINHED)
      nrecc=nred-nrst+1
       call savew( itr, 'NumRec', nrecc, LINHED)
      trac=trac/nsi
      ist=ist/nsi
      iend=iend/nsi
      if(ist .lt. 1) ist=1
      if(iend .lt. 1) iend=nsamp
      nsampo=iend-ist+1
       call savew( itr, 'NumSmp', nsampo, LINHED)
      obytes = SZTRHD + SZSMPD * nsampo

C**********************************************************************C
c     generate big array of random numbers for
c     surface consistent random statics
C**********************************************************************C


         if (ntrc*nrec .gt. SZLNHD) then
            write(LERR,*)'Warning: Too many traces in line'
            write(LERR,*)'Reduce size of data set, i.e. fewer trc/rec'
            write(LERR,*)'or records/line'
            write(LERR,*)'Or call Gutowski'
         endif

         call vrand (iseed,rarray,1,SZLNHD)
         call vrand (iseed/8,sarray,1,SZLNHD)
         call maxmgv(rarray,1,amax,indx,SZLNHD)
         amax2 = .5 * amax
         do  11  ii = 1, SZLNHD
                 rarray(ii) = frac * (rarray(ii) - amax2)/amax2
                 sarray(ii) = trac * (sarray(ii) - amax2)/amax2
11       continue

C**********************************************************************C
C     generate random level for traces
C**********************************************************************C
      if (amp .ne. 0.) then
          call vrand (911*iseed, alevel, 1, SZLNHD)
          call maxmgv(array,1,amax,indxa,SZLNHD)
          amax2 =  .5 * amax
          do  12  ii = 1, SZLNHD
                  alevel(ii) = amp * (alevel(ii) - amax2)/amax2
12        continue
      endif

C**********************************************************************C
C     print out header values
C**********************************************************************C
c     if(verbos) then
        write(LERR,*)
        write(LERR,*)' Values read from input data set line header'
        write(LERR,*)
        write(LERR,*) ' # of Samples/Trace =  ', nsamp
        write(LERR,*) ' Sample Interval    =  ', nsi  
        write(LERR,*) ' Traces per Record  =  ', ntrc 
        write(LERR,*) ' Records per Line   =  ', nrec
        write(LERR,*) ' Output records     =  ', nrecc
        write(LERR,*) ' Format of Data     =  ', iform
        write(LERR,*) ' Output # samples   =  ',nsampo
        write(LERR,*) ' Fraction add nse   =  ',frac
        write(LERR,*) ' Max static         =  ',nsi*trac
        write(LERR,*) ' Seed for random gen=  ',iseed
        if(src)
     1  write(LERR,*) ' Source consistent statics'
        if(rcvr)
     1  write(LERR,*) ' Receiver consistent statics'
        if (amp .ne. 0.) then
           write(LERR,*) ' Amplitude limit for trace-to-trace variation'
           write(LERR,*) ' of random noise level=  ',amp
        endif
        if (job)
     1  write(LERR,*) ' Amplitude level for ampl noise is job const'
c     endif

C**********************************************************************C
C     update historical line header with command line; write header
C**********************************************************************C
      call savhlh( itr, lbytes, lbyout)
 
      call wrtape(luout,itr,lbyout)

C**********************************************************************C
C     skip to starting record
C**********************************************************************C
      call recskp(1,nrst-1,luin,ntrc,itr)

C**********************************************************************C
C
C     READ TRACE, apply noise, write trace
C
C**********************************************************************C
c
c
      call vclr (array,1,nsampo)
      ic = 1

      DO 100 JJ = NRST, NRED

c--------------------------------------------
c  in current record, skip to start trace
c--------------------------------------------
            call trcskp(jj,1,nst-1,luin,ntrc,itr)

           DO 99 KK = NST, NED
             nbytes = 0
              CALL RTAPE  ( LUIN , ITR, NBYTES         )
               if(nbytes .eq. 0) then
                  write(LERR,*)'End of file on input:'
                  write(LERR,*)'  rec= ',jj,'  trace= ',kk
                  go to 999
               endif
               call vmov (itr(ITHWP1), 1, xtr, 1, nsamp)
               call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                     istat  , TRACEHEADER)
               call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                     irec   , TRACEHEADER)
               call saver2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                     itrc   , TRACEHEADER)

               if (ic .gt. SZLNHD) ic = 1
               call vmov(xtr(ist),1,wtrce,1,nsampo)
c-------------------------
c  find max value of trace
               if(frac .gt. 0.) then
                    call maxmgv(wtrce,1,xmax,indx,nsampo)
               endif
               if(amp .gt. 0.) then
                    call maxmgv(wtrce,1,xmax,indx,nsampo)
               endif
c--------------------------
c  find rms value of trace
               if(frac .lt. 0.) then
                   call dotpr(wtrce,1,wtrce,1,xmax,nsampo)
                   xmax=sqrt(xmax/nsampo)
               endif
               if(amp .lt. 0.) then
                   call dotpr(wtrce,1,wtrce,1,xmax,nsampo)
                   xmax=sqrt(xmax/nsampo)
               endif

c----------------------
c  random statics
               call saver2(itr,ifmt_SrcLoc,l_SrcLoc, ln_SrcLoc,
     1                     isi, TRACEHEADER)
               call saver2(itr,ifmt_RecInd,l_RecInd, ln_RecInd,
     1                     igi, TRACEHEADER)

               si = isi/10
               gi = igi
               if (ic .eq. 1) then
                   si0 = si-1
                   gi0 = gi-1
                   si = 1
                   gi = 1
               else
                   si = iabs (si - si0)
                   gi = iabs (gi - gi0)
               endif

c-------------------
c  src consistent
               if (src .and. .not.rcvr) then

                  istats = sarray(si)
                  istatic = istats

c-------------------
c  rcvr consistent
               elseif (rcvr .and. .not.src) then

                  istatr = rarray(gi)
                  istatic = istatr

c--------------------
c  src & rcvr consist
               elseif (src .and. rcvr) then

                  istats = sarray(si)
                  istatr = rarray(gi)
                  istatic = istats + istatr

c--------------------
c  non surf consistent
               else

                  istatic = sarray(ic)
                  istats  = 0
                  istatr  = 0

               endif
               ic = ic + 1
c-------------------------
c  generate random numbers
c  for white noise addition
c  if required

               IF (frac .ne. 0.) THEN                

c                   call vrand (1311*kk*jj, array, 1, nsampo)
                   call vrand (iseed*kk*jj, array, 1, nsampo)
                   call maxmgv(array,1,amax,indxa,nsampo)
                   amax2 = .5 * amax
                   amax = xmax/amax
                   do  51  ii = 1, nsampo
                           array(ii) = (array(ii) - amax2)/amax2
51                 continue

               ENDIF

c              if (itr(125) .ne. 30000) itr(iswd)=nsi*istatic
               if (istat .ne. 30000) then
                  istati = nsi*istatic
                  call savew2(itr,ifmt_iswd,l_iswd, ln_iswd,
     1                        istati , TRACEHEADER)
               else
                  istati = istat
               endif

               if(verbos) then
                 write(LERR,*) 'Record=  ',irec,'  Trace=  ',
     1                         itrc,' Src Static= ',nsi*istats,
     2                         ' Rcvr Static= ',nsi*istatr,
     3                         ' Tot Static= ',istati
               endif
               do 56 ii=1,nsampo
                  i1 = ii + istatic
                  if(i1 .lt. 1) i1 = 1
                  if(i1 .gt. nsampo) i1 = nsampo
                  if (job) then
                     xtr(ii) = wtrce(i1) + abs(frac)*array(ii)
                  else
                     if (xmax .ne. 0.) then
                        xtr(ii) = wtrce(i1) + xmax * abs(frac)*array(ii)
                     else
                        xtr(ii) = wtrce(i1) + abs(frac)*array(ii)
                     endif
                  endif
56             continue

               IF (amp .ne. 0.) THEN
                  var = abs(1.0 - abs(alevel(ic)))
                  if(verbos)
     1            write(LERR,*)'Record= ',irec,'  Trace= ',itrc,
     2            '  Overall trace amplification= ',var
                  call vsmul (xtr, 1, var, xtr, 1, nsampo)
               ENDIF
 
              call vmov  (xtr, 1, itr(ITHWP1), 1, nsampo)
              call wrtape(luout,itr,obytes)
   99      CONTINUE

c-------------------------------------------------------------
c  skip to end of current record
c-------------------------------------------------------------
            call trcskp(jj,ned+1,ntrc,luin,ntrc,itr)

  100 CONTINUE

      write(LER,*)'rand: Normal Termination'
      write(LERR,*)' Normal Termination'
      call lbclos(luin)
      call lbclos(luout)
      stop
    

  999 continue
      write(LER,*)'rand: Abnormal Termination'
      write(LERR,*)' Abnormal Termination'
      call lbclos(luin)
      call lbclos(luout)
      stop
      END

c------------------------------------
c  online help section
c------------------------------------
      subroutine help
#include <f77/iounit.h>

        write(LER,*)' '
        write(LER,*)'Command Line Arguments for RAND: add random noise'
        write(LER,*)' '
        write(LER,*)'Input....................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N[ntap]   -- input data set'
        write(LER,*)'-O[otap]   -- output data set'
        write(LER,*)'-f[frac]   -- add noise equal to fraction of trace'
        write(LER,*)'              ampl. <0=rms used; >0=max amp    (0)'
        write(LER,*)'-t[trac]   -- random static of trac ms       ( 0 )'
        write(LER,*)'-a[amp]    -- limit for random variation of [frac]'
        write(LER,*)'              (def = constant [frac] for all trcs'
        write(LER,*)'-s[ist]    -- start time (ms)         (first samp)'
        write(LER,*)'-e[iend]   -- end time (ms)            (last samp)'
        write(LER,*)'-ns[nstr]  -- start trace number           (first)'
        write(LER,*)'-ne[netr]  -- end trace number              (last)'
        write(LER,*)'-rs[nrst]  -- start record                 (first)'
        write(LER,*)'-re[nred]  -- end record                    (last)'
        write(LER,*)'-wd[iswd]  -- put static in this hdr wrd  (StaCor)'
        write(LER,*)'-S         -- source consistent random statics'
        write(LER,*)'-J         -- amplitude level for [frac] job const'
        write(LER,*)'-R         -- receiver consistent random statics'
        write(LER,*)'              Note: -S -R means surface consistent'
cmam....
        write(LER,*)'-C[ic]     -- seed for random number generator'
        write(LER,*)'              (optional;integer)             (911)'
        write(LER,*)'-V         -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)'        rand -N[] -O[] -f[] -a[] -t[] -s[] -e[]'
        write(LER,*)'               -ns[] -ne[] -rs[] -re[] -wd[]'
        write(LER,*)'               -C[] [-S -R -J -V]'
        write(LER,*)' '

      return
      end

c-----
c     get command arguments
c
c     ntap  - C*100  input file name
c     otap  - C*100  output file name
c     ist   - I      start sample
c    iend   - I      end sample
c     nst   - I      start trace
c     ned   - I      stop end trace
c    nrst   - I      start record
c    nred   - I      stop end record
c    frac   - R      fractional amplitude random noise
c    trac   - R      fractional static noise
c    amp    - R      maximum amp for randon variations of amplitude
c     ic    - I      optional seed for random number generator
c    iswd   - I      optional place for static to go in header
c     src   - L      source sonsistent statics
c    rcvr   - L      receiver sonsistent statics
c    job    - L      amplitide level for [frac] is job const
c    verbos - L      verbose output or not
c-----
      subroutine cmdln(ntap,otap,frac,trac,ist,iend,nst,ned,nrst,nred,
     &           ic,amp,iswd,src,rcvr,verbos,job)
      character     ntap*(*), otap*(*), iswd*6
      integer       argis, ist, iend, nst, ned, nrst, nred, ic
      real          frac, trac, amp
      logical       verbos, src, rcvr, job

         call argstr('-N',ntap,' ',' ') 
         call argstr('-O',otap,' ',' ') 
         call argstr('-wd',iswd,'StaCor','StaCor') 
         call argr4('-f',frac,0.,0.)
         call argr4('-t',trac,0.,0.)
         call argr4('-a',amp,0.,0.)
         call argi4('-s',ist,1,1)
         call argi4('-e',iend,0,0)
         call argi4('-ns',nst,0,0)
         call argi4('-ne',ned,0,0)
         call argi4('-rs',nrst,1,1)
         call argi4('-re',nred,0,0)
         call argi4('-C',ic,911,911)
         src    = (argis('-S') .gt. 0)
         rcvr   = (argis('-R') .gt. 0)
         job    = (argis('-J') .gt. 0)
         verbos = (argis('-V') .gt. 0)

      return
      end
