C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************c
c
c ratdecon reads seismic trace data from an input file,
c performs rational polynomial deconvolution and
c writes the results to an output file
c
c
c**********************************************************************c
c
c     declare variables
c
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
 
      integer     itr ( SZLNHD )
      integer     lhed( SZLNHD )
      integer     nsamp, nsi, ntrc, nrec, iform, ist, iend, luout2
      integer     luin , luout1, lbytes, nbytes, lbyout
      integer     nfilt, isp, lpee, lque, lquei, iter, obytes
#include <f77/pid.h>
      integer     recnum, trcnum, static
      real        tri ( SZLNHD ), pee ( SZLNHD ), que ( SZLNHD )
      real        quei ( SZLNHD ), quemd ( SZLNHD )
      real        work ( SZLNHD ), space ( 4*SZLNHD ), one ( SZLNHD )
      real        prew
      character   ntap * 256, otap1 * 256, otap2 * 256, name*8
      logical     verbos, query, init
      integer     argis, pipe
 
c     equivalence ( itr(129), tri (1) )
      equivalence ( itr(  1), lhed(1) )
      data lbytes / 0 /, nbytes / 0 /, name/'RATDECON'/
      data pipe/3/
 
c-----
c     read program parameters from command line card image file
c-----
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query )then
            call help()
            stop
      endif
 
c-----
c     open printout files
c-----
#include <f77/open.h>
 
      call gcmdln(ntap,otap1,otap2,ist,iend,prew,isp,
     1             lpee,lque,lquei,iter,init,verbos)
c-----
c     get logical unit numbers for input and output
c-----
      call getln(luin , ntap,'r', 0)
      call getln(luout1, otap1,'w', 1)
      if (otap2(1:1) .ne. ' ') then
          call getln(luout2, otap2,'w', 2)
      else
          write(LERR,*)'ratdecon assumed to be running inside IKP'
          call sisfdfit (luout2, pipe)
      endif

      if (luout2 .lt. 0) then
          write(LERR,*)'Unable to open output2 data set'
          stop
      endif


c-----
c     read line header of input
c     save certain parameters
c-----
      call rtape  ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'RATDECON: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

      call hlhprt (itr, lbytes, name, 8, LERR)

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
c-----
c     verbose output of all pertinent information before
c     processing begins
c-----
c     if( verbos ) then
            call verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  ist,iend,prew,isp,lpee,lque,lquei,
     2                   iter,ntap,otap1,otap2,init)
c     end if

c-----------------------------------------------------
c  figure out design window times, polynomial legths

      dt = real (nsi) * unitsc

      lpee = lpee/nsi
      lque = lque/nsi
      lquei = lquei/nsi
      if (lquei .lt. 1) lquei = lque
      if (lpee .lt. 1 .and. lque .lt. 1) then
          lpee = nsamp
          lque = nsamp
          lquei = lque
      endif
      ist = ist/nsi
      if (ist .lt. 1) ist = 1
      isp = isp/nsi
      if (isp .lt. 1) isp = lpee/2
      iend = iend/nsi
      if (iend .lt. 1) iend = nsamp
      if (iend .gt. nsamp) iend = nsamp
      nfilt = iend - ist + 1
      prew = prew/100.

c-----------------------------------------------------

c-----
c     update historical line header
c     output trace size
c-----
      obytes = SZTRHD + nfilt * SZSMPD
      call savew(itr, 'NumSmp', nfilt, LINHED)
      call savhlh(itr,lbytes,lbyout)
      call wrtape ( luout1, itr, lbyout                 )
      call wrtape ( luout2, itr, lbyout                 )


c--------------------------
c  set up initial p-array

      call vclr (pee,1,lpee)
      pee(isp) = 1.0

c-------------------------
c  set up impulse array

      call vclr (one,1,SZSMPM)
      one(1) = 1.0

c-----
c     BEGIN PROCESSING
c     read trace, do inverse, write to output file
c-----
c-----
c     process desired trace records
c-----
      do 1000 jj = 1, nrec
 
 
            do 1001 kk= 1, ntrc
                  nbytes = 0
                  call rtape( luin, itr, nbytes)
                  if(nbytes .eq. 0) then
                     write(LERR,*)'End of file on input:'
                     write(LERR,*)'  rec= ',jj,'  trace= ',kk
                     go to 999
                  endif
                  call vmov (itr(ITHWP1), 1, tri, 1, nsamp)
                  call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                        static, TRACEHEADER)
                  call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                        recnum, TRACEHEADER)
                  call saver2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                        trcnum, TRACEHEADER)


                  IF (static .ne. 30000) THEN


                    call dotpr (tri(ist),1,tri(ist),1,xdot,nfilt)

c--------------------
c  design wind is a
c  mute zone
                    if (xdot .lt. 1.e-10) then
                       write(LERR,*)' '
                       write(LERR,*)'rec= ',recnum,' trc= ',trcnum
                       write(LERR,*)'Design window looks like a mute zon
     1e'
                       write(LERR,*)'Skipping processing'
                       call vclr(pee,1,nsamp)
                       call vclr(quemd,1,nsamp)

c-------------------
c  process design
c  window
                    else

                       if (init) then
                           call vclr (pee,1,nsamp)
                           pee(isp) = 1.0
                       endif

                       DO  10  i = 1, iter

                         call shape (nfilt,tri(ist),lpee,pee,lque,que,
     1                               lc,work,ase,prew,space)
                         call shape (lque,que,lque,one,lquei,quei,
     1                               lc,work,ase,prew,space)
                         call vsdiv (quei,1,quei(1),quei,1,lquei)
                         call shape (lquei,quei,nfilt,tri(ist),lpee,pee,
     1                                lc,work,ase,prew,space)

10                     CONTINUE

                         call shape (lquei,quei,lquei,one,lquei,quemd,
     1                                lc,work,ase,prew,space)
                    endif
c--------------------

                  ELSE

                       call vclr(pee,1,nfilt)
                       call vclr(quemd,1,nfilt)

                  ENDIF


                  call vclr (tri,1,nfilt)
                  call vmov (pee,1,itr(ITHWP1),1,lpee)
                  call wrtape( luout1, itr, obytes)
                  call vclr (tri,1,nfilt)
                  call vmov (quemd,1,itr(ITHWP1),1,lquei)
                  call wrtape( luout2, itr, obytes)

                  if(verbos)write(LERR,*)'ri ',recnum,' trace ',trcnum,
     1                      ' ase=  ',ase
 1001             continue
 
 
 1000       continue
c-----
c     close data files
c-----
  999 continue

      call lbclos ( luin )
      call lbclos ( luout1 )
      call lbclos ( luout2 )

            write(LERR,*)'end of ratdecon, processed',nrec,' record(s)',
     :               ' with ',ntrc, ' traces'
      end
 
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
        write(LER,*)
     :'execute ratdecon by typing ratdecon and list of program parameter  
     :s'
        write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
        write(LER,*) ' '
        write(LER,*)
     :' -N [ntap]    (no default)          : input data file name'
        write(LER,*)
     :' -O1 [otap1]  (no default)          : numerator output fname'
        write(LER,*)
     :' -O2 [otap2]  (no default)          : denominator output fname'
        write(LER,*) ' '
        write(LER,*)
     :' -c[iter]     (default = 5)         : number iterations for solut
     :ion'
        write(LER,*)
     :' -s[is]       (default = 0 ms)      : window start time (ms)'
        write(LER,*)
     :' -e[iend]     (default = end trace) : window end time (ms)'
        write(LER,*)
     :' -p[prew]     (default = 0.01%)     :  prewhitening percent'
        write(LER,*)
     :' -i[isp]      (default = ist ms)    :  time of inverse spike (ms)
     :'
        write(LER,*)
     :' -lp[lpee]    (def = none)          : length of denominator seque
     :nce (ms)'
        write(LER,*)
     :' -lq[lque]    (def = none)          : length of numerator sequenc
     :e (ms)'
        write(LER,*)
     :' -I  re-initialize numerator for every trace'
        write(LER,*)
     :' -V  verbose printout'
        write(LER,*) ' '
        write(LER,*)
     :'usage:   ratdecon -N[ntap] -O1[otap1] -O2[otap2} -c[iter] -s[is]'
        write(LER,*)
     :'                  -e[iend] -p[prew] -i[isp] -lp[lpee] -lq[lque]'
        write(LER,*)
     :'                  -I -V'
         write(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
      subroutine gcmdln(ntap,otap1,otap2,ist,iend,prew,isp,
     1                  lpee,lque,lquei,iter,init,verbos)
c-----
c     get command arguments
c
c     ntap  - c*100     input file name
c     otap1/2 c*100     output file names
c     ist   - I*4       window start time
c     iend  - I*4       window end time
c     isp   - I*4       time of inverse spike
c     lpee  - I*4       length of denominator sequence
c     lque  - I*4       length of numerator sequence
c     lquei - I*4       length of intermediate sequences
c     iter  - I*4       number iterations for solution
c     prew  - R*4       prewhitening percent
c     init        - L   re-initialize numerator at every trace
c     verbos      - L   verbose output or not
c-----
#include <f77/iounit.h>
      character   ntap*(*), otap1*(*), otap2*(*)
      real        prew
      integer     ist, iend, isp, lpee, lque, lquei
      integer     iter
      logical     verbos, init
      integer     argis
 
            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O1', otap1, ' ', ' ' )
            call argstr( '-O2', otap2, ' ', ' ' )
            call argr4( '-p', prew, 0.01, 0.01 )
            call argi4( '-c', iter, 5, 5 )
            call argi4( '-i', isp, 0, 0 )
            call argi4( '-s', ist, 0, 0 )
            call argi4( '-e', iend, 0, 0 )
            call argi4( '-lp', lpee, 0, 0 )
            call argi4( '-lq', lque, 0, 0 )
            call argi4( '-lqi', lquei, 0, 0 )
            init = (argis('-I') .gt. 0)
            verbos = (argis('-V') .gt. 0)

 
      return
      end
 
      subroutine verbal(nsamp, nsi, ntrc, nrec, iform,
     1            ist,iend,prew,isp,lpee,lque,lquei,
     2            iter,ntap,otap1,otap2,init)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4       number of samples in trace
c     nsi   - I*4       sample interval in ms
c     ist   - I*4       window start time
c     iend  - I*4       window end time
c     ntrc  - I*4       traces per record
c     nrec  - I*4       Number of records per line
c     iform - I*4       format of data
c     prew  - R*4       prewhitening percent
c     isp   - I*4       time of inverse spike
c     lpee  - I*4       length of denominator sequence
c     lque  - I*4       length of numerator sequence
c     lquei - I*4       length of intermediate sequences
c     iter  - I*4       number iterations for solution
c     init        - L   re-initialize numerator at every trace
c     ntap  - C*100     input file name
c     otap1/2 C*100     output file names
c-----
#include <f77/iounit.h>
      integer     nsamp, nsi, ntrc, nrec, isp, lpee, lque, lquei
      integer     iter
      real        prew
      character   ntap*(*), otap1*(*), otap2*(*)
      logical     init
 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' records per line   =  ', nrec
            write(LERR,*) ' format of data     =  ', iform
            write(LERR,*) ' start time         =  ',ist
            write(LERR,*) ' end time           =  ',iend
            write(LERR,*) ' time of initial spike =  ', isp
            write(LERR,*) ' length of numerator   =  ', lpee
            write(LERR,*) ' length of denominator =  ', lque
            write(LERR,*) ' length of intermediate=  ', lquei
            write(LERR,*) ' number iterations     =  ', iter
            write(LERR,*) ' prewhitening       =  ', prew
            write(LERR,*) ' input data set name =  ', ntap
            if (init)
     1      write(LERR,*) ' re-initialize numerator for every trace'
            write(LERR,*) ' output data set name=  ', otap1
            write(LERR,*) ' output data set name=  ', otap2
            write(LERR,*)' '
            write(LERR,*)' '
 
      return
      end
 
