C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine glean(inputx,inputy,inputz,nn,istarty,istepy,X,output,
     :     index,IndexTrace,top)
      
      integer nn,istepy,X,istarty,index,IndexTrace,top
      real inputz(*)
      real*8 inputx(*), inputy(*), output(*)

      do ii = istarty ,istarty + nn - 1,istepy

c 
c ----- the following attempts to oversample the shallow part of the -----
c       gain function to allow for a more significant input to the
c       shallow, high amplitude, near offset energy in the data.  This
c       should prevent small (an sometimes negative) gains at this
c       position in the data.  The /5 is used to only oversample over
c       the first fifth of the trace window used.  This parameter is
c       ad hoc and may be changed with experimentation.  If it is found
c       to be data dependant then perhaps it can become a command line
c       parameter.  To get back to the old Glean() just remove the first
c       half of the if loop (as well as the else and endif)
c

         if(top.gt.0.and.ii.lt.(Indextrace+top-1).
     :        and.ii.gt.istarty.and.istepy.gt.1)then

            do jj = ii-istepy+1,ii-1
               if(inputz(jj).gt.0.0.and.jj.lt.Indextrace + top-1) then
                 index = index + 1
                 inputx(index) = dble(X)
                 inputy(index) = dble(jj - IndexTrace + 1)
                 output(index) = dble(inputz(jj))
               endif
            enddo

         else if(inputz(ii).gt.0.0) then

            index = index + 1
            inputx(index) = dble(X)
            inputy(index) = dble(ii - IndexTrace + 1)
            output(index) = dble(inputz(ii))

         endif

      enddo

      return
      end
