C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine dcmpwt(n,x,sd,w)
c*************************************************************************
c     This subroutine calculates a weight array according to the 
c     probability distribution function.
c
c**** Subroutine inputs.
c
c     n = The length of the array x
c     x = The array with a standard deviation, sd, for which weights are
c         required.
c     sd = The standard deviation of the values of the elements of x.
c
c**** Subroutine ouputs.
c
c     w = The array of weights corresponding to the values of the elements
c         of x.
c
c*************************************************************************

      real*8 x(n),w(n),sd,t
      integer n,i
 
      do i = 1,n

        t = dabs(x(i)) / sd

        if(t.lt.10.0d0) then

          w(i) = dexp(-t * t)

          else

          w(i) = 0.0d0

        endif

      enddo 

      return
      end

