C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine p3ind(x,y,iord,c)

c***********************************************************************
c     this subroutine calculates the powers of the two independent
c     variables at the point x,y in a three dimensional polynomial.
c     this subroutine is used in the surface fitting program polyfit and
c     the polynomial evaluation program polyint.
c
c*****Subroutine inputs.
c
c     x = The first independent variable value
c     y = The second independent variable value
c     iord = The order of the polynomial
c
c**** Subroutine outputs.
c
c     c = The array of the powers of x and y up to iord.
c
c***********************************************************************

      real*8 x,y,c((iord + 1) * (iord + 2) / 2)
      integer iord,j,jb,k,kb

      c(1) = 1.0d0
      jb = 1

      do j = 1,iord

        do k = 1,j

          jb = jb + 1
          kb = jb - j
          c(jb) = c(kb) * x

        enddo

        jb = jb + 1
        c(jb) = c(kb) * y

      enddo

      return
      end
