C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine peval3(x,y,coef,iord,p)

c***********************************************************************
c     Evaluates the estimated value of a three dimensional polynomial
c     with two independent variables.
c
c**** Subroutine inputs.
c
c     x = The value of the first independent variable.
c     y = The value of the second independent variable.
c     coef = The array of polynomial coefficients.
c     iord = The order of the polynomial.
c
c**** Subroutine outputs.
c
c     p = The value of the polynomial at the point x,y.
c
c***********************************************************************

      real*8 x,y,p,prow
      real*8 coef((iord + 1) * (iord + 2) / 2)
      integer i,iord,iord2,jstart,nj,nstep,j,ij

      iord2 = (iord + 1) * (iord + 2) / 2
      jstart = iord2
      nj = 0
      p = coef(iord2)

      do i = iord,1,-1

        jstart = jstart - 1
        nj = nj + 1
        nstep = iord
        prow = coef(jstart)
        ij = jstart

        do j = nj,1,-1

          ij = ij - nstep
          prow = prow * x + coef(ij)
          nstep = nstep - 1

        enddo

        p = p * y + prow

      enddo

      return
      end
