C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c     program  ravn: true relative amplitude scaling with 
c                    spherical divergence correction
c
c Changes

c	Aug95 -- changed policman controlling number of live traces
c                used to derive surface.  Previously killed the job
c                if this test failed.  now just outputing a zero record
c                and getting on with life.  The coef file will contian
c                a zero order fit so that the remove gain option knows
c                what to do with this record.  Garossino

c ravn reads seismic trace data from an input file, computes an agc gain
c surface over the entire record based on user defined input parameters.
c It then calculates a best signal fit to each gain trace using robust
c polynomial fitting (Beltrao et.al. Geophysics, vol 56, No.1 Jan 1991,
c pp 80-89).
c The input data is then scaled using this fitted and balanced gain surface.
c Corrections based on the median residual deviation from the surface may
c be optionally applied on a trace by trace basis.
c
c Authors Michael D. Bush[London]/Paul G. A. Garossino [APR]
c Feb[1993]

#include <localsys.h>
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c basic usp variables

      integer     itr ( SZLNHD )
      integer     nsamp, nsi, ntrc, nrec, irs, ire, iform
      integer     luin , lbytes, nbytes, luout, obytes
      integer     KK,JJ,argis

      real        xtr(SZLNHD)

c program variables defined with dynamic memory allocation

      integer     RecordHeaders
      integer     topmutes,InGlean,OutGlean
      integer     errcd1,errcd2,errcd3,errcd4,errcd5,errcd6,errcd7
      integer     errcd8,errcd9,errcd10,errcd11,abort
      integer     itemHeader,itemRecord,itemAmplitude,itemSpace

      real        ScaledTrace, Gain
      real*8      Trace, Sample, Decimated, space, TraceMedians

      pointer     (wkadr1, Gain(200000))
      pointer     (wkadr2, RecordHeaders(200000))
      pointer     (wkadr3, topmutes(500))
      pointer     (wkadr4, ScaledTrace(2000000))
      pointer     (wkadr5, InGlean(500))
      pointer     (wkadr6, OutGlean(500))
      pointer     (dwkadr11, TraceMedians(SZLNHD))

c pointers to arrays that vary in size from record to record
c in order to optimise memory usage

      pointer     (dwkadr7, Decimated(200000))
      pointer     (dwkadr8, Sample(200000))
      pointer     (dwkadr9, space(2000000))
      pointer     (dwkadr10, Trace(2000000))

c program variables defined with static memory allocation

      integer     NN, sstep, agcWindow, ntrcGleaned
      integer     tstart,tend,tstep,TopOverSample
      integer     OpenSpace,NumMedGleanIter
      integer     numGlean,istartGlean,nsampDecimated,lucoef
      integer     numLiveTraces, Sord

      real        Amp,agcScalar

      character   name*4, ntap*255, otap*255, CoefTap*255

      logical     verbos,ave,OutputGainCurveOnly,median,rms
      logical     remove,UseCoefsFile,MedianAdjust

c variables required for robust polynomial subroutine

      integer irtype,limord,ndf1(14),ndf2(14),ndf3,minord
      integer minmute,maxtop
      integer if1max,ifumax,ipoly,ilim,ierr,itrial(14)

      real*8 coef(680),reg(14),ssr(14),ssd(14),sst,f1(14)
      real*8 delta

c irtype = 0 least squares fit
c irtype = 1 robust weighted fit
c limord = 0 order of fit determined by program else
c          1 < limord < 14
c coef = polynomial coefficients
c reg = regression coef of each order
c ssr = variance of regression for each order
c ssd = variance of Decimated for each order
c sst = total variation (sum of squares of data)
c ndf1 = number of degrees of freedom of each regression
c ndf2 = number of degrees of freedom of each set of residuals
c ndf3 = total number of degrees of freedom
c f1 = the f-test value of each order
c minord = minimum significant order of fit
c if1max = order of fit with max f-test value (up to 10000)
c ifumax = order of fit with maximum f-test value
c ipoly = statistically significant order of fit that best
c         describes the data
c ierr = 0 No errors
c      = 1 insufficient data points to fit line
c      = 2 no significant polynomial relationship found
c itrial = number of iterations required 
c delta = if diff between last iteration less that this, give up
c space = workspace (at least ipoly+1)

c Initialize  Variables

      data name/'RAVN'/
      data abort/0/
      data luin/1/
      data lbytes/0/
      data nbytes/0/
      data verbos/.false./
      data OutputGainCurveOnly/.false./
      data irtype/1/
      data limord/0/
      data NN/0/
      data Amp/307.05/
      data delta/1.0d-6/
      data tstep/10/
      data ave/.false./
      data rms/.false./
      data median/.false./
      data MedianAdjust/.false./
      data UseCoefsFile/.false./

c get online help if necessary

      if ( argis('-?') .gt. 0 .or. 
     :     argis('-h') .gt.0 .or. 
     :     argis('-help') .gt.0 ) then
         call help ()
         stop
      endif

c open printout

#include <f77/open.h>

c read command line arguments

      call cmdln (ntap,otap,CoefTap,irs,ire,OutputGainCurveOnly,ave,
     :    median,rms,irtype,limord,sstep,tstep,tend,agcWindow,remove,
     :    agcScalar,verbos,tstart,TopOverSample,ilim,NumMedGleanIter,
     :    UseCoefsFile,MedianAdjust,Sord)

c open input/output datasets

      call getln ( luin, ntap, 'r', 0)
      call getln (luout, otap, 'w', 1)
      call alloclun(lucoef)

c read and update line header,
c write line header, save key parameters.

      lbytes=0
      call rtape  ( luin, itr, lbytes )
      if(lbytes .eq. 0) then
         write(LERR,*)'RAVN: no header read on unit ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         stop
      endif
      
      call hlhprt ( itr , lbytes, name, 4, LERR )

c save standard usp parameters

#include <f77/saveh.h>

      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

c update historical line header & output header

      obytes = SZTRHD + SZSMPD * nsamp
      call savhlh ( itr, lbytes, lbyout )
      call wrtape(luout,itr,lbyout)

c determine sstep and tstep decimation values

      if(sstep .lt. 1) sstep = 50
      if(tstep .lt. 1) tstep = ntrc/12
      sstep = sstep/nsi
      if(tend.lt.1) tend = ntrc
      if(ire.lt.1) ire = nrec

c echo input parameters to printout

      call verbal(nsamp,nsi,ntrc,nrec,iform,ntap,otap,CoefTap,sstep
     :     ,tstep,tstart,tend,TopOverSample,agcWindow,agcScalar,ave,rms,
     :     median,irtype,limord,NumMedGleanIter,ilim,remove,UseCoefsFile
     :     ,MedianAdjust,OutputGainCurveOnly,Sord)

c malloc only fixed space we're going to use
c note also SZSMPD is the native
c size of a float or int in bytes

      itemHeader = ntrc * ITRWRD * SZSMPD
      itemRecord = ntrc * nsamp  * SZSMPD
      itemAmplitude = ntrc * SZSMPD
      itemSpace = (ntrc*nsamp * 2 + 450) * SZSMPD

      call galloc (wkadr1, itemRecord, errcd1, abort)
      call galloc (wkadr2, itemHeader, errcd2, abort)
      call galloc (wkadr3, itemAmplitude, errcd3, abort)
      call galloc (wkadr4, itemRecord, errcd4, abort)
      call galloc (wkadr5, itemAmplitude, errcd5, abort)
      call galloc (wkadr6, itemAmplitude, errcd6, abort)
      call galloc (dwkadr11, 2*itemAmplitude, errcd11, abort)

c the following are set to itemAmplitude since it is small
c prior to use they will be grealloc'd to the appropriate size

      call galloc (dwkadr7, itemAmplitude, errcd7, abort)
      call galloc (dwkadr8, itemAmplitude, errcd8, abort)
      call galloc (dwkadr9, itemAmplitude, errcd9, abort)
      call galloc (dwkadr10, itemAmplitude, errcd10, abort)
 
      if (errcd1.ne.0 .or. errcd2.ne.0 .or. errcd3.ne.0
     :    .or. errcd4.ne.0 .or. errcd5.ne.0 .or. errcd6.ne.0
     :    .or. errcd7.ne.0 .or. errcd8.ne.0 .or. errcd9.ne.0 
     :    .or. errcd10.ne.0 .or. errcd11.ne.0 )then  

         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) itemHeader,' bytes'
         write(LERR,*) 2*itemRecord,'  bytes'
         write(LERR,*) 9*itemAmplitude,'  bytes'
         write(LERR,*)' '
         go to 992
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) itemHeader,' bytes'
         write(LERR,*) 2*itemRecord,'  bytes'
         write(LERR,*) 9*itemAmplitude,'  bytes'
         write(LERR,*)' '
      endif

c initialize memory

      itemRecord = ntrc*nsamp
      itemHeader = ntrc*ITRWRD

      call vclr(Gain,1,itemRecord)
      call vclr(RecordHeaders,1,itemHeader)
      call vclr(topmutes,1,ntrc)
      call vclr(ScaledTrace,1,itemRecord)
      call vclr(InGlean,1,ntrc)
      call vclr(OutGlean,1,ntrc)

c fix gain normalization window limits to be samples
c ( it is expected that they come in as the same units as sample interval)

      agcWindow = agcWindow/nsi
      if(agcWindow .le. 1) agcWindow = 501
      if(agcWindow.gt.nsamp) agcWindow = nsamp/2

c determine agc scaling amplitude and window size (must be odd)

      if(agcScalar.gt.1.e-21)Amp = 0.01 * agcScalar * 2047.
      agcWindow = agcWindow + ( mod(agcWindow,2) -1 )

c skip to start record, passing all unprocessed data untouched

      nbytes = obytes
      call recrw (1,irs-1,luin,ntrc,itr,luout, nbytes)
      if (nbytes  .eq. 0) go to 999

C LOOP OVER RECORDS

      DO 100 JJ = irs, ire

         ntrcGleaned = 0
         minmute = nsamp

c initialize gain traces for this record
         
         call vfill(1.0,Gain,1,ntrc*nsamp)

C LOAD TRACES

         IndexHeader = 1 - ITRWRD
         IndexTrace = 1 - nsamp
         numLiveTraces = 0
 
         DO 99 KK = 1, ntrc

            nbytes=0
            call rtape  ( luin , itr, nbytes )
            if(nbytes .eq. 0) then
               write(LERR,*)'End of file on input:'
               write(LERR,*)'sequential rec= ',JJ,' sequential trc= ',KK
               go to 999
            endif
            
c reset array indices for this trace

            IndexHeader = IndexHeader + ITRWRD
            IndexTrace = IndexTrace + nsamp

c load headers for safekeeping

            call vmov (itr,1,RecordHeaders(IndexHeader),1,ITRWRD)

c load time series and read required header values

            call vmov(itr(ITHWP1),1,ScaledTrace(IndexTrace),1,nsamp)
            call saver2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     :           itrc    , TRACEHEADER)
            call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     :           istatic , TRACEHEADER)

c detmut detects first live sample (non-zero) on trace

            if(istatic.ne.30000) then

               call detmut( ScaledTrace(IndexTrace), topmutes(KK), 
     :              nsamp )
               minmute = min0( minmute, topmutes(kk) )

c If gain removal is requested, or gain is being applied based on a
c coefficients file then skip gain trace generation

               IF(.not.remove .and. .not. UseCoefsFile) then

                  numLiveTraces = numLiveTraces + 1
c calculate gain trace using agc

                  numDagc = nsamp - topmutes(KK) + 1
                  if(numDagc.gt.nsamp)numDagc = nsamp
                  
                  istartDagc = IndexTrace + topmutes(KK) - 1
                  if(topmutes(kk).lt.1)istartDagc = istartDagc + 1

                  if (median) then
                     call dagcm(numDagc,agcWindow,Amp,
     :                    ScaledTrace(istartDagc),Gain(istartDagc),10)
                  elseif (rms) then
                     call dagcsq(ScaledTrace(istartDagc),
     :                    Gain(istartDagc),numDagc,agcWindow,Amp)
                  else
                     call dagc(numDagc,agcWindow,Amp,
     :                    ScaledTrace(istartDagc),Gain(istartDagc))
                  endif
                  
               ENDIF

            else

c     clear time series if trace is flagged dead

               call vclr(ScaledTrace(IndexTrace),1,nsamp)
               topmutes(kk) = nsamp

            endif

 99      CONTINUE

         call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     :        irec    , TRACEHEADER)

         if ( numLiveTraces .le. 2 .and. .not. UseCoefsFile) then

c POLICEMAN: if number of live traces is less than 3 then forget it.
c            output dead record, set ierr to 1 and output zero iord to
c            coef file and continue.  The zero iord is output so that 
c            the gain removal option knows what to do with this record.

            ierr = 1
            goto 79
         endif

         if(topOverSample.gt.0) then
            maxtop = (nsamp - minmute + 1) / topOverSample + minmute
            if(maxtop.gt.nsamp) maxtop = nsamp
         else
            maxtop = 1
         endif

c determine the number of points that will be gleaned and allocate
c arrays accordingly

         IF(.not.remove .and. .not. UseCoefsFile) then

            IndexDecimated = 0
            IndexTrace = 1 - nsamp

            DO KK = 1, ntrc

c reset array indices for this trace

               if(topmutes(kk).ne.nsamp) then 

                  IndexTrace = IndexTrace + nsamp
                  numDagc = nsamp - topmutes(KK) + 1
                  if(numDagc.gt.nsamp)numDagc = nsamp
                  numGlean = numDagc - agcWindow
                  istartDagc = IndexTrace + topmutes(KK) - 1
                  if(topmutes(kk).lt.1)istartDagc = istartDagc + 1
                  istartGlean = istartDagc + agcWindow / 2

c work only on live traces decimated by user request<

                  if( (mod(KK,tstep).eq.0.or.
     :                 topmutes(KK).lt.maxtop.or.
     :                 kk.eq.tstart.or.kk.eq.tend).and. 
     :                 numGlean.gt.0) then
                     call N2glean(Gain,numGlean,istartGlean,sstep,
     :                    IndexDecimated,IndexTrace,maxtop)
                  endif
                  
               endif

            ENDDO

         ELSE
            IndexDecimated = 0
         ENDIF

c reallocate only space we're going to use for fitting
         IF(.not.remove .and. .not. UseCoefsFile) then

            nsampDecimated = max0(nsamp,IndexDecimated)
            itemRecord = nsampDecimated  * SZSMPD
            itemSpace = (nsampDecimated*2 + 450) * SZSMPD

            call grealloc (dwkadr7, 2*itemRecord, errcd7, abort)
            call grealloc (dwkadr8, 2*itemRecord, errcd8, abort)
            call grealloc (dwkadr9, 2*itemSpace, errcd9, abort)
            call grealloc (dwkadr10, 2*itemRecord, errcd10, abort)

            if (errcd7.ne.0 .or. errcd8.ne.0 .or. errcd9.ne.0  
     :           .or. errcd10.ne.0 )then
               write(LERR,*)' '
               write(LERR,*)'Unable to allocate workspace:'
               write(LERR,*) 6*itemRecord,'  bytes'
               write(LERR,*) 2*itemSpace,'  bytes'
               write(LERR,*)' '
               go to 992
            elseif(verbos) then
               write(LERR,*)' '
               write(LERR,*)'Allocating workspace:'
               write(LERR,*) 6*itemRecord,'  bytes'
               write(LERR,*) 2*itemSpace,'  bytes'
               write(LERR,*)' '
            endif
              
c initialize memory

            itemSpace = nsampDecimated * 2 + 450


            call dzero(nsampDecimated,Decimated)
            call dzero(nsampDecimated,Sample)
            call dzero(nsampDecimated,Trace)
            call dzero(itemSpace,Space)
            call dzero(ntrc,TraceMedians)

         ENDIF

c glean only if not using coefficients file for surface

         IF(.not.remove .and. .not. UseCoefsFile) then

            IndexDecimated = 0
            IndexTrace = 1 - nsamp
            DO KK = 1, ntrc

c reset array indices for this trace

               if(topmutes(kk).ne.nsamp) then 
                  
                  IndexTrace = IndexTrace + nsamp
                  
                  numDagc = nsamp - topmutes(KK) + 1
                  if(numDagc.gt.nsamp)numDagc = nsamp
                  numGlean = numDagc - agcWindow
                  
                  istartDagc = IndexTrace + topmutes(KK)  - 1
                  if(topmutes(kk).lt.1)istartDagc = istartDagc + 1
                  istartGlean = istartDagc + agcWindow / 2
                  
c work only on live traces decimated by user request<
                  
                  if( (mod(KK,tstep).eq.0.or.
     :                 topmutes(KK).lt.maxtop.or.
     :                 kk.eq.tstart.or.kk.eq.tend).and. 
     :                 numGlean.gt.0) then
                     
c decimate gain curve according to user defined step size
c (gain is real,  decimated is real*8 for input to rob2sb)

                     ntrcGleaned = ntrcGleaned + 1
                     Inglean(ntrcGleaned) = IndexDecimated + 1
                     call glean(Trace,Sample,Gain,numGlean,istartGlean,
     :                    sstep,KK,Decimated,IndexDecimated,IndexTrace,
     :                    maxtop)
                     OutGlean(ntrcGleaned) = IndexDecimated 

                  endif

               endif

            ENDDO

         ELSE

c If gain removal is requested form inverse gain record
c build gain surface that was applied to input data using information
c from the previous run's coefficient file.

            itemSpace = nsamp * ntrc * SZSMPD
            call grealloc (dwkadr9, 2*itemSpace, errcd9, abort)
            if(errcd9.ne.0)then
               write(LERR,*)' '
               write(LERR,*)'Unable to allocate workspace:'
               write(LERR,*) itemSpace,' bytes'
               write(LERR,*)' '
               goto 992
            else
               write(LERR,*)' '
               write(LERR,*)'Allocating workspace:'
               write(LERR,*) itemSpace,' bytes'
               write(LERR,*)' '
            endif

            do i=1,nsamp*ntrc
               space(i) = 0.0D0
            enddo
         
            call RestoreGain( CoefTap, coef, nsamp, ntrc, Gain, 
     :           topmutes, sstep, space, MedianAdjust, irec, lucoef)

            goto 80

         ENDIF

c find best polynomial fit to gain surface

         IF(NumMedGleanIter.gt.0)then

c iterate NumMedGleanIter times to adjust for anomalous traces.

            do i = 1,NumMedGleanIter
          
               call rob3sb(Trace,Sample,Decimated,IndexDecimated,irtype,
     :              limord,coef,reg,ssr,ssd,sst,ndf1,ndf2,ndf3,f1,
     :              minord,if1max,ifumax,ipoly,ilim,delta,ierr,itrial,
     :              space,Sord)

               iloc = ipoly*(ipoly+1) * (ipoly +2)/6

               call MedGlean(Trace,Sample,Decimated,Inglean,OutGlean,
     :              ntrcGleaned,ipoly,coef(iloc),space)

            enddo

         ENDIF

         call rob3sb(Trace,Sample,Decimated,IndexDecimated,irtype,
     :        limord,coef,reg,ssr,ssd,sst,ndf1,ndf2,ndf3,f1,
     :        minord,if1max,ifumax,ipoly,ilim,delta,ierr,itrial,
     :        space,Sord)

c output coefficients to coefficients file

         iloc = ipoly*(ipoly+1) * (ipoly +2)/6
 
c Statistical  output from rob3sb

         if(verbos) call verbal2(JJ,IndexDecimated,limord,delta,ilim,
     :        itrial,sst,ndf3,minord,if1max,ifumax,ierr,reg,ssr,ipoly,
     :        f1,ii,iloc)

c Check if significant surface fit possible
         
c react to errors
         
 79      if(ierr.ne.0)then
            if(ierr.eq.1)then
               write(LERR,*)'RAVN: Not enough points to fit surface'
               write(LERR,*)'      on sequential record ',JJ
               write(LERR,*)'      Will not scale this record'
               if(verbos)then
               write(LER,*)'RAVN: Not enough points to fit surface'
               write(LER,*)'      on sequential record ',JJ
               write(LER,*)'      Will not scale this record'
               endif
               call vfill(1.0,Gain,1,ntrc*nsamp)
               call RavnCoefOut(ierr,irec,ipoly,coef(iloc),lucoef,
     :              TraceMedians,ntrc,MaxNegative,CoefTap,UseCoefsFile)
               goto 80
            endif
            if(ierr.eq.2)then
               write(LERR,*)'RAVN: No significant polynomial'
               write(LERR,*)'     relationship on sequential'
               write(LERR,*)'     record ',JJ
               write(LERR,*)'     Will not scale this record'
               if(verbos)then
               write(LER,*)'RAVN: No significant polynomial'
               write(LER,*)'     relationship on sequential'
               write(LER,*)'     record ',JJ
               write(LER,*)'     Will not scale this record'
               endif
               call vfill(1.0,Gain,1,ntrc*nsamp)
               call RavnCoefOut(ierr,irec,ipoly,coef(iloc),lucoef,
     :               TraceMedians,ntrc,MaxNegative,CoefTap,UseCoefsFile)
               goto 80
            endif
         endif

c build best fit gain surface

         OpenSpace = nsampDecimated + 1

         call FitGain(ipoly,coef(iloc),irec,nsamp,ntrc,lucoef,
     :        Gain,topmutes,sstep,Gain,space,space(OpenSpace),
     :        agcWindow,maxtop,MedianAdjust,TraceMedians,ierr,CoefTap,
     :        UseCoefsFile)

c Time for output, Loop over Traces

 80      IndexTrace = 1 - nsamp
         IndexHeader = 1 - ITRWRD

         DO 199  KK = 1, ntrc
            
            IndexTrace = IndexTrace + nsamp
            IndexHeader = IndexHeader + ITRWRD
           
            if(OutputGainCurveOnly)then
               
               call vmov(Gain(IndexTrace),1,xtr(1),1,nsamp)
               
            elseif(remove)then

c remove previously applied gain function

               call vdivz(ScaledTrace(IndexTrace),1,Gain(IndexTrace)
     :              ,1,0.0,xtr(1),1,nsamp)

            else
               
c scale data using fitted and spacially balanced gain curves
               
               call vmul(ScaledTrace(IndexTrace),1,Gain(IndexTrace),
     :              1,xtr(1),1,nsamp)

            endif

c resmut zeroes data from sample 1 to sample mkk

            call resmut (xtr, topmutes(KK), nsamp)

c read time series and traceheader for output

            call vmov ( xtr(1), 1, itr(ITHWP1), 1, nsamp)
            call vmov (RecordHeaders(IndexHeader),1,itr,1,ITRWRD)

c output trace

            call wrtape(luout,itr,obytes)

 199     CONTINUE

         if(verbos)write(LERR,*)'writing record ',irec

 100  CONTINUE

c  pass remainder of recs

      nbytes = obytes
      
      call recrw (ire+1, nrec, luin, ntrc, itr, luout, nbytes)
      go to 999

 992  continue
      write(LERR,*)'RAVN: Abnormal Termination : not enough memory'
      write(LERR,*)'FATAL'
      write(LERR,*)'   '
      write(LER,*)'RAVN: Abnormal Termination : not enough memory'
      write(LER,*)'FATAL'
      write(LER,*)'   '
      stop

 999  continue

      call lbclos(luin)
      call lbclos(luout)

      write(LER,*)'Normal Termination of program ravn'
      write(LERR,*)'Normal Termination of program ravn'
      stop
      end
