C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine tsig01(ndfn,ndfd,f,itest)

c***********************************************************************
c     This subroutine carries out the statistical 'f' test at the 0.1%
c     level of significance.
c
c**** Subroutine inputs.
c
c     ndfn = The no. of degrees of freedom of the numerator.
c     ndfd = The no. of degrees of freedom of the denominator.
c     f = The 'f' ratio value to be tested.
c     ftest = The table of values of the test statistic at the desired
c             level of significance according to the CRC. "Handbook of
c             Mathematical Tables".
c
c**** Subroutine outputs.
c
c     itest = The result of the test.
c             itest = 0    The test is not significant
c             itest = 1    The test is significant
c
c***********************************************************************

      real*8 f
      real*4 f4,ftest(646)
      integer ndfn,ndfd,itest,i,j,ij

c***********************************************************************
c     Initialise the table of f-values at the 0.1% level
c***********************************************************************

      data (ftest(i),i = 1,34)/4052.0,98.503,34.116,21.198,16.258,13.745
     :,12.246,11.259,10.561,10.044,9.646,9.3302,9.0738,8.8616,8.6831,8.5
     :310,8.3997,8.2854,8.1850,8.0960,8.0166,7.9454,7.8811,7.8229,7.7698
     :,7.7213,7.6767,7.6356,7.5976,7.5625,7.3141,7.0771,6.8510,6.6349/
      data (ftest(i),i = 35,68)/4999.5,99.0,30.817,18.0,13.274,10.925,9.
     :5466,8.6491,8.0215,7.5594,7.2057,6.9266,6.701,6.5149,6.3589,6.2262
     :,6.1121,6.0129,5.9259,5.8489,5.7804,5.719,5.6637,5.6136,5.568,5.52
     :63,5.4881,5.4529,5.4205,5.3904,5.1785,4.9774,4.7865,4.6052/
      data (ftest(i),i = 69,102)/5403.3,99.166,29.457,16.694,12.06,9.779
     :5,8.4513,7.591,6.9919,6.5523,6.2167,5.9526,5.7394,5.5639,5.417,5.2
     :922,5.185,5.0919,5.0103,4.9382,4.874,4.8166,4.7649,4.7181,4.6755,4
     :.6366,4.6009,4.5681,4.5378,4.5097,4.3126,4.1259,3.9493,3.7816/
      data (ftest(i),i = 103,136)/5624.6,99.249,28.71,15.977,11.392,9.14
     :83,7.8467,7.006,6.4221,5.9943,5.6683,5.4119,5.2053,5.0354,4.8932,4
     :.7726,4.669,4.579,4.5003,4.4307,4.3688,4.3134,4.2635,4.2184,4.1774
     :,4.14,4.1056,4.074,4.0449,4.0179,3.8283,3.6491,3.4796,3.3192/
      data (ftest(i),i = 137,170)/5763.7,99.299,28.237,15.522,10.967,8.7
     :459,7.4604,6.6318,6.0569,5.6363,5.316,5.0643,4.8616,4.695,4.5556,4
     :.4374,4.3359,4.2479,4.1708,4.1027,4.0421,3.988,3.9392,3.8951,3.855
     :,3.8183,3.7848,3.7539,3.7254,3.699,3.5138,3.3389,3.1735,3.0173/
      data (ftest(i),i = 171,204)/5859.0,99.332,27.911,15.207,10.672,8.4
     :661,7.1914,6.3707,5.8018,5.3858,5.0692,4.8206,4.6204,4.4558,4.3185
     :,4.2016,4.1015,4.0146,3.9386,3.8714,3.8117,3.7583,3.7102,3.6667,3.
     :6272,3.5911,3.558,3.5276,3.4995,3.4735,3.291,3.1187,2.9559,2.802/
      data (ftest(i),i = 205,238)/5928.3,99.356,27.672,14.976,10.456,8.2
     :6,6.9928,6.1776,5.6129,5.2001,4.8861,4.6395,4.441,4.2779,4.1415,4.
     :0259,3.9267,3.8406,3.7653,3.6987,3.6396,3.5867,3.539,3.4959,3.4568
     :,3.421,3.3882,3.3581,3.3302,3.3045,3.1238,2.953,2.7918,2.6393/
      data (ftest(i),i = 239,272)/5981.6,99.374,27.489,14.799,10.289,8.1
     :016,6.8401,6.0289,5.4671,5.0567,4.7445,4.4994,4.3021,4.1399,4.0045
     :,3.8896,3.791,3.7054,3.6305,3.5644,3.5056,3.4530,3.4057,3.3629,3.3
     :239,3.2884,3.2558,3.2259,3.1982,3.1726,2.993,2.8233,2.6629,2.5113/
      data (ftest(i),i = 273,306)/6022.5,99.388,27.345,14.659,10.158,7.9
     :761,6.7188,5.9106,5.3511,4.9424,4.6315,4.3875,4.1911,4.0297,3.8948
     :,3.7804,3.6822,3.5971,3.5225,3.4567,3.3981,3.3458,3.2989,3.256,3.2
     :172,3.1818,3.1494,3.1195,3.092,3.0665,2.8876,2.7185,2.5586,2.4073/
      data (ftest(i),i = 307,340)/6055.8,99.399,27.229,14.546,10.051,7.8
     :741,6.6201,5.8143,5.2565,4.8492,4.5393,4.2961,4.1003,3.9394,3.8049
     :,3.6909,3.5931,3.5082,3.4338,3.3682,3.3098,3.2576,3.2106,3.1681,3.
     :1294,3.0941,3.0618,3.0320,3.0045,2.9791,2.8005,2.6318,2.4721,2.320
     :9/
      data (ftest(i),i = 341,374)/6106.3,99.416,27.052,14.374,9.8883,7.7
     :183,6.4691,5.6668,5.1114,4.7059,4.3974,4.1553,3.9603,3.8001,3.6662
     :,3.5527,3.4552,3.3706,3.2965,3.2311,3.1729,3.1209,3.074,3.0316,2.9
     :931,2.9579,2.9256,2.8959,2.8685,2.8431,2.6648,2.4961,2.3363,2.1848
     :/
      data (ftest(i),i = 375,408)/6157.3,99.432,26.872,14.198,9.7222,7.5
     :590,6.3143,5.5151,4.9621,4.5582,4.2509,4.0096,3.8154,3.6557,3.5222
     :,3.4089,3.3117,3.2273,3.1533,3.088,3.0299,2.978,2.9311,2.8887,2.85
     :02,2.815,2.7827,2.753,2.7256,2.7002,2.5216,2.3523,2.1915,2.0385/
      data (ftest(i),i = 409,442)/6208.7,99.449,26.69,14.02,9.5527,7.395
     :8,6.1554,5.3591,4.808,4.4054,4.099,3.8584,3.6646,3.5052,3.3719,3.2
     :588,3.1615,3.0771,3.0031,2.9377,2.8796,2.8274,2.7805,2.738,2.6993,
     :2.6640,2.6316,2.6017,2.5742,2.5487,2.3689,2.1978,2.0346,1.8783/
      data (ftest(i),i = 443,476)/6234.6,99.458,26.598,13.929,9.4665,7.3
     :127,6.0743,5.2793,4.729,4.3269,4.0209,3.7805,3.5868,3.4274,3.294,3
     :.1808,3.0835,2.999,2.9249,2.8594,2.8011,2.7488,2.7017,2.6591,2.620
     :3,2.5848,2.5522,2.5223,2.4946,2.4689,2.288,2.1154,1.95,1.7908/
      data (ftest(i),i = 477,510)/6260.7,99.466,26.505,13.838,9.3793,7.2
     :285,5.9921,5.1981,4.6486,4.2469,3.9411,3.7008,3.507,3.3476,3.2141,
     :3.1007,3.0032,2.9185,2.8422,2.7785,2.72,2.6675,2.6202,2.5773,2.538
     :3,2.5026,2.4699,2.4397,2.4118,2.386,2.2034,2.0285,1.86,1.6964/
      data (ftest(i),i = 511,544)/6286.8,99.474,26.411,13.745,9.2912,7.1
     :432,5.9084,5.1156,4.5667,4.1653,3.8596,3.6192,3.4253,3.2656,3.1319
     :,3.0182,2.9205,2.8354,2.7608,2.6947,2.6359,2.5831,2.5355,2.4923,2.
     :453,2.417,2.384,2.3535,2.3253,2.2992,2.1142,1.936,1.7628,1.5923/
      data (ftest(i),i = 545,578)/6313.0,99.483,26.316,13.652,9.202,7.05
     :68,5.8236,5.0316,4.4831,4.0819,3.7761,3.5355,3.3413,3.1813,3.0471,
     :2.9330,2.8348,2.7493,2.6742,2.6077,2.5484,2.4951,2.4471,2.4035,2.3
     :637,2.3273,2.2938,2.2629,2.2344,2.2079,2.0194,1.8363,1.6557,1.473/
      data (ftest(i),i = 579,612)/6339.4,99.491,26.221,13.558,9.1118,6.9
     :69,5.7372,4.946,4.3978,3.9965,3.6904,3.4494,3.2548,3.0942,2.9595,2
     :.8447,2.7459,2.6597,2.5839,2.5168,2.4568,2.4029,2.3542,2.3099,2.26
     :95,2.2325,2.1984,2.167,2.1378,2.1107,1.9172,1.7263,1.533,1.3246/
      data (ftest(i),i = 613,646)/6366.0,99.501,26.125,13.463,9.0204,6.8
     :801,5.6495,4.8588,4.3105,3.909,3.6025,3.3608,3.1654,3.004,2.8684,2
     :.7528,2.653,2.566,2.4893,2.4212,2.3603,2.3055,2.2559,2.2107,2.1694
     :,2.1315,2.0965,2.0642,2.0342,2.0062,1.8047,1.6006,1.3805,1.0/

c***********************************************************************
c     change the input variable to real*4 to test against the table
c***********************************************************************

      f4 = sngl(f)
      i = 33
      j = 18
      itest = 0
      if(ndfd.lt.120) i = 32
      if(ndfd.lt.60) i = 31
      if(ndfd.lt.40) i = 30
      if(ndfd.le.30) i = ndfd
      if(ndfn.lt.120) j = 17
      if(ndfn.lt.60) j = 16
      if(ndfn.lt.40) j = 15
      if(ndfn.lt.30) j = 14
      if(ndfn.lt.24) j = 13
      if(ndfn.lt.20) j = 12
      if(ndfn.lt.15) j = 11
      if(ndfn.lt.12) j = 10
      if(ndfn.le.10) j = ndfn
      ij = (j - 1) * 34 + i
      if(f4.gt.ftest(ij)) itest = 1
      return
      end
