C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine Xsd_ReadPicks(lupicks, Record, Trace, Time, 
     :     N, NumEntries, SegNum )

c XsdReadPicks reads a required SegNum from an input xsd pick file

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

c declare variables passed from calling routine

      character tmp * 80, tag * 1
      integer lupicks, NumEntries, N, SegNum

      real   Record(NumEntries), Trace(NumEntries), Time(NumEntries) 

      character   SegName*20

c declare variables used in subroutine

      integer     counter, TempSegNum

      real        RecordIndexBuffer(SZSMPM), TraceIndexBuffer(SZSMPM)
      real        TimeIndexBuffer(SZSMPM)

c initialize memory

      call vclr(RecordIndexBuffer,1,NumEntries)
      call vclr(TraceIndexBuffer,1,NumEntries)
      call vclr(TimeIndexBuffer,1,NumEntries)
      counter = 0

c----
c read down to appropriate segment
c----

      rewind lupicks

      js = 0
      do  while (1.eq.1)

          read(lupicks,'(a80)', err=900, end=901) tmp

c----
c   take into account possibility pick file doesn't start in column 1
c   then read the "Segment" line extracting the segment sequence #
c----
          do  ib = 1, 80
              if (tmp(ib:ib) .ne. ' ') then
                  tag = tmp(ib:ib)
                  go to 3
              endif
          enddo
3         continue
          if (tag .eq. 'S') then
             js = js + 1
             call fsscnf (tmp,'%s %s %d',SegName,tag,TempSegNum)
             if (TempSegNum .eq. SegNum ) then
                go to 1
             else
                write(LERR,*)'skipping segment ',TempSegNum
             endif
          endif
      enddo

1     continue
      
      if (js .eq. 0) then
         write(LERR,*)'FATAL ERROR in recshift xsd pick reader'
         write(LERR,*)'Pick file seems empty'
         stop 666
      endif

c----
c   we now have read the "Segment" line of the correct pick segment and
c   are ready to ready numerical data
c----

      k = 0
      do  while (1.eq.1)

c read Trace function picks

            read (lupicks,'(a80)', err=900, end=2) tmp
            do  ib = 1, 80
                if (tmp(ib:ib) .ne. ' ') then
                    tag = tmp(ib:ib)
                    go to 4
                endif
            enddo
4           continue

c----
c   stop reading numerical data for this "Segment"
c----
            if (tag .ne. 'S') then
                  k = k + 1
                  call fsscnf (tmp,'%f %f %f', rr, tr, tt)
                  RecordIndexBuffer (k) = rr
                  TraceIndexBuffer  (k) = tr
                  TimeIndexBuffer   (k) = tt
            else

                  go to 2
            endif
      enddo

2     continue

      N = k

      if (N .eq. 0) then
         write(LERR,*)'FATAL ERROR in recshift xsd pick reader'
         write(LERR,*)'No legitimate picks found'
         stop 666
      endif

c----
c   we now have read all picks
c   build first output (record, Trace, Time) entry
c----

      counter = 1
      Trace(counter) = TraceIndexBuffer(counter)
      Record(counter) = RecordIndexBuffer(counter)
      Time(counter) = TimeIndexBuffer(counter)

c POLICEMAN: watch out for duplicate picks in the pickfile

      do j = 2, N

         if ( RecordIndexBuffer(j) .eq. Record(j-1)
     :        .and.
     :        TraceIndexBuffer(j) .eq. TraceIndexBuffer(j-1)
     :        .and. 
     :        TimeIndexBuffer(j) .eq. Time(j-1) ) then

            write(LERR,*)' '
            write(LERR,*)'Duplicate entry occurred in Pickfile'
            write(LERR,*)'at record & Trace entries: '
     :           ,RecordIndexBuffer(j), TraceIndexBuffer(j)
            write(LERR,*)'Will fix by deleting 2nd occurrence'
            write(LERR,*)' '
            
         else

            counter = counter + 1
            Record(counter) = RecordIndexBuffer(j)
            Trace(counter) = TraceIndexBuffer(j)
            Time(counter) = TimeIndexBuffer(j) 
            
         endif
      enddo

      N = counter

c sort based on increasing Record entry

c echo function read to printout file

      write(LERR,*)' '
      write(LERR,*)' Data Read From Pickfile '
      write(LERR,*)' '
      write(LERR,*)' Record      Trace      Time '
      write(LERR,*)' '

      do i = 1, N
         write(LERR,*) Record(i), Trace(i), Time(i)
      enddo
      write(LERR,*)' '

      call hsort3 ( N, Record, Trace, Time )
      
      return

1001  continue

      N = counter
      return

 900  continue
      write(LERR,*)' '
      write(LERR,*)' RECSHIFT: Error reading input pickfile.'
      write(LERR,*)' Possibly trying to read header pick file?'
      write(LERR,*)' FATAL' 
      write(LERR,*)' '
      write(LER,*)' '
      write(LER,*)' RECSHIFT: Error reading input pickfile'
      write(LER ,*)' Possibly trying to read header pick file?'
      write(LER,*)' FATAL' 
      write(LER,*)' '
      stop

  901  continue
      write(LERR,*)' '
      write(LERR,*)' RECSHIFT: Premature EOF on input pickfile'
      write(LERR,*)' FATAL' 
      write(LERR,*)' '
      write(LER,*)' '
      write(LER,*)' RECSHIFT: Premature EOF on input pickfile'
      write(LER,*)' FATAL' 
      write(LER,*)' '
      stop

      end
