C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine Min_Max(tri, nsamp, new_vel, 
     :     Index_Constraint,Pick_Constraint,
     :     Null_Constraint,No_Constraint,
     :     replacement_value,minval,maxval,
     :     hdrwd1,hdrwd2,hdrwd3,
     :     iword1,iword2,iword3,
     :     irs, ire, ns, ne, nsi,
     :     recnum, trcnum, nullval,
     :     Start_End_Constraint,ist,iend,
     :     Min_Constraint, Max_Constraint,top,bot)
      
c     Subroutine to perform a value replacement based on the 
c     given constraint conditions and min/max constraints
c     and then outputs the 
c     the new time series as NEW_VEL.
c     
c     
c     James M. Gridley
c     USP Team
c     July 1996
      
c     variables passed from calling routine
      
      integer nsamp, irs, ire, ns, ne, ist, iend
      integer iword1, iword2, iword3, nullval
      integer recnum, trcnum
      
      real tri(nsamp)
      real new_vel(nsamp)
      real minval, maxval
      logical Index_Constraint, Pick_Constraint
      logical  Null_Constraint, No_Constraint
      logical  Start_End_Constraint
      logical  Min_Constraint, Max_Constraint, top, bot, once
      logical  Min_Constrainti, Max_Constrainti
      real replacement_value
      character   hdrwd1 * 6, hdrwd2 * 6, hdrwd3 * 6
c=============================================================================
c     process data
c=============================================================================
      Min_Constrainti = Min_Constraint
      Max_Constrainti = Max_Constraint
      once = .false.

      if ( top ) then
         is = 1
         ie = nsamp
         ii = 1
         once = .true.
      elseif ( bot ) then
         is = nsamp
         ie = 1
         ii = -1
         once = .true.
      else
         is = 1
         ie = nsamp
         ii = 1
      endif

      if (Null_Constraint  .and. iword3 .eq. nullval) then
         do i = 1, nsamp
            new_vel(i) = tri(i)
         enddo
         go to 999
      endif
c=============================================================================
      
      if(Pick_Constraint .and. Index_Constraint) then
         
         do i = 1,nsamp
            if(i .ge. (iword1/nsi)+(ist-1) .and.
     :           i .le. (iword2/nsi) .and.
     :           recnum .ge. irs .and. recnum .le. ire .and.
     :           trcnum .ge. ns .and. trcnum .le. ne) then
               
               if (Max_Constraint) then
                  if (tri(i) .gt. maxval) then
                     new_vel(i) =  replacement_value
                  else
                     new_vel(i) = tri(i)
                  endif
               endif
               
               if (Min_Constraint) then
                  if (tri(i) .lt. minval) then
                     new_vel(i) =  replacement_value
                  else
                     new_vel(i) = tri(i)
                  endif

               endif
               
            else
               new_vel(i) = tri(i)
            endif
         enddo
         go to 999
      endif
      
c=============================================================================

      if(Index_Constraint .and. Start_End_Constraint ) then
         do i = 1, nsamp
            if (i .ge. ist .and. i .le. iend .and.
     :           recnum .ge. irs .and. recnum .le. ire .and.
     :           trcnum .ge. ns .and. trcnum .le. ne ) then
               
               if (Max_Constraint) then
                  if (tri(i) .gt. maxval) then
                     new_vel(i) =  replacement_value
                  else
                     new_vel(i) = tri(i)
                  endif
               endif
               
               if (Min_Constraint) then
                  if (tri(i) .lt. minval) then
                     new_vel(i) =  replacement_value
                  else
                     new_vel(i) = tri(i)
                  endif
               endif 
               
            else
               new_vel(i) = tri(i)
            endif
         enddo
         go to 999
      endif
      
c=============================================================================

      if (No_Constraint) then
         
         do i = is, ie, ii
            if (Max_Constrainti) then
               if (tri(i) .gt. maxval)then 
                  new_vel(i) =  replacement_value
               else
                  new_vel(i) = tri(i)
                  if ( once ) Max_Constrainti = .false.
               endif
            endif
            
            if (Min_Constrainti) then
               if (tri(i) .lt. minval) then
                  new_vel(i) =  replacement_value
               else
                  new_vel(i) = tri(i)
                  if ( once ) Min_Constrainti = .false.
              endif  
            endif

            if (.not. Max_Constrainti .and. .not. Min_Constrainti) then
               new_vel(i) = tri(i)
            endif
            
         enddo
         go to 999
      endif
c=============================================================================

         if(Start_End_Constraint) then
            do i = 1, nsamp
               if (i .ge. ist .and. i .le. iend) then
                  if (Max_Constraint) then
                     if (tri(i) .gt. maxval) then
                        new_vel(i) =  replacement_value
                     else
                        new_vel(i) = tri(i)
                     endif
                  endif
                  
                  if (Min_Constraint) then
                     if (tri(i) .lt. minval) then
                        new_vel(i) =  replacement_value
                     else
                        new_vel(i) = tri(i)
                     endif
                  endif
                  
               else
                  new_vel(i) = tri(i)
               endif
            enddo
            go to 999
         endif
            
c=============================================================================         
         if(Pick_Constraint) then
            
            do i = 1, nsamp
               if(i .ge. (iword1/nsi)+(ist-1) .and.
     :              i .le. (iword2/nsi)) then
                  if (Max_Constraint) then
                     if (tri(i) .gt. maxval) then
                        new_vel(i) =  replacement_value
                     else
                        new_vel(i) = tri(i)
                     endif
                  endif
                  
                  if (Min_Constraint) then
                     if (tri(i) .lt. minval) then
                         new_vel(i) =  replacement_value
                      else
                         new_vel(i) = tri(i)
                      endif
                  endif
                  
                  
               else
                  new_vel(i)=tri(i)
               endif
            enddo
            go to 999
         endif
c=============================================================================
         if(Index_Constraint) then
            
            do i = 1, nsamp
               if(recnum .ge. irs .and. recnum .le. ire .and.
     :              trcnum .ge. ns .and. trcnum .le. ne) then
                  if (Max_Constraint) then
                     if (tri(i) .gt. maxval) then
                         new_vel(i) =  replacement_value
                         else
                            new_vel(i) = tri(i)
                         endif
                  endif
                  
                  if (Min_Constraint) then
                     if (tri(i) .lt. minval) then
                        new_vel(i) =  replacement_value
                     else
                        new_vel(i) = tri(i)
                     endif
                  endif
                  
               else
                  new_vel(i) = tri(i)
               endif
            enddo
            
         endif
      
c=============================================================================      
      
 999  return
      end
