C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM MODULE  Rept Data Set
C
C**********************************************************************C
C
C REPT READS SEISMIC TRACE DATA FROM AN INPUT FILE,
C retrieves a specified record, and repeats that record, and
C WRITES THE RESULTS TO AN OUTPUT FILE
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, SAVE, MOV
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      integer     itr ( SZLNHD )
      integer     lhed( SZLNHD )
      integer     nsamp, nsi, ntrc, nrec, iform
      integer     luin , luout, lbytes, nbytes, obytes
      integer     argis

      integer     work
      pointer     (wkaddr, work(1))

      character   name*4, ntap*255, otap*255

      logical     verbos, query, heap, trc, all
 
      equivalence ( itr(  1), lhed(1) )
      data name     /'REPT'/
      data luin / 1 /
      data luout  / 2 /
      data lbytes / 0 /
      data nbytes / 0 /
      data obytes / 0 /
      data verbos/.false./

c get online help if necessary

      query = (argis('-?').gt.0 .or. argis('-h').gt.0)
      if ( query ) then
           call help ()
           stop
      endif

c open printout file

#include <f77/open.h>

c read program parameters from command line

      call cmdln ( ntap, otap, ist, iend, nst, nrst, nrep, verbos, ned, 
     :     trc, all )

c open input and output datasets

      call getln ( luin, ntap, 'r', 0 )
      call getln (luout, otap, 'w', 1 )

c read input line header 

      lbytes=0
      CALL RTAPE  ( LUIN, ITR, LBYTES           )
      if(lbytes .eq. 0) then
         write(LERR,*)'REPT: no header read on unit ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         stop
      endif

c---------------------------
c  save key header values
#include <f77/saveh.h>

      call hlhprt ( itr , lbytes, name, 4, lerr )

      if(nsamp .gt. SZLNHD) nsamp=SZLNHD

      if (all) then
         if (nst .le. 1) nst = 1
         if (ned .le. 1) ned = ntrc
         jtr   = ned - nst + 1
         nreco = nrep * nrec
         nrecc = nreco
         ntrco = jtr
         call savew( itr, 'NumRec', nreco, LINHED)
         call savew( itr, 'NumTrc', ntrco, LINHED)
      else
         if (nst .le. 1) nst = 1
         if (ned .le. 1) ned = ntrc
         jtr   = ned - nst + 1
         nreco = nrep
         nrecc = 1
         ntrco = jtr
         call savew( itr, 'NumRec', nreco, LINHED)
         call savew( itr, 'NumTrc', ntrco, LINHED)
      endif

c verbos printout

      write(LERR,*)
      write(LERR,*)' Values read from input data set line header'
      write(LERR,*)
      write(LERR,*) ' # of Samples/Trace =  ', nsamp
      write(LERR,*) ' Sample Interval    =  ', nsi  
      write(LERR,*) ' Traces per Record  =  ', ntrc 
      write(LERR,*) ' Records per Line   =  ', nrec 
      write(LERR,*) ' Format of Data     =  ', iform

c check card defaults and set parameters
c adjust line header; write header
      
      iend=iend/nsi + .5
      ist=ist/nsi
      if(ist .le. 1) ist=1
      if(iend .eq. 0) iend=nsamp
      if(iend .gt. nsamp) iend=nsamp
      
      nsampo = nsamp + ITRWRD
      call savew( itr, 'NumSmp', nsamp , LINHED)
      obytes = SZTRHD + SZSMPD * nsamp 
      call savhlh ( itr, lbytes, lbyout )
      call wrtape ( luout, itr, lbyout )
      
c  verbos printout

      write(LERR,*)
      write(LERR,*)' Line header values after default check '
      write(LERR,*)
      write(LERR,*) ' # of Samples/Trace =  ', nsampo
      write(LERR,*) ' Sample Interval    =  ', nsi  
      write(LERR,*) ' Traces per Record  =  ', ntrco
      write(LERR,*) ' Records out        =  ', nreco
      IF (trc) then
         write(LERR,*) ' Start trc          =  ',nst
         write(LERR,*) ' End trc            =  ',ned
      ELSE
         write(LERR,*) ' Target Record      =  ', nrst
         if(nst .eq. 0) then
            write(LERR,*) ' Records per Line   =  ', nrep
         else
            write(LERR,*) ' Output is 1 rec with ',nrep,' traces'
         endif
      ENDIF
      write(LERR,*) ' Format of Data     =  ', iform

c  malloc only space we're going to use
      heap = .true.

      items = jtr * (nsampo)
      call galloc (wkaddr, items*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      if (.not. heap) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) items*SZSMPD,'  bytes'
         write(LERR,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) items*SZSMPD,'  bytes'
         write(LERR,*)' '
      endif

c skip to start record if not record one

      if (.not. all) call recskp(1,nrst-1,luin,ntrc,itr)

c read trace(s), do repeats, write to output file

      DO JJ = 1, nrecc

c skip to start trace

         if ( .not. all ) then
            call trcskp ( nrst, 1, nst-1, luin, ntrc, itr )
         elseif(ntrc .ne. 1 ) then
            call trcskp(jj,1,nst-1,luin,ntrc,itr)
         endif

c read trace(s) into memory

         ic = 0
         do kk = nst, ned
            nbytes = 0
            call rtape( luin, itr, nbytes)
            if(nbytes .eq. 0) then
               write(LERR,*)'End of file on input:'
               write(LERR,*)'  rec= ',jj,'  trace= ',kk
               go to 999
            endif
            ic = ic + 1
            istrc = (ic-1) * nsampo
            call vmov (itr,1, work(istrc+1),1,nsampo)
         enddo

c     write out as many repeats as requested
         
         ic = 0
         do ir = 1, nrep
            do kk = 1, jtr
               ic = ic + 1
               istrc = (kk-1) * nsampo
               call vmov (work(istrc+1),1,itr,1,nsampo)
               call wrtape (luout, itr, obytes)
            enddo
         enddo
         
c  skip to end of record

         if ( .not. all ) then
            call trcskp(nrst,ned+1,ntrc,luin,ntrc,itr)
         elseif ( ntrc .ne. 1 ) then
            call trcskp(jj,ned+1,ntrc,luin,ntrc,itr)
         endif
            
      ENDDO

 999  continue
      call lbclos(luin)
      call lbclos(luout)
      END

c------------------------------------------
c  online help section
c------------------------------------------
      subroutine  help
#include <f77/iounit.h>

        write(LER,*)' '
        write(LER,*)'Command Line Arguments for REPT: data set repeat'
        write(LER,*)' '
        write(LER,*)'Input....................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N[ntap]   -- input data set name'
        write(LER,*)'-O[otap]   -- output data set name'
        write(LER,*)'-ns[nst]   -- start trace in record        (first)'
        write(LER,*)'-ne[ned]   -- end trace in record           (last)'
        write(LER,*)'-rs[nrst]  -- repeat record             (all recs)'
        write(LER,*)'-nr[nrep]  -- number of repeats                (1)'
        write(LER,*)'-V         -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)'     rept -N[] -O[] -ns[] -ne[] -rs[] -nr[]'
        write(LER,*)'           [-V]'
        write(LER,*)' '

      return
      end

c-----
c     get command arguments
c
c     ntap  - C*100  input file name
c     otap  - C*100  output file name
c     ist   - I      start sample
c    iend   - I      stop sample
c     nst   - I      trace # to be repeated
c    nrst   - I      record # to be repeated
c    nrep   - I      number times to repeat
c    igath  - I      force number traces in gather to stack
c    norm   - L      normalize stacked trace by # live traces
c    verbos - L      verbose output or not
c-----
      subroutine cmdln (ntap,otap,ist,iend,nst,nrst,nrep,verbos,
     1                  ned, trc, all)
#include <f77/iounit.h>
      character  ntap*(*), otap*(*)
      integer    argis,ist,iend,nst,nrst,nrep, ned
      logical    verbos, trc, all

          all = .false.
          call argstr('-N',ntap,' ',' ')
          call argstr('-O',otap,' ',' ')
          ist  = 1
          iend = 0
          call argi4('-ns',nst,0,0)
          call argi4('-ne',ned,0,0)
          call argi4('-rs',nrst,0,0)
          call argi4('-nr',nrep,1,1)
          if (nrst .eq. 0) all = .true.
          verbos = ( argis( '-V' ) .gt. 0 )

      return
      end
