C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c -----------------------resorter-----------------------------------------72
c
c Author Klaas Koster
c
c resorter reads data in USP format one trace at a time.  It output traces
c interchanged for records.  ie rec10 trace 1 on input becomes record1 trace
c 10 on output
c
c<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
c
c     declare variables
c
c ----- get machine dependent parameters -----
c
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c
c ----- dimension standard USP variables -----
c

      integer     itr( SZLNHD )
      integer     jtr( SZLNHD )
      integer     nsamp,nsampo,nsi,ntrc,ntrco,nrec,nreco,iform
      integer     luin,lbytes,nbytes,obytes
      integer     argis,ist,iend,irs,ire,ns,ne
      integer     JJ,KK,recnum,trcnum
      integer     LL,lenblk
      integer     limin, limax, lidel, dimin, dimax, didel

      real        tri(SZLNHD)
      real        xtr(SZLNHD)

      character   name*8,ntap*512,otap*512

      logical     verbos,query, fdslice, rev, D3, stack


c ----- integer USP variables -----
c
c	itr   array: trace plus header from rtape
c       itrh  array: trace headers for record
c       nsamp      : number of samples of input trace
c       nsampo     : number of samples of output trace
c       nsi        : input sample interval
c       ntrc       : input traces/record
c       ntrco      : output traces/record
c       nrec       : input number of records
c       nreco      : output number of records
c       iform      : format of data
c       luin       : input device
c       lbytes     :
c       nbytes     :
c       obytes     :
c       argis      : 
c       ist        : window start time (ms)
c       iend       : window end time (ms)
c       irs        : record start
c       ire        : record end
c       ns         : trace start
c       ne         : trace end
c       lenblk     : blocking factor for traces
c       JJ,KK      : loop counters
c       KKOUT      : output record counter
c       errcd1     : error flag from galloc
c       abort1     : abort flag from galloc
c
c ----- real USP variables -----
c
c	tri array  : working trace   
c
c ----- character USP variables -----
c
c	name       : for print file identification
c	ntap       : input file name 
c       otap       : output file name
c
c ----- logical USP variables -----
c
c	verbos     : printout verbosity flag
c	query      : online help flag
c
c
c ----- dimension program specific variables -----
c

c
c ----- set up useful hooks -----
c
 

c
c ----- initialize necessary variables -----
c

      data name/'RESORTER'/
      data luin/1/,lbytes/0/

c
c ----- get online help if necessary -----
c

      query = (argis('-?').gt.0 .or. argis('-h').gt.0)

      if ( query ) then

           call help ()
           stop

      endif

c
c ----- printout -----

#include <f77/open.h>

c
c ----- get command line parameters -----
c

      call cmdln (ntap,otap,ist,iend,irs,ire,ns,ne,lenblk,verbos,
     1            fdslice, rev, D3, limin, limax, lidel,
     2            dimin, dimax, didel, stack)

c
c ----- get logical units -----
c

      call getln    (luin , ntap, 'r' , 0)
      call getln    (luout, otap, 'w+', 1)
      call sislgbuf (luout, 'off')

      write(LERR,*)'Input unit # is ',luin,' for DSN= ',ntap
      write(LERR,*)'Output unit # is ',luout,' for DSN= ',otap

c
c ----- read line header, check to see if input empty -----
c

      lbytes = 0
      call rtape(luin,itr,lbytes)
      write(LERR,*)'lbytes= ',lbytes

      if(lbytes .eq. 0) then
         write(LERR,*)'resorter: no header read on unit ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         stop
      endif

c
c ----- alter line header -----
c

#include <f77/saveh.h>

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)


      if(nsamp .gt. SZLNHD) nsamp=SZLNHD

      call cmdchk(ns,ne,irs,ire,ntrc,nrec)

c
c ----- set record start and end defaults -----
c

      if(irs .eq. 0) irs=1
      if(ire .eq. 0) ire=nrec
      if(ns.eq.0)ns = 1
      if(ne.eq.0)ne = ntrc

c
c ----- determine number of records to process -----
c

      nreco = ne - ns +1
      nreco = nreco/lenblk
      
c
c ----- convert start and end time to start and end sample -----
c

      ist=ist/nsi
      iend=iend/nsi

      if(ist .lt. 1) ist=1
      if(iend .lt. 1) iend=nsamp

c
c ----- determine number of output samples -----
c

      nsampo=iend-ist+1

c
c ----- determine number of output traces -----
c

      ntrco = ire - irs +1
      ntrco = ntrco*lenblk
      

c
c ----- modify output lineheader -----
c

      IF (fdslice) THEN

         call savew( itr, 'NumSmp', nsampo, LINHED)
         call savew( itr, 'NumRec', ntrco , LINHED)
         call savew( itr, 'NumTrc', nreco , LINHED)

      ELSEIF (D3) THEN

         NLI = (limax - limin)/lidel + 1
         NDI = (dimax - dimin)/didel + 1
         call savew( itr, 'NumSmp', nsampo, LINHED)
         call savew( itr, 'NumRec', NLI   , LINHED)
         call savew( itr, 'NumTrc', NDI   , LINHED)

      ELSE

         call savew( itr, 'NumSmp', nsampo, LINHED)
         call savew( itr, 'NumRec', nreco , LINHED)
         call savew( itr, 'NumTrc', ntrco , LINHED)

      ENDIF

c
c ----- change output bytes to reflect change -----
c       from time to # traces
c

      obytes = SZTRHD + SZSMPD * nsampo

c
c ----- adjust historical line header & write header -----
c

      call savhlh(itr,lbytes,lbyout)

      call wrtape(luout,itr,lbyout)

c
c ----- printout -----
c

      call verbal(nsamp,nsampo,nsi,ntrc,ntrco,nrec,nreco,iform,ist,iend,
     :            ns,ne,irs,ire,lenblk,D3,limin,limax,lidel,dimin,
     :            dimax,didel,nli,ndi)

c
c ----- create output filespace to skip around in -----
c

      IF (D3) THEN

         call vclr (tri, 1, nsamp)
         call vmov (tri, 1, itr(ITHWP1), 1, nsamp)

         call savew2 (itr, ifmt_StaCor,l_StaCor,ln_StaCor, 
     1                30000, TRACEHEADER)
         do  JJ = limin, limax, lidel
            call savew2 (itr, ifmt_RecNum,l_RecNum,ln_RecNum, 
     1                   JJ, TRACEHEADER)
            call savew2 (itr, ifmt_LinInd,l_LinInd,ln_LinInd, 
     1                   JJ, TRACEHEADER)
            do  KK =dimin, dimax, didel
               call savew2 (itr, ifmt_TrcNum,l_TrcNum,ln_TrcNum, 
     1                      KK, TRACEHEADER)
               call savew2 (itr, ifmt_DphInd,l_DphInd,ln_DphInd, 
     1                      KK, TRACEHEADER)
               call wrtape (luout, itr, obytes)
            enddo
         enddo

      ELSE

         call vclr (tri, 1, nsamp)
         call vmov (tri, 1, itr(ITHWP1), 1, nsamp)
         call savew2 (itr, ifmt_StaCor,l_StaCor,ln_StaCor, 
     1                30000, TRACEHEADER)
         do  JJ = irs, ire
            do  KK = ns, ne
               call wrtape (luout, itr, obytes)
            enddo
         enddo

      ENDIF

c
c ----- skip to start record -----
c

      call recskp(1,irs-1,luin,ntrc,itr)


      IF  (fdslice) THEN

         DO 100 JJ = irs, ire

c
c ----- skip to desired trace -----
c

              call trcskp(jj,1,ns-1,luin,ntrc,itr)

              DO 99 KK = ns,ne

                    nbytes = 0
                    call rtape(luin,itr,nbytes)

                    if(nbytes .eq. 0) then

                       write(LERR,*)'End of file on input:'
                       write(LERR,*)'  rec= ',jj,'  trace= ',KK
                       go to 999

                    endif

                    call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                          recnum , TRACEHEADER)
                    call saver2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                          trcnum , TRACEHEADER)


                    ioff = (recnum-1)*nreco + trcnum
                    call sisseek (luout, ioff)

                    call wrtape(luout,itr,obytes)

99            CONTINUE

c
c ----- skip to end of record -----
c

               call trcskp(jj,ne+1,ntrc,luin,ntrc,itr)


100      CONTINUE

      ELSEIF (D3) THEN

         DO While (1.eq.1)

            nbytes = 0
            call rtape (luin, itr, nbytes)

            if(nbytes .eq. 0) then
               write(LERR,*)'End of file on input:'
               write(LERR,*)'  rec= ',jj,'  trace= ',KK
               go to 999
            endif

            call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                  recnum , TRACEHEADER)
            call saver2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                  trcnum , TRACEHEADER)
            IWRN = 0
            if (recnum .lt. limin) IWRN = 1
            if (recnum .gt. limax) IWRN = 1
            if (trcnum .lt. dimin) IWRN = 1
            if (trcnum .gt. dimax) IWRN = 1
            if (IWRN .eq. 0) then
               jcl = recnum - limin + 1
               icd = trcnum - dimin + 1
               ipntr = icd + (jcl-1) * ndi
               call sisseek (luout, ipntr)
               if (stack) then
                  call vmov  (itr(ITHWP1), 1, xtr, 1, nsamp)
                  call rtape (luout , jtr, mbytes)
                  call sisseek (luout, ipntr)
                  call vmov  (jtr(ITHWP1), 1, tri, 1, nsamp)
                  call stak  (xtr, tri, nsamp, SZSMPD)
                  call vmov  (xtr, 1, itr(ITHWP1), 1, nsamp)
               endif
               call wrtape (luout, itr, obytes)
            endif

         ENDDO

 
      ELSE

         DO 200 JJ = irs, ire

c
c ----- skip to desired trace -----
c

              call trcskp(jj,1,ns-1,luin,ntrc,itr)

              DO 199 KK = ns,ne,lenblk
                KKOUT = 1 + (KK-1)/lenblk

                    DO 198 LL=1,lenblk
                    nbytes = 0
                    call rtape(luin,itr,nbytes)
   
                    if(nbytes .eq. 0) then

                       write(LERR,*)'End of file on input:'
                       write(LERR,*)'  rec= ',jj,'  trace= ',KK
                       if(lenblk.ne.1)
     *                 write(LERR,*)'  subrec= ',LL
                       go to 999

                    endif

                    IF( LL.EQ. 1 ) THEN
                    ioff = (KKOUT-1)*ntrco + 1+(JJ-1)*lenblk
                    call sisseek (luout, ioff)
                    ENDIF

                    call wrtape(luout,itr,obytes)
198                 CONTINUE

199           CONTINUE

c
c ----- skip to end of record -----
c

               call trcskp(jj,ne+1,ntrc,luin,ntrc,itr)


200      CONTINUE

      ENDIF

999   continue

       call lbclos(luin)
       call lbclos(luout)

      stop
      end

c
c ----- online help section -----
c

      subroutine  help

#include <f77/iounit.h>

        write(LER,*)' '
        write(LER,*)'Command Line Arguments for resorter'
        write(LER,*)' '
        write(LER,*)'Input....................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N[ntap] -- input data set'
        write(LER,*)'-O[otap] -- output data set'
c       write(LER,*)'-s[ist]  -- start time (ms)         (first samp)'
c       write(LER,*)'-e[iend] -- end time (ms)            (last samp)'
        write(LER,*)'-ns[ns]  -- start trace             (first trace)'
        write(LER,*)'-ne[ne]  -- end trace                (last trace)'
        write(LER,*)'-rs[irs] -- start record                 (first)'
        write(LER,*)'-re[ire] -- end record                    (last)'
        write(LER,*)'-lb[lbk] -- length of block. This is for data with'
        write(LER,*)'            a third dimension, i.e. other than'
        write(LER,*)'            record & traces, e.g. components'
        write(LER,*)'-fdslice -- reorder fdslice data (forward)'
        write(LER,*)' '
        write(LER,*)'-D3      -- D3 option: sort input trcs into volume'
        write(LER,*)'-limin[] -- minimum line number in survey'
        write(LER,*)'-limax[] -- maximum line number in survey'
        write(LER,*)'-lidel[] -- line number increment'
        write(LER,*)'-dimin[] -- minimum trace number in survey'
        write(LER,*)'-dimax[] -- maximum trace number in survey'
        write(LER,*)'-didel[] -- trace number increment'
        write(LER,*)'-S       -- stack traces into volume'
        write(LER,*)' '
        write(LER,*)'-V       -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)'resorter -N[] -O[] -ns[] -ne[] -rs[] -re[] -lb[]'
        write(LER,*)'         [-D3 -fdslice -V] [-limin[] -limax[]'
        write(LER,*)'         [ -lidel[] -dimin[] -dimax[] -didel[]'
        write(LER,*)'           -S ]'
        write(LER,*)' '

      return
      end

c
c ----- command line parsing subroutine -----
c

      subroutine cmdln (ntap,otap,ist,iend,irs,ire,ns,ne,lenblk,verbos,
     1                 fdslice, rev, D3, limin, limax, lidel,
     2                 dimin, dimax, didel, stack)

#include <f77/iounit.h>

      integer    argis,ist,iend,irs,ire,lenblk
      integer    limin, limax, lidel, dimin, dimax, didel
     
      character  ntap*(*), otap*(*)

      logical    verbos, fdslice, rev, stack, D3

          call argstr('-N',ntap,' ',' ') 
          call argstr('-O',otap,' ',' ') 

          call argi4('-s',ist,1,1)
          call argi4('-e',iend,0,0)
          call argi4('-rs',irs,1,1)
          call argi4('-re',ire,0,0)
          call argi4('-ns',ns,0,0)
          call argi4('-ne',ne,0,0)
          call argi4('-lb',lenblk,1,1)
          call argi4('-limin',limin, 0 , 0)
          call argi4('-limax',limax, 0 , 0)
          call argi4('-lidel',lidel, 1 , 1)
          call argi4('-dimin',dimin, 0 , 0)
          call argi4('-dimax',dimax, 0 , 0)
          call argi4('-didel',didel, 1 , 1)

          fdslice = (argis('-fdslice') .gt. 0)
          rev     = (argis('-R') .gt. 0)
          D3      = (argis('-D3') .gt. 0)
          stack   = (argis('-S') .gt. 0)
          verbos  = (argis('-V') .gt. 0)

          if (limin .ne. 0 .AND. limax .ne. 0 .AND.
     1        dimin .ne. 0 .AND. dimax .ne. 0      ) then
              D3 = .true.
          else
              if (D3) then
              write(LERR,*)'FATAL ERROR in resorter: D3 option'
              write(LERR,*)'You must specify survey bounds using'
              write(LERR,*)'-limin[] -limax, etc'
              write(LER ,*)'FATAL ERROR in resorter: D3 option'
              write(LER ,*)'You must specify survey bounds using'
              write(LER ,*)'-limin[] -limax, etc'
              stop 666
              endif
          endif

      return
      end

      subroutine verbal(nsamp,nsampo,nsi,ntrc,ntrco,nrec,nreco,iform,
     :                  ist,iend,ns,ne,irs,ire,lenblk,D3,limin,limax,
     :                  lidel,dimin,dimax,didel,nli,ndi)

#include <f77/iounit.h>

      
      integer nsamp,nsampo,nsi,ntrc,ntrco,nrec,nreco,iform,ist,iend
      integer ns,ne,lenblk,limin,limax,lidel,dimin,dimax,didel
      integer nli,ndi
      logical D3

        write(LERR,*)
        write(LERR,*)' Values read from input data set line header'
        write(LERR,*)
        write(LERR,*) ' # of Samples/Trace =  ', nsamp
        write(LERR,*) ' Sample Interval    =  ', nsi
        write(LERR,*) ' Input Traces per Record  =  ', ntrc
        write(LERR,*) ' Output Traces per Record  =  ', ntrco
        write(LERR,*) ' Records per Line   =  ', nrec
        write(LERR,*) ' Format of Data     =  ', iform
c       write(LERR,*) ' window start in samples   =  ', ist
c       write(LERR,*) ' window end in samples     =  ', iend
        write(LERR,*) ' trace start       =  ', ns
        write(LERR,*) ' trace end       =  ', ne
        write(LERR,*) ' record start       =  ', irs
        write(LERR,*) ' record end         =  ', ire
        if (D3) then
        write(LERR,*) ' Minimum LI         =  ', limin
        write(LERR,*) ' Maximum LI         =  ', limax
        write(LERR,*) ' LI increment       =  ', lidel
        write(LERR,*) ' Minimum DI         =  ', dimin
        write(LERR,*) ' Maximum DI         =  ', dimax
        write(LERR,*) ' DI increment       =  ', didel
        write(LERR,*) ' Output records     =  ', nli
        write(LERR,*) ' Output # samples   =  ', ndi
        else
        write(LERR,*) ' Output records     =  ', nreco
        write(LERR,*) ' Output # samples   =  ',nsampo
        write(LERR,*) ' Input/Output trace block length =  ',lenblk
        endif
        write(LERR,*) ' '

      return
      end
