C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM MODULE rest
C
C**********************************************************************C
C
C rest READS SEISMIC TRACE DATA FROM AN INPUT FILE,
C applies trace header statics,
C AND PRINTS UPDATED LINE HEADER AND REQUIRED RECORDS
C OR TRACES
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, SAVE
C
c	modified by James Gridley
c	USP Team, Tulsa
c	Added the null and nullvalue option for use 
c	with the attribute analysis tools
c
c	Requested by Steve Farmer.
c
C**********************************************************************C
C
C     DECLARE VARIABLES
C
#include <localsys.h>
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/sisdef.h>
#include <f77/lhdrsz.h>

      integer      SZS64
      parameter   (SZS64 = 4*SZSMPM)
      INTEGER     ITR ( SZLNHD )
      INTEGER     LHED( SZLNHD ), LUIN, LUOUT, NBYTES, lbyout
      REAL        HEAD( SZLNHD )
      INTEGER     NSAMP, NSI, NTRC, NREC, IFORM, LBYTES, obytes
      REAL        TRI     ( 2*SZLNHD )
      real        work    ( 2*SZLNHD )
      real        omega   ( 2*SZLNHD )
      complex     expphi  ( 2*SZLNHD)
      real        nullvalue,nulhrz
     
#include <f77/pid.h>
      real        sii,unit
      integer     nsampo, ipos
      integer     ordfft
      CHARACTER   NAME * 4, ntap * 256, otap * 256, iswd*6
      logical     verbos,undo, pad, datum, phase, flt, amp
      logical     fstsmp, null, coarse
      integer     argis
      integer     irs, ire, ns, ne
      integer     nreout, ntrout
      external    rshift
C
      EQUIVALENCE ( ITR(  1), LHED(1), HEAD(1) )
      DATA  NBYTES / 0 /, LBYTES / 0 /, name/'REST'/
      DATA  nlast /0/
      pi = 3.14159265


C**********************************************************************C
C     get help if necessary
C**********************************************************************C
      if ( argis ( '-?' ) .gt. 0 .or.
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif

C**********************************************************************C
C     open printout file
C**********************************************************************C
#include <f77/open.h>
      
C**********************************************************************C
C     read command line parameters, print out values
C**********************************************************************C
      call cmdln ( ntap, otap, ns, ne, irs, ire, iswd, undo, pad, phase,
     1     unit, iglob, verbos, datum, itd, ipos, dsii, flt,
     2     amp, fstsmp, null, nullvalue, coarse)
C**********************************************************************C
C     open logical i/o units
C     check line header; save key values
C**********************************************************************C
      call getln( luin, ntap, 'r', 0 )
      call getln( luout, otap, 'w', 1 )

c-----------------
c  input data
c-----------------
      lbytes=0
      CALL RTAPE ( LUIN , ITR , LBYTE           )
      if( lbyte .eq. 0 ) then
         write(LERR,*)'REST: no header read on unit ',luin
         write(LERR,*)'FATAL'
         stop
      endif
      CALL HLHprt ( ITR , LBYTE, name, 4, LERR         )

c--------------------------
c  save key header values
c--------------------------
#include <f77/saveh.h>

c------
c     save certain parameters
      
      call saver(itr, 'HrzNul', nulhrz, LINHED)
      
      if(nulhrz .ne. nullvalue) then
         nullvalue = nulhrz
      endif
     
   

c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that
c     refers to the trace header
 
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

      call savelu(  iswd  ,ifmt_iswd,l_iswd  ,ln_iswd,TRACEHEADER)

      if(nsamp .gt. SZLNHD) nsamp = SZLNHD

      write(LERR,*)' First record to process              =  ',irs
      write(LERR,*)' Last record to process               =  ',ire
      write(LERR,*)' Starting trace number                =  ',ns
      write(LERR,*)' Ending   trace number                =  ',ne
      write(LERR,*)' Static Word in Header                =  ',iswd
      write(LERR,*)' (header word position)               =  ',l_iswd
      write(LERR,*)' (header word format)              =  ',ifmt_iswd
      write(LERR,*)' Undo statics flag                    =  ',undo
      write(LERR,*)' Preserve original tr length (?)      =  ',pad
      write(LERR,*)' Pad taces with ',iglob,' ms'
      write(LERR,*)' Sample interval override             =  ',dsii
      if (fstsmp)
     1     write(LERR,*)' Will use line header trace start time'
      if (unit .ne. 0.)
     1     write(LERR,*)' Time units override (ms)             =  ',unit
      if (flt) then
         write(LERR,*)' Header static is a floating point value'
      else
         write(LERR,*)' Header static is an integer value'
      endif
      if (coarse) then
         write(LERR,*)' All shifts are set to nearest integer sample'
      else
         write(LERR,*)' Shifts are full floating point values'
      endif
      
      if (fstsmp) then
         call saver( itr, 'TmMsFS', val  , LINHED )
         firstsamp = val
         write(LERR,*)' Will use line header trace start time= ',
     1        firstsamp
      else
         firstsamp = 0.
      endif
      
c---------------------------------
c  set sample intervals
c  set up interpolation fft lengths

      sii = nsi
      if ( dsii .ne. 0.0 ) then
         siw = dsii
      else
         siw = sii
      endif
      
      if ( unit .eq. 0. ) then
         unit = 1.0
      endif
      
      dt = nsi * unitsc
      
c---------------------------------
c to pad or not to pad

      IF (phase) THEN
         
         nsampo = nsamp
         
      ELSE
         
         if (undo) then
            call saver( itr, 'ReSpFm',iglob , LINHED )
         else
            call savew( itr, 'ReSpFm',iglob , LINHED )
         endif
         glob = float (iglob)
         if( undo ) then
            nsampo = nsamp - 2 * nint (glob / siw)
         else
            nsampo = nsamp + 2 * nint (glob / siw)
         endif
         
      ENDIF
      
      if (max(nsamp,nsampo) .gt. 2*SZLNHD) then
         write(LERR,*)'Padded trace length= ',nsampo,' samps, or'
         write(LERR,*)nsamp,' greater than...'
         write(LERR,*)'Max allowable length= ',2*SZLNHD
         write(LERR,*)'run editt to reduce trace length'
         stop
      endif
      
      if(undo) then
         k2 = ordfft (nsamp)
      else
         k2 = ordfft (nsampo)
      endif
      
      if (phase) then
         k2 = ordfft (nsamp)
      endif
      
      ntnew  = 2**k2

      ntmax  = max (nsamp, nsampo, ntnew)
      
      domega = 2.*pi/ntnew
      do  10000  iomega = 1, ntnew/2
         omega(iomega) = (iomega-1) * domega
10000 continue
      
      
      write(LERR,*)' '
      if (phase) then
         write(LERR,*)' Doing Phase Rotation'
      else
         write(LERR,*)' Doing Static Application'
      endif
      write(LERR,*)' nsamp    = ',nsamp
      write(LERR,*)' nsampo   = ',nsampo
      write(LERR,*)' ntnew    = ',ntnew
      write(LERR,*)' ntmax    = ',ntmax
      write(LERR,*)' '
      

      xsamp = nsamp
c---------------------------------

c--------------------------------------
c   print out header values
c--------------------------------------

      write(LERR,*)' Values read from input data set lineheader'
      write(LERR,*)' # of Samples/Trace =  ',nsamp
      write(LERR,*)' Sample Interval    =  ',nsi
      write(LERR,*)' Traces per Record  =  ',ntrc
      write(LERR,*)' Records per Line   =  ',nrec
      write(LERR,*)' Format of Data     =  ',iform
      if(undo)write(LERR,*)' Undo trace operation'
      if (amp)write(LERR,*)' Trace scaling'
      if (phase)write(LERR,*)' Phase rotation'
      if (.not.phase .and. .not.amp)
     1     write(LERR,*)' Trace static application'
      if(pad) then
         write(LERR,*)' Global static applied =  ',iglob,' integer'
         write(LERR,*)' Global static applied =  ',glob,' real'
         write(LERR,*)' Trace Length Increased Accordingly to ',
     1        nsampo
      endif
      if (datum) then
         write(LERR,*)' Datum time (ms)        =  ',itd
      endif
      
      glob = glob/siw
      iglob = nint (glob)

C**********************************************************************C
C     CHECK DEFAULT VALUES AND SET PARAMETERS
C**********************************************************************C
      call cmdchk(ns, ne, irs, ire, ntrc, nrec)

c-----
c      modify header as needed
c-----
      nreout = ire - irs + 1
      ntrout =  ne -  ns + 1
      obytes = SZTRHD + SZSMPD * nsampo
      call savew( itr, 'NumTrc',ntrout, LINHED)
      call savew( itr, 'NumRec',nreout, LINHED)
      call savew( itr, 'NumSmp',nsampo, LINHED)
      call savhlh(itr, lbyte, lbyout)
      
C**********************************************************************C
C     write out modified line header
C**********************************************************************C
      call wrtape(luout, itr, lbyout)

c-----
c      skip unwanted records
c-----
      call recskp(1,irs-1,luin,ntrc,itr)
      
      if (iglob .lt. 0) iglob = 0
      td = unit * (float(itd) / siw)
c--------------------------------------------------------------------
c  read traces, shift, and write
c--------------------------------------------------------------------
      DO 5000 JJ = irs, ire

c-----------------------
c  skip to start trace
           call trcskp(jj, 1, ns-1, luin, ntrc, itr)
c-----------------------

           DO 5001 KK = ns, ne
              nbytes = 0
              CALL RTAPE  ( LUIN, ITR, NBYTES )
              if(nbytes .eq. 0) then
                 write(LERR,*)'End of file on input:'
                 write(LERR,*)'  rec= ',jj,'  trace= ',kk
                 go to 999
              endif
              call vmov (itr(ITHWP1), 1, tri, 1, nsamp)
              
              call saver2(itr, ifmt_StaCor, l_StaCor, ln_StaCor,
     1             istatic, TRACEHEADER)
              
c---------------
c  get phase
c  from header word mnemonic
c  do rotation
c---------------
              IF (phase) THEN
                 
                 IF (istatic .ne. 30000) THEN

                    if (flt) then
                       call getfp2(itr, ifmt_iswd, l_iswd, ln_iswd,
     1                      val    , TRACEHEADER)
                       if(val .eq. nullvalue)then
                          istatic2=30000
                          call savew2(itr, ifmt_StaCor, l_StaCor,
     :                         ln_StaCor, istatic2, TRACEHEADER)
                          go to 997
                       endif
                       rot = -unit * val
                    else
                       call saver2(itr,ifmt_iswd,l_iswd, ln_iswd,
     1                      ival   , TRACEHEADER)
                       rot = -unit * float (ival)
                    endif
                    if (undo) rot = -rot
                    call rotate (tri, ntnew, rot)
                 ENDIF
                 
c---------------
c  get log amp scaler
c  from header word mnemonic
c  do amp correction
c---------------
              ELSEIF (amp) THEN
                 
                 
                 IF (istatic .ne. 30000) THEN
                    
                    call getfp2(itr, ifmt_iswd, l_iswd, ln_iswd,
     1                   val    , TRACEHEADER)
                    if( val .eq. nullvalue ) then
                       istatic2=30000
                       call savew2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                      istatic2, TRACEHEADER)
                       go to 997
                    endif
                    if (val .eq. 0.) val = 1.0
                    if (undo) val = 1. / val
                    call vsmul (tri, 1, val, tri, 1, nsamp)
                 ENDIF
c---------------
c  get static
c  from header word mnemonic
c  do shift
c---------------
              ELSE
                 
                 IF (istatic .ne. 30000) THEN
                    
                    if (flt) then
                       call getfp2(itr,ifmt_iswd,l_iswd, ln_iswd,
     1                      val    , TRACEHEADER)
                       if( val .eq. nullvalue ) then
                          istatic2=30000
                          
                          call savew2(itr,ifmt_StaCor,l_StaCor,
     1                         ln_StaCor,
     1                         istatic2, TRACEHEADER)
                          go to 997
                       endif
                       
                       ss = unit * (val - firstsamp)/ siw
                    else
                       call saver2(itr,ifmt_iswd,l_iswd, ln_iswd,
     1                      ival   , TRACEHEADER)
                       ss = unit * (float(ival) - firstsamp)/ siw
                    endif
                 ELSE
                    ss = 0.0
                 ENDIF
                 
                 IF (datum) THEN
                    st = td - ss
                 ELSE
                    st = ss
                 ENDIF

                 IF ( coarse ) THEN
                    intst = nint (st)
                    st = float (intst)
                 ENDIF
                 
                 if (abs(st) .gt. xsamp) then
                    write(LERR,*)'WARNING: static > trace length'
                    write(LERR,*)'Setting it to zero'
                    st = 0.
                 endif
                 
                 if (verbos) then
                    if (datum) then
                       write(LERR,*)'Rec= ',jj,'  trc= ',
     :                      kk,' hdr shift= ',
     1                      ss,' datumed shift= ',st,' samps'
                    else
                       write(LERR,*)'Rec= ',jj,'  trc= ',
     :                      kk,' hdr shift= ',ss,
     1                      ' samps'
                    endif
                 endif
                 
                 IF(istatic .ne. 30000) then
                    
                    call vclr(work,1, ntmax )
c----------------------------------------
c apply trace statics
c----------------------------------------
                    if(.not. undo) then

c----------------------------------------
c                       apply global shift
c----------------------------------------
                       call vmov(tri(1),1,work(iglob+1),1,nsamp)
                       if (st .ne. 0.0) 
     1                      call rshift (work,nsampo,ntnew, st,omega,
     :                      expphi)
                       call vmov(work,1,tri,1,nsampo)
                       
c----------------------------------------
c unapply trace statics
c----------------------------------------
                    else
                       
                       call vmov(tri, 1, work, 1, nsamp)
                       if (st .ne. 0.0) 
     1                      call rshift (work,nsamp,ntnew,-st,omega,
     :                      expphi)
c----------------------------------------
c     unapply global shift
c----------------------------------------
                       call vmov(work(iglob+1), 1, tri(1), 1, nsampo)
                    endif
                    
                    
                 ELSE
                    call vclr ( tri, 1, nsamp )
                 ENDIF
                 
              ENDIF
 997          call vmov   (tri, 1, itr(ITHWP1), 1, nsampo)
              call wrtape (luout, itr, obytes)
 5001      continue
           
c--------------------
c     skip to end of
c     current record
           call trcskp (jj, ne+1, ntrc, luin, ntrc, itr)
c--------------------
           
 5000   continue
 999    continue
        call lbclos ( luin )
        call lbclos ( luout )
        END
      
      
c------------------------------------------------------
c     online help screen
c------------------------------------------------------
      subroutine help
#include <f77/iounit.h>
      
      write(LER,*)
     :'***************************************************************'
      write(LER,*)
     :    'Run this program by typing: rest and the following arguments'
      write(LER,*)
     :     ' -N [ntap]    (stdin)      : Input data file name'
      write(LER,*)
     :     ' -O [otap]    (stdout)      : Output data file name'
      write(LER,*)
     :     ' -ns [ns] starting trace (default = 1)'
      write(LER,*)
     :     ' -ne [ne] ending trace   (default = all traces)'
      write(LER,*)
     :     ' -rs[irs] starting record (default = 1)'
      write(LER,*)
     :     ' -re[ire] ending record (default = all)'
      write(LER,*)
     :   ' -SW[iswd] trace header static word mnemonic (default=StaCor)'
      write(LER,*)
     :     ' -F static value in header word is floating point number'
      write(LER,*)
     :    ' -FS get time of first sample from line header, else time of'
      write(LER,*)
     :     '     first sample is assumed to be zero'
      write(LER,*)
     :     ' -p[iglob] pad traces by this many ms (default=0)'
      write(LER,*)
     :     'the pad will be removed automatically during the undo'
      write(LER,*)
     :     ' -u[unit] time scaler (default = 1.0)'
      write(LER,*)
     :     ' -nullvalue[] skip traces with this value in the headerword'
      write(LER,*)
     :     '            apply no correction and flag as dead'
      write(LER,*)
     :     ' -A do amplitude scaling (from header word), or...'
      write(LER,*)
     :     ' -P do phase rotation (from header word), or...'
      write(LER,*)
     :     '    do phase static correction (from header word)'
      write(LER,*)
     :     ' -D datum to a given time from trace header time values'
      write(LER,*)
     :     ' -t[itd]  datum time (ms or micros)'
      write(LER,*)
     :     ' -U undo previous application of trace statics'
      write(LER,*)
     :     ' -M[dsii] override line header sample interval (input s.i.)'
      write(LER,*)
     :     '          Note: can be fractional value'
      write(LER,*)
     :     '    sets the sample interval to 1000x header value'
      write(LER,*)
     :     ' -null  Flag for skipping traces with no correction applied'
      write(LER,*)
     :     ' -C force shifts to be integer sample only. Must be on cmd'
      write(LER,*)
     :     '    line to undo previous integer shift, i.e. -U'
      write(LER,*)
     :     ' -V verbose printout'
      write(LER,*)
     :     'Usage:     rest -N[ntap] -O[otap] -ns[] -ne[] -rs[] -re[]'
      write(LER,*)
     :     '                -p[] -M[] [ -SW[] -sw[] ] -u[] -nullvalue[]'
      write(LER,*)
     :     '                [-P -A -D -t[] -F -FS -U -C -null -V]'
      write(LER,*)
     : '***************************************************************'
      
      return
      end
      
C**********************************************************************C
C     get command line parameters
C**********************************************************************C
      subroutine cmdln(ntap, otap, ns, ne, irs, ire,iswd,undo,pad,phase,
     1     unit,iglob, verbos, datum, itd, ipos, dsii, flt,
     2     amp, fstsmp, null, nullvalue, coarse)
      
#include <f77/iounit.h>
      
c-----
c     get command arguments
c     
c     ntap  - C*100  input file name
c     otap  - C*100  output file name
c     ns   - I      start trace
c     ne   - I      stop end trace
c     irs   - I      start record
c     ire   - I      stop end record
c     iswd   - I      header word for static
c     iunit   - I      time units override
c     iglob   - I      time to pad traces
c     undo   - L      remove normal moveout
c     pad   - L      pad record
c     verbos - L      verbose output or not
c-----
      integer     ns,ne,irs,ire, argis, iglob, itd, ipos
      real        unit, dsii, nullvalue
      character   ntap*(*),otap*(*), iswd*6
      logical     undo,pad,verbos,datum,phase,flt,amp,fstsmp
      logical     null, coarse
      
      phase  = .false.
      verbos = .false.
      flt    = .false.
      undo   = .false.
      pad    = .false.
      datum  = .false.
      null   = .false.
      coarse = .false.
      
      
      call argr4 ('-nullvalue', nullvalue, -30000., -30000.)
      
      null    = ( argis ('-null') .gt. 0 )
      
      
      call argstr ('-N', ntap, ' ', ' ' )
      call argstr ('-O', otap, ' ', ' ' )
      call argi4  ('-ns',ns,0,0)
      call argi4  ('-ne',ne,0,0)
      call argi4  ('-rs',irs,0,0)
      call argi4  ('-re',ire,0,0)
      call argstr ('-SW',iswd,' ',' ')
      if (iswd(1:1) .eq. ' ')
     1     call argstr ('-sw',iswd,' ',' ')
      call argi4  ('-p',iglob, 0, 0)
      call argr4  ('-u',unit,1.,1.)
      call argr4  ('-M', dsii, 0.0, 0.0)
      
      amp    = ( argis ('-A') .gt. 0 )
      fstsmp = ( argis ('-FS') .gt. 0 )
      flt    = ( argis ('-F') .gt. 0 )
      
      datum  = ( argis ('-D') .gt. 0 )
      if (datum)
     1     call argi4  ('-t',itd,0,0)
      
      undo   = ( argis ('-U') .gt. 0 )
      if (iglob .eq. 0) then
         pad = .true.
      else
         pad = .false.
      endif
      phase  = ( argis ('-P') .gt. 0 )
      coarse = ( argis ('-C') .gt. 0 )
      verbos = ( argis ('-V') .gt. 0 )
      
      if (phase) then
         if (iswd(1:1) .eq. ' ') iswd = 'SGRNum'
c     if (undo) unit = -unit
         fstsmp = .false.
      elseif (amp) then
         fstsmp = .false.
         if (iswd(1:1) .eq. ' ') then
            write(LERR,*)'FATAL ERROR in rest -amp option:'
            write(LERR,*)'Must have header word specification -sw[] on'
            write(LERR,*)'cmd line for input of amplitude scaler'
            write(LER ,*)'FATAL ERROR in rest -amp option:'
            write(LER ,*)'Must have header word specification -sw[] on'
            write(LER ,*)'cmd line for input of amplitude scaler'
            stop 666
         endif
      else
         if (iswd(1:1) .eq. ' ') iswd = 'StaCor'
      endif
      
      return
      end
      
      


















































