C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine rshift(u,nt,ntnew,sv,omega,expphi)                             
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      real      u(ntnew)
      real      omega(ntnew/2)
      complex   expphi(ntnew/2)                   

C_______________________________________________________________________
C     DETERMINE FRONT END MUTE
C_______________________________________________________________________
      MUTE=0
      do 10000 k=1,nt
       if(u(k) .eq. 0.) then
          mute=mute+1
       else
          go to 10001
       endif
10000 continue
10001 continue

C_______________________________________________________________________
C     determine if shift is a whole sample. If so things are
c     a whole lot simpler - and faster
C_______________________________________________________________________
      isv = int (sv)
      dsv = float(isv) - sv
      if (dsv .eq. 0.0) then
         if (isv .lt. 0) then
            ii = 0
            do  i = iabs(isv)+1, nt
                ii = ii + 1
                u (ii) = u (i)
            enddo
         elseif (isv .gt. 0) then
            do  i = nt, 1, -1
                u (i+isv) = u (i)
            enddo
            do  i = 1, isv
                u (i) = 0.0
            enddo
         endif
         go to 29999
      endif
C_______________________________________________________________________
C     calculate phase shift operator in frequency domain.
c     this will vectorize on the cray.
C_______________________________________________________________________
      do 50000 iomega=1,ntnew/2
       arg=-omega(iomega)*sv
       expphi(iomega)=cmplx(cos(arg),sin(arg))
50000 continue
C_______________________________________________________________________
C     pad end of trace with zeros.           
C_______________________________________________________________________
      NZERO=NTNEW-NT
      CALL VCLR(U(NT+1),1,NZERO)
C_______________________________________________________________________
C     TAKE FORWARD FFT FROM T TO OMEGA
C     A REAL TO COMPLEX FFT (IN PLACE)
C_______________________________________________________________________
      CALL RFFT(U(1),NTNEW,1)
      CALL RFFTSC(U(1),NTNEW,2,1)
C_______________________________________________________________________
C     perform phase shift in the frequency domain.
C_______________________________________________________________________
      call cvmul(u,2,expphi,2,u,2,ntnew/2,1)
C_______________________________________________________________________
C     TAKE INVERSE FFT FROM OMEGA TO T
C     A COMPLEX TO REAL FFT (IN PLACE)
C_______________________________________________________________________
      call rfft(u(1),ntnew,-1)
C_______________________________________________________________________
C     apply front end mute to kill positive wrap around.
C_______________________________________________________________________
29999 continue

      m=nint(sv)
      do 30000 k=1,mute+m
       u(k)=0.       
30000 continue
C_______________________________________________________________________
C     apply back end mute to kill negative wrap around.
c     only need to apply to OUTPUT end of trace at nt, vs ntnew.
C_______________________________________________________________________
      do 40000 k=nt+1+m,nt 
       u(k)=0.  
40000 continue
c
      RETURN
      END
