C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine DoForwardTrans(Record, Headers, 
     :     Record2, Headers2,
     :     nsamp, ntrc, ist, iend, dt,dx,nfend,
     :     nf, nx, nfstart,
     :     etap, ttap, Space, ktap, xtap,
     :     ct, cdat_mut, cdat_hor, cx_mut, cx_hor,
     :     cterm, cdat, dlabda)
      
#include <save_defs.h>
#include <f77/lhdrsz.h>

c     Subroutine for Roald's Interbed Predictor
c     Summer 1998
c     James Gridley
c     USP Team Tulsa OK
      
c     variables passed from calling routine
      
      integer nsamp, ntrc, ist, iend 
      integer nfend,nf,nx
      
      integer Headers(ITRWRD*ntrc)
      integer Headers2(ITRWRD*ntrc)
      
      real Record(nsamp, ntrc), Record2(nsamp,ntrc)
      real dt, Space(nsamp, ntrc), dlabda, dx
      real etap(nsamp),ttap(nsamp),ktap(nx/2)
      real xtap(ntrc)
      
      complex ct(nf), cx_mut(nx),cx_hor(nx)
      complex  cterm(nx)
      complex cdat_mut(nf,nx), cdat_hor(nf,nx)
      complex cdat(nf,nx)
      
      
c     process data
      
      DO j = 1, ntrc
         
         do i =1, nf
            ct(i)=(0.,0.)
         enddo
         
c     prep Record for transform and put into ct
         
         do i =1, nsamp
               ct(i)=cmplx (Record(i,j)/etap(i),0.)*ttap(i)
            enddo
            
c     fft ct
            call pfft(ct,nf,-dt)
            
c     move ct into the proper trace position of cdat_mut
            do i=1,nfend
               cdat_mut(i,j)=ct(i)
            enddo
            
            do i=1,nf
               ct(i)=(0.,0.)
            enddo
c     
            do i=1,nsamp
               ct(i)=cmplx(Record2(i,j)/etap(i),0.)*ttap(i)
            enddo
            
c     calculate fft jof ct
            call pfft(ct,nf,-dt)
            
c     move conjugate part of ct (which is the fft) into cdat_hor
            
            
            do i=1,nfend
               cdat_hor(i,j)=conjg(ct(i))
            enddo
            
         ENDDO
      
      
c     do the frequency stuff
      
      DO 100  iom=nfstart,nfend
         
         do i=1,nx
            cx_mut(i)=(0.,0.)
            cx_hor(i)=(0.,0.)
            cterm(i)=(0.,0.)
         enddo
         
         do i=1,ntrc
            cx_mut(i)=cdat_mut(iom,i)*xtap(i)
            cx_hor(i)=cdat_hor(iom,i)*xtap(i)
            cx_mut(nx+1-i) = cx_mut(i)
            cx_hor(nx+1-i) = cx_hor(i)
         enddo
         
         call pfft(cx_mut,nx,-dx)
         call pfft(cx_hor,nx,-dx)
         
         do i=1,int(nx/2)
            cterm(i)=cx_mut(i)*cx_hor(i)*cx_mut(i)*ktap(i)
            cterm(nx+1-i)=cterm(i)
         enddo
         
c     transform data to space
         call pfft(cterm,nx,dlabda)
         
         
c     return only positive offsets
         do i=1,int(nx/2)
            cdat(iom,i)=cterm(i)
         enddo
         
c     end frequency loop
 100  ENDDO
      
      DO 200 j = 1, ntrc
         
         
         do i=1,nsamp
            ct(i)=(0.,0.)
            Space(i,j)=0.
         enddo
         
         do iom=nfstart,nfend
            ct(iom)=cdat(iom,j)
         enddo
         
         call pfft(ct,nf,dt)
         
         do k =1, nsamp
            Space(k,j) = 2. * real( ct(k)*etap(k) )
         enddo
         
 200  ENDDO
      
      return
      end



