C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine accnorm(a,radon,ifl,ifh,np)
c_______________________________________________________________________
C     accumulate normal equations in Toeplitz matrix form.
c
c            T 
c     [A]=[R] [R]
c_______________________________________________________________________
      complex  a(ifl:ifh,np)
      complex  rt   
c_______________________________________________________________________
c     radon transform operator matrix.                         
c_______________________________________________________________________
      complex  radon(ifl:ifh,np)
c_______________________________________________________________________
c     divide out the pmodelmin component of the radon transform.
c     recall radon transform is hermetian - hence diagonal is real!
c_______________________________________________________________________
      do 30000 ifreq=ifl,ifh
       rt=conjg(radon(ifreq,1))
       do 20000 ip=1,np                 
        a(ifreq,ip)=a(ifreq,ip)+rt*radon(ifreq,ip)                  
20000  continue
30000 continue
C
      return
      end
