C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
       subroutine getradon(radon,p,ifl,ifh,df,np,
     1                     freq,theta,cincr)
c_________________________________________________________________
c     calculate the radon transform matrix for a given value 
c     theta(x)
c
c     radon(omega,p,x)=exp{+i*(p*omega*theta(x))}
c_________________________________________________________________
      real     p(np)             
      real     freq(ifl:ifh)
      complex  radon(ifl:ifh,np)                 
      complex  cincr(np)
c_________________________________________________________________
c     intialize first frequency and update vector.            
c_________________________________________________________________
      do 10000 ip=1,np       
       arg=-theta*p(ip)*freq(ifl)
       argincr=-theta*p(ip)*df   
       radon(ifl,ip)=cmplx(cos(arg),sin(arg))
       cincr(ip)=cmplx(cos(argincr),sin(argincr))
10000 continue
c_________________________________________________________________
c     complete the coefficient matrix by a nonrecursive vector
c     multiply across parameters p.
c_________________________________________________________________
      do 30000 ifreq=ifl+1,ifh
       do 20000 ip=1,np
        radon(ifreq,ip)=radon(ifreq-1,ip)*cincr(ip)
20000  continue
30000 continue
c
      return
      end
