C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine gettab(freq,p,wgt,delt,df,dp,nf,np, 
     1                  pi,twopi,ifl,ifh,
     2                  minpnoise,maxpnoise,pminnoise,pmaxnoise,
     3                  pminmodel,pmaxmodel,nptaper,
     4                  nfft,signal,pass,
     5                  radon,cincr,noffset,
     6                  linear,parabolic,hyperbolic,zref,
     7                  xmin,xmax,dx,factor,bigmem,lerr,cputim,waltim)
c_______________________________________________________________
c     routine to precompute/table relevant matrices and arrays for
c     efficient calculations.
c_______________________________________________________________
c     radon transform matrix
c_______________________________________________________________
      complex    radon(ifl:ifh,np,0:noffset)
      complex    cincr(np)                         
      logical    bigmem
c
      logical    linear,parabolic,hyperbolic
      logical    signal(np)   
      logical    pass
c_______________________________________________________________
c     other tabled arrays.
c_______________________________________________________________
      real    freq(ifl:ifh)
      real    p(np)
      real    wgt(np)
      real    delt(np)
      real    cputim(*),waltim(*)
c
c_____________________________________________________________
c     precompute frequency array
c_____________________________________________________________
      nfmax=nfft/2
      df=pi/nfmax
      do 10000 ifreq=ifl,ifh
       freq(ifreq)=float(ifreq)*df      
10000 continue
c___________________________________________________________________
c     calculate reconstruction p's
c___________________________________________________________________
      minpnoise=(np-1)*(pminnoise-pminmodel)/(pmaxmodel-pminmodel)+1.5
      maxpnoise=(np-1)*(pmaxnoise-pminmodel)/(pmaxmodel-pminmodel)+1.5
c_____________________________________________________________
c     precompute p array
c_____________________________________________________________
      write(lerr,'(/,a15,4a15,/)') 'curve number','p','delt',
     1                              'wgt','signal'
      dp=(pmaxmodel-pminmodel)/float(np-1)
      do 40000 jp=1,np      
       p(jp)=pminmodel+(jp-1)*dp
       delt(jp)=factor*p(jp)
       if(jp .lt. minpnoise) then
           wgt(jp)=1.
           signal(jp)=.not. pass        
           write(lerr,'(i15,e15.5,2f15.6,l15)') jp,p(jp),wgt(jp),
     1                                        delt(jp),signal(jp)
       elseif(jp .gt. maxpnoise) then
           wgt(jp)=1.
           signal(jp)=.not. pass        
           write(lerr,'(i15,e15.5,2f15.6,l15)') jp,p(jp),wgt(jp),
     1                                        delt(jp),signal(jp)
       else
           signal(jp)=pass        
           if(abs(jp-minpnoise) .lt. nptaper) then
              wgt(jp)=float(jp-minpnoise)/(nptaper+1)
           elseif(abs(jp-maxpnoise) .lt. nptaper) then
              wgt(jp)=float(maxpnoise-jp)/(nptaper+1)
           else
              wgt(jp)=1.
           endif
           write(lerr,'(i15,e15.5,2f15.6,l15)') jp,p(jp),wgt(jp),
     1                                        delt(jp),signal(jp)
       endif
40000 continue
c
      if(bigmem) then
c______________________________________________________________________
c        precompute radon transform matrices.
c        these can take up a sizeable chunk of memory.
c______________________________________________________________________
         call timstr(v1,w1)
         do 80000 ioffset=1,noffset           
            x=xmin+(ioffset-1)*dx         
            if(linear) then
               theta=x
            elseif(parabolic) then
               theta=x**2
            elseif(hyperbolic) then	
               theta=sqrt(zref**2+x**2)-zref
            else
               write(lerr,*) 'generalized radon transform logical'
     1                  //' variables not set in routine gettab'
               write(lerr,*) 'programmer error!'
               call exit(666)
            endif
            call getradon(radon(ifl,1,ioffset),p,ifl,ifh,
     1                    df,np,freq,theta,cincr)
80000    continue
         call timend(cputim(3),v1,v2,waltim(3),w1,w2)
      endif

      return
      end

