C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine Calculate_Area ( Record, Space, nsamp, ntrc, ist, 
     :     iwin_sample, Area, Number_Windows )

#include <f77/lhdrsz.h>

c variables passed from calling routine

      integer nsamp, ntrc, ist, iwin_sample
      integer Number_Windows
      
      real Record ( nsamp, ntrc )
      real Space ( nsamp, ntrc )
      real Area ( nsamp, ntrc )

c declare local variables

      integer j, k, m, iwin_start

      real work(SZLNHD), value(SZLNHD)
      
c     process data
      
      DO j = 1, ntrc
               
         do k = 1, Number_Windows - 1

            iwin_start = iwin_sample * (k-1) + ist
            
            do m = iwin_start, iwin_start + iwin_sample - 1
               work(m-iwin_start+1)=abs(Record(m,j))             
            enddo

            call vsimps(work,1,value,1,iwin_sample,1.)
            Area(k,j) = value(iwin_sample)

         enddo

c Pick up the end of the data

         if (Number_Windows*iwin_samples .le. nsamp) then
       
            do m = nsamp-iwin_sample, nsamp
               work(m-(nsamp-iwin_sample)+1)=abs(Record(m,j)) 
            enddo

            call vsimps(work,1,value,1,nsamp-iwin_sample+1,1.)

c what is k here......pgag....is it always defined...not if the loop above
c actually finished

            Area(k,j) = value(nsamp-iwin_sample+1)

         endif
         
      ENDDO

      return
      end
