C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine Calculate_Kurtosis ( Record, Space, nsamp, ntrc, ist, 
     :     iwin_sample, Average_Val, Stan_Dev, Number_Windows, Kurt )

#include <save_defs.h> 
#include <f77/lhdrsz.h>

c variables passed from calling routine

      integer nsamp, ntrc, ist
      integer iwin_sample, Number_Windows
      
      real Record ( nsamp, ntrc )
      real Space ( nsamp, ntrc )
      real Stan_Dev ( nsamp, ntrc )
      real Average_Val ( nsamp, ntrc )
      real Kurt ( nsamp, ntrc )

c declare local variables

      integer j, k, m, iwin_start
      
c     process data
      
      DO j = 1, ntrc
         
         do k = 1, Number_Windows-1

            iwin_start= iwin_sample * (k-1) + ist

            kurt(k,j)=0.

            do m = iwin_start, iwin_start + iwin_sample - 1

               if (Stan_Dev(k,j) .eq. 0. ) then
                  kurt(k,j)=0.
               else
                  Kurt(k,j) = Kurt(k,j) + 
     :                 (  ( (abs(Record(m,j)) - Average_Val(k,j) ))
     :                 /Stan_Dev(k,j))**4
               endif
                        
            enddo

            Kurt(k,j)= (Kurt(k,j) /( iwin_sample)) - 3.

       enddo

c Pick up the end of the data
         
       if ((Number_Windows-1)*iwin_samples .le. nsamp) then

          do m = nsamp-iwin_sample, nsamp

             if (Stan_Dev(Number_Windows,j) .eq. 0. ) then

                kurt(Number_Windows,j)=0.

             else

                Kurt(Number_Windows,j) = Kurt(Number_Windows,j) + 
     :               (  ( (abs(Record(m,j)) - 
     :               Average_Val(Number_Windows,j) ))
     :               / Stan_Dev(Number_Windows,j))**4

             endif
               
 80       enddo
          
          Kurt(Number_Windows,j)=(Kurt(Number_Windows,j)/
     :         (iwin_sample)) - 3.
          
       endif
         
      ENDDO
      
      return
      end
      
