C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c -----------------  Main Routine -----------------------
c	program Road_Kill: Robust objective amplitude 
c			   Deviation Kill
c	Amplitude Editt/QC program
c	James M. Gridley
c	USP Team
c	Tulsa OK
c	January 1997

c	rewritten in 2-98 JMG (took 2 months)
c
c get machine dependent parameters 

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h> 

c dimension standard USP variables 

      integer     itr ( SZLNHD )
      Integer     Static_Cor (SZLNHD)
      integer     nsamp, nsi, ntrc, nrec, nreco, iform, obytes
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     ist, iend, irs, ire, argis

      character   ntap*255, otap*255, name*255, qctap*255

      logical     verbos, Repair, QC, Zero

c Program Specific _ dynamic memory variables

      integer RecordSize, HeaderSize, errcd1, errcd2, errcd3, abort
      integer Headers

      real    Record, Space
      real    Average_Val, Stan_Dev,Max_Val, A_Dev
      real    Max_A_Dev, Area, Kurt, pct, kurt_lim
      integer Comparison

      pointer (memadr_Record, Record(200000))
      pointer (memadr_Average_Val, Average_Val(200000))
      pointer (memadr_Max_Val, Max_Val(200000))
      pointer (memadr_Stan_Dev, Stan_Dev(200000))
      pointer (memadr_A_Dev, A_Dev(200000))
      pointer (memadr_Max_A_Dev, Max_A_Dev(200000))
      pointer (memadr_Space, Space(200000))
      pointer (memadr_Headers, Headers(200000))
      pointer (memadr_Area, Area(200000))  
      pointer (memadr_Kurt, Kurt(200000))  
      pointer (memadr_Comparison, Comparison(200000))

c Program Specific _ static memory variables

      integer ifmt_StaCor,l_StaCor,ln_StaCor, StaCor
      integer hdr_index, tr_index, JJ, KK
      integer iwin_sample, Number_Windows

c Initialize variables

      data abort/0/
      data name/"ROAD_KILL"/

c     default the module to fix the data      
       Repair = .true.

c give command line help if requested

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif

c open printout file

#include <f77/open.h>

c get command line input parameters

      call cmdln ( ntap, otap, irs, ire, ist, iend, 
     :     name, verbos, iwin, Repair,inum, QC,
     :     pct, kurt_lim, Zero)


c open input and output files

      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

c     Check
      if (Zero .and. Repair) then
         write(LER,*)'road_kill went SPLAT !'
         write(LER,*)'Choose either -I or -Z but not both.'
         write(LERR,*)'road_kill went SPLAT !'
         write(LERR,*)'Choose either -I or -Z but not both.'
         go to 999
      endif

      if (QC) then
         len1=lenth(otap)
	 if (len1 .gt. 0) then
           qctap(1:len1)=otap(1:len1)
	 else
           qctap='road_kill'
           len1=lenth(qctap)
	 endif
 
         qctap(len1+1:len1+4)='_QC'

         luin2 = 11
         open(unit=luin2, file=qctap(1:len1+3),status='unknown')
      endif

c  read input line header and save certain parameters

      call rtape(luin,itr,lbytes)
      if(lbytes.eq.0)then
         write(LER,*)'ROAD_KILL: no line header on input file',ntap
         write(LER,*)'FATAL'
         stop
      endif

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)

c print HLH to printout file 

      call hlhprt (itr, lbytes, name, 12, LERR)

c check user supplied boundary conditions and set defaults

      if ( irs .eq. 0 ) irs = 1
      if ( ire .eq. 0 .or. ire .gt. nrec ) ire = nrec

      ist = nint ( float(ist) / float(nsi) )
      iend = nint ( float(iend) / float(nsi) )
      if ( ist .eq. 0 ) ist = 1
      if ( iend .eq. 0 .or. iend .gt. nsamp ) iend = nsamp

      nreco = ire - irs + 1

c     convert window length from time to samples
      iwin_sample =  int(iwin / nsi)
    

c modify line header to reflect actual record configuration output
c NOTE: in this case the trace and sample limits are used to 
c       limit processing only.   All data within the selected record
c       range are actually passed.

      call savew(itr, 'NumRec', nreco, LINHED)

c number output bytes

      obytes = SZTRHD + SZSMPD * nsamp 

c save out hlh and line header

      call savhlh  ( itr, lbytes, lbyout )
      call wrtape ( luout, itr, lbyout )

c set up pointers to header mnemonic StaCor

      call savelu ( 'StaCor', ifmt_StaCor, l_StaCor, ln_StaCor, 
     :     TRACEHEADER )

c verbose output of all pertinent information before processing begins

      call verbal ( ntap, otap, nsamp, nsi, ntrc, nrec, iform, 
     :     ist, iend, irs, ire, verbos, iwin_sample, Repair,pct,
     :     kurt_lim,Zero)
c dynamic memory allocation:  

      RecordSize = ntrc * nsamp 
      HeaderSize = ntrc * ITRWRD 

      call galloc (memadr_Record, RecordSize * SZSMPD, errcd1, abort)
      call galloc (memadr_Space, RecordSize * SZSMPD, errcd2, abort)
      call galloc (memadr_Headers, HeaderSize * SZSMPD, errcd3, abort)
      call galloc (memadr_Average_Val,  RecordSize * 
     :     SZSMPD, errcd4, abort)
      call galloc (memadr_Stan_Dev,  RecordSize * 
     :     SZSMPD, errcd5, abort)
          call galloc (memadr_Max_Val,  RecordSize * 
     :     SZSMPD, errcd6, abort)
          call galloc (memadr_A_Dev,  RecordSize * 
     :     SZSMPD, errcd7, abort)
          call galloc (memadr_Max_A_Dev,  RecordSize * 
     :     SZSMPD, errcd8, abort)
          call galloc (memadr_Area,  RecordSize * 
     :     SZSMPD, errcd9, abort)
          call galloc (memadr_Kurt,  RecordSize * 
     :     SZSMPD, errcd10, abort)
          call galloc (memadr_Comparison,  RecordSize * 
     :         SZSMPD, errcd11, abort)
      if ( errcd1 .ne. 0 .or.
     :     errcd2 .ne. 0 .or.
     :     errcd3 .ne. 0 .or.
     :     errcd4 .ne. 0 .or.
     :     errcd5 .ne. 0 .or.
     :     errcd6 .ne. 0 .or.
     :     errcd7 .ne. 0 .or.
     :     errcd8 .ne. 0 .or.
     :     errcd9 .ne. 0 .or.
     :     errcd10 .ne. 0 .or.
     :     errcd11 .ne. 0 )then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) 2*RecordSize+HeaderSize* SZSMPD, '  bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'Unable to allocate workspace:'
         write(LER,*) 2*RecordSize+HeaderSize* SZSMPD, '  bytes'
         write(LER,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) 2*RecordSize+HeaderSize* SZSMPD, '  bytes'
         write(LERR,*)' '
      endif

c initialize memory
         
      call vclr ( Record, 1, RecordSize )
      call vclr ( Space, 1, RecordSize )
      call vclr ( Headers, 1, HeaderSize )
      call vclr ( Average_Val, 1, RecordSize )
      call vclr ( A_Dev, 1, RecordSize )
      call vclr ( Max_A_Dev, 1, RecordSize )
      call vclr ( Stan_Dev, 1, RecordSize)
      call vclr ( Max_Val, 1, RecordSize)
      call vclr ( Area, 1, RecordSize)
      call vclr ( Kurt, 1, RecordSize)
      call vclr ( Comparison, 1, RecordSize)
c BEGIN PROCESSING 

c skip unwanted input records

      call recskp ( 1, irs-1, luin, ntrc, itr )

      DO JJ = irs, ire

c load record to memory

         tr_index = 1 - nsamp
         hdr_index = 1 - ITRWRD

          DO KK = 1, ntrc

            nbytes = 0
            call rtape( luin, itr, nbytes)

c if end of data encountered (nbytes=0) then bail out

            if(nbytes .eq. 0) then
               write(LERR,*)'Premature EOF on input at:'
               write(LERR,*)'  rec= ',JJ,'  trace= ',KK
               go to 999
            endif

c set array load points for this trace 

           tr_index = tr_index + nsamp
           hdr_index = hdr_index + ITRWRD

c process only live traces and zero out dead traces

           call saver2 ( itr, ifmt_StaCor, l_StaCor, ln_StaCor, StaCor, 
     :          TRACEHEADER )

           if ( StaCor .ne. 30000 ) then

c load trace to array Record[]

              call vmov ( itr(ITHWP1), 1, Record(tr_index), 1, nsamp )

           else
              call vclr ( Record(tr_index), 1, nsamp )
           endif

c load trace header to array Headers[]

            call vmov ( itr, 1, Headers(hdr_index), 1, ITRWRD )

         ENDDO

c     get the correct number of samples in the analysis window
      
      Number_Windows = (iend - ist + 1)/iwin_sample
      
c     Policeman, be sure we have enough windows to cover all the data
c     if not then the last window will work from the end of the data
c     and count back.  This will be redundant for some data but it will
c     ensure that all data is being considered with similar conditions.
            
      if (Number_Windows*iwin_sample .lt. nsi) then

         Number_Windows = Number_Windows + 1 

      endif

c calculate statistics
      
         call Calculate_Average ( Record, Space, nsamp, ntrc, ist, 
     :     iwin_sample, Average_Val, Max_Val, A_Dev, Number_Windows )

          call Calculate_StanDev ( Record, Space, nsamp, ntrc, ist, 
     :        iwin_sample, Average_Val, Stan_Dev, A_Dev, Max_A_Dev, 
     :        Number_Windows )   
                    
          call Calculate_Area ( Record, Space, nsamp, ntrc, ist, 
     :         iwin_sample, Area, Number_Windows )

          call Calculate_Kurtosis ( Record, Space, nsamp, ntrc, ist, 
     :         iwin_sample, Average_Val, Stan_Dev, Number_Windows, Kurt)

          call Get_StaCor ( Record, Headers, Space, nsamp, ntrc, 
     :         ifmt_StaCor, l_StaCor, ln_StaCor, Static_Cor )

c do comparison and editting if required
        
          call Compare ( Record, Headers, Space, nsamp, ntrc, ist, 
     :     iwin_sample, JJ, nsi, Average_Val, Max_Val, A_Dev,
     :     Max_A_Dev, Stan_Dev, Static_Cor, Area, Repair, Kurt, 
     :     kurt_lim, Number_Windows, inum, pct, Comparison, Zero,
     :     ifmt_StaCor, l_StaCor, ln_StaCor )
          
c write output data

creset array load points for this trace 

         tr_index = 1 - nsamp
         hdr_index = 1 - ITRWRD

         DO KK = 1, ntrc

            tr_index = tr_index + nsamp
            hdr_index = hdr_index + ITRWRD
          
            call vmov ( Record(tr_index), 1, itr(ITHWP1), 1, nsamp )
            call vmov ( Headers(hdr_index), 1, itr(1), 1, ITRWRD )
            call wrtape ( luout, itr, obytes )
 
         ENDDO

      ENDDO

c close data files 

      if (qc) close (unit=11)
      call lbclos ( luin )
      call lbclos ( luout )
      write(LERR,*)'ROAD_KILL: Normal Termination'
      write(LER,*)'ROAD_KILL: Normal Termination'
      stop

 999  continue

      call lbclos ( luin )
      call lbclos ( luout )
      write(LERR,*)'ROAD_KILL: ABNORMAL Termination'
      write(LER,*)'ROAD_KILL: ABNORMAL Termination'
      stop
      end

c -----------------  Subroutine -----------------------

      subroutine help()

c provide terse online help [detailed help goes in man page]

#include <f77/iounit.h>

      write(LER,*)' '
      write(LER,*)'===================================================='
      write(LER,*)' '
      write(LER,*)' Command Line Arguments for ROAD_KILL'
      write(LER,*)' '
      write(LER,*)' For a more detailed description of these parameters'
      write(LER,*)' see the online man page using uman, xman or xuspman'
      write(LER,*)' '
      write(LER,*)'Input ....................................  (def)'
      write(LER,*)' '
      write(LER,*)'-N[]   -- input data set                  (stdin)'
      write(LER,*)'-O[]   -- output data set                (stdout)'
      write(LER,*)'-s[]   -- process start time (ms)             (1)'
      write(LER,*)'-e[]   -- process end time (ms)     (last sample)'
      write(LER,*)'-rs[]  -- start record                        (1)'
      write(LER,*)'-re[]  -- end record                (last record)'
      write(LER,*)'-win[] -- analysis window length       (1000 ms )'
      write(LER,*)'-num[] -- Max. Number of dead traces to skip and'
      write(LER,*)'                     length of spacial window (3)'
      write(LER,*)'-ratio[] -- comparison ratio ( range 0.- 1.) '
      write(LER,*)'    higher values increase kill sensitivty  (0.5)'
      write(LER,*)'-kurt[] -- Kurtosis limit, only kurtosis values'
      write(LER,*)'            greater than this constitutes a '
      write(LER,*)'                              kurtosis kill (1.0)'
      write(LER,*)'-I     -- Interpolate/extrapolate deviated window'
      write(LER,*)'-qc   --Output qc file of rec/trc killed/repaired'
      write(LER,*)'          by the module.  filename = stdin_qc'
      write(LER,*)'-Z     --  Zero offesive window only'
      write(LER,*)'-V     -- verbos printout'
      write(LER,*)' '
      write(LER,*)'Usage:'
      write(LER,*)'       road_kill -N[] -O[] -s[] -e[] -rs[] -re[]'
      write(LER,*)'        -win[] -ratio[] -kurt[] ( -I -qc -Z -V)'
      write(LER,*)' '
      write(LER,*)'===================================================='
      
      return
      end

c -----------------  Subroutine -----------------------

c pick up command line arguments 

      subroutine cmdln ( ntap, otap, irs, ire, ist, iend, 
     :     name, verbos, iwin, Repair,inum ,QC,
     :     pct, kurt_lim, Zero)

#include <f77/iounit.h>

      integer    ist, iend, irs, ire, argis, iwin
      real       pct, kurt_lim

      character  ntap*(*), otap*(*), name*(*)

      logical    verbos, Repair,QC, Zero

           call argi4 ( '-e', iend, 0, 0 )

           Repair = (argis('-I') .gt. 0)

           call argr4 ( '-kurt', kurt_lim, 1.0, 1.0 )

           call argi4 ( '-num', inum, 3, 3 )
           call argstr ( '-N', ntap, ' ', ' ' ) 

           call argstr ( '-O', otap, ' ', ' ' ) 

           QC = (argis('-qc') .gt. 0)

           call argr4 ( '-ratio', pct, 0.5, 0.5 )

           call argi4 ( '-re', ire, 0, 0 )
           call argi4 ( '-rs', irs, 0, 0 )

           call argi4 ( '-s', ist, 1, 1 )

           verbos = (argis('-V') .gt. 0)

         

           call argi4 ( '-win', iwin, 1000, 1000 )
           Zero = (argis('-Z') .gt. 0)
        
c check for extraneous arguments and abort if found to
c catch all manner of user typo's

      call xtrarg ( name, ler, .FALSE., .FALSE. )
      call xtrarg ( name, lerr, .FALSE., .TRUE. )

           
      return
      end

c -----------------  Subroutine -----------------------

c verbal printout of pertinent program particulars


      subroutine verbal ( ntap, otap, nsamp, nsi, ntrc, nrec, iform, 
     :     ist, iend, irs, ire, verbos, iwin_sample, Repair,pct,
     :     kurt_lim, Zero)

#include <f77/iounit.h>

      integer    nsamp, ntrc, iform, ist, iend, irs, ire, nsi
      real       pct, kurt_lim
      character  ntap*(*), otap*(*)

      logical    verbos, Repair,Zero

      write(LERR,*)' '
      write(LERR,*)' Input Line Header Parameters'
      write(LERR,*)' '
      write(LERR,*) ' input data set name   =  ', ntap
      write(LERR,*) ' samples per trace     =  ', nsamp
      write(LERR,*) ' traces per record     =  ', ntrc
      write(LERR,*) ' number of records     =  ', nrec
      write(LERR,*) ' data format           =  ', iform
      write(LERR,*) ' sample interval       =  ', nsi
      write(LERR,*)' '
      write(LERR,*)' '
      write(LERR,*)' Command Line Parameters '
      write(LERR,*)' '
      write(LERR,*) ' output data set name    =  ', otap
      write(LERR,*) ' start record            =  ', irs 
      write(LERR,*) ' end record              =  ', ire 
      write(LERR,*) ' processing sample start = ', ist
      write(LERR,*) ' processing sample end   = ', iend
      write(LERR,*) ' window length           = ', iwin_sample*nsi
      write(LERR,*) ' Comparison ratio        = ', pct
      write(LERR,*) ' Kurtosis threshold      = ', kurt_lim
      if ( Repair) write(LERR,*)'Interpolating/Extrapolating bad data'
      if ( Zero) write(LERR,*)'Zero window with bad data'
      if (.not. Repair .and. .not. Zero) 
     :      write(LERR,*)'Killing Entire trace if a bad window is found'
      if ( verbos )  write(LERR,*) ' verbose printout requested'
      write(LERR,*)' '
      write(LERR,*)'========================================== '
      write(LERR,*)' '

      return
      end





