c***********************************************************************
c                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
c                                                                      *
c***********************************************************************
c  routine:       detmut                                               *
c  routine type:  subroutine                                           *
c  purpose:                                                            *
c      this routine detects the first non-zero sample in an array and  *
c      reports that sample's location in variable imute.  it is used   *
c      for detecting the extent of an initial mute zone (detect mute). *
c  entry points:                                                       *
c      detmut  (n,x,imute)                                             *
c  arguments:                                                          *
c      n       integer       i      -                                  *
c      x       real          i  (n) -                                  *
c      imute   integer       o      -                                  *
c       +------------------------------------------------------+       *
c       |               development information                |       *
c       +------------------------------------------------------+       *
c  author:   bill done                          origin date: 85/09/17  *
c  language: fortran 77                  date last compiled: 86/04/09  *
c       +------------------------------------------------------+       *
c       |                 external environment                 |       *
c       +------------------------------------------------------+       *
c  routines called:  none                                              *
c  intrinsic functions called:  none                                   *
c  files:            none                                              *
c  common:           none                                              *
c  stop codes:       none                                              *
c       +------------------------------------------------------+       *
c       |             other documentation details              |       *
c       +------------------------------------------------------+       *
c  error handling:  none                                               *
c  general description:                                                *
c      detect the location of the first non-zero value in an array.    *
c                                                                      *
c       +------------------------------------------------------+       *
c       |                 analysis information                 |       *
c       +------------------------------------------------------+       *
c  nonstandard features:   none detected                               *
c*******************   end of documentation package   ******************
c***********************************************************************
c
      subroutine detmut (n, x, imute)
c
      dimension x(n)
      do 100 k = 1, n
         if (x(k) .ne. 0.0) then
            imute = k
            go to 200
         endif
  100 continue
  200 return
      end
