c***********************************************************************
c                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
c***********************************************************************
c  routine:       rdparm                                               *
c  routine type:  subroutine                                           *
c  purpose:                                                            *
c      read the input parameters for program rost.                     *
c  entry points:                                                       *
c      rdparm  (luso,luprt,lucard,cardid,name,ntap,otap,cfile,ialgor,  *
c               nfold,range,inirec,notrpr,icard,verbos)                *
c  arguments:                                                          *
c      luso    integer   ??iou* -                                      *
c      luprt   integer       i -                                       *
c      lucard  integer       i -                                       *
c      cardid  char*4   ??iou* -                                       *
c      name    char*4   ??iou* -                                       *
c      ntap    char*120  ??iou* -                                      *
c      otap    char*120  ??iou* -                                      *
c      cfile   char*120  ??iou* -                                      *
c      ialgor  integer       o -                                       *
c      nfold   integer       o -                                       *
c      range   real          o -                                       *
c      inirec  integer       o -                                       *
c      notrpr  integer       o -                                       *
c      icard   char*80  ??iou* -                                       *
c      verbos  logical   ??iou* -                                      *
c       +------------------------------------------------------+       *
c       |               development information                |       *
c       +------------------------------------------------------+       *
c  author:   bill done                          origin date: 88/08/30  *
c  language: fortran 77                  date last compiled: 88/08/30  *
c       +------------------------------------------------------+       *
c       |                 external environment                 |       *
c       +------------------------------------------------------+       *
c  routines called:                                                    *
c      argis   integer -                                               *
c      argstr          -                                               *
c      argi4           -                                               *
c      argr4           -                                               *
c  intrinsic functions called:  none                                   *
c  files:                                                              *
c      lucard  ( input  sequential ) -                                 *
c      luprt   ( output sequential ) -                                 *
c      luso    ( output sequential ) -                                 *
c  common:           none                                              *
c  stop codes:                                                         *
c      =blank=  ( 1) -                                                 *
c      1220     ( 1) -                                                 *
c      2000     ( 1) -                                                 *
c      2100     ( 1) -                                                 *
c      2500     ( 1) -                                                 *
c      9100     ( 1) -                                                 *
c       +------------------------------------------------------+       *
c       |             other documentation details              |       *
c       +------------------------------------------------------+       *
c  error handling:  detects errors in input parameters read from       *
c                   a card.  errors cause termination of program.      *
c                                                                      *
c  general description:                                                *
c      read and check input parameters.                                *
c                                                                      *
c  revised by:  bill done                     revision date: 88/08/30  *
c      modified from re2rdp for use with rostae.                       *
c                                                                      *
c       +------------------------------------------------------+       *
c       |                 analysis information                 |       *
c       +------------------------------------------------------+       *
c  nonstandard features:   none detected                               *
c*******************   end of documentation package   ******************
c***********************************************************************
c
      subroutine rdparm (luso  , luprt , lucard, cardid, name  , ntap  ,
     *                   otap  , cfile , ialgor, nfold , range , inirec,
     *                   notrpr, icard , verbos, renum)
c
      character*4 cardid, name
      character icard*80
c
c     cray input parameter file name
c
      character cfile*(*)
c
c     definitions for command line input
c
      character ntap*(*), otap*(*)
      logical help, verbos,renum
      integer argis
c
c     read help command line entry if present
c
      help = (argis('-H') .gt. 0) .or. (argis('-?') .gt. 0)
      if (help) then
         write (luso,1000)
 1000    format(/
     *    ' rost:  robust stacking, version rostae'//
     *    ' -flag{value}..................(default)'/
     *    ' replace {value} with desired value.  if {value} is not'/
     *    ' present, use (default).'//
     *    ' usage:'/
     *    '    rost -N{ntap} -O{otap} -C{parmfile} -L{listfile} -[R,V]'/
     *    ' or'/
     *    '    rost -N{ntap} -O{otap} -L{listfile} -[R,V] -alg{algor}'/
     *    '         -fold{fold} -rng{range} -rec0{nrec0} -otr{trprec}'//
     *    ' -N{ntap}     -- input data file (stdin)'/
     *    ' -O{otap}     -- output data file (stdout)')
         write (luso,1005)
 1005    format(
     *    ' -C{parmfile} -- file containing test parameters.  If -C'/
     *    '                 is present on the command line with no'/
     *    '                 argument, the input parameters are read'/
     *    '                 in-line from the job script file using'/
     *    '                 the STARTJOB syntax.  The flag used to'/
     *    '                 mark the in-line parameters is "-rost.crd"'/
     *    '                 If the -C flag is not present on the'/
     *    '                 command line, then the program will scan'/
     *    '                 the command line for the -alg -fold -rng'/
     *    '                 -rec0 -otr flags below.')
         write (luso,1010)
 1010    format(
     *    ' -L{listfile} -- file to receive program the listing.  If'/
     *    '                 -L is present on the command line with no'/
     *    '                 argument, the listing goes to file'/
     *    '                 ROST.xxx.yyy where xxx and yyy are'/
     *    '                 numbers obtained from the PID and PPID'/
     *    '                 of this job.  If -L is not present on'/
     *    '                 on the command line, the listing file'/
     *    '                 name is generated using the startjob'/
     *    '                 convention, for use with that system.'/
     *    ' -R           -- renumber to single record, multi trace'/
     *    ' -V           -- verbose program run listing'/
     *    ' -? or -H     -- print this help section and stop'/)
         write (luso,1015)
 1015    format(
     *    ' the following are read if -C is not present:'/
     *    ' -alg{algor}  -- stacking algorithm (1)'/
     *    '                 1:  median'/
     *    '                 2:  alpha trimmed mean'/
     *    '                 3:  range trimmed mean'/
     *    '                 4:  asymmetric range trimmed mean'/
     *    ' -fold{fold}  -- traces to be stacked (0)'/
     *    '                 (0) defaults to number of traces'/
     *    '                 in input record'/
     *    ' -rng{range}  -- trim range for trimmed mean algorithms'/
     *    '                 in per cent (0.)'/
     *    ' -rec0{nrec0} -- number of first output record (1)'/
     *    '                 increment record count by 1.  if'/
     *    '                 nrec0 = -1, then use DI of first'/
     *    '                 input record.'/
     *    ' -otr{trprec} -- number of traces per output record (1)'/)
         stop
      endif
c
c     read parameter file name (cfile) if present
c
      call argstr('-C',cfile,'inline',' ')
c
c     read input and output file names if present
c
      call argstr('-N',ntap,' ',' ')
      call argstr('-O',otap,' ',' ')
      verbos = (argis('-V') .gt. 0)
      renum = ( argis ('-R') .gt. 0 )

c     get processing parameters
c
      if (cfile .eq. ' ') then
c
c        read parameters from command line (numcrd and name
c        set explicitly)
c
         if (verbos) write (luprt,*) 'Parameters from command line'
         call argi4('-alg',ialgor,1,1)
         call argi4('-fold',nfold,0,0)
         call argr4('-rng',range,0.,0.)
         call argi4('-rec0',inirec,0,0)
         call argi4('-otr',notrpr,1,1)
         numcrd = 1
         name = 'ROST'
       else if (cfile .eq. 'inline') then
c
c        parameters will be read in-line with execution statement
c
         ncfile = icopen ('-rost.crd', lucard)
         if (ncfile .eq. 0) then
            write (luprt,1200)
 1200       format(' -Error setting up in-line parameters.'/
     *             '  If operating on SUN workstation, this mode',
     *             ' of parameter input is not operable.'/
     *             ' -Execution terminated'//)
            stop 1200
         endif
       else
c
c        read parameters from unit lucard if cfile
c        is not blank string
c
c        open the file from which to read processing parameters
c
         if (verbos) write (luprt,1210) cfile
 1210    format(/' Get processing parameters from input parameter',
     *          ' file:'/5x,a16/)
         open (lucard,file=cfile,iostat=ios)
         rewind lucard
         if (ios .ne. 0) then
            write (luprt,1220) cfile
 1220       format(/' -Error opening input parameter file ',a16/
     *             ' -Execution terminated'//)
            stop 1220
         endif
      endif
      if (cfile .ne. ' ') then
         read (lucard,1240,end=9000) numcrd, name, ialgor, nfold,
     *        range, inirec, notrpr, icard
 1240    format(i1,a4,2i5,f5.0,2i5,t1,a80)
c
c        print image of input data card
c
         if (verbos) write (luprt,1260) icard
 1260    format(/////,' -1ROST card image:'//1x,'|---:----1',
     *   '----:----2----:----3----:----4----:----5----:----6',
     *   '----:----7----:---'/1x,a80)
c
c        close the input parameter file
c
         close (lucard,iostat=ios)
      endif
c
c     set defaults on parameters ialgor and notrpr
c
      if (ialgor .eq. 0) ialgor = 1
      if (notrpr .eq. 0) notrpr = 1
c
c     set default on initial record.  if inirec = -1, output record
c     index is the input depth index, starting with the DI of the
c     first input record and incrementing by 1 for each output
c     record (and number of traces per record, notrpr, is forced
c     to be 1).  if inirec is less than or equal to 0 (but not -1)
c     then the initial record number is set to 1.
c
      if (inirec .eq. -1) then
         notrpr = 1
       else if (inirec .le. 0) then
         inirec = 1
      endif
c
c     impose limits on range
c
      if (range .lt. 0.0) range = 0.0
      if (range .gt. 100.0) range = 100.0
c
c     error checking
c
c        data card number
c
      if (numcrd .ne. 1) then
         write (luprt,2000) numcrd
 2000    format(' -Input data card is numbered ',i2,'.'/
     *          ' -Execution terminated')
         stop 2000
      endif
c
c        data card name
c
      if (name .ne. cardid) then
         write (luprt,2100)
 2100    format(' -Input data card is not a 1rost card.'/
     *          ' -Execution terminated')
         stop 2100
      endif
c
c     stacking algorithm
c
      if ((ialgor .lt. 1) .or. (ialgor .gt. 4)) then
         write (luprt,2500)
 2500    format(' -Error in selecting type of stacking algorithm.'/
     *          ' -Execution terminated')
         stop 2500
      endif
c
c     print interpreted and defaulted card parameters
c
      if (verbos) then
         write (luprt,6100)
 6100    format(/////,' Parameter summary after defaulting:'/)
         write (luprt,6300) ialgor
 6300    format(' Stacking algorithm:  ',i2/5x,'(1=median)'/
     *          5x,'(2=alpha trimmed mean)'/
     *          5x,'(3=range trimmed mean)'/
     *          5x,'(4=asymmetric range trimmed mean)'/)
         if (ialgor .eq. 1) then
            write (luprt,6400) nfold
 6400       format(' Median:'/5x,
     *             ' number of traces in stacking window = ',i5/)
         endif
         if (ialgor .eq. 2) then
            write (luprt,6500) range, nfold
 6500       format(' Alpha trimmed mean:  range, alpha = ',f6.1/5x,
     *             ' number of traces in stacking window = ',i5/)
         endif
         if (ialgor .eq. 3) then
            write (luprt,6600) range, nfold
 6600       format(' Range trimmed mean:  range, alpha = ',1pe11.4/5x,
     *             ' number of traces in stacking window = ',i5/)
         endif
         if (ialgor .eq. 4) then
            write (luprt,6700) range, nfold
 6700       format(' Asymmetric trange trimmed mean:  range,',
     *             ' alpha = ',1pe11.4/5x,
     *             ' number of traces in stacking window = ',i5/)
         endif
      endif
      return
c
c     error exit for end of data set when reading card
c
 9000 write (luprt,9100)
 9100 format(' -Input 1ROST card is missing.'/' -Execution terminated')
      stop 9100
      end
