c***********************************************************************
c                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
c                                                                      *
c***********************************************************************
c  routine:       srtqkp                                               *
c  routine type:  subroutine                                           *
c  purpose:                                                            *
c      sort the n elements of vector v so that v(1) is the smallest    *
c      element and v(n) the largest.  a fast sorting method is used.   *
c  entry points:                                                       *
c      srtqkp  (n,v,nmax,ipntr)                                        *
c  arguments:                                                          *
c      n       integer  ??iou*      -                                  *
c      v       real     ??iou*  (n) -                                  *
c      nmax    integer  ??iou*         -                               *
c      ipntr   integer  ??iou*  (nmax) -                               *
c       +------------------------------------------------------+       *
c       |               development information                |       *
c       +------------------------------------------------------+       *
c  author:   martin smith                       origin date: 85/08/02  *
c  language: fortran 77                  date last compiled: 86/04/07  *
c       +------------------------------------------------------+       *
c       |                 external environment                 |       *
c       +------------------------------------------------------+       *
c  routines called:  none                                              *
c  intrinsic functions called:  none                                   *
c  files:            none                                              *
c  common:           none                                              *
c  stop codes:       none                                              *
c       +------------------------------------------------------+       *
c       |             other documentation details              |       *
c       +------------------------------------------------------+       *
c  error handling:  none                                               *
c  general description:                                                *
c                                                                      *
c      name: (sort), (q)uic(k)                                         *
c                                                                      *
c      taken from martin smith's fortran 77 implementation of a        *
c      sorting subroutine called quicks.  quicks was copied from       *
c      martin smith on 84/0/21.  sortqk was created 84/2/21.           *
c                                                                      *
c  revised by:  bill done                     revision date: 86/04/03  *
c      modified to include a pointing vector ipntr, the elements of    *
c      of which sorted identically to those of v, indicating the       *
c      position of specific elements of v after the sort.              *
c                                                                      *
c       +------------------------------------------------------+       *
c       |                 analysis information                 |       *
c       +------------------------------------------------------+       *
c  nonstandard features:   none detected                               *
c*******************   end of documentation package   ******************
c***********************************************************************
c
       subroutine srtqkp (n, v, nmax, ipntr)
c
       dimension v(n)
       integer p, pivot, lv(121), uv(121), ipntr(nmax)
       lv(1) = 1
       uv(1) = n
       p = 1
100    if(p .le. 0) go to 900
         if(lv(p) .lt. uv(p)) go to 200
           p = p - 1
           go to 850
200      continue
           i = lv(p) - 1
           j = uv(p)
           pivot = j
300        if(i .ge. j) go to 600
             i = i + 1
400          if(v(i) .ge. v(pivot)) go to 450
               i = i + 1
               go to 400
450          continue
             j = j - 1
500          if(j .le. i) go to 520
               if(v(j) .le. v(pivot)) go to 520
                 j = j - 1
                 go to 500
520          if(i .ge. j) go to 540
                 vtemp = v(i)
                 v(i) = v(j)
                 v(j) = vtemp
                 iptemp = ipntr(i)
                 ipntr(i) = ipntr(j)
                 ipntr(j) = iptemp
540          continue
             go to 300
600        continue
           j = uv(p)
           vtemp = v(i)
           v(i) = v(j)
           v(j) = vtemp
           iptemp = ipntr(i)
           ipntr(i) = ipntr(j)
           ipntr(j) = iptemp
           if((i-lv(p)) .ge. (uv(p)-i)) go to 700
             lv(p+1) = lv(p)
             uv(p+1) = i - 1
             lv(p) = i + 1
             go to 800
700        continue
             lv(p+1) = i + 1
             uv(p+1) = uv(p)
             uv(p) = i - 1
800        continue
           p = p + 1
850        continue
         go to 100
900    return
       end
