C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine process(xin,yin,xout,live,
     1                   nsamp_in,nsamp_out,ntr,nrec,
     2                   ITRWRD,lerr,nrot,drot,
     3                   luxin,luyin,luxout,nbytes_out,
     4                   jattr1,jattr2,nattribute,
     4                   ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
c
      real       xin(-ITRWRD:nsamp_in-1,ntr)
      real       yin(-ITRWRD:nsamp_in-1,ntr)
      real       xout(-ITRWRD:nsamp_out-1,ntr)
      logical    live(ntr)
c
      do 90000 jrec=1,nrec   
       if(nattribute .eq. 1) then
c___________________________________________________________
c         2 separate single attribute input files. 
c         read data into arrays xin and yin from each file.
c___________________________________________________________
          call rdgather(xin,live,ntr,nsamp_in,
     1                  luxin,eof,ITRWRD,TRACEHEADER,
     2                  ifmt_StaCor,l_StaCor,ln_StaCor)
          call rdgather(yin,live,ntr,nsamp_in,
     1                  luyin,eof,ITRWRD,TRACEHEADER,
     2                  ifmt_StaCor,l_StaCor,ln_StaCor)
       else
c___________________________________________________________
c         one single multiattribute file.
c         read through all the data and pull out the appropriate
c         attributes
c___________________________________________________________
          do 5000 jattr=1,nattribute
           if(jattr .eq. jattr1) then
c___________________________________________________________
c             read attribute 1 into array xin.
c___________________________________________________________
              call rdgather(xin,live,ntr,nsamp_in,
     1                      luxin,eof,ITRWRD,TRACEHEADER,
     2                      ifmt_StaCor,l_StaCor,ln_StaCor)
           elseif(jattr .eq. jattr2) then
c___________________________________________________________
c             read attribute 2 into array yin.
c___________________________________________________________
              call rdgather(yin,live,ntr,nsamp_in,
     1                      luyin,eof,ITRWRD,TRACEHEADER,
     2                      ifmt_StaCor,l_StaCor,ln_StaCor)
           else
c___________________________________________________________
c             skip attributes that are not used.
c             use xout as a temporary buffer.
c___________________________________________________________
              call recskp(jattr,jattr,luxin,ntr,xout)
           endif
5000      continue
       endif
       do 80000 jtr=1,ntr
c_______________________________________________________________
c       copy the header
c_______________________________________________________________
cbug	do 10000 jh=-ITRHDR,0
	do 10000 jh=-ITRWRD,0
	   xout(jh,jtr)=xin(jh,jtr)
10000   continue
        if(live(jtr)) then
c_______________________________________________________________
c          live traces. rotate.
c_______________________________________________________________
           do 70000 jrot=0,nrot-1
            th=jrot*drot 
            costh=cos(th)
            sinth=sin(th)
            do 60000 jtin=0,nsamp_in-1
             jtout=jtin*nrot+jrot
             xout(jtout,jtr)=
     1           costh*xin(jtin,jtr)+sinth*yin(jtin,jtr)
60000      continue
70000      continue
        else
c_______________________________________________________________
c          dead traces. zero out output.
c_______________________________________________________________
           do 50000 jtout=0,nsamp_out-1
            xout(jtout,jtr)=0.
50000      continue
        endif
80000  continue
       call wrgather(xout,ntr,nsamp_out,luxout,ITRWRD,nbytes_out)
90000 continue
c
      return
      end
