C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      program rotaten
c______________________________________________________________________
c     program to rotate 2 component attributes through 360 degrees.
c
c     Author:    Kurt J. Marfurt (Amoco EPTG, Tulsa, OK, USA)
c
c______________________________________________________________________
c
c     declare variables
c
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
c______________________________________________________________________
c     parameters needed for dynamic memory allocation routine 'galloc'.
c______________________________________________________________________
      parameter (maxs=0 000 002)
      dimension s(maxs)
      pointer   (pntrs,s)
c______________________________________________________________________
      parameter   (pi=3.1415926,twopi=2.*pi)
      integer     sheader(SZLNHD)
      real        cputim(20),waltim(20)
#include <f77/pid.h>
#include <save_defs.h>
c
      character*120  file_xin,file_yin,file_xout,file_multiattribute
      character*7    name
      character*8    linnam
      logical        verbose,query,IKP
      logical        xinfile,yinfile,outfile
      logical        rdxin,rdyin,wrxout,rdmultifile
      logical        rdp,rdq,rddadx,rddady
      integer        argis
      integer        stdin,stdout,stderr
      character*9    host,blank9
      integer        pipe(9)
c
      data           name/'ROTATEN'/
      data           host/'         '/
      data           blank9/'         '/
      data           pipe/1,3,4,5,6,7,8,9,10/
      data           undefined/-99999./
c_______________________________________________________________
c     check to see if we are running under IKP.
c_______________________________________________________________
      call ikpchk(host)
      if(host .ne. blank9) then
         IKP=.true.
      else
         IKP=.false.
      endif
c_______________________________________________________________
c     initialize timing arrays.
c_______________________________________________________________
      do 10000 j=1,20
       cputim(j)=0.
       waltim(j)=0.
10000 continue
      call timstr(vtot,wtot)
      call timstr(v1,w1)
      stdin=LIN
      stdout=LOT
      stderr=LER
c_______________________________________________________________
c     read program parameters from command line card image file
c_______________________________________________________________
      query=(argis( '-?' ) .gt. 0 )
      if(query) then
         call help(ler)
         call exitfu(0)
      endif
c_______________________________________________________________
c     open printout files
c_______________________________________________________________
#include <f77/open.h>
c_______________________________________________________________
c     read input and output file names.
c_______________________________________________________________
      call argstr('-N1',file_xin,'INFILE','INFILE')   
      call argstr('-N2',file_yin,'INFILE','INFILE')   
      call argstr('-O',file_xout,' ',' ')   
c_______________________________________________________________
c     read other necessary parameters from the command line
c_______________________________________________________________
      call argi4('-nrot',nrot,24,24)          
      verbose=(argis('-V') .gt. 0)
c_______________________________________________________________
c     the following command lines are intended for programmer 
c     use only.
c     these should be used with hard shell scripts connected to 
c     SSAM panels.
c_______________________________________________________________
      call argstr('-N',file_multiattribute,' ',' ')   
      rdp=(argis('-P') .gt. 0)
      rdq=(argis('-Q') .gt. 0)
      rddadx=(argis('-DADX') .gt. 0)
      rddady=(argis('-DADY') .gt. 0)
c_______________________________________________________________
c     if we are using ikp, make sure all filenames are blank
c_______________________________________________________________
      write(stderr,*) 'IKP = ',IKP
      if (IKP) then
         file_xin = ' '
         file_yin = ' '
         file_multiattribute = ' '
         file_xout = ' '
      endif
c_______________________________________________________________
c     get logical unit numbers for input and output
c_______________________________________________________________
      call getln(luin,file_multiattribute,'r',0)
      call getln(luxout,file_xout,'w',1)
      call openfile(file_xin,luxin,pipe(1),rdxin,xinfile,IKP,
     1              'r',luin) 
      call openfile(file_yin,luyin,pipe(2),rdyin,yinfile,IKP,
     1              'r',luin) 
c     call openfile(file_xout,luxout,pipe(3),wrxout,outfile,IKP,
c    1              'w',luin)
c
      if(xinfile .and. yinfile) then
c_______________________________________________________________
c        read line headers off two explicitly named input files.
c_______________________________________________________________
         rdmultifile=.false.
         nattribute=1
         lbytes=0
         call rtape(luxin,sheader,lbytes)
         lbytes=0
         call rtape(luyin,sheader,lbytes)
         if(lbytes .eq. 0) then
            write(lerr,*)'c: no header read from unit ',luin
            write(ler,*)'c: no header read from unit ',luin
            call exitfu(1666)
         endif
      else
c_______________________________________________________________
c        read line header off multiattribute input file.
c_______________________________________________________________
         rdmultifile=.true. 
         lbytes=0
         call rtape(luin,sheader,lbytes)
         call saver(sheader,'LinNam',linnam,LINEHEADER)
         nattribute=0
         jattr1=0
         jattr2=0
         do 10010 k=1,8
          if(linnam(k:k) .ne. ' ') then
             nattribute=nattribute+1
             if(rdp .and. linnam(k:k) .eq. 'p') then
                jattr1=nattribute
             endif
             if(rdq .and. linnam(k:k) .eq. 'q') then
                jattr2=nattribute
             endif
             if(rddadx .and. linnam(k:k) .eq. 'x') then
                jattr1=nattribute
             endif
             if(rddady .and. linnam(k:k) .eq. 'y') then
                jattr2=nattribute
             endif
          endif
10010    continue
         if(jattr1 .eq. 0 .or. jattr2 .eq. 0) then
            write(lerr,*) 'error in rotaten!'
            write(lerr,*) 'attribute 1, jattr1 = ',jattr1
            write(lerr,*) 'attribute 2, jattr2 = ',jattr2
            call exit(666)
         endif
      endif
      call hlhprt (sheader,lbytes,name,len(name),lerr)
C_______________________________________________________________________
c     pull relevent values from line header.
c_______________________________________________________________________
      call saver(sheader,'NumSmp',nsamp_in,LINEHEADER)
      call saver(sheader,'SmpInt',nsi,LINEHEADER)
      call saver(sheader,'NumRec',nrec,LINEHEADER)
      call saver(sheader,'NumTrc',ntr,LINEHEADER)
      nrec=nrec/nattribute
      nsamp_out=nsamp_in*nrot
      nbytes_out=(nsamp_out+ITRWRD)*szsmpd
      if(nrot .le. 0) then
         write(lerr,*) 'command line error! nrot = ',nrot,
     1           ' must be positive!'
         call exit(666)
      endif
      drot_degrees=360/nrot
      drot=2.*pi/nrot
c
      write(lerr,*)
      write(lerr,'(a,t40,i5,t50,a)') 'input x component file name',
     1                         luxin,file_xin
      write(lerr,'(a,t40,i5,t50,a)') 'input y component file name',
     1                         luyin,file_yin
      write(lerr,'(a,t40,i5,t50,a)') 'input multi-attribute file name',
     1                         luin,file_multiattribute
      write(lerr,'(a,t40,i5)') 'number of input samples',nsamp_in
      write(lerr,'(a,t40,i5)') 'number of output samples',nsamp_out
      write(lerr,'(a,t40,i5)') 'number of traces',ntr
      write(lerr,'(a,t40,i5)') 'number of records',nrec
      write(lerr,'(a,t40,i5)') 'number of rotation angles',nrot
      write(lerr,'(a,t40,f12.3)') 'rotation increment(degrees)',drot
c______________________________________________________________________
c     calculate memory requirements
c______________________________________________________________________
      write(lerr,'(///,80a1)') ('_',i=1,80)
      write(lerr,'(A)')'storage map of major arrays'
      write(lerr,'(80a1)') ('_',i=1,80)
      l_free=1
      lenin=(ITRWRD+nsamp_in)*ntr
      lenout=(ITRWRD+nsamp_out)*ntr
c____________________________________________________________________
      write(lerr,'(a20,3a10)')'variable name','begin','end','length'
      call mapmem('xin',l_xin,l_free,lenin,lerr)
      call mapmem('yin',l_yin,l_free,lenin,lerr)
      call mapmem('xout',l_xout,l_free,lenout,lerr)
      call mapmem('live',l_live,l_free,ntr,lerr)
c___________________________________________________________________
C     allocate dynamic memory.
C_______________________________________________________________________
      lens=l_free-1
      write(ler,'(//,a)') 'allocate dynamic memory for rotaten: '
      write(ler,*) 1.e-6*lens,' Mwords'
      write(ler,*) 1.e-6*lens*szsmpd,' Mbytes'
      write(lerr,'(a20,10x,i10)') 'total vector length',lens
      call galloc(pntrs,lens*szsmpd,ierrcd,0)
      if(ierrcd .ne. 0 ) then
         write(lerr,*)'galloc memory allocation error from main'
         write(lerr,*)'ierrcd = ',ierrcd
         write(lerr,*)
         write(lerr,*)'probable cause: too much memory requested!'
         write(lerr,*)'go check your seismic headers and command'//
     1                ' line arguments!'
         write(lerr,*)
         write(lerr,*)'program rotaten aborted'
c
         write(ler,*)'galloc memory allocation error from main'
         write(ler,*)'ierrcd = ',ierrcd
         write(ler,*)
         write(ler,*)'probable cause: too much memory requested!'
         write(ler,*)'go check your seismic headers and command'//
     1                ' line arguments!'
         write(ler,*)
         write(ler,*)'program rotaten aborted'
c         call exit(101)
         call exitfu(101)
      endif
C_______________________________________________________________________
c     modify line header to reflect actual number of samples output
C_______________________________________________________________________
      call savhlh(sheader,lbytes,lbyout)
      call savew(sheader,'NumSmp',nsamp_out,LINEHEADER)
      call savew(sheader,'NumRec',nrec,LINEHEADER)
      call wrtape(luxout,sheader,lbyout)
c
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
c_____________________________________________________________
      call process(s(l_xin),s(l_yin),s(l_xout),s(l_live),
     1             nsamp_in,nsamp_out,ntr,nrec,
     2             ITRWRD,lerr,nrot,drot,
     3             luxin,luyin,luxout,nbytes_out,
     4             jattr1,jattr2,nattribute,
     4             ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
c
      call timend(cputim(20),vtot,v2,waltim(20),wtot,w2)
      write(lerr,'(A30,2A15,/)') 'routine','cpu time','wall time'
      write(lerr,'(A30,2f15.3)')
     7         'total',cputim(20),waltim(20)
c_____________________________________________________________   
c     close data files
c_____________________________________________________________   
      call lbclos(luin)
      call lbclos(luxout)
      if(xinfile) call lbclos(luxin)
      if(yinfile) call lbclos(luyin)

      write(ler,*)'normal completetion. routine rotaten'           
      write(lerr,*)'normal completetion. routine rotaten'           
      close(lerr)
      call exitfu(0)
c
      end
      subroutine help(ler)
      write(ler,*)
     1'**************************************************************'
      write(ler,*)'3D coherency mapping of seismic coherency'
      write(ler,*)'Non AMOCO users require a license from AMOCO  '
      write(ler,*)'to use this software and any documentation'
      write(ler,*)
     1'**************************************************************'
      write(ler,*)'execute rotaten by typing rotaten and list of'
     1                   //' program parameters.'
      write(ler,*)
     1'note that each parameter is proceeded by -a where "a" is '
      write(ler,*)
     1'a character(s) correlation to some parameter.'
      write(ler,*)
     1'users enter the following parameters, or use the default values'
      write(ler,*)' '
        write(ler,*)
     1' -N1 [file_xin]  (stdin)    : input in-line attribute'     
     2                        //' file name'
        write(ler,*)
     1' -N2 [file_yin]  (stdin)    : input cross-line attribute'     
     2                        //' file name'
        write(ler,*)
     1' -O [file_out]  (stdout)    : output rotated attribute '
     2                        //' file name'
        write(ler,*)
     1' -nrot [nrot]  (24)         : number of rotation angles'
       write(ler,*)' '
       write(ler,*)'usage:'
       write(ler,*)
       write(ler,*)'rotaten -N1[file_xin] -N2[file_yin] -O[file_out]'
       write(ler,*)'        -nrot[] '
       write(ler,*)' '
       write(ler,*)
 
      return
      end
 

