C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c-----------
c do spatial 
c interpolation
c and sum

      subroutine binsum (ntrc, ngrp, ntrcm, nsamp, dist, xmax,
     1                   tabl1, tabl2, zz, iz, icinit, live, dx,
     2                   spread, data, out, bin)

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

      
      real       data (nsamp,ntrcm)
      real       out  (nsamp,ntrcm)

      real       dist(*), spread(*)
      real       zz(*), tabl1(*), tabl2(*)
      integer    iz(*)

      real       work1 (SZLNHD)
      real       work2 (SZLNHD)
      integer    jdist (SZLNHD)
      integer    nrept (SZLNHD)
      integer    key   (SZLNHD)

      logical    bin

      SAVE

c----
c bin option: vertically stack into distance bins
c----
      IF (bin) THEN

c----
c   make sure distances are all in ascending order
c   or else the interpolator will fail
c----
         call sort (dist, key, live)
c----
c   build input distance table,
c   find any bins that have multiple traces
c   in them
c----
c     write(0,*)'spread'
c     write(0,*)(spread(ii),ii=1,ngrp)

      ic = 0
      nrept(1) = 1
      do  j = 1, live
          x  = dist (j)
          do  jj = 1, ngrp
              x1 = spread (jj) - .5 * dx
              x2 = spread (jj) + .5 * dx
              if (x .ge. x1 .and. x .lt. x2) then
                 jdist (j) = jj
                 if (j .ge. 2 .AND. (jdist(j) .eq. jdist(j-1))) then
                    nrept(ic) = nrept(ic) + 1
                 else
                    ic = ic + 1
                    nrept(ic) = 1
                 endif
              endif
          enddo
      enddo
      nrp = ic

c     write(0,*)'dist'
c     write(0,*)(dist(i),i=1,live)
c     write(0,*)'jdist'
c     write(0,*)(jdist(i),i=1,live)
c     write(0,*)'nrept'
c     write(0,*)(nrept(i),i=1,nrp)

      icum = 1

      DO  j = 1, nrp

          ir1 = icum
          ir2 = icum + nrept(j) - 1
          rp  = nrept(j)
          x = 0.
          do  ii = 1, nsamp
              work1(ii) = 0.
          enddo
          do  ir = ir1, ir2
              icum = icum + 1
              irs  = key (ir)
              x = x + dist(ir)
              do  ii = 1, nsamp
                  work1(ii) = work1(ii) + data(ii,irs)
              enddo
          enddo
          dist(j) = x / rp
          jdist(j) = jdist(ir1)
          irs = key (j)
          do  ii = 1, nsamp
              data(ii,irs) = work1(ii) / rp
          enddo
      ENDDO

      do  j = 1, nrp
          tabl1 (j) = dist (j)
      enddo

      do  j = 1, nrp
          tabl2(j) = spread (jdist(j))
      enddo

c     write(0,*)'tabl1'
c     write(0,*)(tabl1(i),i=1,nrp)
c     write(0,*)'tabl2'
c     write(0,*)(tabl2(i),i=1,nrp)
c     write(0,*)'dist'
c     write(0,*)(dist(i),i=1,nrp)
c     write(0,*)'jdist'
c     write(0,*)(jdist(i),i=1,nrp)

c----
c   interpolate record
c----

      call vclr (work1, 1, ntrcm)

      DO  100  i = 1, nsamp

          do  1  j = 1, nrp

              jj = key (j)
              work1 (j) = data (i,jj)
1         continue

          call vclr (work2, 1, ngrp)
          call fcuint (tabl1, work1, nrp, tabl2, work2, nrp,
     1                            iz, zz, icinit)
          icinit = 0

          do  2  j = 1, nrp

              jj = key (j)
              data (i,jj) = work2(j)
2         continue

100   CONTINUE

c---
c   vertically sum re-gridded record (bin option)
c----
      do  j = 1, nrp

          jm = jdist (j)
          jj = key (j)
          do  i = 1, nsamp

              out (i,jm) = out (i,jm) + data (i,jj)
          enddo
      enddo

      ELSE
c---
c   vertically stack record (no bin option)
c----
      do  j = 1, ntrc

          do  i = 1, nsamp

              out (i,j) = out (i,j) + data (i,j)
          enddo
      enddo


      ENDIF

      return
      end
