C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM MODULE  rstak:  stack n records vertically together
C
C**********************************************************************C
C
C rstak READS SEISMIC TRACE DATA FROM AN INPUT FILE,
C vertically stacks N records sample-to-sample, trace-to-trace
C or into distance bins, and
C WRITES THE RESULTS TO AN OUTPUT FILE
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, SAVE
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h>


      INTEGER     ITR ( SZLNHD )
      INTEGER     LHED( SZLNHD )
      INTEGER     NSAMP, NSI, NTRC, NREC, IFORM
      INTEGER     LUIN , LUOUT, LBYTES, NBYTES,obytes
      integer     argis, stacor

      REAL        xtr( SZLNHD )

      CHARACTER   NAME * 5,  ntap * 256, otap * 256

      logical     verbos, noscl, every
      logical     EOF,query,vector,heap,split,bin,threed,abslt

c variables used in dynamic memory allocation

      integer     ITRH, iz
      integer     errcod, abort

      real        data, out
      real        rept, spread, dist, static 
      real        tabl1, tabl2, zz

      pointer     (mem_data, data(1))
      pointer     (mem_out,  out(1))
      pointer     (mem_itrh, itrh(1))
      pointer     (mem_rept, rept(1))
      pointer     (mem_spread, spread(1))
      pointer     (mem_dist, dist(1))
      pointer     (mem_static, static(1))
      pointer     (mem_tabl1, tabl1(1))
      pointer     (mem_tabl2, tabl2(1))
      pointer     (mem_zz, zz(1))
      pointer     (mem_iz, iz(1))

c initialize variables
 
      EQUIVALENCE ( ITR(  1), LHED(1) )
      DATA NAME     /'RSTAK'/
      DATA LUIN / 1 /, LUOUT  / 2 /, LBYTES / 0 /, NBYTES / 0 /
      data verbos/.false./, vector/.false./
      data abort/ 0 /, EOF/.false./

c-------------------------------------
c  get online help if necessary
c-------------------------------------
      query = (argis('-?').gt.0 .or. argis('-h').gt.0)
      if ( query ) then
           call  help ()
           stop
      endif

c----------------------------------
c  open printout file
c----------------------------------
#include <f77/open.h>

C**********************************************************************C
C     READ PROGRAM PARAMETERS FROM command line
C**********************************************************************C
      call cmdln (ntap,otap,far,dx,nstk,verbos,split,bin,threed,abslt,
     1            noscl,every)

C**********************************************************************C
C     READ AND UPDATE LINE HEADER,
C     WRITE LINE HEADER, SAVE KEY PARAMETERS.
C**********************************************************************C
      call getln ( luin, ntap, 'r', 0 )
      call getln (luout, otap, 'w', 1 )
      lbytes=0
      CALL RTAPE ( LUIN, ITR, LBYTES           )
      if(lbytes .eq. 0) then
         write(LERR,*)'rstak: no header read on unit ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         stop
      endif

c--------------------------
c  get key header values
#include <f77/saveh.h>

      call saver (itr, 'CDPFld', ncdp,  LINHED)
      call saver (itr, 'MnLnIn', nli1,  LINHED)
      call saver (itr, 'MxLnIn', nli2,  LINHED)
      call saver (itr, 'MnDpIn', ndi1,  LINHED)
      call saver (itr, 'MxDpIn', ndi2,  LINHED)

      if (threed) then
         nli  = nli2 - nli1 + 1
         ndi  = ndi2 - ndi1 + 1
         nrec = nli * ndi
         ntrc = ncdp
      endif

      if (nstk .eq. 0) nstk = nrec
      if (nstk .ge. nrec) nstk = nrec
      CALL HLHprt ( ITR, LBYTES, NAME, 5, LERR        )

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

c-----------------------------------------
c  figure out last partial group to stack
      if (every) then
          nstk = 999999999
          nrec = 1
          nrecc = 1
      else
          xrec=float(nrec)/float(nstk)
          nrecc=ifix(xrec+.99)
          left=nrec - nstk*ifix(xrec)
          write(LERR,*)'xrec= ',xrec,' nrecc= ',nrecc,' left= ',left
      endif
c
      call savew( itr, 'NumRec', nrecc, LINHED)

        write(LERR,*) ' '
        write(LERR,*) ' '
        write(LERR,*)' Values read from input data set line header'
        write(LERR,*)
        write(LERR,*) ' # of Samples/Trace =  ', nsamp
        write(LERR,*) ' Sample Interval    =  ', nsi  
        write(LERR,*) ' Traces per Record  =  ', ntrc 
        write(LERR,*) ' Records per Line   =  ', nrec 
        write(LERR,*) ' Format of Data     =  ', iform

C**********************************************************************C
C     update historical line header; write out header
C**********************************************************************C
      if(nsamp .gt. SZLNHD) nsamp=SZLNHD
      nsampo=nsamp
      obytes = SZSMPD * (nsampo + ITRWRD)
      call savhlh ( itr, lbytes, lbyout )

        write(LERR,*) ' '
        write(LERR,*)
        write(LERR,*)' Line header values after default check '
        write(LERR,*)
        write(LERR,*) ' # of Samples/Trace =  ', nsampo
        write(LERR,*) ' Sample Interval    =  ', nsi  
        write(LERR,*) ' Traces per Record  =  ', ntrc
        write(LERR,*) ' Records per Line   =  ', nrecc
        write(LERR,*) ' Format of Data     =  ', iform
        write(LERR,*) ' Records to stack   =  ', nstk
        write(LERR,*) ' '
        if(left .ne. 0) then
          write(LERR,*)'Last group of records=  ',left
          write(LERR,*)'Less than ',nstk,' specified on cmnd line'
        endif
        write(LERR,*) ' '
        if (bin) then
        write(LERR,*) 'Bin option selected:'
        write(LERR,*) ' Far offset for spread =  ', far
        write(LERR,*) ' Bin size              =  ', dx
        if (abslt) 
     1  write(LERR,*) ' Input trace distances forced to be positive'
        endif
        if (noscl) then
        write(LERR,*) ' Normalize stack by live traces'
        else
        write(LERR,*) ' Do not normalize stack'
        endif
        if (every)
     1  write(LERR,*) ' Vertically stack every record in input'
        write(LERR,*) ' '

c-------
c for bin option:
c compute spread model
c-------
      IF (bin) THEN

         ngrp = far / dx
         if (split) ngrp = 2 * ngrp - 1
         ntrcm = max (ntrc, ngrp)
         heap = .true.
         call galloc (mem_spread, ntrcm*SZSMPD, errcod, abort)
         if (errcod .ne. 0) heap = .false.
         if (.not. heap) then
            write(LERR,*)' '
            write(LERR,*)'Unable to allocate workspace:'
            write(LERR,*)'spread: ',ntrcm*SZSMPD,' bytes'
            write(LER ,*)' '
            write(LER ,*)'Unable to allocate workspace:'
            write(LER ,*)'spread: ',ntrcm*SZSMPD,' bytes'
            go to 999
         endif
         call vclr (spread, 1, ntrcm)

         if (split) then

            x  = 0.
            dx = abs(dx)
            do  j = 1, ntrcm
   
                if (x .gt. abs(far)) then
                    ngrp2 = j - 1
                    go to 20
                else
                    xtr (j) = x
                endif
                x = x + dx
   
            enddo
20          continue
            ngrp = 2 * ngrp2 - 1

            ic = 0
            do  j = 2, ngrp2
                ic = ic + 1
                spread (ngrp2-ic) = -xtr(j)
            enddo
            ic = 0
            do  j = 1, ngrp2
                ic = ic + 1
                spread (ngrp2+ic-1) = xtr(j)
            enddo
   
         else

            x = 0.
            do  j = 1, ntrcm
   
                if (far .gt. 0.) then
   
                   if (x .gt. far) then
                       ngrp = j - 1
                       go to 21
                   else
                       spread (j) = x
                   endif
   
                elseif (far .lt. 0.) then
   
                   if (x .gt. 0.0) then
                       ngrp = j - 1
                       go to 21
                   else
                       spread (j) = x
                   endif
   
                endif
                x = x + dx
            enddo
 21      continue
   
         endif

         call galloc (mem_tabl1, ntrcm*SZSMPD, errcod, abort)
         if (errcod .ne. 0) heap = .false.
         call galloc (mem_tabl2, ntrcm*SZSMPD, errcod, abort)
         if (errcod .ne. 0) heap = .false.
         if (.not. heap) then
            write(LERR,*)' '
            write(LERR,*)'Unable to allocate workspace:'
            write(LERR,*)'tabl1: ',ntrcm*SZSMPD,' bytes'
            write(LERR,*)'tabl2: ',ntrcm*SZSMPD,' bytes'
            write(LER ,*)' '
            write(LER ,*)'Unable to allocate workspace:'
            write(LER ,*)'tabl1: ',ntrcm*SZSMPD,' bytes'
            write(LER ,*)'tabl2: ',ntrcm*SZSMPD,' bytes'
            go to 999
         endif
         call vclr (tabl1, 1, ntrcm)
         call vclr (tabl2, 1, ntrcm)

         do  j = 1, ngrp
             if (spread(j) .eq. 0.0) then
                tabl2 (j) = .01 * dx
             else
                tabl2 (j) = spread (j)
             endif
         enddo
         call maxmgv (tabl2, 1, xmax, loc, ngrp)

         write(LERR,*)' '
         write(LERR,*)'Spread model:'
         write(LERR,*)'Number of groups in spread   = ',ngrp
         write(LERR,*)(spread(i),i=1,ngrp)
         write(LERR,*)' '
         if (verbos) then
         write(LER ,*)' '
         write(LER ,*)'Spread model:'
         write(LER ,*)'Number of groups in spread   = ',ngrp
         write(LER ,*)(spread(i),i=1,ngrp)
         write(LER ,*)' '
         endif

      ELSE

         ngrp = ntrc

      ENDIF
c---------------------------------------------------
c  malloc only space we're going to use
      heap = .true.

c - switch from machine-dependent to generic memory allocation
c - j.m.wade 8/20/92

      ntrcm = max0(ngrp,ntrc)
      itemi = ntrcm * ITRWRD
      items = ntrcm * (nsamp)

      call galloc (mem_itrh, itemi*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      call galloc (mem_data, items*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      call galloc (mem_out, items*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      call galloc (mem_rept, ntrcm*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      call galloc (mem_dist, ntrcm*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      call galloc (mem_static, ntrcm*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      call galloc (mem_zz, 4*ntrcm*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      call galloc (mem_iz, ntrcm*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.

      if (.not. heap) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) itemi*SZSMPD,'  bytes'
         write(LERR,*) 2*items*SZSMPD,'  bytes'
         write(LERR,*) ntrcm * 11 *SZSMPD,'  bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'Unable to allocate workspace:'
         write(LER,*) itemi*SZSMPD,'  bytes'
         write(LER,*) 2*items*SZSMPD,'  bytes'
         write(LER,*) ntrcm * 11 *SZSMPD,'  bytes'
         write(LER,*)' '
         go to 999
      else 
         write(LERR,*)' ' 
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) itemi*SZSMPD,'  bytes'
         write(LERR,*) 2*items*SZSMPD,'  bytes'
         write(LERR,*) ntrcm * 11 *SZSMPD,'  bytes'
         write(LERR,*)' '
      endif

c initialize memory

      call vclr (data, 1, items)
      call vclr (out, 1, items)
      call vclr (rept, 1, ntrcm)
      call vclr (dist, 1, ntrcm)
      call vclr (static, 1, ntrcm)
      call vclr (zz, 1, 4*ntrcm)
      
      do i = 1, ntrcm
         iz(i) = 0
      enddo

      do i = 1, itemi
         itrh(i) = 0
      enddo

c---------------------------------------------------
      call savew( itr, 'NumTrc', ntrcm, LINHED)
      CALL WRTAPE ( LUOUT, ITR, LBYOUT                 )

C**********************************************************************C
C
C     READ TRACE, DO rstak3d, WRITE TO OUTPUT FILE
C
C**********************************************************************C
      nstk0 = nstk
      irec = 0
      DO 100 JJ = 1, NRECC

        irec = irec + 1
        if(jj.eq.nrecc .and. left.ne.0) nstk0 = left
           call vclr ( out, 1, nsamp*ntrcm )

c-----------------------------
c  loop over stacking groups

        if (.not.bin) call vclr (dist, 1, ntrc)
        call vclr (rept, 1, ntrcm)
        call vclr (static, 1, ntrcm)
        istak = 0

        DO 99 LL = 1, NSTK0

          live = 0
          call vclr ( data, 1, nsamp*ntrcm )

          DO 98 KK = 1, NTRC

              nbytes = 0
              CALL RTAPE  ( LUIN , ITR, NBYTES         )
               if(nbytes .eq. 0) then
                  if (EOF) go to 999
                  write(LERR,*)'End of file on input:'
                  write(LERR,*)'  rec= ',jj,'  group= ',ll,' trace ',kk
                  EOF = .true.
                  go to 918
               endif
               call vmov (lhed(ITHWP1), 1, xtr, 1, nsamp)

               call saver2(lhed,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                     idist  , TRACEHEADER)
               call saver2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                     stacor , TRACEHEADER)

               if (abslt) idist = iabs (idist)

               IF (bin) THEN
                  if (stacor .ne. 30000) then
                      call dotpr (xtr,1,xtr,1,xdot,nsamp)
                      if (xdot .ne. 0.) then
                          live = live + 1
                          istrc = (live-1) * nsamp
                          call vmov (xtr, 1, data(istrc+1), 1, nsamp)
                          dist(live) = idist
                          rept(live) = rept(live) + 1
                      endif
                  endif 
               ELSE
                  if (stacor .eq. 30000) then
                          call vclr (xtr, 1, nsamp)
                  else
                          rept(KK) = rept(KK) + 1
                          dist (KK) = dist(KK) + float(idist)
                          static (KK) = static(KK) + float(stacor)
                          istrc = (KK-1) * nsamp
                          call vmov (xtr, 1, data(istrc+1), 1, nsamp)
                  endif
                  live = KK
               ENDIF

               if (LL .eq. 1) then
c______________________________________________________________________
c                 if first record in the stack, copy in headers.
c                 (this will give us something in the headers)
c                 if subsequent live trace, copy in valid header values.
c______________________________________________________________________
                  ishdr = (kk-1) * ITRWRD
                  call vmov (lhed,1, itrh(ishdr+1),1,ITRWRD)
               endif

c----------------


   98     CONTINUE

          icinit = 1

          call  binsum (ntrc, ngrp, ntrcm, nsamp, dist, xmax,
     1                  tabl1, tabl2, zz, iz, icinit, live, dx,
     2                  spread, data, out, bin)
          istak = istak + 1

   99   CONTINUE

918     continue

        if (istak .ne. 0) then
            if (noscl) then
               scl = 1.0
            else
               scl = 1. / float(istak)
            endif
        else
            go to 999
        endif

        DO 75 KK = 1, NTRCM

          istrc = (kk-1) * nsamp
          call vmov  ( out(istrc+1), 1, xtr, 1, nsamp )
          call dotpr ( xtr, 1, xtr, 1, xdot, nsamp)
          call vsmul (xtr, 1, scl, lhed(ITHWP1), 1, nsamp)
c------------------------
c  reconstitute headers
          ishdr = (kk-1) * ITRWRD
          call vmov (itrh(ishdr+1),1,lhed,1,ITRWRD)

          IF (bin) THEN

             if (xdot .lt. 1.e-30) then
                call savew2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                              30000  , TRACEHEADER)
             else
                call savew2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                              0      , TRACEHEADER)
             endif
             idist = spread (KK)
             call savew2(lhed,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                           idist  , TRACEHEADER)
          ELSE

             xscl = rept(KK)
             if (xscl .ne. 0.) then
                 xscl = 1. / xscl
             else
                 xscl = 0.
             endif
             idist  =   dist (KK) * xscl
             stacor = static (KK) * xscl
             call savew2(lhed,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                           idist  , TRACEHEADER)
             call savew2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                           stacor , TRACEHEADER)
          ENDIF

          call savew2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                        irec   , TRACEHEADER)
          call savew2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                        KK     , TRACEHEADER)
c------------------------
          call wrtape(luout,itr,obytes)

   75   CONTINUE

        if(verbos) then
           write(LERR,*)'Output Record ',jj
        endif

  100 CONTINUE

  999 continue

       call lbclos(luin)
       call lbclos(luout)
      END

c------------------------------------
c  online help section
c------------------------------------
      subroutine  help
#include <f77/iounit.h>

        write(LER,*)' '
        write(LER,*)'Command Line Arguments for rstak: stack groups'
        write(LER,*)'                                of n records'
        write(LER,*)' '
        write(LER,*)'Input....................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N[ntap]   -- input data set name'
        write(LER,*)'-O[otap]   -- output data set name'
        write(LER,*)'-n[nstk]   -- stack groups of nstk records'
        write(LER,*)'-E         -- vertically stack every record'
        write(LER,*)'-S         -- split spread (-far,...,0,...,far)'
        write(LER,*)'-A         -- input trc distances forced positive'
        write(LER,*)'-B         -- stack into bins defined by xf,xd'
        write(LER,*)'-3d        -- 3D CDP input data assumed'
        write(LER,*)'-xf[far]   -- bin option: far offset (ft,m)'
        write(LER,*)'-xd[dx]    -- bin option: bin size override (ft,m)'
        write(LER,*)'-s         -- do not live trc normalize stack'
        write(LER,*)'-V         -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)'      rstak -N[] -O[] -n[] [ -V ]'
        write(LER,*)'            [ -B [-xf[] -xd[] -s -E -S -3d -A ]'
        write(LER,*)' '

      return
      end

c-----
c     get command arguments
c
c     ntap  - C*100  input file name
c     otap  - C*100  output file name
c    nstk   - I      number of groups of records to stack
c    igath  - I      force number traces in gather to stack
c    verbos - L      verbose output or not
c-----
      subroutine cmdln (ntap,otap,far,dx,nstk,verbos,split,bin,threed,
     1                 abslt,noscl,every)
#include <f77/iounit.h>
      character  ntap*(*), otap*(*)
      real       far, dx
      integer    argis,nstk
      logical    verbos, split, bin, threed, abslt, noscl, every

           call argstr('-N',ntap,' ',' ')
           call argstr('-O',otap,' ',' ')
           call argi4('-n',nstk,0,0)
           call argr4('-xf',far,0.,0.)
           call argr4('-xd',dx ,0.,0.)

           abslt  = ( argis( '-A' ) .gt. 0 )
           bin    = ( argis( '-B' ) .gt. 0 )
           if (bin .and. far .eq. 0.) then
              write(LERR,*)'FATAL error in rstak bin option:'
              write(LERR,*)'must enter far offset using'
              write(LERR,*)'-xf[] cmd line argument'
              stop
           endif

           every  = ( argis( '-E' ) .gt. 0 )
           noscl  = ( argis( '-s' ) .gt. 0 )
           split  = ( argis( '-S' ) .gt. 0 )
           threed = ( argis( '-3d') .gt. 0 )
           verbos = ( argis( '-V' ) .gt. 0 )

      return
      end
