C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE SHIFTS(TRACE,LENTR,SV)
      PARAMETER (MAXN=8192,PI=3.141592654)
      COMPLEX   T(0:MAXN-1)
      REAL      trigs(2*MAXN)
      REAL      TRACE(0:LENTR-1), SV, P, W
      LOGICAL   FRAC
      DATA      LASTR /0/
      SAVE                     ! DATA STATIC AFTER 1ST CALL

C     IF TRACE LENGTH CHANGES, REBUILD SIN/COS TABLE
      IF (LENTR .NE. LASTR) THEN
          N=2**INT(LOG(FLOAT(LENTR-1))/LOG(2.0)+1.0)
          IF (N .GT. MAXN) STOP
          LASTR=LENTR
          call cfftx (T, 2, N, 0, 1, trigs, ierr)
      ENDIF

C     DETERMINE FRONT END MUTE
      MUTE=0
      DO 1 K = 0, LENTR-1

         IF (TRACE(K) .NE. 0.0) go to 2
             MUTE=MUTE+1
1     CONTINUE
2     continue

C     FILL COMPLEX VECTOR &
      DO 3 K = 0, LENTR-1
         T(k) = cmplx (trace(k), 0.0)
3     CONTINUE

C     ZERO TO END OF BUFFER
      DO 4 K = LENTR, N-1
         T(K) = (0.,0.)
4     CONTINUE

C     DO FORWARD FFT
      call cfftx  (T, 2, N, 1, 0, trigs, ierr)
      call cfftss (T, 2, N)

C     CALCULATE REQUIRED PHASE SHIFT
      P = -(2.0*PI*SV)/N
C     APPLY PHASE SHIFT AT EACH FREQ
      DO 5 K = 0, N-1
         W = K
         IF (K .GT. N/2) W = W-N
         T(K) = T(K) * CMPLX(COS(P*W),SIN(P*W))
5     CONTINUE

C     BACK TO TIME DOMAIN
      call cfftx  (T, 2, N, -1, 0, trigs, ierr)

      do  6  k = 1, LENTR
          TRACE(k) = real (T(k))
6     continue

C     RE-APPLY FRONT END MUTE
      FRAC = (SV-REAL(INT(SV)) .NE. 0.0)
      M = SV
      IF (FRAC .AND. SV .GT. 0.0) M=M+1  
      J = 0
      DO 7 K = 0, MUTE+M
         TRACE(J) = 0.0
         J = J+1
7     CONTINUE

C     WE'RE DONE IF POSITIVE SHIFT 
      IF (SV .GE. 0.0) RETURN

C     KILL WRAPPED AROUND SAMPLES
      J = LENTR-1
      M = ABS(M)
      IF (FRAC) M = M+1
      DO 8 K = 0, M-1       
         TRACE(J) = 0.0
         J = J-1
8     CONTINUE

      RETURN
      END
