C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine forward_dft 
     :     (Work, Space, iwin, amp_out, faze_out, 
     :     stable, t, df,k)

c     Subroutine to compute the forward DFT
c     James M. Gridley, Greg Partyka
c     USP Team
c     Tulsa OK
c     
c     Work = input array of time series
c     Space = array to work with
c     iwin = length in samples of Work and Space
c     stable = cis table
c     t = taper array
c     df = frequency of decomposition
c
c     amp = output amplitude spectra
c     faze = output phase spectra
c
#include <save_defs.h> 
#include <f77/lhdrsz.h>

c variables passed from calling routine

      integer iwin,k

      real Work(iwin), Space(iwin)
      real stable(SZLNHD),t(SZLNHD)
      
      real amp_out, faze_out, df
      real pie, radeg, xr, xi      
      complex csum
      
      pie = 4.0 * atan(1.0) 
      radeg = 180. / pie
      csum = (0., 0.)
      
      do i = 1, iwin
         Space(i) =  Work(i)*t(i)
c         if (k .ge. 14 .and. k .le. 16) 
c     :        write(6,*)i,Space(i),stable(i),df
      enddo
      csum = (0.,0.)
      do 99 i = 1, iwin
        
         csum = ((cmplx ((cos(df*stable(i))),
     :        -(sin(df*stable(i)))))
     :        * (cmplx(Space(i),0.)))
     :        + csum
        
c       write(6,*)k,i,((cos(df*stable(i)))),(sin(df*stable(i))),
c     ;        Space(i),csum
 99   enddo

      xr = real(csum)
      xi = aimag(csum)

      amp_out = (sqrt(xr*xr + xi*xi))/iwin
      faze_out = radeg*( atan2(xi,xr))
c      write(6,*)k,amp_out,faze_out
      return
      end





