C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine  inverse_rwdft ( Record, Headers, 
     :     Space, nsamp, 
     :     ntrc, ist, iend, fmin, fmax, fint, 
     :     nsi, Num_Freqs,ihalf,iwin,
     :     amp, faze,  unit_scale, inv_stable,
     :     Out_Data, cdata2)

c
c     Subroutine to compute the forward DFT
c
c     Input is of the form amplitude and phase
c     The inverse transform converts the amplitude and
c     phase back into the Fourier components (complex domain).
c     This has been done so that the user can work with either
c     phase or ampltidue and get back to the correct form.
c
c     James M. Gridley, Greg Partyka
c     USP Team
c     Tulsa OK
c     Fall 1997

#include <save_defs.h> 
#include <f77/lhdrsz.h>

c variables passed from calling routine

      integer nsamp, ntrc, ist, iend, nsi, StaCor
      integer Headers(ITRWRD*ntrc)

      real Record(nsamp*2, ntrc*Num_Freqs)
      real Space(nsamp*2,ntrc*Num_Freqs) 

      real amp(nsamp,ntrc*Num_Freqs), faze(nsamp,ntrc*Num_Freqs)
      real inv_stable(SZLNHD), Out_Data(nsamp,ntrc)

      real pie, radeg, fmin, fmax, fint, unit_scale
      
      complex csum, cdata2(nsamp,Num_Freqs)

c     local variables

      pie= 4.0 * atan(1.0) 
      radeg=180./pie
      csum = (0., 0.)
      
c     initialize variables
     
      
c     process data
      
      hdr_index = 0

      do j = 1, ntrc
         do i=1,nsamp
            Out_Data(i,j)=0.
         enddo
      enddo
      

      DO 400 j = 1, ntrc
       
         
c     define pointers to header words required by your routine
         
         call savelu ( 'StaCor', ifmt_StaCor, l_StaCor, ln_StaCor, 
     :        TRACEHEADER )
         
c     get header value
         
         hdr_index = (j-1) * ITRWRD + 1 
         call saver2 ( Headers(hdr_index), ifmt_StaCor, l_StaCor, 
     :        ln_StaCor, StaCor, TRACEHEADER)
         
c     process live traces only
         
         if ( StaCor .ne. 30000 ) then
	tval1=0.
	tval2=0.
c======================================================================
            do jj = 1, Num_Freqs  
               do i=1,nsamp
                  amp(i,jj)=Record(i,((jj-1)*ntrc) + j)
                  faze(i,jj)=Record(i+nsamp,((jj-1)*ntrc) + j)
c                  write(6,*)i,amp(i,jj)
               enddo
            enddo   
	
c     now amp/faze are common trace arrays
c======================================================================
c     Convert the amplitude and phase compoments into the Fourier
c     componets (complex domain)
            
            do 503 jj = 1, Num_Freqs
               do 403 i = 1, nsamp
                  cdata2(i,jj)=(0.,0.)
                  cdata2(i,jj) =  cmplx (
     :                 (amp(i,jj)*iwin)*(cos (faze(i,jj)/radeg)),
     :                 (amp(i,jj)*iwin)*(sin (faze(i,jj)/radeg)))
 403           enddo
 503        enddo

c======================================================================
c     set csum initially to zero
            csum=(0.,0.)
            dt = (float(ihalf)*(float(nsi)*unit_scale))
c======================================================================
c     Set up the summation and perform

            do 501 i = 1,nsamp               
               do 502 jj = 1, Num_Freqs
                  
                  csum  = (cmplx(
     :                 (cos(inv_stable(jj)*dt)),
     :                 (sin(inv_stable(jj)*dt))))
     :                 * cdata2(i,jj) + csum
 502           enddo
               
               Out_Data(i,j) =  (real(csum))/(Num_Freqs) 
              
 123           csum=(0.,0.)
               
 501        enddo
c=======================================================================
         elseif(StaCor .eq. 30000) then
            do i = 1, nsamp
               Out_Data(i,j) = 0.
            enddo   
         endif
         
 400  ENDDO
            
      return
      end


