C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine restore(u,iu,uout,ibuffer,wgt1,wgt2,
     1                   hbegin,lenhed,nsamp,nbytes_out,
     2                   luin,luout,lerr,npad,ntr,nrec_inline,
     3                   lenu2,ntrpline,nline)
      integer   hbegin
c___________________________________________________________________________
c     smooth adjacent data sets to restore stacked section.   
c___________________________________________________________________________
      real      u(hbegin:nsamp,-npad+1:ntr+npad,3)
      real      uout(hbegin:nsamp,ntr)
      integer   ibuffer(lenu2,ntr)
      integer   iu(lenu2,-npad+1:ntr+npad,3)
      real      wgt1(-npad/2:+npad/2)
      real      wgt2(-npad/2:+npad/2)

      common /thdr/ ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     1              ifmt_RecNum,l_RecNum,ln_RecNum,
     2              ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,
     3              ifmt_RecInd,l_RecInd,ln_RecInd,
     4              ifmt_DphInd,l_DphInd,ln_DphInd,
     5              ifmt_DstSgn,l_DstSgn,ln_DstSgn,
     6              ifmt_DstUsg,l_DstUsg,ln_DstUsg,
     7              ifmt_StaCor,l_StaCor,ln_StaCor,
     8              ifmt_SoPtNm,l_SoPtNm,ln_SoPtNm,
     9              ifmt_LRcCDP,l_LRcCDP,ln_LRcCDP

c___________________________________________________________________________
c     calculate interpolation weights.  
c___________________________________________________________________________
      do 8000 jtr=-npad/2+1,+npad/2
       wgt2(jtr)=float(jtr-(-npad/2+1))/(npad-2)
       wgt1(jtr)=1.-wgt2(jtr)
       write(lerr,*) 'jtr,wgt1,wgt2 ',jtr,wgt1(jtr),wgt2(jtr)
8000  continue
c
      jrec=0    
      do 80000 iline=1,nline
       jrec=jrec+1
       ileft=1
       icenter=2
       iright=3
       jtrtotal=0
c___________________________________________________________________________
c      create a dummy (zeroed) left record. 
c___________________________________________________________________________
       do 10000 jtr=-npad+1,ntr+npad
        call vclr(u(hbegin,jtr,ileft),1,nsamp)
10000  continue
c___________________________________________________________________________
c      read in the first (center) record    
c___________________________________________________________________________
       irec=1
       do 11000 jtr=-npad+1,ntr+npad
        nbytes = 0
        call rtape(luin,u(hbegin,jtr,icenter),nbytes)
        if(nbytes .eq. 0) then
           write(LERR,*)'End of file on input!'
           write(LERR,*)'  rec= ',irec,'  trace= ',jtr
           return         
        endif
11000  continue
c___________________________________________________________________________
c      loop over the remaining records, interpolating and writing out as 
c      we go.
c___________________________________________________________________________
       do 70000 irec=2,nrec_inline+1
        if(irec .gt. nrec_inline) then
c___________________________________________________________________________
c          no more input. zero out a dummy right record.
c___________________________________________________________________________
           do 12000 jtr=-npad+1,ntr+npad
            call vclr(u(hbegin,jtr,iright),1,nsamp)
12000      continue
        else
c___________________________________________________________________________
c          read in the right record.                   
c___________________________________________________________________________
           do 20000 jtr=-npad+1,ntr+npad
            nbytes = 0
            call rtape(luin,u(hbegin,jtr,iright),nbytes)
            if(nbytes .eq. 0) then
               write(LERR,*)'End of file on input!'
               write(LERR,*)'  rec= ',irec,'  trace= ',jtr
            endif
20000      continue
        endif
c___________________________________________________________________________
c       copy in the headers.
c___________________________________________________________________________
        do 30000 jtr=1,ntr
         call vmov(u(hbegin,jtr,icenter),1,uout(hbegin,jtr),1,lenhed)
30000   continue
c___________________________________________________________________________
c       blend the left part of the record.             
c___________________________________________________________________________
        do 32000 jtr=1,npad/2 
         do 31000 isamp=1,nsamp
          uout(isamp,jtr)=wgt1(jtr)*u(isamp,ntr+jtr,ileft)
     1                    +wgt2(jtr)*u(isamp,jtr,icenter)
31000    continue
32000   continue
c___________________________________________________________________________
c       center traces.     
c___________________________________________________________________________
        do 34000 jtr=npad/2+1,ntr-npad/2
         do 33000 isamp=1,nsamp            
          uout(isamp,jtr)=u(isamp,jtr,icenter)
33000    continue
34000   continue
c___________________________________________________________________________
c       blend the right part of the record.             
c___________________________________________________________________________
        do 36000 jtr=-npad/2+1,0
         do 35000 isamp=1,nsamp
          uout(isamp,ntr+jtr)=wgt1(jtr)*u(isamp,ntr+jtr,icenter)
     1                       +wgt2(jtr)*u(isamp,jtr,iright) 
35000    continue
36000   continue
c___________________________________________________________________________
c       write out the results.
c___________________________________________________________________________
        do 40000 jtr=1,ntr
         jtrtotal=jtrtotal+1
c        ibuffer(l_RecNum,jtr)=jrec
c        ibuffer(l_TrcNum,jtr)=jtrtotal
c        ibuffer(l_DstSgn,jtr)=0           
         call savew2(ibuffer(1,jtr),ifmt_RecNum,l_RecNum, ln_RecNum,
     1                jrec , 1)
         call savew2(ibuffer(1,jtr),ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                jtrtotal, 1)
         call savew2(ibuffer(1,jtr),ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                0    , 1)

         if(jtrtotal .gt. ntrpline) then
            go to 80000
         endif
         call wrtape(luout,uout(hbegin,jtr),nbytes_out)
40000    continue
c_____ ______________________________________________________________________
c       cycle the pointers.     
c___________________________________________________________________________
        itemp=ileft
        ileft=icenter
        icenter=iright
        iright=itemp
70000  continue
80000 continue
c
      return
      end

