C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine Decompose ( tri, nsamp, ist, iend, nskip, trbias, 
     :     nomega, iwind, ihalf, ctable, t, sum, radeg, phase, smax )

c variables passed from calling routine

      integer nsamp, ist, iend, nskip, nomega, iwind, ihalf

      real tri(nsamp)
      real t(iwind+1)
      real sum(nsamp, nomega)
      real radeg, smax

      complex ctable(iwind+1, nomega)

      logical trbias, phase

c local variables
      
      integer icount, k

      real sumavg, xtmp, xr, xi, sumtmp

      complex cb, csum

c initialize variables


c do decomposition of this trace
      
      DO icount = ist, iend, nskip
                  
         cb = ( 0., 0. )
         sumavg = 0.
                  
         if ( trbias ) then
         
            do i=icount-ihalf, icount+ihalf
               sumavg=t(i-icount+ihalf+1)*tri(i) + sumavg
            enddo
            
            sumavg=sumavg/(2*ihalf+1)

         endif
                  
         DO k = 1, nomega

            cb=(0.,0.)
                     
            do i = icount-ihalf, icount+ihalf
                        
               csum=(0.,0.)

               if ( trbias ) then
                  xtmp = tri(i) * t(i-icount+ihalf+1) - sumavg
                  csum = ctable(i-icount+ihalf+1,k) *
     :                 cmplx(xtmp,0.)
               else 
                  xtmp = tri(i) * t(i-icount+ihalf+1) 
                  csum = ctable(i-icount+ihalf+1,k) *
     :                 cmplx(xtmp,0.)
               endif
                        
               cb = csum + cb

            enddo
                  
            if (phase) then
               xr = real(cb)
               xi = aimag(cb)
            else
               call cvabs(cb,2,sumtmp,1,1)
               sumtmp = sumtmp / iwind
            endif

            smax = max(smax,sumtmp)

c store spectral information in sum [ sample, frequency ] array

            sum(icount,k) = sumtmp

            sumtmp=0.

c phase calculation

            if (phase) then
               if(xr .eq. 0.) then
                  sum(icount,k)=0.
               else
                  sum(icount,k) = 
     :                 radeg*( atan2 (xi,xr))
               endif
            endif
                     
         ENDDO
      ENDDO

      return
      end
