C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine verbal( ntap, otap, ist, iend, ns, ne, irs, ire,
     1     nsi, trbias, opbias,window, itw, nskip, land, verbos,
     2     omega1, omega2, domega, gaus,
     3     period1, period2, dperiod, phase, ntrc, nrec, nsamp,
     4     ntrco, nreco, nsampo, nsamp2, nomega )

#include <f77/iounit.h>

c variables passed from calling routine

      integer ist, iend, ns, ne, irs, ire, window, itw, nskip
      integer ntrco, nreco, nsampo, nsamp2, nomega
      integer nrec, ntrc, nsamp

      real omega1, omega2, domega
      real period1, period2, dperiod

      character ntap*(*), otap*(*)

      logical trbias, opbias, land, verbos, phase, gaus

c local variables

      integer length

      write(LERR,*)' '
      write(LERR,*)' Input Line Header Parameters'
      write(LERR,*)' '
      length = lenth(ntap)
      if (length .gt. 0) then
        write(LERR,*) ' input data set name   =  ', ntap(1:length)
      else
        write(LERR,*) ' input data set        =  stdin'
      endif
      write(LERR,*) ' samples per trace     =  ', nsamp
      write(LERR,*) ' traces per record     =  ', ntrc
      write(LERR,*) ' number of records     =  ', nrec
      write(LERR,*) ' sample interval       =  ', nsi
      write(LERR,*)' '
      write(LERR,*)' '
      write(LERR,*)' Command Line Parameters '
      write(LERR,*)' '
      length = lenth(otap)
      if (length .gt. 0) then
        write(LERR,*) ' output data set name  =  ', otap(1:length)
      else
        write(LERR,*) ' output data set       =  stdout'
      endif
      write(LERR,*) ' start record          =  ', irs 
      write(LERR,*) ' end record            =  ', ire 
      write(LERR,*) ' start trace           =  ', ns
      write(LERR,*) ' end trace             =  ', ne
      write(LERR,*) ' processing sample start = ', ist
      write(LERR,*) ' processing sample end   = ', iend
      write(LERR,*)' '
      if ( trbias )  write(LERR,*) ' trace bias removed'
      if ( opbias )  write(LERR,*) ' operator bias removed'
      write(LERR,*)' '
      write(LERR,*) ' DFT sampling window  = ', window
      write(LERR,*) ' percent taper        = ', 100 - itw
      write(LERR,*)' '

      if ( gaus ) then
         write(LERR,*) ' Gaussian Taper used'
      else
         write(LERR,*) ' Cosine Taper used'
      endif
      write(LERR,*)' '

      write(LERR,*) ' start frequency           =  ', omega1
      write(LERR,*) ' end frequency             =  ', omega2
      write(LERR,*) ' frequency interval        =  ', domega
      write(LERR,*) ' '
      write(LERR,*) ' start period          =  ', period1
      write(LERR,*) ' end period            =  ', period2
      write(LERR,*) ' period interval       =  ', dperiod
      write(LERR,*)' '

      if ( verbos )  write(LERR,*) ' verbose printout requested'
      write(LERR,*)' '
      write(LERR,*)' Output Dataset Parameters '
      write(LERR,*)' '
      write(LERR,*) ' samples per trace     =  ', nsampo
      write(LERR,*) ' traces per record     =  ', ntrco
      write(LERR,*) ' number of records     =  ', nreco
      write(LERR,*) ' sample interval       =  ', nsi*nskip
      write(LERR,*)' '
      write(LERR,*)' samples in each frequency chunk = ', nsamp2
      write(LERR,*)' number of frequency chunks      = ', nomega
      write(LERR,*)' '
      if ( land ) then
         write(LERR,*)' output scaled for 8 bit display '
      endif
      if ( nobias ) then
         write(LERR,*)' bias not removed from spectrum '
      endif
      if ( phase ) then
         write(LERR,*)' output is spectral phase '
      else
         write(LERR,*)' output is spectral amplitude '
      endif
      write(LERR,*)' '
      write(LERR,*)'========================================== '
      write(LERR,*)' '

      return
      end

