C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine normal ( xtr, nsamp, lowlimit, upperlimit, range)

#include <f77/lhdrsz.h>
c variables passed from calling routine

      integer nsamp

      real xtr(SZLNHD), lowlimit, upperlimit, range

c local variables

      integer i
      real max, min, rangeOrig 

c initialize variables

      max = -1.e32
      min = 1.e32

c determine max and min amplitude in trace

      do i = 1, nsamp
         if ( abs(xtr(i)) .gt. 1.e-32 ) then
            
            if ( xtr(i) .gt. max ) then
               max = xtr(i)
            endif
            if ( xtr(i) .lt. min ) then
               min = xtr(i)
            endif
         endif
      enddo

c normalize trace then redistribute between lowlimit and upperlimit

      rangeOrig = max - min
      range = upperlimit - lowlimit

      do i = 1, nsamp
         if ( abs(xtr(i)) .gt. 1.e-32 ) then
            xtr(i) = range * ( ( xtr(i) - min ) / rangeOrig ) + lowlimit
         endif
      enddo

      return
      end
