C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine tdfninb (vels, times, numtvs, rinums, numris, iopen,
     :                   wantri, fntdfn, lutdfn, ierror)

c-------
c this program is to manipulate a tdfn input file in numerous ways.
c
c     vels   r*4   - array to return velocity values in.
c     times  r*4   - array to return time values in.
c     numtvs i*4   - the number of time velocity pairs being returned.
c     rinums i*2   - array in which to return all ri numbers found
c                    within the dataset.
c     numris i*4   - the number of ri's being returned.
c     iopen  i*4   - flag indicating what the user wants:
c                    0 = open the file.
c                    1 = return all ri numbers within the file and
c                        rewind the dataset when finished. the number
c                        of ri's will also be returned at this time.
c                    2 = read the time velocity pairs for a certain
c                        ri number which is specified by "wantri".
c                        also return the number of time velocity pairs.
c                    3 = rewind the dataset.
c                   -1 = close the file.
c     wantri i*4   - contains the ri number wanted when the user elects
c                    to retrieve all the time velocity pairs for a
c                    particular ri.
c     fntdfn c*(*) - contains the filename of the input data.
c                    declared in calling routine with 60 or more
c                    characters.
c     lutdfn i*4   - contians the logical unit number for the input
c                    data.
c     ierror i*4   - error return argument.
c                    0 = no errors detected.
c                    1 = tdfnin encountered an error trying to open
c                        the requested file.
c                    2 = tdfnin encountered a non-tdfn card while
c                        trying to accumulate the existing ri numbers.
c                    3 = for some reason end of file encountered but
c                        no ri numbers were found.
c                    4 = ri numbers were not in ascending order.
c                    5 = requested ri number has been passed, evidently
c                        it does not exist or possibly "9tdfn" card
c                        is missing.
c                    6 = end of file encountered while trying to read
c                        the ri requested by the user. it must not
c                        exist.
c                    7 = file does not exist 
c-------

      real
     :vels(*), times(*)

      integer
     :numtvs, numris, iopen, lutdfn, wantri, ierror, cardno, 
     :time(7), veloc(7), ri, ios

      integer*2 
     :rinums(*)

      character 
     :tdfn*4, fntdfn*(*), oaclin*8

      logical
     :doesit

c
      oaclin(8:8) = '$'
c
c see if the user wants to open the file.
c
      if (iopen .eq. 0) go to 10
c
c see if the user just requested the number of ri's and their
c respective numbers.
c
      if (iopen .eq. 1) go to 110
c
c see if the user wants the time velocity pairs for a certain ri.
c
      if (iopen .eq. 2) go to 150
c
c see if the user wanted to rewind the file.
c
      if (iopen .eq. 3) go to 210
c
c see if the user wanted to close the file and do so.
c
      if (iopen .eq. -1) go to 220
c-----
c target for opening the file.
c
10    continue
c-----
      lenc = len(fntdfn)
      call charct(fntdfn,lenc,lent)
c-----
c insure the specified file exist.
c-----
      doesit = .false.
      inquire (file=fntdfn(:lent), exist=doesit)
      if (.not. doesit) then
c        print*,' '
c        print*,'file = ',fntdfn(:lent)
c        print*,'file does not exist.'
         ierror = 7
         return
      endif
c-----
c now open the specified file.
c-----
      ios = 0
      open (unit=lutdfn, iostat=ios, file=fntdfn,
     :      status='old',form='formatted')
c-----
c check for a valid open.
c-----
      if (ios .ne. 0) then
         ierror = 1
         return
      endif
c-----
c open was successful so return.
c-----
      return
c-----
c this section will deal with gathering the number of ri's and buffering
c-----
c all of their numbers. after doing this it will rewind the file and
c return.
c-----
  110 continue
      rinums(1) = 0
      numris    = 1
  120 continue
      tdfn(1:4) = '    '
      read (lutdfn, 130, end=140) cardno, tdfn, ri
  130 format (i1,a4,70x,i5)
c-----
c make sure a tdfn card was read, else set error flag and get out.
c-----
      if (tdfn .ne. 'TDFN') then
         ierror = 2
         numris = 0
         return
      endif
c-----
c see if we are dealing with the case of the first ri being found.
c-----
      if (numris .eq. 1) then
         rinums(numris) = ri
         numris = numris + 1
         go to 120
      endif
c-----
c here we deal with all ri's other than the first.while here make
c sure the ri numbers are in ascending order, if not set error flag
c and get out.
c-----
      if (ri .ne. rinums(numris - 1)) then
         if (ri .lt. rinums(numris - 1)) then
              ierror = 4
              numris = 0
              return
         endif
         rinums(numris) = ri
         numris = numris + 1
         go to 120
      else
         go to 120
      endif
c-----
c to get here we have reached the end of the file.
c-----
  140 continue
      if (numris .gt. 1) then
         numris = numris - 1
         rewind (lutdfn)
         return
      else
         ierror = 3
         numris = 0
         return
      endif
c-----
c this section will deal with returning the time velocity pairs for a
c certain ri.
c-----
  150 continue
      numtvs = 1
  160 continue
      read (lutdfn, 170, end=200) cardno, tdfn, time(1), veloc(1),
     :                            time(2), veloc(2), time(3), veloc(3),
     :                            time(4), veloc(4), time(5), veloc(5),
     :                            time(6), veloc(6), time(7), veloc(7),
     :                            oaclin(1:7), ri
c
  170 format (i1,a4,7(i4,i5),a7,i5)
c-----
c see if the requested ri has been passed. if so set the error flag and
c get out.
c-----
      if (ri .gt. wantri) then
         ierror = 5
         numtvs = 0
c-----
         numris = 0
         return
      endif
c-----
c see if the ri number just read is less than the requested ri. if so
c go back and read another card.
c-----
      if (ri .lt. wantri) then
         go to 160
      endif
c-----
c see if we are dealing with part of the requested ri. if we are
c transfer the values just read to the users arrays. two cases need
c to be delt with; the "9tdfn" card and all other "tdfn" cards.
c-----
      if (ri .eq. wantri) then
         if (cardno .ge. 1 .and. cardno .le. 8) then
              do 180 i = 1, 7
                   times(numtvs) = float(time(i))/1000.0
                   vels(numtvs)  = float(veloc(i))
                   numtvs = numtvs + 1
  180         continue
              go to 160
         endif
c
         if (cardno .eq. 9) then
              do 190 i = 1, 7
                   if (time(i) .ne. 0 .and. veloc(i) .ne. 0) then
                        times(numtvs) = float(time(i))/1000.0
                        vels(numtvs)  = float(veloc(i))
                        numtvs = numtvs + 1
                   else
                        numtvs = numtvs - 1
                        rewind (lutdfn)
                        return
                   endif
  190         continue
              numtvs = numtvs - 1
              rewind (lutdfn)
              return
         endif
      endif
c-----
c to get here end of file was reached while trying to read the requested
c ri. something is wrong, set error flag and get out.
c-----
  200 continue
      ierror = 6
      numtvs = 0
      numris = 0
      return
c-----
c this section will rewind the file and then return.
c-----
  210 continue
      rewind (lutdfn)
      return
c-----
c this section will close the file and then return.
c-----
  220 continue
      close (lutdfn, iostat=ios)
c
      return
      end
