C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************

c Average              
      real function avgsmp(arr,minsmp,maxsmp,minwin,maxwin,rnul)
      real arr(minsmp:maxsmp)
      double precision sum
      avgsmp = rnul
      sum = 0.0D0
      n = 0
      do k = min(minwin,maxwin), max(minwin,maxwin)
         sum = arr(k) + sum
         n = n + 1
      enddo
      if (n .ne. 0) avgsmp = sum/n
cc    write(0,*) 'avgsmp:', avgsmp
      return
      end

c Largest positive (> 0) value
      real function peak(arr,minsmp,maxsmp,minwin,maxwin,rnul)
      real arr(minsmp:maxsmp)
      p = arr(minwin)
      n = 1
      do k = min(minwin,maxwin), max(minwin,maxwin)
         p = max(p,arr(k))
         n = n + 1
      enddo
      if (p .le. 0.0) then
          peak = rnul
      else
          peak = p
      endif 
cc    write(0,*) 'peak:', p, peak
      return
      end

c Largest negative (< 0) value
      real function trough(arr,minsmp,maxsmp,minwin,maxwin,rnul)
      real arr(minsmp:maxsmp)
      trough = arr(minwin)
      do k = min(minwin,maxwin), max(minwin,maxwin)
         trough = min(trough,arr(k))
      enddo
      if (trough .ge. 0.0) then
          trough = rnul
      else
          trough = abs(trough)
      endif
cc    write(0,*) 'trough:', trough
      return
      end

c Standard deviation
      real function stddev(arr,minsmp,maxsmp,minwin,maxwin,rnul)
      integer minsmp, maxsmp, minwin, maxwin
      real arr(minsmp:maxsmp), rnul
      real avg
      double precision sum
      integer ip, n, is, ie
      is = min(minwin,maxwin)
      ie = max(minwin,maxwin)
      avg = avgsmp(arr,minsmp,maxsmp,minwin,maxwin,rnul)
      sum = 0.0d0
      n = ie - is + 1
      do ip = is, ie
         sum = sum + ((arr(ip) - avg)**2)
      enddo
      if (n .ne. 0) then
         stddev = sqrt(sum / n)
      else
         stddev = 0.0
      endif
      return
      end

c Mode
      subroutine mode(arr,minsmp,maxsmp,minwin,maxwin,rmode,modecnt)
      real arr(minsmp:maxsmp)
      real rmode
      integer minsmp,maxsmp,minwin,maxwin,modecnt
          
      icnt = 1
      modecnt = 0
      do indx = minwin+1, maxwin
         if (arr(indx) .eq. arr(indx-1)) then
             icnt = icnt + 1
         else
            if (icnt .ge. modecnt) then
                rmode = arr(indx -1)
                modecnt = icnt
                icnt = 1
            endif
         endif
      enddo

      if (icnt .ge. modecnt) then
          rmode = arr(indx -1)
          modecnt = icnt
          icnt = 1
      endif

      return
      end

c Decile              
      subroutine decile(arr,minsmp,maxsmp,maxwin,i,indx,rdecile)
      real arr(minsmp:maxsmp)
      real rdecile
      integer minsmp,maxsmp,maxwin,i,indx
 
      indx = i * (maxwin + 1) / 10
      if (indx .gt. 0) then
          rdecile = arr(indx)
      else
          rdecile = 0.0
      endif

      return 
      end
