C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE APLYCR ( IBUF, IHEAD1, LHEAD, IBLOCK, IHEADR, IGRP,
     *                    IGMIN, IGMAX, IPMIN, IPMAX, I, R, GIDIM,
     *                    iunit, DATA, ISHIFT , micro, phase,
     *                    ITRWRD, SZSMPD, SZLNHD, quarter,
     * ifmt_TrcNum,l_TrcNum, ln_TrcNum,ifmt_RecNum,l_RecNum, ln_RecNum,
     * ifmt_DphInd,l_DphInd, ln_DphInd,ifmt_RecInd,l_RecInd, ln_RecInd,
     * ifmt_PrRcNm,l_PrRcNm, ln_PrRcNm,ifmt_StaCor,l_StaCor, ln_StaCor,
     * ifmt_DstSgn,l_DstSgn, ln_DstSgn,ifmt_LinInd,l_LinInd, ln_LinInd,
     * ifmt_DatShf,l_DatShf, ln_DatShf,ifmt_ToStUn,l_ToStUn, ln_ToStUn,
     * ifmt_ToTmAU,l_ToTmAU, ln_ToTmAU,ifmt_ihdwrd,l_ihdwrd, ln_ihdwrd,
     * ifmt_InStUn,l_InStUn, ln_InStUn,ifmt_RcStUn,l_RcStUn, ln_RcStUn,
     * ifmt_InStAp,l_InStAp, ln_InStAp,ifmt_RcStAp,l_RcStAp, ln_RcStAp,
     * ifmt_ToStAp,l_ToStAp, ln_ToStAp,ifmt_ToTmAA,l_ToTmAA, ln_ToTmAA)
C***********************************************************************
C
C     SUBROUTINE NAME: APLYCR
C
C     LANGUAGE: FORTRAN
C
C     AUTHOR: UNKNOWN
C
C     DATE WRITTEN: UNKNOWN
C
C     AMOCO PRODUCTION CO. PROPRIETARY
C                          - TO BE MAINTAINED IN CONFIDENCE
C
C     ABSTRACT: SUBROUTINE APLYCR EXTRACTS THE CORRECTIONS FOR A
C               TRACE, CONVERTS THE CORRECTIONS TO 1/4 MS AND
C               CALLS FDSTAT FOR THE APPLICATION AND TRACE HEADER
C               UPDATE PHASE.
C
C     MODIFICATION HISTORY: ??/??/??  -  ?.?.
C                           02/28/85  -  E.ANDES
C                           WHEN CONVERTING TO 1/4 MS. MAKE SURE
C                           NOTHING IS LOST WHEN STUFFING IT INTO
C                           THE INTEGER BUFFER.
C
C     PARAMETERS PASSED:
C        IBUF   - TRACE BUFFER
C        IHEAD1 - LINE HEADER BUFFER
C        IBLOCK - STATIC APPLICATION MODE FROM 1SCOR CARD
C        IHEADR - APPLY HEADER STATICS FLAG FROM 1SCOR CARD
C        IGRP   - 3D PROCESSING FLAG
C        IGMIN  - MIN LIVE GI
C        IGMAX  - MAX LIVE GI
C        IPMIN  - MIN LIVE PRI
C        IPMAX  - MAX LIVE PRI
C        I      - INITIATION CORRECTIONS
C        R      - RECEPTION CORRECTIONS
C        GIDIM  - GI LIMIT
c        ihdwrd - statics header word to update
C
C***********************************************************************

c#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

C
      REAL        I(*), R(*), DATA(*)
C
C     INTEGER     DI, GI, TPRI, IHEAD1(1500), GIDIM, OUTPUT,
      INTEGER     DI, GI, TPRI, IHEAD1(*), GIDIM, 
     *            OUTPUT, ICSA(10), ihdwrd
      INTEGER     KRI,N4,ITIMNG,IAP,ISHIFT,IUPDAT,NREG,IDUM1,
     *            IDUM2,IDUM3,IDUM4,ITRWRD, SZSMPD, SZLNHD
      REAL        CHG, CSA(10)
C
      INTEGER     IBUF(*), LHEAD(*)
C
      CHARACTER   SCOR*4
      LOGICAL     first, micro, phase
      COMMON /LUNITS/ INEVNT, INPUT, OUTPUT, IPRNTR
C
      DATA KRI/-99999/, N4/4/, SCOR/'SCOR'/, CHG/1.5/, ITIMNG/0/,
     *     IAP/70/, IUPDAT/0/, NREG/0/, IDUM1/0/,
     *     IDUM2/0/, IDUM3/0/, IDUM4/0/, first/.true./
C
      SAVE ! CRAY
C
      WRITE (IPRNTR,100)
  100 FORMAT ('1')
C
C---- OPEN UP UNITS..
C     CALL LBOPEN ( INPUT, OUTPUT )
C
C---- READ LINE HEADER...
      LENGTH = 0
      CALL RTAPE ( INPUT, IHEAD1, LENGTH )
      call saver(  ibuf,'Format', ifmt , LINHED)
      call saver(  ibuf,'SmpInt',  isi , LINHED)
      call saver(  ibuf,'NumSmp', nsamp, LINHED)
      call saver(ibuf, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(ibuf, 'UnitSc', unitsc, LINHED)
      endif

      IF ( LENGTH .NE. 0 ) GO TO 300
      WRITE(IPRNTR,200)
  200 FORMAT(/,12X, ' ** M7801 ** ERROR DETECTED BY SUBROUTINE APLYCR:',
     *       /,25X, 'END-OF-FILE ENCOUNTERED ATTEMPTING TO READ INPUT',
     *       /,25X, 'DATA SET LINE HEADER.  VERIFY DATA SET NAME AND',
     *       /,25X, 'IN THE CASE OF MULTI-VOLUME DATA SETS, VERIFY',
     *       /,25X, 'ORDER IN WHICH VOLUMES WERE CATALOGED.',/)
      CALL LBCLOS ( INPUT ) ! CRAY
      CALL LBCLOS ( OUTPUT) ! CRAY
      STOP 1060 ! CRAY
C
C---- PRINT HEADING...
  300 WRITE(IPRNTR,400)
  400 FORMAT(//,46X,'*** MESSAGE FROM PROGRAM SCOR ***',
     *        /,45X,'THE FOLLOWING IS THE INPUT DATA TAPE',
     *        /,45X,'(NTAP) LINE HEADER TO PROGRAM SCOR.')
C
C---- UPDATA LINE HEADER AND START ACCOUNTING....
      CALL HLHPRT ( IHEAD1, LENGTH, SCOR, N4, IPRNTR ) ! CRAY
C
C---- CHECK VITAL SIGNS..
      IF ( ifmt .EQ. 1 .OR. ifmt .EQ. 3) GOTO 600 ! CRAY
      WRITE(IPRNTR,500)
  500 FORMAT(/,12X, ' ** M7802 ** ERROR DETECTED BY SUBROUTINE APLYCR:',
     *       /,25X, 'FORMAT CODE READ FROM THE INPUT DATA SET LINE',
     *       /,25X, 'HEADER IS NOT A 1 OR A 3.  VERIFY THE INPUT DATA',
     *       /,25X, 'SET LINE HEADER FORMAT CODE.',/)
      CALL LBCLOS ( INPUT ) ! CRAY
      CALL LBCLOS ( OUTPUT) ! CRAY
      STOP 1070 ! CRAY
C
  600 CONTINUE

      nsamps = nsamp
      call saver(ihead1,'SmpInt', intrvl ,LINHED)
      if (micro) then
         call savew (ihead1,'SmpInt',intrvl*1000,LINHED)
      endif
C
      IF ( ifmt .EQ. 1 .AND. NSAMPS .LE. 12000 ) GOTO 800 ! CRAY
      IF ( ifmt .EQ. 3 .AND. NSAMPS .LE. 6000  ) GOTO 800 ! CRAY
      WRITE(IPRNTR,700)
  700 FORMAT(/,12X, ' ** M7807 ** ERROR DETECTED BY SUBROUTINE APLYCR:',
     *       /,25X, 'THE NUMBER OF SAMPLES FILED IN THE INPUT DATA',
     *       /,25X, 'SET LINE HEADER EXCEEDS THE PROGRAM LIMIT.',
     *       /,25X, 'PROGRAM SCOR ACCEPTS A MAXIMUM OF 12000 SAMPLES',
     *       /,25X, 'IF FORMAT 1, AND A MAXIMUM OF 6000 SAMPLES IF',
     *       /,25X, 'FORMAT 3.  EITHER CHANGE THE NUMBER OF SAMPLES',
     *       /,25X, 'ENTRY IN THE INPUT DATA SET LINE HEADER, OR',
     *       /,25X, 'WINDOW THAT PORTION OF THE DATA OF INTEREST SUCH',
     *       /,25X, 'THAT THE NUMBER OF SAMPLES CONFORMS TO PROGRAM',
     *       /,25X, 'RESTRICTIONS.',/)
      CALL LBCLOS ( INPUT ) ! CRAY
      CALL LBCLOS ( OUTPUT) ! CRAY
      STOP 1080 ! CRAY
C
C---- DETERMINE BYTES PER TRACE 
  800 continue
c     IBYTES = SZSMPD*(NSAMPS + ITRWRD)
      call saver(ibuf,'StWdFl', istwd , LINHED)
      IF ( istwd .EQ. 2 ) IUPDAT = 1       ! CRAY
C
C---- WRITE OUT LINE HEADER....
      call savhlh ( ihead1, LENGTH, LENGTH1)
      CALL WRTAPE ( OUTPUT, IHEAD1, LENGTH1 )
C
C---- READ A TRACE...
      KOUNT  = 0
  900 LENGTH = 0
      CALL RTAPE ( INPUT, IBUF, LENGTH )
      IF ( LENGTH .EQ. 0 ) GO TO 2100
C
C---- GET PERTINENT INFO..
              call saver2(IBUF ,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                    itrct , 1)
              call saver2(IBUF ,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                    irect , 1)
              call saver2(IBUF ,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                    idi   , 1)
              call saver2(IBUF ,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                    ili   , 1)
              call saver2(IBUF ,ifmt_RecInd,l_RecInd, ln_RecInd,
     1                    igi   , 1)
              call saver2(IBUF ,ifmt_PrRcNm,l_PrRcNm, ln_PrRcNm,
     1                    iprn  , 1)
              call saver2(IBUF ,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                    istat , 1)
              call saver2(IBUF ,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                    idist , 1)

      DI   = idi
      GI   = igi
      TPRI = DI - GI
      IF ( IGRP .EQ. 3 ) TPRI = iprn
C
C---- ZERO STATICS BUFFER..
      CALL MOVE ( 0, CSA(1), 0.0, 10*SZSMPD ) ! CRAY
C
C---- IS INPUT TRACE DEAD ??
      IF ( istat .EQ. 30000 ) GO TO 2000
C
C---- TRAP OUT MIN'S AND MAX'S OF LIVE PICKS....
C---- THIS IS FOR PUNCHING STATIC CARDS THAT
C---- WILL MAKE PROGRAM "STAT" OPERATE CORRECTLY...
C---- "STAT" USES WORD 110 FOR SOURCE...
      IF (  GI  .LT. IGMIN ) IGMIN = GI
      IF (  GI  .GT. IGMAX ) IGMAX = GI
      IF ( tpri .LT. IPMIN ) IPMIN = tpri
      IF ( tpri .GT. IPMAX ) IPMAX = tpri
C
C---- IS GI WITHIN PROGRAM LIMIT ??
      IF ( GI .GT. GIDIM ) GO TO 1000
      RSTAT = 0.
      JSTAT = 0
C
C---- CONVERT RECEPTION STATIC TO 1/4 MS..
C---- BE CAREFUL NOT TO LOSE ANY WHEN INTEGERIZING....
      RSTAT = R(GI) * quarter
      CSA(5) = RSTAT
      GO TO 1200
C
 1000 CALL RICLR0 ( IPRNTR )
      WRITE(IPRNTR,1100) irect, itrct, GI, GIDIM
 1100 FORMAT (/,12X, ' ** M7803 ** WARNING FROM SUBROUTINE APLYCR:',
     *        /,25X, 'NO RECEPTION STATIC CORRECTION APPLIED TO ',
     *               'RECORD ',I5,' TRACE ',I4,' BECAUSE THE',
     *        /,25X, 'GROUP INDEX (WORD 118) IS ',I5,' WHICH EXCEEDS ',
     *               'THE PROGRAM LIMIT OF ',I5,'.',/)
      CSA(5) = 0
C
 1200 IF ( TPRI .GT. GIDIM ) GO TO 1300
      RSTAT = 0.
      JSTAT = 0
C
C---- CONVERT INITIATION STATIC TO 1/4 MS..
C---- BE CAREFUL NOT TO LOSE ANY WHEN INTEGERIZING....
      RSTAT = I(TPRI) * quarter
      CSA(2) = RSTAT
      GO TO 1500
C
 1300 CALL RICLR0 ( IPRNTR )
      WRITE(IPRNTR,1400) irect, itrct, TPRI, GIDIM
 1400 FORMAT (/,12X, ' ** M7804 ** WARNING FROM SUBROUTINE APLYCR:',
     *        /,25X, 'NO INITIATION STATIC CORRECTION APPLIED TO ',
     *               'RECORD ',I5,' TRACE ',I4,' BECAUSE THE SOURCE',
     *        /,25X, 'LOCATION INDEX IS ',I5,' WHICH EXCEEDS THE ',
     *               'PROGRAM LIMIT OF ',I5,'.  IF TWO DIMENSIONAL',
     *        /,25X, 'PROCESSING IS REQUESTED (CC 20 = 0 OR 1), THE ',
     *               'SOURCE LOCATION IS THE DIFFERENCE BETWEEN DEPTH',
     *        /,25X, 'INDEX (WORD 122) AND GROUP INDEX (WORD 118).   ',
     *               'IF THREE DIMENSIONAL PROCESSING (CC 20 = 3),',
     *        /,25X, 'THE SOURCE LOCATION INDEX IS THE PERMANENT ',
     *               'RECORD INDEX (WORD 110).',/)
      CSA(2) = 0
C
C---- SUM UP TWO COMPONENTS...
 1500 ISTAT   = 0
      CSA(9) = CSA(2) + CSA(5)
      RCSA    = ICSA(9)

      if (phase) go to 1900
C
C---- CHECK VALIDITY OF THE SOLUTION...
      ISTAT = ( ( RCSA / 4 ) / INTRVL ) + SIGN ( 0.5, RCSA )
C
C---- IS STATIC LESS THAN 100 SAMPLES ???
C---- A RESIDUAL STATIC SHOULD BE...
      IF ( IABS( ISTAT ) .LE. 100 ) GO TO 1900
C
      CALL RICLR0 ( IPRNTR )
      WRITE(IPRNTR,1600) irect, itrct, DI, ISTAT
 1600 FORMAT (/,12X, ' ** M7805 ** WARNING FROM SUBROUTINE APLYCR:',
     *        /,25X, 'THE CALCULATED STATIC SHIFT VALUE FOR RECORD ',
     *                I8,' TRACE ',I8,' DEPTH INDEX ',I8,' IS ',I8,
     *        /,25X, 'SAMPLES.  THE STATIC SHOULD NOT BE GREATER THAN ',
     *               '100 SAMPLES.  THIS INDICATES THE SOLUTION IS',
     *        /,25X, 'DIVERGING.  A ZERO STATIC HAS BEEN SUBSTITU',
     *               'TED.',/)
C
      CALL MOVE ( 0, CSA(1), 0.0, 10*SZSMPD ) ! CRAY
C
C---- KEEP TRACK OF HOW MANY...
      KOUNT = KOUNT + 1
C
C---- WERE LESS THAN 200 TRACES OVER 100 SAMPLES ???
      IF ( KOUNT .LT. 200 ) GO TO 1800
C
      CALL RICLR0 ( IPRNTR )
      WRITE(IPRNTR,1700)
 1700 FORMAT (/,12X,' ** M7806 ** ERROR DETECTED BY SUBROUTINE APLYCR:',
     *        /,25X, 'THE CALCULATED SHIFT VALUE WAS GREATER THAN 100',
     *        /,25X, 'SAMPLES ON 200 TRACES.  THIS INDICATES THAT THE',
     *        /,25X, 'SOLUTION HAS DIVERGED.  EDIT THE TIMES AND',
     *        /,25X, 'WEIGHTS ON THE EVENT TAPE.',/)
      CALL LBCLOS ( INPUT ) ! CRAY
      CALL LBCLOS ( OUTPUT) ! CRAY
      STOP 1090 ! CRAY
C
 1800 ISTAT = 0
C
C---- GO APPLY THE STATIC.... Update header word "ihdwrd"
 1900 continue


      CALL FDSTAT ( IBUF(1), DATA, LHEAD(1), IHEAD1(1), CSA, ihdwrd,
     *              iheadr, ishift, iupdat, iblock, itimng, iap,first,
     *              IPRNTR, nsamp, intrvl, isi, ifmt, micro, phase,
     *              ITRWRD, SZSMPD, SZLNHD, quarter,
     * ifmt_TrcNum,l_TrcNum, ln_TrcNum,ifmt_RecNum,l_RecNum, ln_RecNum,
     * ifmt_DphInd,l_DphInd, ln_DphInd,ifmt_RecInd,l_RecInd, ln_RecInd,
     * ifmt_PrRcNm,l_PrRcNm, ln_PrRcNm,ifmt_StaCor,l_StaCor, ln_StaCor,
     * ifmt_DstSgn,l_DstSgn, ln_DstSgn,ifmt_LinInd,l_LinInd, ln_LinInd,
     * ifmt_DatShf,l_DatShf, ln_DatShf,ifmt_ToStUn,l_ToStUn, ln_ToStUn,
     * ifmt_ToTmAU,l_ToTmAU, ln_ToTmAU,ifmt_ihdwrd,l_ihdwrd, ln_ihdwrd,
     * ifmt_InStUn,l_InStUn, ln_InStUn,ifmt_RcStUn,l_RcStUn, ln_RcStUn,
     * ifmt_InStAp,l_InStAp, ln_InStAp,ifmt_RcStAp,l_RcStAp, ln_RcStAp,
     * ifmt_ToStAp,l_ToStAp, ln_ToStAp,ifmt_ToTmAA,l_ToTmAA, ln_ToTmAA)
C
C---- WRITE TRACE OUT...
 2000 CONTINUE

      CALL WRTAPE ( OUTPUT, IBUF, LENGTH )
C
C---- KEEP TRACK OF WHAT AND HOW MANY...
      IF ( irect .EQ. KRI ) GO TO 900
      KRI = irect
      CALL RIPRT0 ( KRI, IPRNTR )
C
C---- GO READ ANOTHER....
      GO TO 900
C
 2100 CALL RICLR0 ( IPRNTR )
      CALL LBCLOS ( INPUT ) ! CRAY
      CALL LBCLOS ( OUTPUT) ! CRAY
C
C---- LET'S FLY.....
      RETURN
      END
