C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE ERRTAB ( IERR2, RERR2, DIERR2, IDUM, RDUM, IPRI, IGI,
     *                    IKNT, RKNT, DIKNT, IEQWLR, LI2D, DI2D, IGRP,
     *                    I, R, C, M, ARRAY, NBLK, LBLK, NTRBLK,
     *                    NITEMS, GIDIM, DIDIM ,
     *                    ITRWRD, SZSMPD, SZLNHD)
C***********************************************************************
C
C     SUBROUTINE NAME: ERRTAB
C
C     LANGUAGE: FORTRAN
C
C     AUTHOR: UNKNOWN
C
C     DATE WRITTEN: UNKNOWN
C
C     AMOCO PRODUCTION CO. PROPRIETARY
C                          - TO BE MAINTAINED IN CONFIDENCE
C
C     ABSTRACT: SUBROUTINE ERRTAB PRINTS A TABLE OF CALCULATED
C               STATICS AND THE ERROR ASSOCIATED WITH EACH.  A
C               COUNT OF THE NUMBER OF CONTRIBUTORS IS ALSO GIVEN
C               WITH THE ERROR BEING RMS ERROR.
C
C     MODIFICATION HISTORY: ??/??/??  -  ?.?.
C                           02/01/83  -  G.SHIBA
C                           IMPLEMENT TWO-DIMENSIONAL CDP NUMBERING
C                           SCHEME.
C                           02/28/85  -  E.ANDES
C                           VISUAL ENHANCEMENTS ON PRINTOUT.
C
C     PARAMETERS PASSED:
C        IERR2  - SUM OF SHOT ERRORS SQUARED
C        RERR2  - SUM OF GROUP ERRORS SQUARED
C        DIERR2 - SUM OF CDP ERRORS SQUARED
C        IDUM   - PRI CORRECTIONS BY CDP
C        RDUM   - GROUP CORRECTIONS BY CDP
C        IPRI   - PRI'S BY CDP
C        IGI    - GI'S BY CDP
C        CDUM   - STRUCTURE CORRECTIONS
C        MDUM   - NMO CORRECTIONS
C        IKNT   - NUMBER OF SHOT OBSERVATIONS BY CDP
C        RKNT   - NUMBER OF GROUP OBSERVATIONS BY CDP
C        DIKNT  - NUMBER OF CDP OBSERVATIONS
C        IEQWLR - I = R FLAG
C        LI2D   - LINE INDEX FOR 3D LINES
C        DI2D   - DEPTH INDEX FOR 3D LINES
C        IGRP   - 3D PROCESSING FLAG
C        I      - INITIATION CORRECTIONS
C        R      - RECEPTION CORRECTIONS
C        C      - STRUCTURE CORRECTIONS
C        M      - MOVEOUT CORRECTIONS
C        ARRAY  - BUFFER FOR READING DISK INFO
C        NBLK   - DISKIO BLOCK COUNTER
C        LBLK   - TOTAL NUMBER OF BLOCKS DISKIO NEEDS
C        NTRBLK - NUMBER OF TRACES PER BLOCK
C        NITEMS - NUMBER OF SAMPLES PER DISK "TRACE"
C        GIDIM  - GROUP INDEX LIMIT
C        DIDIM  - DEPTH INDEX LIMIT
C
C***********************************************************************

c#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

C
C---- NOTE: ALL ARRAYS EXCEPT I & R MUST BE DIMENSIONED BY DIDIM
C----       BECAUSE THE PRINTED TABLE IS BASED ON GI AND TPRI
C----       WHERE;  GI = GI * 2  AND  TPRI = (TPRI-1)*2
C
      REAL        IDUM(30001), RDUM(30001), CDUM, MDUM, I(12001),
     *            R(12001), C(30001), M(30001), ARRAY(8190),
     *            IERR2(30001), RERR2(30001), DIERR2(30001)
C
      INTEGER     DI, GI, TPRI, DIDIM, GIDIM, ITRWRD, SZSMPD, SZLNHD
C
      INTEGER     IKNT(30001), RKNT(30001), DIKNT(30001), IPRI(30001),
     *            IGI(30001), LI2D(30001), DI2D(30001)
C
      COMMON /LUNITS/ INEVNT, INPUT, OUTPUT, IPRNTR
C
      DATA MAXDI/0/
C
      SAVE ! Cray
C
C---- ZERO OUT DISPLAY BUFFERS...
      CALL MOVE ( 0, IKNT  , 0, DIDIM * SZSMPD )  ! Cray
      CALL MOVE ( 0, RKNT  , 0, DIDIM * SZSMPD )  ! Cray
      CALL MOVE ( 0, DIKNT , 0, DIDIM * SZSMPD )  ! Cray
      CALL MOVE ( 0, IPRI  , 0, DIDIM * SZSMPD )  ! Cray
      CALL MOVE ( 0, IGI   , 0, DIDIM * SZSMPD )  ! Cray
      CALL MOVE ( 0, IDUM  , 0, DIDIM * SZSMPD )  ! Cray
      CALL MOVE ( 0, RDUM  , 0, DIDIM * SZSMPD )  ! Cray
      CALL MOVE ( 0, IERR2 , 0, DIDIM * SZSMPD )  ! Cray
      CALL MOVE ( 0, RERR2 , 0, DIDIM * SZSMPD )  ! Cray
      CALL MOVE ( 0, DIERR2, 0, DIDIM * SZSMPD )  ! Cray
C
C---- RETRIEVE AND TRAP INFORMATION...
      MINDI = DIDIM
C
      DO 300 IPNT1 = 1,NBLK
         N = NTRBLK
         IF ( IPNT1 .EQ. NBLK ) N = LBLK
         CALL ELREAD ( IPNT1, ARRAY )
C
         DO 200 IPNT2 = 1,N
            INDEX = ( IPNT2 - 1 ) * NITEMS + 1
C
C---- GET PERTINENT INFO...
            DI       = ARRAY( INDEX +  6 )
            LI2D(DI) = ARRAY( INDEX + 11 )
            DI2D(DI) = ARRAY( INDEX + 12 )
C
C---- IS PICK DEAD ???
            IF ( ARRAY(INDEX) .EQ. -10000. ) GO TO 200
C
            GI   = ARRAY( INDEX + 7 )
            TPRI = ARRAY( INDEX + 8 )
C
C---- HOW MUCH ERROR IN CORRECTION ???

            ERROR  = ARRAY( INDEX )
     *           - I(TPRI) - R(GI) - C(DI) - M(DI) * ARRAY( INDEX + 9 )
            IGI( GI * 2 ) = GI
            TPRI = TPRI * 2
            GI   = GI   * 2
C
C---- FIND MIN & MAX RANGES TO BE PRINTED...
            IF ( MINDI .GT. TPRI ) MINDI = TPRI
            IF ( MINDI .GT.   GI ) MINDI = GI
            IF ( MINDI .GT.   DI ) MINDI = DI
            IF ( MAXDI .LT. TPRI ) MAXDI = TPRI
            IF ( MAXDI .LT.   GI ) MAXDI = GI
            IF ( MAXDI .LT.   DI ) MAXDI = DI
C
C---- COUNT NUMBER OF
C---- CONTRIBUTORS TO SUMS...
C---- RECEIVER AND DI SUMS...
            IF ( IPRI( TPRI ) .LT. ARRAY( INDEX + 10 ) )
     *                             IPRI(TPRI) = ARRAY( INDEX + 10 )
            RKNT(GI)  = RKNT (GI) + 1
            DIKNT(DI) = DIKNT(DI) + 1
C
C---- COMPUTE SUM OF SQUARES...
            ERROR2     = ERROR * ERROR
            RERR2(GI)  = RERR2 (GI) + ERROR2
            DIERR2(DI) = DIERR2(DI) + ERROR2
C
C---- I = R ??
            IF ( IEQWLR .NE. 1 )    GO TO 100
            RKNT(TPRI)  = RKNT (TPRI) + 1
            RERR2(TPRI) = RERR2(TPRI) + ERROR2
            GO TO 200
C
C---- SOURCE SUMS...
  100       IKNT(TPRI)  = IKNT (TPRI) + 1
            IERR2(TPRI) = IERR2(TPRI) + ERROR2
  200    CONTINUE
  300 CONTINUE
C
C---- PUT RECEIVER INFO INTO
C---- INITIATION IF I = R ...
      IF ( IEQWLR .NE. 1 ) GO TO 500
C
      DO 400 GI = 1,DIDIM
         IKNT (GI) = RKNT (GI)
         IERR2(GI) = RERR2(GI)
         IF ( IPRI( GI ) .NE. 0 )
     *               GO TO 400
         IKNT (GI) = 0
         IERR2(GI) = 0.0
  400 CONTINUE
C
C---- COMPUTE RMS ERROR....
C---- RMS FOR INITIATION...
  500 DO 600 TPRI = 1,DIDIM
         IF ( IKNT( TPRI ) .EQ. 0 ) GO TO 600
         SUM         = IERR2(TPRI) / IKNT(TPRI)
         IERR2(TPRI) = SQRT ( SUM )
  600 CONTINUE
C
C---- RMS FOR RECEIVER...
      DO 700 GI = 1,DIDIM
         IF ( RKNT( GI ) .EQ. 0 ) GO TO 700
         SUM       = RERR2(GI) / RKNT(GI)
         RERR2(GI) = SQRT( SUM )
  700 CONTINUE
C
C---- RMS FOR CDP...
      DO 800 DI = 1,DIDIM
         IF ( DIKNT( DI ) .EQ. 0 ) GO TO 800
         SUM        = DIERR2(DI) / DIKNT(DI)
         DIERR2(DI) = SQRT( SUM )
  800 CONTINUE
C
C---- PUT STATICS IN CORRECT BUFFER POSITIONS
      DO 900 TPRI = 1,GIDIM
         DI = TPRI * 2
         IF ( IPRI(DI)  .EQ.   0 )
     *             GO TO 900
         IF ( I( TPRI ) .EQ. 0.0 )
     *           GO TO 900
         IDUM(DI) = I(TPRI)
  900 CONTINUE
C
      DO 1000 GI = 1,GIDIM
         IF ( R ( GI ) .EQ. 0.0 ) GO TO 1000
         RDUM ( GI * 2 ) = R(GI)
 1000 CONTINUE
C
C---- PRINT PAGE HEADING...
C---- EVERY 50 LINES OF DATA...
      KOUNT = 50
C
C---- GO FROM MIN TO MAX....
      DO 2400 DI = MINDI,MAXDI
C
C---- HAVE WE DONE A PAGE YET ???
         IF ( KOUNT .LT. 50 ) GO TO 1700
C
C---- YES...
         WRITE(IPRNTR,1100)
         IF (IGRP .EQ. 3 ) WRITE(IPRNTR,1500)
         IF (IGRP .NE. 3 ) WRITE(IPRNTR,1600)
C
 1100    FORMAT('1', 43X, 'STATIC CORRECTION',
     *               15X, 'NUMBER OF OBSERVATIONS',
     *               15X, 'RMS ERROR',
     *             /,33X, 38('-'),3X,25('-'),4X,28('-'))
 1500    FORMAT(3X, 'LI',    5X, 'DI',    5X, 'GI',    7X, 'PRI',
     *          4X, 'INITIATION', 1X, 'RECEPTION', 1X, 'STRUCTURE',
     *          1X, 'MOVEOUT', 3X, 'INITIATION', 1X, 'RECEPTION',
     *          3X, 'DI',    4X, 'INITIATION', 1X, 'RECEPTION',
     *          6X, 'DI',//,2X,130('='),/)
 1600    FORMAT(            10X, 'DI',    5X, 'GI',    7X, 'PRI',
     *          4X, 'INITIATION', 1X, 'RECEPTION', 1X, 'STRUCTURE',
     *          1X, 'MOVEOUT', 3X, 'INITIATION', 1X, 'RECEPTION',
     *          3X, 'DI',    4X, 'INITIATION', 1X, 'RECEPTION',
     *          6X, 'DI',//,8X,124('='),/)
C
C---- PULL OUT STRUCTURE AND MOVEOUT
         KOUNT = 0
 1700    CDUM  = 0
         MDUM  = 0
         IF ( C( DI ) .EQ. 0.0 ) GO TO 1800
         CDUM  = C(DI)
 1800    IF ( M( DI ) .EQ. 0.0 ) GO TO 1900
         MDUM  = M(DI)
C
C---- PRINT IT....
 1900    IF ( IGRP .EQ. 3 )
     *   WRITE(IPRNTR,2000) LI2D(DI), DI2D(DI), IGI(DI), IPRI(DI),
     *                      IDUM(DI), RDUM(DI), CDUM, MDUM, IKNT(DI),
     *                      RKNT(DI), DIKNT(DI), IERR2(DI), RERR2(DI),
     *                      DIERR2(DI)
 2000    FORMAT(    1X,I5    , 2X,I5     , 2X,I5    , 5X,I5    ,
     *              4X,F7.2  , 3X,F7.2   , 3X,F7.2  , 3X,F7.2  ,
     *              5X,I5    , 6X,I5     , 3X,I5    , 4X,F8.2  ,
     *              2X,F8.2  , 2X,F8.2   )
         IF ( IGRP .NE. 3 )
     *   WRITE(IPRNTR,2100) DI, IGI(DI), IPRI(DI), IDUM(DI), RDUM(DI),
     *                      CDUM, MDUM, IKNT(DI), RKNT(DI), DIKNT(DI),
     *                      IERR2(DI), RERR2(DI), DIERR2(DI)
 2100    FORMAT(               8X,I5     , 2X,I5    , 5X,I5    ,
     *              4X,F7.2  , 3X,F7.2   , 3X,F7.2  , 3X,F7.2  ,
     *              5X,I5    , 6X,I5     , 3X,I5    , 4X,F8.2  ,
     *              2X,F8.2  , 2X,F8.2   )
         KOUNT = KOUNT + 1
         IF ( KOUNT .LT. 50
     *              .AND. DI .LT. MAXDI ) GO TO 2400
         IF ( IGRP .NE. 3 ) WRITE(IPRNTR,2200)
 2200    FORMAT (/,8X,124('='),
     *          //,25X,'DI = DEPTH INDEX',10X,'GI = GROUP INDEX',10X,
     *                 'PRI = PERMANENT RECORD INDEX')
         IF ( IGRP .EQ. 3 ) WRITE(IPRNTR,2300)
 2300    FORMAT (/,2X,130('='),
     *          //,12X,'LI = LINE INDEX',10X,'DI = DEPTH INDEX',10X,
     *                 'GI = GROUP INDEX',10X,'PRI = PERMANENT RECORD',
     *                 ' INDEX')
 2400 CONTINUE
         WRITE(IPRNTR,2500)
 2500    FORMAT('1')
C
C---- LET'S SPLIT....
      RETURN
      END
